<div>
    @if(session()->has('message'))
        <div class="alert alert-success">{{ session('message') }}</div>
    @endif

    <form wire:submit.prevent="saveReminder">
        <div>
            <label for="letter_id">انتخاب نامه:</label>
            <select id="letter_id" wire:model="letter_id">
                <option value="">انتخاب نامه</option>
                @foreach($letters as $letter)
                    <option value="{{ $letter->id }}">{{ $letter->title }}</option>
                @endforeach
            </select>
            @error('letter_id') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="reminder_date">تاریخ یادآوری:</label>
            <input type="date" id="reminder_date" wire:model="reminder_date" />
            @error('reminder_date') <span class="error">{{ $message }}</span> @enderror
        </div>

        <button type="submit">ذخیره یادآوری</button>
    </form>

        <h3>یادآوری‌های تنظیم‌شده:</h3>
        <ul>
            @foreach($reminders as $reminder)
                @if($reminder->letter)
                    <li>نامه: {{ $reminder->letter->title }} - تاریخ یادآوری: {{ $reminder->reminder_date }}</li>

                @else

                    <li>نامه پیدا نشد - تاریخ یادآوری: {{ $reminder->reminder_date }}</li>
                @endif
            @endforeach
        </ul>


</div>
