@php
    // فرض می‌کنیم این متغیرها از والد (LetterShow) ارسال می‌شوند
    $isReply = $isReply ?? false;
    $replyParentId = $replyParentId ?? null;

    // تعیین کلاس‌های استایل
    $boxClass = $isReply ? 'comment-box-reply' : 'shadow-sm';
    $wrapperClass = $isReply ? 'mt-3' : 'comment-box-wrapper';
    $borderStyle = $isReply ? 'border-right: 3px solid var(--primary-100); padding-right: 12px; margin-right: 8px;' : '';
@endphp

<div class="{{ $wrapperClass }}" style="{{ $borderStyle }}">
    <div class="comment-box {{ $boxClass }}">

        <div class="comment-meta d-flex align-items-center gap-3">
            <img src="{{ $this->getUserProfilePhotoUrl($comment->user) }}"
                 class="comment-avatar rounded-circle"
                 alt="{{ $comment->user->name ?? 'کاربر' }}">
            <div>
                <div class="fw-bold">{{ $comment->user->name ?? 'کاربر ناشناس' }}</div>
                <div class="text-muted small">
                    <i class="far fa-clock me-1"></i>
                    {{ $this->formatShamsiDate($comment->created_at, 'Y/m/d H:i') }}
                </div>
            </div>
        </div>

        <div class="comment-body mt-3">
            {!! nl2br(e($comment->body)) !!}
        </div>

        @if(!$isReply)
            <div class="d-flex gap-2 mt-2">
                <button wire:click="replyTo({{ $comment->id }})"
                        class="comment-action d-flex align-items-center btn btn-sm"
                        style="color: var(--primary); background: transparent; padding: 4px 8px !important;">
                    <i class="fas fa-reply me-1"></i> پاسخ
                </button>
                @if($comment->user_id === Auth::id())
                    <button wire:click="deleteComment({{ $comment->id }})"
                            class="comment-action d-flex align-items-center btn btn-sm text-danger"
                            style="background: transparent; padding: 4px 8px !important;">
                        <i class="fas fa-trash me-1"></i> حذف
                    </button>
                @endif
            </div>
        @endif

        @if($comment->replies->count())
            <div class="mt-4 ps-3" style="border-right: 3px solid var(--primary-100); margin-right: 12px;">
                @foreach($comment->replies as $reply)
                    {{-- فراخوانی بازگشتی با isReply = true --}}
                    @include('livewire.admin.letter.partials.comment', [
                        'comment' => $reply,
                        'replyParentId' => $replyParentId,
                        'isReply' => true,
                    ])
                @endforeach
            </div>
        @endif
    </div>
</div>
