@if (isset($node['referral']) && $node['referral'])
    @php
        /** @var \App\Models\Referral $ref */
        $ref = $node['referral'];
        $user = $ref->user;
        $status = $ref->status;
        $level = $level ?? 0;

        // Map وضعیت‌ها به کلاس‌های Bootstrap
        $statusMap = match($status) {
            \App\Models\Referral::STATUS_COMPLETED => ['color' => 'success', 'icon' => 'fa-check-circle'],
            \App\Models\Referral::STATUS_REJECTED => ['color' => 'danger', 'icon' => 'fa-times-circle'],
            \App\Models\Referral::STATUS_VIEWED => ['color' => 'info', 'icon' => 'fa-eye'],
            \App\Models\Referral::STATUS_PENDING => ['color' => 'warning', 'icon' => 'fa-clock'],
            default => ['color' => 'secondary', 'icon' => 'fa-question-circle'],
        };
        $statusColor = $statusMap['color'];
        $statusIcon = $statusMap['icon'];
        $statusLabel = $ref->statusLabel();

        // Map نوع ارجاع به آیکون و رنگ
        $typeMap = match($ref->type) {
            \App\Models\Referral::TYPE_APPROVAL => ['icon' => 'fa-signature', 'color' => 'success', 'label' => 'تأیید/امضا'],
            \App\Models\Referral::TYPE_ACTION => ['icon' => 'fa-tools', 'color' => 'warning', 'label' => 'اقدام و اجرا'],
            \App\Models\Referral::TYPE_INFORMATION => ['icon' => 'fa-bullhorn', 'color' => 'info', 'label' => 'صرفاً اطلاع'],
            \App\Models\Referral::TYPE_CONSULTATION => ['icon' => 'fa-comment-dots', 'color' => 'primary', 'label' => 'مشاوره/نظر'],
            \App\Models\Referral::TYPE_CORRECTION => ['icon' => 'fa-redo-alt', 'color' => 'danger', 'label' => 'برگشت جهت تصحیح'],
            \App\Models\Referral::TYPE_OTHER => ['icon' => 'fa-thumbtack', 'color' => 'secondary', 'label' => 'سایر اعمال'],
            default => ['icon' => 'fa-paper-plane', 'color' => 'secondary', 'label' => 'نامشخص'],
        };

        $animationDelay = $level * 0.08;
    @endphp

    <div class="mb-4 referral-step" style="animation: fadeInUp 0.4s ease forwards; opacity: 0; animation-delay: {{ $animationDelay }}s;">
        <div class="d-flex align-items-stretch gap-3 position-relative referral-node">

            <div class="position-relative d-flex flex-column align-items-center" style="width: 30px; min-width: 30px;">
                <div class="position-absolute top-0 bottom-0 w-px bg-gray-200" style="height: 100%; z-index: 0;"></div>

                <div class="bg-{{ $statusColor }}-subtle rounded-circle p-1 border border-1 border-{{ $statusColor }}-subtle text-{{ $statusColor }}"
                     style="width: 14px; height: 14px; margin-top: 18px; z-index: 1; display: flex; align-items: center; justify-content: center; transform: scale(1.2);">
                    <i class="fas {{ $statusIcon }}" style="font-size: 0.6rem;"></i>
                </div>
            </div>

            <div class="flex-grow-1 card card-body p-3 w-100 transition-all border-start border-start-3 border-{{ $typeMap['color'] }}"
                 style="background: white; border-radius: 8px; margin-top: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.08);">

                <div class="d-flex justify-content-between align-items-center border-bottom pb-2 mb-2">
                    <div class="d-flex align-items-center">
                        <div class="avatar avatar-xs me-2">
                            <img src="{{ $this->getUserProfilePhotoUrl($user) }}" alt="{{ $user?->name }}">
                        </div>
                        <div class="fw-bold text-dark me-3" style="font-size: 0.95rem;">{{ $user?->name ?? 'کاربر نامشخص' }}</div>

                        <span class="badge bg-{{ $typeMap['color'] }}-subtle text-{{ $typeMap['color'] }} px-3 py-1 fw-bold small rounded-pill">
                            <i class="fas {{ $typeMap['icon'] }} me-1"></i>
                            {{ $typeMap['label'] }}
                        </span>
                    </div>

                    <span class="badge bg-{{ $statusColor }}-subtle text-{{ $statusColor }} px-3 py-1 rounded-pill small fw-bold">
                        {{ $statusLabel }}
                    </span>
                </div>

                <div class="small text-muted pt-1">
                    <div class="d-flex justify-content-between align-items-center mb-1">
                        <div class="text-xs">
                            <i class="far fa-clock me-1"></i>
                            زمان ارسال: {{ $this->formatShamsiDate($ref->created_at, 'Y/m/d H:i') }}
                        </div>
                        @if($ref->creator?->name)
                            <span class="text-xs text-gray-500">
                                <i class="fas fa-user-tie me-1"></i> فرستنده: {{ $ref->creator->name }}
                            </span>
                        @endif
                    </div>

                    @if($ref->correction_message)
                        <div class="mt-2 p-2 rounded-2 bg-danger-subtle text-danger fw-bold border border-danger-subtle" style="font-size: 0.85rem;">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            <span class="me-1">پیام برگشت:</span>
                            {{ Str::limit($ref->correction_message, 80) }}
                        </div>
                    @endif

                    @if($ref->isApproval() && $ref->status == \App\Models\Referral::STATUS_COMPLETED)
                        <div class="mt-2 p-2 rounded-2 bg-success-subtle text-success fw-bold border border-success-subtle" style="font-size: 0.85rem;">
                            <i class="fas fa-check-double me-1"></i>
                            تأیید نهایی و امضا انجام شد.
                        </div>
                    @endif
                </div>
            </div>
        </div>

        @if(!empty($node['children']))
            <div class="ps-4 mt-3 position-relative">
                {{-- خط عمودی برای اتصال به فرزندان --}}
                <div class="position-absolute top-0 bottom-0 w-px bg-gray-200" style="left: 14px;"></div>
                @foreach($node['children'] as $child)
                    {{-- فراخوانی بازگشتی برای نمایش زیردرخت --}}
                    @include('livewire.admin.letter.partials.referral-node', [
                        'node' => $child,
                        'level' => $level + 1
                    ])
                @endforeach
            </div>
        @endif
    </div>
@endif

<style>
    /* CSS برای انیمیشن گره‌ها */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(15px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    /* تعریف رنگ‌های کم‌رنگ برای استفاده در Badge/Background */
    .bg-danger-subtle { background-color: #fef2f2; }
    .text-danger-subtle { color: #dc2626; }

    .bg-success-subtle { background-color: #f0fdf4; }
    .text-success-subtle { color: #059669; }

    .bg-warning-subtle { background-color: #fffbeb; }
    .text-warning-subtle { color: #d97706; }

    .bg-info-subtle { background-color: #eff6ff; }
    .text-info-subtle { color: #3b82f6; }

    .bg-primary-subtle { background-color: #eef2ff; }
    .text-primary-subtle { color: var(--primary); }

    .bg-secondary-subtle { background-color: #f3f4f6; }
    .text-secondary-subtle { color: #6b7280; }

    /* استایل دهی خطوط Timeline */
    /* خط اصلی (عمودی) در ستون تاریخ */
    .referral-step > .referral-node > .position-relative > .w-px {
        inset-inline-start: 50%;
        transform: translateX(-50%);
        background: #e5e7eb; /* رنگ خط مرکزی ملایم */
    }
    /* خطوط اتصال فرزندان */
    .referral-step > .ps-4 > .w-px {
        inset-inline-start: 14px;
        background: #e5e7eb;
    }

    /* رفع فاصله افقی بین گره و کارت */
    .referral-node > .card {
        margin-right: 0 !important;
        margin-left: 0 !important;
    }
</style>
