<div>
    @if(session()->has('message'))
        <div class="alert alert-success">{{ session('message') }}</div>
    @endif

    <form wire:submit.prevent="saveReferral">
        <div>
            <label for="letter_id">انتخاب نامه:</label>
            <select id="letter_id" wire:model="letter_id">
                <option value="">انتخاب نامه</option>
                @foreach($letters as $letter)
                    <option value="{{ $letter->id }}">{{ $letter->title }}</option>
                @endforeach
            </select>
            @error('letter_id') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="user_id">انتخاب کاربر:</label>
            <select id="user_id" wire:model="user_id">
                <option value="">انتخاب کاربر</option>
                @foreach($users as $user)
                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                @endforeach
            </select>
            @error('user_id') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="type">نوع ارجاع:</label>
            <select id="type" wire:model="type">
                <option value="">انتخاب نوع ارجاع</option>
                <option value="امضا">امضا</option>
                <option value="ارایه نظر">ارایه نظر</option>
                <option value="ثبت و صادر">ثبت و صادر</option>
                <option value="بایگانی">بایگانی</option>
                <option value="نمایش یا رونوشت">نمایش یا رونوشت</option>
            </select>
            @error('type') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="comment">توضیحات:</label>
            <textarea id="comment" wire:model="comment" placeholder="توضیحات"></textarea>
        </div>

        <button type="submit">ذخیره</button>
    </form>
</div>
