<div>
    <form wire:submit="submitReferral">
        <div class="mb-3">
            <label for="letter-code" class="form-label fw-medium">نامه مرجع:</label>
            <input type="text" id="letter-code" class="form-control" value="کد: {{ $letter->code }} | موضوع: {{ Str::limit($letter->subject, 30) }}" disabled>
        </div>

        <div class="mb-3">
            <label for="recipient" class="form-label fw-medium required">گیرنده ارجاع:</label>
            <select wire:model="recipientId" id="recipient" class="form-select @error('recipientId') is-invalid @enderror">
                <option value="">انتخاب کنید...</option>
                @foreach($users as $user)
                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                @endforeach
            </select>
            @error('recipientId') <div class="invalid-feedback">{{ $message }}</div> @enderror
        </div>

        <div class="mb-3">
            <label for="type" class="form-label fw-medium required">نوع ارجاع:</label>
            <select wire:model="type" id="type" class="form-select @error('type') is-invalid @enderror">
                <option value="action">اقدام شود</option>
                <option value="info">جهت اطلاع</option>
                <option value="follow-up">پیگیری شود</option>
            </select>
            @error('type') <div class="invalid-feedback">{{ $message }}</div> @enderror
        </div>

        <div class="mb-4">
            <label for="comment" class="form-label fw-medium">توضیحات/دستور ارجاع:</label>
            <textarea wire:model="comment" id="comment" rows="3" class="form-control @error('comment') is-invalid @enderror" placeholder="دستورالعمل‌های خاص برای گیرنده..."></textarea>
            @error('comment') <div class="invalid-feedback">{{ $message }}</div> @enderror
        </div>

        <div class="d-flex justify-content-end pt-3 border-top">
            <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">لغو</button>
            <button type="submit" class="btn btn-action-primary" wire:loading.attr="disabled">
                <span wire:loading class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>
                ثبت ارجاع
            </button>
        </div>
    </form>
</div>
