<div class="container-fluid py-5" x-data="{}">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a0ca3;
            --primary-light: #e0e7ff;
            --info: #4cc9f0;
            --danger: #ef4444;
            --border: #d1d5db;
            --success: #2ecc71;
        }
        .form-card {
            max-width: 1100px;
            margin: 0 auto;
            background: white;
            border-radius: 24px;
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.12);
            padding: 2.8rem;
            transition: transform 0.3s ease;
        }
        .form-card:hover {
            transform: translateY(-2px);
        }
        .form-label {
            font-weight: 700;
            color: #1e293b;
            font-size: 0.95rem;
            margin-bottom: 0.6rem;
            display: block;
        }
        .form-control, .form-select {
            border-radius: 14px;
            padding: 0.85rem 1.2rem;
            border: 1px solid #e2e8f0;
            transition: all 0.25s;
            font-size: 0.95rem;
        }
        .form-control:focus, .form-select:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
            outline: none;
        }
        .grid-3 {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.6rem;
        }
        .required::after {
            content: ' *';
            color: var(--danger);
        }
        fieldset {
            border: 1px solid #edf2f7 !important;
            border-radius: 18px !important;
            padding: 1.8rem !important;
            margin-bottom: 1.8rem;
            background: #fafbff;
            transition: all 0.3s;
        }
        fieldset:hover {
            border-color: var(--primary-light) !important;
            box-shadow: 0 4px 12px rgba(67, 97, 238, 0.08);
        }
        legend {
            color: var(--primary-dark) !important;
            font-size: 1rem !important;
            font-weight: 700 !important;
            padding: 0 0.6rem !important;
            background: white;
            border-radius: 10px;
        }

        .uploader-zone {
            border: 2px dashed var(--primary);
            background: var(--primary-light);
            border-radius: 18px;
            padding: 2.2rem;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        .uploader-zone:hover {
            background: #d0d9ff;
        }
        .file-icon-large {
            font-size: 2.8rem;
            color: var(--primary-dark);
            margin-bottom: 0.8rem;
        }
        .file-list {
            list-style: none;
            padding: 0;
            margin-top: 1.4rem;
        }
        .file-list li {
            background: white;
            border-radius: 12px;
            padding: 12px 20px;
            margin-bottom: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid #eef2f7;
            font-size: 0.93rem;
            box-shadow: 0 2px 6px rgba(0,0,0,0.03);
        }
        .btn-primary {
            background: var(--primary);
            border-color: var(--primary);
            padding: 0.75rem 1.8rem;
            font-weight: 600;
            font-size: 1.05rem;
            border-radius: 50px;
            transition: all 0.25s;
        }
        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(58, 12, 163, 0.3);
        }
        .form-control.date-input {
            background: #f8fafc;
            font-weight: 600;
            color: #1e293b;
            cursor: pointer;
        }
        .form-control.date-input:focus {
            background: white;
        }
    </style>

    <div class="form-card">
        <h2 class="fw-bold text-dark mb-4">
            <i class="fas fa-file-import me-3 text-primary"></i> ثبت نامه وارده جدید
        </h2>

        <p class="text-muted mb-5">
            برای بایگانی و پیگیری هوشمند نامه‌های دریافتی از مراجع خارج از سیستم، اطلاعات را در فرم زیر وارد کنید.
        </p>

        <form wire:submit.prevent="saveIncoming">

            <fieldset>
                <legend>
                    <i class="fas fa-id-card-alt me-2"></i> مشخصات فرستنده خارجی
                </legend>

                <div class="grid-3">
                    <div>
                        <label class="form-label required">نام فرستنده (سازمان/شخص)</label>
                        <input type="text" class="form-control" wire:model.defer="external_sender" placeholder="مثلاً: شرکت الف، وزارت نیرو">
                        @error('external_sender') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>
                    <div>
                        <label class="form-label required">شماره نامه خارجی</label>
                        <input type="text" class="form-control" wire:model.defer="external_number" placeholder="شماره ثبت شده روی نامه">
                        @error('external_number') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>
                    <div>
                        <label class="form-label required">تاریخ نامه (شمسی)</label>
                        <input type="text" class="form-control date-input" id="external-date-picker"
                               placeholder="تاریخ ثبت نامه خارجی"
                               value="{{ $externalDateShamsi }}" readonly>
                        <input type="hidden" id="external-date-alt" wire:model.defer="external_date">
                        @error('external_date') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>
                </div>
            </fieldset>

            <fieldset>
                <legend>
                    <i class="fas fa-clipboard-check me-2"></i> دسته‌بندی و ارجاع اولیه
                </legend>

                <div class="mb-4">
                    <label class="form-label required">موضوع نامه (خلاصه داخلی)</label>
                    <input type="text" class="form-control" wire:model.defer="subject" placeholder="خلاصه‌ای از محتوای نامه برای پیگیری داخلی">
                    @error('subject') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                </div>

                <div class="grid-3">
                    <div>
                        <label class="form-label required">مسئول پیگیری (گیرنده اولیه)</label>
                        <select class="form-select" wire:model.defer="recipient_user_id">
                            <option value="">انتخاب کاربر</option>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                        @error('recipient_user_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>
                    <div>
                        <label class="form-label required">طبقه‌بندی</label>
                        <select class="form-select" wire:model.defer="classification_id">
                            <option value="">انتخاب کنید</option>
                            @foreach($classifications as $cls)
                                <option value="{{ $cls->id }}">{{ $cls->name }}</option>
                            @endforeach
                        </select>
                        @error('classification_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>
                    <div>
                        <label class="form-label">پروژه مرتبط (اختیاری)</label>
                        <select class="form-select" wire:model.defer="project_id">
                            <option value="">-- بدون پروژه --</option>
                            @foreach($projects as $project)
                                <option value="{{ $project->id }}">{{ $project->code }} - {{ $project->name }}</option>
                            @endforeach
                        </select>
                        @error('project_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>
                </div>
            </fieldset>

            <div class="mb-5 p-4 border rounded-4 bg-light-subtle">
                <label class="form-label"><i class="fas fa-lock me-2 text-danger"></i> محرمانگی</label>
                <div class="form-check form-switch pt-2">
                    <input class="form-check-input" type="checkbox" role="switch" id="confidentialSwitch" wire:model.defer="confidential">
                    <label class="form-check-label" for="confidentialSwitch">
                        این نامه محرمانه است (برای بایگانی)
                    </label>
                </div>
            </div>

            <fieldset>
                <legend>
                    <i class="fas fa-cloud-upload-alt me-2"></i> اسناد و پیوست‌ها
                </legend>

                <label class="form-label required">فایل اسکن شده نامه (PDF/JPG)</label>

                <label for="incoming-attachments" class="uploader-zone shadow-sm"
                       @dragover.prevent="event.currentTarget.classList.add('dragover')"
                       @dragleave.prevent="event.currentTarget.classList.remove('dragover')"
                       @drop.prevent="event.currentTarget.classList.remove('dragover'); $wire.set('attachments', [...$wire.attachments, ...event.dataTransfer.files])">

                    <i class="fas fa-file-pdf file-icon-large"></i>
                    <p class="fw-bold text-dark mb-1">فایل‌ها را اینجا بکشید و رها کنید</p>
                    <small class="text-muted">حداقل ۱ فایل (PDF/JPG/PNG) - حداکثر ۲۰MB</small>
                </label>
                <input type="file" id="incoming-attachments" class="d-none" multiple
                       wire:model="attachments" accept="application/pdf,image/jpeg,image/png">

                @error('attachments') <div class="text-danger small mt-2">{{ $message }}</div> @enderror
                @error('attachments.*') <div class="text-danger small mt-2">{{ $message }}</div> @enderror

                @if(count($attachments))
                    <ul class="file-list">
                        @foreach($attachments as $index => $file)
                            <li wire:key="file-{{ $index }}">
                                <span><i class="fas fa-file me-2 text-info"></i> {{ $file->getClientOriginalName() }}</span>
                                <button type="button" class="btn btn-sm btn-outline-danger rounded-circle p-1" wire:click="removeAttachment({{ $index }})">
                                    <i class="fas fa-times fs-6"></i>
                                </button>
                            </li>
                        @endforeach
                    </ul>
                @endif
            </fieldset>

            <div class="text-end pt-3">
                <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                    <span wire:loading.remove>
                        <i class="fas fa-paper-plane me-2"></i> ثبت و ارجاع اولیه
                    </span>
                    <span wire:loading>
                        <span class="spinner-border spinner-border-sm me-2"></span> در حال پردازش...
                    </span>
                </button>
            </div>
        </form>
    </div>

    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // ✅ دریافت مقدار فعلی تاریخ میلادی از فیلد مخفی
                const altField = document.getElementById('external-date-alt');
                if (!altField.value) {
                    const today = new Date().toISOString().split('T')[0];
                    altField.value = today;
                }

                // ✅ راه‌اندازی persianDatepicker
                if (typeof $.fn.persianDatepicker === 'function') {
                    $('#external-date-picker').persianDatepicker({
                        altField: '#external-date-alt',
                        altFormat: 'YYYY-MM-DD',
                        format: 'YYYY/MM/DD',
                        initialValue: false,
                        autoClose: true,
                        calendar: {
                            persian: { locale: 'fa' }
                        },
                        onSelect: function () {
                            const gregorian = $('#external-date-alt').val();
                            // ✅ استفاده از @this.set() — این روش همیشه کار می‌کند
                            @this.set('external_date', gregorian);
                        }
                    });
                }
            });
        </script>
    @endpush
</div>
