<div>
    <div class="letters-container rtl" dir="rtl"
         x-data="{
            toastStore: {
                toasts: [],
                add(type, msg, isGlobal = false) {
                    const id = Date.now();
                    const toastType = isGlobal ? 'global' : type;
                    this.toasts.push({id, type: toastType, message: msg, visible: true});
                    setTimeout(() => {
                        const t = this.toasts.find(t => t.id === id);
                        if (t) t.visible = false;
                        setTimeout(() => this.toasts = this.toastStore.toasts.filter(t => t.id !== id), isGlobal ? 6500 : 3800);
                    }, isGlobal ? 6500 : 3800);
                }
            },
            init() {
                Livewire.on('show-toast', (e) => {
                    const data = Array.isArray(e) ? e[0] : e;
                    this.toastStore.add(data.type || 'info', data.message || 'پیام نامشخص');
                });

                // ✨ مدیریت تأیید با SweetAlert/Confirmation Dialog
                Livewire.on('show-confirmation', (e) => {
                    const data = Array.isArray(e) ? e[0] : e;
                    if (typeof Swal !== 'undefined') {
                        Swal.fire({
                            title: data.title || 'آیا مطمئن هستید؟',
                            text: data.text || 'این عملیات قابل بازگشت نیست.',
                            icon: data.icon || 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: data.confirmButtonText || 'بله، انجام بده!',
                            cancelButtonText: 'انصراف'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // فراخوانی متد Livewire پس از تأیید
                                @this.dispatch('confirmed', {
                                    method: data.method,
                                    params: data.params || []
                                });
                            }
                        });
                    }
                });

                if (!this.datePickersInitialized) {
                    this.initShamsiDatePickers();
                    this.datePickersInitialized = true;
                }
            },
            datePickersInitialized: false,
            initShamsiDatePickers() {
                if (typeof $ === 'function' && $.fn.persianDatepicker) {
                    // ✨ رفع باگ: تنظیمات مشترک با timePicker: false
                    const datepickerOptions = {
                        altField: '',
                        altFormat: 'YYYY-MM-DD',
                        format: 'YYYY/MM/DD',
                        timePicker: false,
                        dayPicker: {
                            enabled: true
                        },
                        autoClose: true
                    };

                    $('#filter-from-date').persianDatepicker({
                        ...datepickerOptions,
                        altField: '#filter-from-date-alt',
                        onSelect: function(unix, obj) {
                            const greg = $('#filter-from-date-alt').val();
                            @this.set('filterFromDate', greg);
                        }
                    });
                    $('#filter-to-date').persianDatepicker({
                        ...datepickerOptions,
                        altField: '#filter-to-date-alt',
                        onSelect: function(unix, obj) {
                            const greg = $('#filter-to-date-alt').val();
                            @this.set('filterToDate', greg);
                        }
                    });
                }
            }
         }"
         style="font-family: 'Vazirmatn', 'Segoe UI', sans-serif;"
    >
        <style>
            :root {
                --primary: hsl(217, 91%, 55%);
                --primary-50: hsl(217, 91%, 95%);
                --primary-100: hsl(217, 91%, 90%);
                --primary-600: hsl(217, 91%, 35%);
                --secondary: hsl(200, 15%, 55%);
                --accent: hsl(170, 100%, 45%);
                --bg: #f3f4f6;
                --card: #ffffff;
                --text: #1f2937;
                --text-muted: #6b7280;
                --border: #e5e7eb;
                --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.06);
                --shadow-lg: 0 10px 25px -3px rgba(15, 23, 42, 0.55), 0 4px 6px -4px rgba(15, 23, 42, 0.4);
                --transition: all 0.25s cubic-bezier(0.16, 1, 0.3, 1);

                /* Modal Referral Styles */
                --success: #10b981;
                --warning: #f59e0b;
                --info: #3b82f6;
            }

            .letters-container {
                max-width: 1600px;
                margin: 0 auto;
                padding: 24px 16px 40px;
            }

            /* HEADER + HERO */
            .page-header {
                background:
                    radial-gradient(circle at top left, rgba(255,255,255,0.16), transparent 55%),
                    linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
                border-radius: 24px;
                padding: 30px 28px 26px;
                color: white;
                position: relative;
                overflow: hidden;
                box-shadow: var(--shadow-lg);
                margin-bottom: 20px;
            }
            .page-header::after {
                content: '';
                position: absolute;
                inset-inline-start: -70px;
                inset-block-start: -70px;
                width: 220px;
                height: 220px;
                border-radius: 50%;
                background: rgba(255,255,255,0.12);
                filter: blur(30px);
                opacity: 0.8;
            }
            .header-main-title {
                font-size: 2.3rem;
                font-weight: 900;
                margin-bottom: 4px;
                color: #fff;
                text-shadow: 0 3px 10px rgba(0,0,0,0.3);
            }
            .header-sub-title {
                opacity: 0.96;
                font-size: 0.98rem;
                color: #f9fafb;
            }
            .header-icon-wrapper {
                background: rgba(255,255,255,0.2);
                border: 1px solid rgba(255,255,255,0.35);
                border-radius: 18px;
                padding: 16px;
                display: inline-flex;
                align-items: center;
                justify-content: center;
                margin-left: 24px;
                backdrop-filter: blur(8px);
            }

            /* FILTER CARD */
            .filter-section {
                margin-top: 24px;
                padding: 18px 20px;
                border-radius: 18px;
                background: rgba(15,23,42,0.18);
                backdrop-filter: blur(14px);
                border: 1px solid rgba(255,255,255,0.3);
                box-shadow: 0 8px 24px rgba(15,23,42,0.3);
            }
            .filter-section label {
                color: #f9fafb !important;
                font-weight: 600;
                text-shadow: 0 1px 2px rgba(0,0,0,0.3);
            }
            .filter-section input,
            .filter-section select {
                background: rgba(255,255,255,0.94) !important;
                border: 1px solid rgba(15,23,42,0.08) !important;
                color: #111827 !important;
                font-weight: 500;
                border-radius: 10px !important;
                box-shadow: 0 1px 2px rgba(15,23,42,0.15);
            }
            .filter-section input::placeholder {
                color: #6b7280 !important;
            }
            .filter-section .input-group-text {
                background: rgba(255,255,255,0.95) !important;
                border-radius: 10px 0 0 10px;
                border: 1px solid rgba(15,23,42,0.08) !important;
            }

            /* ACTIVE FILTERS */
            .active-filters-wrapper {
                margin-top: 14px;
                padding-top: 10px;
                border-top: 1px dashed rgba(255,255,255,0.35);
            }
            .active-filter-badge {
                background: rgba(255,255,255,0.22);
                border: 1px solid rgba(255,255,255,0.6);
                color: #fefefe;
                padding: 5px 12px;
                border-radius: 999px;
                font-size: 0.8rem;
                display: inline-flex;
                align-items: center;
                gap: 6px;
                backdrop-filter: blur(4px);
            }
            .active-filter-badge .btn-close {
                filter: invert(1);
                opacity: .8;
            }

            /* STAT CARDS */
            .stat-row {
                margin-top: 16px;
            }
            .stat-card {
                background: rgba(15,23,42,0.14);
                border: 1px solid rgba(255,255,255,0.28);
                backdrop-filter: blur(12px);
                color: white;
                padding: 14px 16px 12px;
                border-radius: 16px;
                transition: var(--transition);
                box-shadow: 0 4px 16px rgba(15,23,42,0.35);
            }
            .stat-card:hover {
                transform: translateY(-3px);
                box-shadow: 0 10px 28px rgba(15,23,42,0.5);
                background: rgba(15,23,42,0.22);
            }
            .stat-label {
                font-size: 0.78rem;
                letter-spacing: .04em;
                text-transform: uppercase;
                opacity: 0.9;
            }
            .stat-icon {
                width: 30px;
                height: 30px;
                border-radius: 999px;
                display: flex;
                align-items: center;
                justify-content: center;
                background: rgba(15,23,42,0.55);
                border: 1px solid rgba(255,255,255,0.35);
                font-size: 0.85rem;
            }

            /* MAIN CARD */
            .main-content-card {
                background-color: var(--card);
                border-radius: 18px;
                box-shadow: var(--shadow);
                overflow: hidden;
                margin-top: 18px;
            }

            /* TABLE */
            .table-responsive {
                overflow-x: auto;
                scrollbar-width: thin;
                scrollbar-color: var(--border) transparent;
            }
            .table-responsive::-webkit-scrollbar {
                height: 8px;
            }
            .table-responsive::-webkit-scrollbar-track {
                background: transparent;
            }
            .table-responsive::-webkit-scrollbar-thumb {
                background-color: var(--border);
                border-radius: 4px;
            }
            .table {
                min-width: 100%; /* ✨ اصلاح: جلوگیری از اسکرول غیرضروری */
                margin-bottom: 0;
            }
            .table thead th {
                color: var(--text);
                background: linear-gradient(to bottom, #f9fafb, #eef2ff);
                border-bottom: 2px solid var(--primary-100);
                font-weight: 700;
                font-size: 0.85rem; /* ✨ متراکم‌سازی */
                padding: 12px 10px; /* ✨ متراکم‌سازی */
                white-space: nowrap;
            }
            .table tbody td {
                padding: 12px 10px; /* ✨ متراکم‌سازی */
                vertical-align: middle;
                font-size: 0.88rem; /* ✨ متراکم‌سازی */
                border-color: var(--border);
            }
            .table-hover tbody tr {
                transition: var(--transition);
            }
            .table-hover tbody tr:hover {
                background-color: var(--primary-50);
            }

            /* AVATAR */
            .avatar {
                width: 36px; /* ✨ متراکم‌سازی */
                height: 36px; /* ✨ متراکم‌سازی */
                min-width: 36px;
                min-height: 36px;
                border-radius: 50%;
                overflow: hidden;
                background-color: #e5e7eb;
                display: flex;
                align-items: center;
                justify-content: center;
                flex-shrink: 0;
                box-shadow: var(--shadow-sm);
            }
            .avatar img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            .avatar-xs {
                width: 28px;
                height: 28px;
                min-width: 28px;
                min-height: 28px;
            }

            /* LETTER TITLE */
            .letter-title {
                font-weight: 600;
                color: var(--primary);
                cursor: pointer;
                transition: var(--transition);
                display: inline-block;
                font-size: 0.9rem; /* ✨ متراکم‌سازی */
            }
            .letter-title:hover {
                color: var(--primary-600);
                text-decoration: underline;
                text-decoration-thickness: 1.5px;
                text-underline-offset: 3px;
            }

            /* STATUS BADGE */
            .status-badge {
                display: inline-flex;
                align-items: center;
                gap: 6px;
                padding: 5px 12px; /* ✨ متراکم‌سازی */
                border-radius: 999px;
                font-size: 0.75rem; /* ✨ متراکم‌سازی */
                font-weight: 600;
                white-space: nowrap;
            }
            .status-badge.pending { background-color: #fffbeb; color: #d97706; }
            .status-badge.approved { background-color: #ecfdf5; color: #059669; }
            .status-badge.rejected { background-color: #fef2f2; color: #dc2626; }
            .status-badge.draft { background-color: #f3f4f6; color: #6b7280; }
            .status-badge.archived { background-color: #e5e7eb; color: #4b5563; }

            .badge-soft-danger {
                background-color: #fee2e2;
                color: #b91c1c;
            }
            .badge-soft-warning {
                background-color: #fef3c7;
                color: #92400e;
            }
            .bg-danger-subtle { background-color: #fee2e2; }
            .text-danger { color: #dc2626; }
            .border-danger-subtle { border-color: #fee2e2 !important; }

            .bg-success-subtle { background-color: #ecfdf5; }
            .text-success { color: #059669; }

            .bg-warning-subtle { background-color: #fffbeb; }
            .text-warning { color: #d97706; }

            .bg-primary-subtle { background-color: #eef2ff; }
            .text-primary { color: var(--primary); }

            .bg-secondary-subtle { background-color: #f3f4f6; }
            .text-secondary { color: #6b7280; }


            /* ACTION DROPDOWN */
            .action-dropdown {
                position: relative;
            }
            .action-dropdown-btn {
                width: 32px; /* ✨ متراکم‌سازی */
                height: 32px; /* ✨ متراکم‌سازی */
                border-radius: 10px; /* ✨ متراکم‌سازی */
                display: flex;
                align-items: center;
                justify-content: center;
                background: #f9fafb;
                border: 1px solid var(--border);
                color: var(--text-muted);
                transition: var(--transition);
                font-size: 0.85rem;
            }
            .action-dropdown-btn:hover {
                background: var(--primary-50);
                color: var(--primary);
                border-color: var(--primary);
            }
            .action-dropdown-menu {
                position: absolute;
                top: 100%;
                left: 50%;
                transform: translateX(-50%) translateY(-8px);
                margin-top: 8px;
                background: white;
                border-radius: 14px;
                box-shadow: var(--shadow);
                min-width: 190px;
                padding: 8px 0;
                z-index: 1000;
                opacity: 0;
                visibility: hidden;
                transition: opacity 0.2s, transform 0.2s;
            }
            .action-dropdown:hover .action-dropdown-menu {
                opacity: 1;
                visibility: visible;
                transform: translateX(-50%) translateY(0);
            }
            .action-dropdown-item {
                display: flex;
                align-items: center;
                gap: 10px;
                padding: 8px 14px; /* ✨ متراکم‌سازی */
                font-size: 0.85rem; /* ✨ متراکم‌سازی */
                color: var(--text);
                text-decoration: none;
                transition: var(--transition);
                cursor: pointer;
            }
            .action-dropdown-item:hover {
                background: var(--primary-50);
                color: var(--primary);
            }
            .action-dropdown-item i {
                width: 18px;
                text-align: center;
            }

            /* DUE DATE */
            .due-date-wrapper {
                font-size: 0.8rem; /* ✨ متراکم‌سازی */
                display: inline-flex;
                align-items: center;
                gap: .35rem;
            }
            .due-date-wrapper.critical {
                color: #dc2626;
                font-weight: 600;
            }
            .due-date-wrapper.warning {
                color: #d97706;
            }

            /* EMPTY STATE */
            .empty-state {
                padding: 64px 24px;
                text-align: center;
            }
            .empty-icon {
                width: 80px;
                height: 80px;
                margin: 0 auto 24px;
                background: #f3f4f6;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                color: #9ca3af;
                font-size: 2rem;
            }

            /* TIMELINE */
            .timeline {
                position: relative;
                padding-right: 16px;
            }
            .timeline::before {
                content: '';
                position: absolute;
                inset-block-start: 4px;
                inset-inline-end: 8px;
                width: 2px;
                height: 100%;
                background: linear-gradient(to bottom, #e5e7eb, #cbd5f5);
            }

            /* MODAL REFERRAL MODERNIZATION */
            .modal-body-referral {
                display: flex;
                padding: 0;
                min-height: 500px;
            }
            .user-list-pane {
                max-height: 500px;
                overflow-y: auto;
                border-inline-end: 1px solid var(--border);
                padding: 1.5rem;
            }
            .user-card-referral {
                transition: all 0.2s;
                border: 1px solid var(--border);
                cursor: pointer;
            }
            .user-card-referral:hover {
                background: var(--primary-50);
                border-color: var(--primary);
            }
            .purpose-pane {
                padding: 1.5rem;
                max-height: 500px;
                overflow-y: auto;
            }
            .purpose-toggle-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
                gap: 10px;
                margin-top: 15px;
            }
            .purpose-toggle-button {
                border-radius: 8px !important;
                font-weight: 600;
                padding: 12px 15px;
                transition: all 0.2s;
                box-shadow: var(--shadow-sm);
            }
            .purpose-toggle-button:hover {
                transform: translateY(-2px);
            }
            .user-card-selected {
                background: var(--primary-50) !important;
                border-color: var(--primary) !important;
            }
        </style>

        @push('scripts')
            <script>
                document.addEventListener('livewire:initialized', () => {
                    Livewire.hook('element.updated', (el) => {
                        if (el.querySelector('[data-bs-toggle="tooltip"]')) {
                            const tooltipTriggerList = [].slice.call(el.querySelectorAll('[data-bs-toggle="tooltip"]'));
                            tooltipTriggerList.forEach(tooltipTriggerEl => {
                                const tooltip = bootstrap.Tooltip.getInstance(tooltipTriggerEl);
                                if (tooltip) tooltip.dispose();
                                new bootstrap.Tooltip(tooltipTriggerEl, {
                                    placement: 'top',
                                    trigger: 'hover',
                                    container: 'body'
                                });
                            });
                        }
                    });
                });
            </script>
            {{-- ✨ اطمینان از Import بودن SweetAlert (برای Modal تأیید) --}}
            @if(file_exists(public_path('assets/js/sweetalert2.min.js')))
                <script src="{{ asset('assets/js/sweetalert2.min.js') }}"></script>
            @endif
        @endpush

        @php
            use Illuminate\Support\Str;
            $statusLabelMap = [
                'pending'  => 'در انتظار',
                'approved' => 'تایید شده',
                'rejected' => 'رد شده',
                'draft'    => 'پیش‌نویس',
                'archived' => 'بایگانی',
            ];
            // دسترسی به computed property در Blade
            $purposesOptions = $this->purposesOptions;
        @endphp

        <div class="notification-container position-fixed top-0 end-0 p-3" style="z-index: 1200;">
            <template x-for="t in toastStore.toasts" :key="t.id">
                <div x-show="t.visible"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-x-full"
                     x-transition:enter-end="opacity-100 translate-x-0"
                     x-transition:leave="transition ease-in duration-300"
                     x-transition:leave-start="opacity-100 translate-x-0"
                     x-transition:leave-end="opacity-0 translate-x-full"
                     class="toast show fade-in rounded-3 shadow-lg mb-3 overflow-hidden"
                     role="alert">
                    <div class="toast-header p-3"
                         :class="{
                             'bg-success text-white': t.type === 'success',
                             'bg-danger text-white': t.type === 'error',
                             'bg-info text-white': t.type === 'info',
                             'bg-primary text-white': t.type === 'global'
                         }">
                        <i class="me-2"
                           :class="{
                               'fas fa-check-circle': t.type === 'success',
                               'fas fa-exclamation-triangle': t.type === 'error',
                               'fas fa-info-circle': t.type === 'info',
                               'fas fa-bell': t.type === 'global'
                           }"></i>
                        <strong class="me-auto"
                                x-text="t.type === 'success' ? 'موفقیت' : (t.type === 'error' ? 'خطا' : (t.type === 'global' ? 'اطلاعیه' : 'اطلاعات'))">
                        </strong>
                        <button type="button" class="btn-close btn-close-white" @click="t.visible = false"></button>
                    </div>
                    <div class="toast-body bg-white text-dark" x-text="t.message"></div>
                </div>
            </template>
        </div>

        <div class="page-header position-relative">
            <div class="d-flex flex-column flex-md-row align-items-center justify-content-between gap-4">
                <div class="d-flex align-items-center flex-wrap">
                    <span class="header-icon-wrapper shadow-sm">
                        <i class="fas fa-envelope-open-text text-white fs-2"></i>
                    </span>
                    <div class="ms-4">
                        <h1 class="header-main-title">صندوق نامه‌های من</h1>
                        <div class="header-sub-title">
                            مدیریت، ارجاع و رهگیری هوشمند نامه‌های ارسالی در یک نگاه
                        </div>
                    </div>
                </div>

                <a href="{{ route('admin.create.letter') }}"
                   class="btn px-5 py-3 fw-bold rounded-3 d-flex align-items-center gap-2"
                   style="background: white; color: var(--primary); box-shadow: var(--shadow);">
                    <i class="fas fa-plus ms-1"></i>
                    <span>نامه جدید</span>
                </a>
            </div>

            <div class="filter-section mt-3">
                <div class="d-flex flex-wrap align-items-end gap-3">

                    <div class="flex-fill" style="max-width: 300px;">
                        <label class="form-label small mb-1">جستجو</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="fas fa-search text-primary"></i>
                            </span>
                            <input type="text"
                                   wire:model.live.debounce.400ms="searchLetter"
                                   class="form-control"
                                   placeholder="عنوان یا محتوا...">
                        </div>
                    </div>

                    <div wire:ignore class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">بازه تاریخ</label>
                        <div class="d-flex gap-2">
                            <input type="text" id="filter-from-date" class="form-control form-control-sm"
                                   placeholder="از" style="width: 120px;">
                            <input type="text" id="filter-to-date" class="form-control form-control-sm"
                                   placeholder="تا" style="width: 120px;">
                            <input type="hidden" id="filter-from-date-alt" wire:model="filterFromDate">
                            <input type="hidden" id="filter-to-date-alt" wire:model="filterToDate">
                        </div>
                    </div>

                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">وضعیت</label>
                        <select class="form-select form-select-sm" wire:model.live="filterStatus" style="width: 150px">
                            <option value="">همه (بایگانی نشده)</option>
                            <option value="pending">در انتظار</option>
                            <option value="approved">تایید شده</option>
                            <option value="rejected">رد شده</option>
                            <option value="draft">پیش‌نویس</option>
                        </select>
                    </div>

                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">پروژه</label>
                        <select class="form-select form-select-sm" wire:model.live="filterProject" style="width: 150px">
                            <option value="">همه پروژه‌ها</option>
                            @foreach($this->userProjects as $project)
                                <option value="{{ $project->id }}">{{ Str::limit($project->name, 20) }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">فوری</label>
                        <div class="form-check form-switch p-0 mt-1">
                            <input class="form-check-input ms-3 mt-2" type="checkbox" role="switch"
                                   wire:model.live="filterUrgent" id="filterUrgentSwitch" style="font-size: 1.1rem;">
                            <label class="form-check-label text-white fw-bold small" for="filterUrgentSwitch">
                                <i class="fas fa-exclamation-triangle text-danger me-1"></i> فقط فوری
                            </label>
                        </div>
                    </div>

                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">صفحه‌بندی</label>
                        <select class="form-select form-select-sm" wire:model.live="perPage" style="width: 100px">
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                        </select>
                    </div>

                    <div class="ms-auto">
                        <button wire:click="resetFilters"
                                class="btn btn-outline-light btn-sm d-flex align-items-center gap-1 rounded-pill px-3">
                            <i class="fas fa-undo"></i> ریست
                        </button>
                    </div>
                </div>

                @if($filterStatus || $filterFromDate || $filterToDate || $searchLetter || $filterProject || $filterUrgent)
                    <div class="active-filters-wrapper">
                        <div class="d-flex flex-wrap align-items-center gap-2">
                            <span class="text-white fw-bold small">فیلترهای فعال:</span>

                            @if($searchLetter)
                                <span class="active-filter-badge">
                                    <i class="fas fa-search"></i> {{ Str::limit($searchLetter, 18) }}
                                    <button wire:click="$set('searchLetter', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            @endif

                            @if($filterStatus)
                                <span class="active-filter-badge">
                                    <i class="fas fa-flag"></i>
                                    {{ $statusLabelMap[$filterStatus] ?? $filterStatus }}
                                    <button wire:click="$set('filterStatus', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            @endif

                            @if($filterProject)
                                <span class="active-filter-badge">
                                    <i class="fas fa-folder"></i>
                                    پروژه: {{ $this->userProjects->firstWhere('id', $filterProject)->name ?? 'ناشناس' }}
                                    <button wire:click="$set('filterProject', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            @endif

                            @if($filterUrgent)
                                <span class="active-filter-badge bg-danger-subtle text-danger border-danger-subtle">
                                    <i class="fas fa-exclamation-triangle"></i> فقط فوری
                                    <button wire:click="$set('filterUrgent', false)" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            @endif

                            @if($filterFromDate)
                                <span class="active-filter-badge">
                                    <i class="far fa-calendar-alt"></i>
                                    از: {{ $this->formatShamsiDate($filterFromDate, 'Y/m/d') }}
                                    <button wire:click="$set('filterFromDate', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            @endif

                            @if($filterToDate)
                                <span class="active-filter-badge">
                                    <i class="far fa-calendar-alt"></i>
                                    تا: {{ $this->formatShamsiDate($filterToDate, 'Y/m/d') }}
                                    <button wire:click="$set('filterToDate', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            @endif
                        </div>
                    </div>
                @endif
            </div>

            <div class="row g-3 mt-3 stat-row">
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="stat-label">کل نامه‌ها</span>
                            <span class="stat-icon">
                                <i class="fas fa-layer-group"></i>
                            </span>
                        </div>
                        <div class="fs-4 fw-bold">{{ $statusCounts->sum() }}</div>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="stat-label">در انتظار</span>
                            <span class="stat-icon">
                                <i class="fas fa-clock"></i>
                            </span>
                        </div>
                        <div class="fs-4 fw-bold text-warning">{{ $statusCounts['pending'] ?? 0 }}</div>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="stat-label">تایید شده</span>
                            <span class="stat-icon">
                                <i class="fas fa-check-circle"></i>
                            </span>
                        </div>
                        <div class="fs-4 fw-bold text-success">{{ $statusCounts['approved'] ?? 0 }}</div>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="stat-label">رد / پیش‌نویس</span>
                            <span class="stat-icon">
                                <i class="fas fa-pen"></i>
                            </span>
                        </div>
                        <div class="fs-4 fw-bold text-light">
                            {{ ($statusCounts['rejected'] ?? 0) + ($statusCounts['draft'] ?? 0) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content-card">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead>
                    <tr>
                        <th class="ps-4">عنوان نامه</th>
                        <th class="text-center d-none d-md-table-cell">کد</th>
                        <th class="text-center d-none d-lg-table-cell">تاریخ ایجاد</th>
                        <th class="text-center d-none d-lg-table-cell">سررسید</th>
                        <th class="text-center d-none d-lg-table-cell">خواندن</th>
                        <th class="text-center">ارجاعات</th>
                        <th class="text-center d-none d-lg-table-cell">مسئول فعلی</th>
                        <th class="text-center">وضعیت</th>
                        <th class="pe-4 text-end">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse ($letters as $letter)
                        <tr wire:key="letter-{{ $letter->id }}">
                            <td class="ps-4">
                                <div class="d-flex align-items-center gap-2">
                                    <div class="avatar flex-shrink-0">
                                        <img src="{{ $this->getUserProfilePhotoUrl($letter->user) }}"
                                             alt="{{ $letter->user->name ?? '—' }}">
                                    </div>
                                    <div>
                                        <a wire:click="showPreview({{ $letter->id }})" class="letter-title">
                                            {{ Str::limit($letter->title, 40) }}
                                        </a>
                                        <div class="text-muted small mt-1 d-flex align-items-center gap-2" style="font-size: 0.75rem;">
                                            @if ($letter->confidential)
                                                <i class="fas fa-lock text-danger" data-bs-toggle="tooltip" title="محرمانه"></i>
                                            @endif
                                            <i class="far fa-calendar-alt me-1"></i>
                                            {{ $this->formatShamsiDate($letter->created_at, 'Y/m/d') }}
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="text-center d-none d-md-table-cell fw-medium">
                                {{ Str::limit($letter->code ?? 'LTR-' . $letter->id, 12) }}
                            </td>
                            <td class="text-center d-none d-lg-table-cell text-muted small">
                                {{ $this->formatShamsiDate($letter->created_at, 'Y/m/d') }}
                            </td>
                            <td class="text-center d-none d-lg-table-cell">
                                @if($letter->due_date)
                                    @php
                                        $daysDiff = $letter->due_date->diffInDays(now(), false);
                                    @endphp
                                    <span class="due-date-wrapper {{ $letter->due_date->isPast() ? 'critical' : ($daysDiff <= 3 ? 'warning' : '') }}">
                                        {{ $this->formatShamsiDate($letter->due_date, 'Y/m/d') }}
                                        @if($letter->due_date->isPast())
                                            <span class="badge badge-soft-danger rounded-pill px-2 py-1">گذشته</span>
                                        @elseif($daysDiff <= 3)
                                            <span class="badge badge-soft-warning rounded-pill px-2 py-1">نزدیک سررسید</span>
                                        @endif
                                    </span>
                                @else
                                    <span class="text-muted">—</span>
                                @endif
                            </td>

                            {{-- ✨ وضعیت خوانده شدن --}}
                            <td class="text-center d-none d-lg-table-cell">
                                @if ($letter->receivers()->exists())
                                    @php
                                        $percentage = $letter->read_percentage;
                                        $color = match (true) {
                                            $percentage === 100 => 'success',
                                            $percentage >= 50 => 'warning',
                                            default => 'danger',
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $color }}-subtle text-{{ $color }} rounded-pill px-3 py-1 fw-normal"
                                          data-bs-toggle="tooltip"
                                          title="تعداد خوانده شده: {{ $letter->read_count }}">
                                        {{ $percentage }}%
                                    </span>
                                @else
                                    <span class="text-muted small">—</span>
                                @endif
                            </td>
                            {{-- ✨ پایان وضعیت خوانده شدن --}}

                            <td class="text-center">
                                @if($letter->referrals_count)
                                    <span class="badge bg-primary-subtle text-primary rounded-pill px-3 py-1 fw-normal">
                                        {{ $letter->referrals_count }} ارجاع
                                    </span>
                                @else
                                    <span class="badge bg-secondary-subtle text-secondary rounded-pill px-3 py-1 fw-normal">
                                        —
                                    </span>
                                @endif
                            </td>

                            {{-- ✨ مسئول فعلی ارجاع --}}
                            <td class="text-center d-none d-lg-table-cell">
                                @php
                                    // اولویت با ارجاع فعال (pending)
                                    $currentReferral = $letter->latestActiveReferral ?? $letter->latestReferral;
                                @endphp

                                @if($currentReferral)
                                    <div class="d-flex align-items-center justify-content-center gap-2">
                                        <div class="avatar avatar-xs flex-shrink-0">
                                            <img src="{{ $this->getUserProfilePhotoUrl($currentReferral->user) }}">
                                        </div>
                                        <div>
                                            <span class="fw-bold small d-block text-truncate" style="max-width: 100px;" data-bs-toggle="tooltip" title="ارجاع از: {{ $currentReferral->creator->name ?? 'سیستم' }}">
                                                {{ Str::limit($currentReferral->user->name ?? '—', 15) }}
                                            </span>
                                            <span class="badge bg-{{ $currentReferral->status === \App\Models\Referral::STATUS_PENDING ? 'warning-subtle text-warning' : 'success-subtle text-success' }} rounded-pill px-2" style="font-size: 0.65rem;">
                                                {{ $currentReferral->typeLabel() }}
                                            </span>
                                        </div>
                                    </div>
                                @else
                                    <span class="text-muted small">—</span>
                                @endif
                            </td>
                            {{-- ✨ پایان مسئول فعلی ارجاع --}}

                            <td class="text-center">
                                <span class="status-badge {{ $letter->status ?? 'draft' }}">
                                    @switch($letter->status)
                                        @case('approved')
                                            <i class="fas fa-check-circle"></i> تایید شده
                                            @break
                                        @case('rejected')
                                            <i class="fas fa-times-circle"></i> رد شده
                                            @break
                                        @case('pending')
                                            <i class="fas fa-clock"></i> در انتظار
                                            @break
                                        @case('archived')
                                            <i class="fas fa-box-archive"></i> بایگانی
                                            @break
                                        @default
                                            <i class="fas fa-pen"></i> پیش‌نویس
                                    @endswitch
                                </span>
                            </td>
                            <td class="pe-4 text-end">
                                <div class="d-flex justify-content-end align-items-center gap-2">
                                    @if ($letter->status === 'draft')
                                        <button class="btn btn-sm btn-success rounded-pill px-3 py-1 fw-bold"
                                                wire:click="quickSendForSign({{ $letter->id }})"
                                                data-bs-toggle="tooltip" title="ارسال سریع برای امضا">
                                            <i class="fas fa-share-square me-1"></i> ارسال
                                        </button>
                                    @endif
                                    <div class="action-dropdown">
                                        <button class="action-dropdown-btn">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="action-dropdown-menu shadow">
                                            <div class="action-dropdown-item" wire:click="showPreview({{ $letter->id }})">
                                                <i class="fas fa-eye"></i> پیش‌نمایش
                                            </div>
                                            <div class="action-dropdown-item" wire:click="openSendPurposeModal({{ $letter->id }})">
                                                <i class="fas fa-paper-plane"></i> ارجاع
                                            </div>
                                            <div class="action-dropdown-item" wire:click="cloneLetterContent({{ $letter->id }})">
                                                <i class="fas fa-copy"></i> استفاده از متن نامه
                                            </div>

                                            @if($letter->status === 'pending' && $letter->referrals_count > 0)
                                                <div class="action-dropdown-item" wire:click="sendReferralReminder({{ $letter->id }})">
                                                    <i class="fas fa-bell"></i> یادآوری
                                                </div>
                                            @endif

                                            {{-- ✨ دکمه بایگانی --}}
                                            @if ($letter->status !== \App\Models\Letter::STATUS_ARCHIVED && $letter->status !== \App\Models\Letter::STATUS_PENDING)
                                                <div class="action-dropdown-item text-secondary"
                                                     wire:click="confirmArchive({{ $letter->id }})">
                                                    <i class="fas fa-box-archive"></i> بایگانی
                                                </div>
                                            @endif

                                            <div class="action-dropdown-item" wire:click="openReferralTreeModal({{ $letter->id }})">
                                                <i class="fas fa-sitemap"></i> تاریخچه
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="empty-state">
                                <div class="empty-icon">
                                    <i class="fas fa-inbox"></i>
                                </div>
                                <h5 class="fw-bold text-gray-700">نتیجه‌ای یافت نشد</h5>
                                <p class="text-muted mb-4">هیچ نامه‌ای با این شرایط وجود ندارد.</p>
                                <div class="d-flex justify-content-center gap-2">
                                    <button wire:click="resetFilters"
                                            class="btn btn-outline-secondary btn-sm rounded-pill px-3">
                                        <i class="fas fa-filter me-1"></i> ریست فیلترها
                                    </button>
                                    <a href="{{ route('admin.create.letter') }}"
                                       class="btn btn-primary btn-sm rounded-pill px-3">
                                        <i class="fas fa-plus me-1"></i> نامه جدید
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            @if($letters->hasPages())
                <div class="p-4 d-flex flex-column flex-md-row justify-content-between align-items-center gap-3 border-top">
                    <div class="text-muted small">
                        نمایش <b>{{ $letters->firstItem() }}</b> تا <b>{{ $letters->lastItem() }}</b> از <b>{{ $letters->total() }}</b> مورد
                    </div>
                    {{ $letters->links('pagination::bootstrap-5') }}
                </div>
            @endif
        </div>

        @if($showPreviewModal && $previewLetter)
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.7);" tabindex="-1">
                <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content border-0 rounded-4 shadow-lg">
                        <div class="modal-header" style="background: var(--primary); color: white; padding: 20px;">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm bg-white bg-opacity-20 text-white rounded-circle me-3">
                                    <i class="fas fa-file-alt"></i>
                                </div>
                                <h5 class="modal-title fw-bold">پیش‌نمایش نامه</h5>
                            </div>
                            <button type="button" class="btn-close btn-close-white" wire:click="closePreviewModal"></button>
                        </div>
                        <div class="modal-body p-0">
                            <div class="border-bottom p-4 bg-light">
                                <div class="d-flex justify-content-between flex-wrap gap-3">
                                    <div>
                                        <span class="badge bg-primary me-2">
                                            کد: {{ $previewLetter->code ?? 'LTR-'.$previewLetter->id }}
                                        </span>
                                        <span class="badge bg-secondary">
                                            تاریخ: {{ $this->formatShamsiDate($previewLetter->created_at, 'Y/m/d') }}
                                        </span>
                                        {{-- ✨ نمایش درصد خوانده شدن در پیش‌نمایش --}}
                                        @if ($previewLetter->receivers()->exists())
                                            <span class="badge bg-info text-white me-2" data-bs-toggle="tooltip" title="تعداد خوانده شده: {{ $previewLetter->read_count }}">
                                                <i class="fas fa-eye me-1"></i> {{ $previewLetter->read_percentage }}% خوانده شده
                                            </span>
                                        @endif
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar avatar-xs me-2">
                                            <img src="{{ $this->getUserProfilePhotoUrl($previewLetter->user) }}">
                                        </div>
                                        <span class="text-muted small">{{ $previewLetter->user->name ?? 'سیستم' }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="p-4" style="min-height: 400px; max-height: 600px; overflow-y: auto;">
                                <div class="bg-white rounded-3 p-4 shadow-sm border">
                                    {!! $previewLetter->content !!}
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer bg-light p-4 d-flex justify-content-between">
                            <button class="btn btn-outline-secondary px-4 rounded-3" wire:click="closePreviewModal">
                                بستن
                            </button>

                            <div class="d-flex gap-2">
                                @if($previewLetterId)
                                    <a href="{{ route('letter.show', $this->previewLetterId) }}"
                                       class="btn btn-outline-primary px-4 rounded-3">
                                        <i class="fas fa-expand me-1"></i> مشاهده کامل
                                    </a>
                                @endif

                                <button class="btn btn-primary px-4 rounded-3"
                                        wire:click="openSendPurposeModal({{ $this->previewLetterId }})">
                                    <i class="fas fa-paper-plane me-1"></i> ارسال نامه
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        @if($showSendPurposeModal)
            @php
                $currentLetter = \App\Models\Letter::find($letter_id);
                $signerUser = $currentLetter?->user;
            @endphp
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.85);" tabindex="-1">
                <div class="modal-dialog modal-xl modal-dialog-centered">
                    <div class="modal-content border-0 rounded-4 shadow-lg">

                        <div class="modal-header" style="background: linear-gradient(90deg, #3b82f6 0%, var(--primary) 100%); color: white; padding: 20px;">
                            <div class="d-flex flex-column">
                                <h5 class="modal-title fw-bold mb-1">
                                    <i class="fas fa-paper-plane me-2"></i> ارجاع نامه: {{ Str::limit($currentLetter?->title ?? 'نامه نامشخص', 60) }}
                                </h5>
                                <div class="text-white small opacity-75 mt-1">
                                    @if($signerUser)
                                        <i class="fas fa-signature me-1"></i> امضاکننده نهایی: {{ $signerUser->name ?? '—' }}
                                        @if($currentLetter->signature_position)<span class="ms-1">({{ $currentLetter->signature_position }})</span>@endif
                                    @endif
                                </div>
                            </div>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeSendPurposeModal"></button>
                        </div>

                        <form wire:submit.prevent="submitSendPurpose">

                            <div class="modal-body-referral d-flex flex-column flex-md-row">

                                <div class="col-md-5 user-list-pane">
                                    <div class="sticky-top bg-white pt-0 pb-3 border-bottom mb-3" style="z-index: 10;">
                                        <h6 class="fw-bold text-primary mb-2">انتخاب گیرندگان</h6>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text rounded-start-3"><i class="fas fa-search text-primary"></i></span>
                                            <input type="text" class="form-control rounded-end-3"
                                                   wire:model.live.debounce.300ms="searchUser"
                                                   placeholder="جستجوی کاربران...">
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox"
                                                       wire:click="toggleSelectAllUsers"
                                                       id="selectAllUsers"
                                                    @checked(count($selectedUsers) === $users->count() && $users->isNotEmpty())>
                                                <label class="form-check-label small fw-bold" for="selectAllUsers">
                                                    <i class="fas fa-users me-1 text-primary"></i> انتخاب همه
                                                </label>
                                            </div>
                                            <span class="badge bg-primary rounded-pill px-3 py-1 fw-bold">
                                                {{ count($selectedUsers) }} انتخاب شده
                                            </span>
                                        </div>
                                    </div>

                                    <div class="row g-2">
                                        @if($users->isNotEmpty())
                                            @foreach($users as $user)
                                                @php
                                                    $userIsSelected = in_array($user->id, $selectedUsers);
                                                    $userIsSigner = ($user->id === $signerUser?->id);
                                                @endphp
                                                <div class="col-12" wire:key="user-{{ $user->id }}">
                                                    <div class="card user-card-referral rounded-3 shadow-none @if($userIsSelected) user-card-selected @endif"
                                                         style="border-color: @error('selectedPurposes.'.$user->id) #dc2626 @endif">
                                                        <div class="card-body p-3">
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <label class="form-check-label d-flex align-items-center flex-grow-1" for="user_{{ $user->id }}">
                                                                    <div class="avatar avatar-sm me-3">
                                                                        <img src="{{ $this->getUserProfilePhotoUrl($user) }}" alt="{{ $user->name }}">
                                                                    </div>
                                                                    <div>
                                                                        <div class="fw-bold text-dark">
                                                                            {{ $user->name }}
                                                                            @if($userIsSigner)
                                                                                <i class="fas fa-user-tag text-accent small ms-1" title="امضاکننده نهایی نامه"></i>
                                                                            @endif
                                                                        </div>
                                                                        <div class="text-muted small">{{ Str::limit($user->email, 25) }}</div>
                                                                    </div>
                                                                </label>
                                                                <input class="form-check-input flex-shrink-0" type="checkbox"
                                                                       wire:model.live="selectedUsers"
                                                                       value="{{ $user->id }}"
                                                                       id="user_{{ $user->id }}"
                                                                       style="width: 20px; height: 20px;">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @else
                                            <div class="text-center py-5">
                                                <i class="fas fa-user-slash fa-3x text-muted mb-3"></i>
                                                <p class="text-muted fw-bold">کاربری یافت نشد.</p>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <div class="col-md-7 purpose-pane">
                                    @if(count($selectedUsers))
                                        <h5 class="fw-bold text-primary mb-4">
                                            <i class="fas fa-tasks me-2"></i> تعیین هدف ارجاع
                                        </h5>

                                        @foreach($selectedUsers as $userId)
                                            @php
                                                $user = $users->firstWhere('id', $userId);
                                                if (!$user) continue;
                                                $userIsSigner = ($userId === $signerUser?->id);
                                            @endphp
                                            <div class="mb-4 p-3 rounded-3" style="border: 1px solid var(--border); background: var(--primary-50);" wire:key="user-purpose-{{ $userId }}">
                                                <h6 class="fw-bold mb-3 d-flex align-items-center text-dark">
                                                    <div class="avatar avatar-xs me-2">
                                                        <img src="{{ $this->getUserProfilePhotoUrl($user) }}" alt="">
                                                    </div>
                                                    {{ $user->name }}
                                                    @if($userIsSigner) <span class="badge bg-accent ms-2">امضاکننده</span> @endif
                                                </h6>

                                                <div class="purpose-toggle-grid">
                                                    {{-- SEND PURPOSE MODAL > Objectives Pane > foreach purposes --}}
                                                    @foreach($this->purposesOptions as $purpose => $details)
                                                        @php
                                                            // تعریف مجدد این متغیرها برای راحتی دسترسی
                                                            $isSignerOption = ($purpose === 'امضا');
                                                            $isUserSigner = ($userId === $signerUser?->id);
                                                        @endphp

                                                        @if ($isSignerOption && !$isUserSigner)
                                                            @continue {{-- اگر امضا است و کاربر امضاکننده نامه نیست، نمایش نده --}}
                                                        @endif

                                                        <input type="checkbox" class="btn-check"
                                                               wire:model="selectedPurposes.{{ $userId }}.{{ $purpose }}"
                                                               id="purpose_{{ $userId }}_{{ Str::slug($purpose) }}"
                                                               autocomplete="off"
                                                            {{-- اگر امضا است و کاربر امضاکننده است، آن را به عنوان پیش‌فرض ست می‌کنیم --}}
                                                            @checked($isSignerOption && $isUserSigner && $this->selectedPurposes[$userId][$purpose] ?? true)
                                                        >
                                                        <label class="btn purpose-toggle-button"
                                                               for="purpose_{{ $userId }}_{{ Str::slug($purpose) }}"
                                                               {{-- کلاس‌های داینامیک --}}
                                                               :class="{
                'btn-outline-{{ $details['color'] }}': !@this.selectedPurposes[{{ $userId }}]['{{ $purpose }}'],
                'btn-{{ $details['color'] }} text-white shadow-sm': @this.selectedPurposes[{{ $userId }}]['{{ $purpose }}']
           }"
                                                               data-bs-toggle="tooltip"
                                                               title="{{ $details['description'] }}">
                                                            <i class="{{ $details['icon'] }} me-1"></i>
                                                            {{ $purpose }}
                                                        </label>
                                                    @endforeach
                                                </div>

                                                @error("selectedPurposes.{$userId}")
                                                <div class="text-danger small mt-2 fw-bold">
                                                    <i class="fas fa-exclamation-triangle me-1"></i> {{ $message }}
                                                </div>
                                                @enderror
                                            </div>
                                        @endforeach

                                    @else
                                        <div class="text-center py-5 border rounded-3 bg-light">
                                            <i class="fas fa-mouse-pointer fa-3x text-muted mb-3"></i>
                                            <p class="text-muted fw-bold">لطفاً ابتدا کاربران مورد نظر را از لیست سمت چپ انتخاب کنید.</p>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div class="modal-footer bg-light p-4">
                                <button type="button" class="btn btn-outline-secondary rounded-3 px-4"
                                        wire:click="closeSendPurposeModal">
                                    <i class="fas fa-times me-1"></i> انصراف
                                </button>
                                <button type="submit" class="btn btn-primary rounded-3 px-4"
                                        wire:loading.attr="disabled">
                                    <span wire:loading.remove>
                                        <i class="fas fa-paper-plane me-1"></i> ارسال ارجاع ({{ count($selectedUsers) }})
                                    </span>
                                    <span wire:loading>
                                        <span class="spinner-border spinner-border-sm me-2"></span> در حال ارسال...
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endif

        @if($showReferralTreeModal)
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.7);" tabindex="-1">
                <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content border-0 rounded-4 shadow-lg">
                        <div class="modal-header" style="background: var(--secondary); color: white; padding: 20px;">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm bg-white bg-opacity-20 text-white rounded-circle me-3">
                                    <i class="fas fa-history"></i>
                                </div>
                                <h5 class="modal-title fw-bold">تاریخچه و مسیر ارجاعات</h5>
                            </div>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeReferralTreeModal"></button>
                        </div>
                        <div class="modal-body p-0">
                            <div class="row g-0">
                                <div class="col-md-6 border-end" style="border-color: var(--border);">
                                    <div class="p-4">
                                        <h5 class="fw-bold text-primary mb-3">
                                            <i class="fas fa-sitemap me-2"></i> درخت ارجاعات
                                        </h5>
                                        @if(count($referralTree))
                                            <div class="ps-3">
                                                @foreach($referralTree as $node)
                                                    @include('livewire.admin.letter.partials.referral-tree-node', [
                                                        'nodes' => [$node],
                                                        'level' => 0
                                                    ])
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="text-center py-4 bg-light rounded-3">
                                                <i class="fas fa-info-circle text-muted fs-1 mb-2"></i>
                                                <p class="text-muted">هیچ ارجاعی ثبت نشده است.</p>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="p-4">
                                        <h5 class="fw-bold text-secondary mb-4">
                                            <i class="fas fa-list-ul me-2"></i> خط زمانی رویدادها
                                        </h5>
                                        @if($historyTimeline->isNotEmpty())
                                            <div class="timeline">
                                                @foreach($historyTimeline as $event)
                                                    <div class="d-flex mb-4">
                                                        <div class="avatar avatar-sm me-3 mt-1">
                                                            <img src="{{ $this->getUserProfilePhotoUrl($event->user) }}">
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <div class="fw-bold small mb-1">{{ $event->user->name ?? '—' }}</div>
                                                            <div class="text-muted small mb-1">
                                                                <i class="far fa-clock me-1"></i>
                                                                {{ $this->formatShamsiDate($event->created_at, 'Y/m/d H:i') }}
                                                                <span class="badge bg-light text-dark ms-2">{{ $event->type }}</span>
                                                            </div>
                                                            @if($event->description)
                                                                <div class="mt-1 bg-light p-2 rounded-2 small border">
                                                                    {{ $event->description }}
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="text-center py-4 bg-light rounded-3">
                                                <i class="fas fa-clock text-muted fs-1 mb-2"></i>
                                                <p class="text-muted">هیچ رویدادی ثبت نشده است.</p>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer bg-light p-4">
                            <button type="button" class="btn btn-outline-secondary rounded-3 px-4"
                                    wire:click="closeReferralTreeModal">
                                بستن
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
    <style>
        /* --------------------------------------
           CSS Styles for Final Minimal Design (Timeline Node)
        ----------------------------------------- */
        /* انیمیشن */
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(15px); }
            to { opacity: 1; transform: translateY(0); }
        }
        /* رنگ‌های کم‌رنگ (Subtle Backgrounds) */
        .bg-danger-subtle { background-color: #fee2e2; }
        .text-danger { color: #dc2626; }
        .border-danger-subtle { border-color: #fee2e2 !important; }

        .bg-success-subtle { background-color: #f0fdf4; }
        .text-success { color: #059669; }
        .border-success-subtle { border-color: #d1fae5 !important; }

        .bg-warning-subtle { background-color: #fffbeb; }
        .text-warning { color: #d97706; }

        .bg-info-subtle { background-color: #eff6ff; }
        .text-info { color: #3b82f6; }

        .bg-primary-subtle { background-color: #eef2ff; }
        .text-primary { color: var(--bs-primary); }

        .bg-secondary-subtle { background-color: #f3f4f6; }
        .text-secondary { color: #6b7280; }

        /* Timeline Main Line */
        .referral-tree-node {
            padding-inline-start: 35px; /* افزایش پدینگ برای تراز بهتر */
        }
        .referral-tree-node > .referral-card-wrapper {
            padding-top: 15px; /* افزایش فاصله دایره از بالا */
        }

        /* خط عمودی اصلی (بهره‌گیری از همان رنگ) */
        .referral-tree-node::before {
            inset-inline-start: 12px;
            background-color: #e5e7eb;
        }
        /* خط افقی (حذف شد، به جای آن از padding/margin استفاده می‌کنیم) */
        .referral-tree-node > .referral-card-wrapper::before {
            display: none;
        }
        /* اگر گره تکمیل شده، خط را سبز کن */
        .referral-tree-node.is-completed::before {
            background-color: var(--bs-success);
        }

        /* Status Icon Styling */
        .referral-status-icon {
            width: 18px;
            height: 18px;
            border-width: 3px !important;
            left: 12px;
            margin-top: 3px; /* تراز با شروع کارت */
        }

        /* Children Line Fix */
        .referral-tree-node .ps-4 {
            padding-inline-start: 24px !important;
        }
        .referral-tree-node .ps-4 > .w-px {
            left: 12px;
        }
    </style>
</div>
