<div wire:ignore.self class="modal fade" id="formModal" tabindex="-1" aria-labelledby="formModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white" style="border-radius: 14px 14px 0 0;">
                <h5 class="modal-title" id="formModalLabel">
                    <i class="fas fa-{{ $editId ? 'edit' : 'plus-circle' }} me-2"></i>
                    {{ $editId ? __('ویرایش مدرک') : __('افزودن مدرک جدید') }}
                </h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closeForm" aria-label="Close"></button>
            </div>
            <form wire:submit.prevent="saveDocument" class="needs-validation" novalidate>
                <div class="modal-body p-4">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('document_number') is-invalid @enderror" id="document_number" placeholder="{{ __('شماره مدرک') }}" wire:model.defer="document_number">
                                <label for="document_number">{{ __('شماره مدرک') }} *</label>
                                @error('document_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" placeholder="{{ __('عنوان مدرک') }}" wire:model.defer="title">
                                <label for="title">{{ __('عنوان مدرک') }} *</label>
                                @error('title') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label d-block">{{ __('کلاس (Category)') }} *</label>
                            <div class="input-group">
                                <select class="form-select @error('category_id') is-invalid @enderror" wire:model.defer="category_id">
                                    <option value="">{{ __('انتخاب کنید') }}</option>
                                    @foreach($categories as $cat)
                                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                    @endforeach
                                </select>
                                <button class="btn btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#addCategoryCollapse" aria-expanded="false" title="{{ __('افزودن کلاس جدید') }}">
                                    <i class="fas fa-plus"></i>
                                </button>
                                @error('category_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="collapse mt-2" id="addCategoryCollapse">
                                <div class="input-group">
                                    <input type="text" class="form-control form-control-sm @error('new_category') is-invalid @enderror" placeholder="{{ __('کلاس جدید') }}" wire:model.defer="new_category">
                                    <button class="btn btn-success btn-sm" type="button" wire:click="addCategory" wire:loading.attr="disabled">
                                        {{ __('ثبت') }}
                                    </button>
                                    @error('new_category') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label d-block">{{ __('دیسپلین (Discipline)') }} *</label>
                            <div class="input-group">
                                <select class="form-select @error('discipline_id') is-invalid @enderror" wire:model.defer="discipline_id">
                                    <option value="">{{ __('انتخاب کنید') }}</option>
                                    @foreach($disciplines as $disc)
                                        <option value="{{ $disc->id }}">{{ $disc->name }}</option>
                                    @endforeach
                                </select>
                                <button class="btn btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#addDisciplineCollapse" aria-expanded="false" title="{{ __('افزودن دیسپلین جدید') }}">
                                    <i class="fas fa-plus"></i>
                                </button>
                                @error('discipline_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="collapse mt-2" id="addDisciplineCollapse">
                                <div class="input-group">
                                    <input type="text" class="form-control form-control-sm @error('new_discipline') is-invalid @enderror" placeholder="{{ __('دیسپلین جدید') }}" wire:model.defer="new_discipline">
                                    <button class="btn btn-success btn-sm" type="button" wire:click="addDiscipline" wire:loading.attr="disabled">
                                        {{ __('ثبت') }}
                                    </button>
                                    @error('new_discipline') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('document_type') is-invalid @enderror" id="document_type" placeholder="{{ __('توضیحات نوع مدرک') }}" wire:model.defer="document_type">
                                <label for="document_type">{{ __('توضیحات نوع مدرک (اختیاری)') }}</label>
                                @error('document_type') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-floating">
                                <input type="number" step="0.01" min="0.01" class="form-control @error('weight') is-invalid @enderror" id="weight" placeholder="{{ __('وزن') }}" wire:model.defer="weight">
                                <label for="weight">{{ __('وزن (POI)') }}</label>
                                @error('weight') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label for="status" class="form-label">{{ __('وضعیت اولیه') }}</label>
                            <select class="form-select @error('status') is-invalid @enderror" id="status" wire:model.defer="status">
                                <option value="در حال تهیه">{{ __('در حال تهیه') }}</option>
                                <option value="ارسال شده">{{ __('ارسال شده') }}</option>
                                <option value="تایید شده">{{ __('تایید شده') }}</option>
                                <option value="رد شده">{{ __('رد شده') }}</option>
                                <option value="نامشخص">{{ __('نامشخص') }}</option>
                            </select>
                            @error('status') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        @if(!$editId)
                            <div class="col-12">
                                <label for="files" class="form-label d-block fw-bold"><i class="fas fa-file-upload me-1"></i> {{ __('فایل(ها)ی اولیه (اختیاری)') }}</label>
                                <input type="file" class="form-control @error('files.*') is-invalid @enderror" id="files" wire:model="files" multiple>
                                <div wire:loading wire:target="files" class="text-info mt-1"><i class="fas fa-spinner fa-spin"></i> {{ __('در حال بارگذاری فایل‌ها...') }}</div>
                                @error('files.*') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @error('files') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>
                        @else
                            <div class="col-12">
                                <div class="alert alert-info py-2 mb-0">
                                    <i class="fas fa-info-circle me-1"></i> {{ __('برای افزودن رویژن جدید یا فایل، از بخش "رویژن‌ها" در جدول اصلی استفاده کنید.') }}
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-secondary btn-modern" wire:click="closeForm"><i class="fas fa-times me-1"></i> {{ __('لغو') }}</button>
                    <button type="submit" class="btn btn-primary btn-modern" wire:loading.attr="disabled">
                        <span wire:loading wire:target="saveDocument"><i class="fas fa-spinner fa-spin"></i></span>
                        <span wire:loading.remove wire:target="saveDocument"><i class="fas fa-save me-1"></i> {{ $editId ? __('ذخیره تغییرات') : __('ایجاد مدرک') }}</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
