<div wire:ignore.self class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white" style="border-radius: 14px 14px 0 0;">
                <h5 class="modal-title" id="previewModalLabel">
                    <i class="fas fa-eye me-2"></i>
                    {{ __('پیش‌نمایش فایل') }} (آخرین رویژن)
                </h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closePreviewModal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0" style="min-height: 70vh;">
                @if($previewFileUrl)
                    @php
                        $isPdf = Str::endsWith($previewFileUrl, '.pdf');
                    @endphp
                    @if($isPdf)
                        <iframe src="{{ $previewFileUrl }}" style="width: 100%; height: 70vh; border: none;"></iframe>
                    @else
                        <div class="text-center p-5">
                            <img src="{{ $previewFileUrl }}" class="img-fluid rounded shadow" style="max-height: 70vh; max-width: 100%; object-fit: contain;" alt="{{ __('پیش‌نمایش تصویر') }}">
                        </div>
                    @endif
                @else
                    <div class="text-center py-5 text-muted">
                        <i class="fas fa-times-circle fa-3x mb-3"></i>
                        <p>{{ __('فایل برای پیش‌نمایش آماده نیست یا فرمت آن پشتیبانی نمی‌شود (فقط PDF و Image).') }}</p>
                    </div>
                @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-modern" wire:click="closePreviewModal">{{ __('بستن') }}</button>
            </div>
        </div>
    </div>
</div>
