<div wire:ignore.self class="modal fade" id="revisionModal" tabindex="-1" aria-labelledby="revisionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-secondary text-white" style="border-radius: 14px 14px 0 0;">
                <h5 class="modal-title" id="revisionModalLabel">
                    <i class="fas fa-history me-2"></i>
                    {{ __('تاریخچه رویژن‌ها') }} ({{ $revisionDocId ? MasterDocument::find($revisionDocId)?->document_number : 'N/A' }})
                </h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closeRevisionModal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">

                <button class="btn btn-outline-primary btn-modern mb-3" type="button" data-bs-toggle="collapse" data-bs-target="#addRevisionCollapse" aria-expanded="false">
                    <i class="fas fa-plus me-1"></i> {{ __('افزودن رویژن جدید') }}
                </button>

                <div class="collapse mb-4 p-3 border rounded-3 bg-light" id="addRevisionCollapse">
                    <h6 class="fw-bold mb-3">{{ __('جزئیات رویژن جدید') }}</h6>
                    <form wire:submit.prevent="addRevision" class="row g-3">
                        <div class="col-md-3">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('new_revision_number') is-invalid @enderror" placeholder="Rev.XX" wire:model.defer="new_revision_number">
                                <label>{{ __('شماره رویژن') }} *</label>
                                @error('new_revision_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label d-block">{{ __('نوع POI (اختیاری)') }}</label>
                            <select class="form-select @error('new_revision_poi_type') is-invalid @enderror" wire:model.defer="new_revision_poi_type">
                                <option value="">{{ __('بدون POI') }}</option>
                                <option value="IFC">IFC</option>
                                <option value="IFA">IFA</option>
                                <option value="AFC">AFC</option>
                                <option value="IFI">IFI</option>
                                <option value="Rec">Rec</option>
                            </select>
                            @error('new_revision_poi_type') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('new_revision_remark') is-invalid @enderror" placeholder="{{ __('شرح تغییرات') }}" wire:model.defer="new_revision_remark">
                                <label>{{ __('شرح تغییرات (اختیاری)') }}</label>
                                @error('new_revision_remark') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="form-label d-block"><i class="fas fa-file-upload me-1"></i> {{ __('فایل(ها)ی رویژن') }}</label>
                            <input type="file" class="form-control @error('new_revision_files.*') is-invalid @enderror" wire:model="new_revision_files" multiple>
                            <div wire:loading wire:target="new_revision_files" class="text-info mt-1"><i class="fas fa-spinner fa-spin"></i> {{ __('در حال بارگذاری فایل‌ها...') }}</div>
                            @error('new_revision_files.*') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-success btn-modern" wire:loading.attr="disabled">
                                <span wire:loading wire:target="addRevision"><i class="fas fa-spinner fa-spin"></i></span>
                                <span wire:loading.remove wire:target="addRevision"><i class="fas fa-check me-1"></i> {{ __('ثبت رویژن') }}</span>
                            </button>
                        </div>
                    </form>
                </div>

                <h6 class="fw-bold mb-3 mt-4">{{ __('لیست رویژن‌ها') }}</h6>
                @forelse($revisions as $revision)
                    @php
                        $statusClass = match($revision->status) {
                            'تایید شده' => 'bg-success',
                            'رد شده' => 'bg-danger',
                            'ارسال شده' => 'bg-warning text-dark',
                            default => 'bg-secondary'
                        };
                    @endphp
                    <div class="card mb-3 shadow-sm" wire:key="revision-{{ $revision->id }}">
                        <div class="card-body p-3">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <h5 class="mb-1 fw-bold" style="color: var(--brand-dark);">
                                        <i class="fas fa-code-branch me-2"></i>
                                        {{ $revision->revision }}
                                        <span class="badge {{ $statusClass }} text-white ms-2">{{ $revision->status }}</span>
                                    </h5>
                                    <p class="mb-1 text-muted small">
                                        {{ __('تاریخ') }}: {{ $revision->date_formatted }} |
                                        {{ __('نوع') }}: {{ $revision->revision_type }}
                                        @if($revision->poi_type) | <span class="badge bg-primary">{{ __('POI') }}: {{ $revision->poi_type }}</span> @endif
                                    </p>
                                    @if($revision->remark)
                                        <p class="mb-1 fst-italic"><i class="fas fa-comment-dots me-1"></i> {{ $revision->remark }}</p>
                                    @endif
                                </div>
                                <div class="d-flex flex-column gap-2 align-items-end">
                                    <button class="btn btn-icon btn-sm btn-outline-danger" onclick="confirm('{{ __('آیا مطمئن هستید؟') }}') || event.stopImmediatePropagation()" wire:click="deleteRevision({{ $revision->id }})" title="{{ __('حذف رویژن') }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                            <hr class="my-2">

                            <h6 class="fw-bold mt-2 mb-2">{{ __('فایل‌های پیوست') }} ({{ $revision->files->count() }})</h6>
                            <div class="d-flex flex-wrap gap-2 mb-2">
                                @forelse($revision->files as $file)
                                    <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank" class="btn btn-sm btn-outline-dark btn-modern" title="{{ $file->file_name }}">
                                        <i class="fas fa-file-alt me-1"></i> {{ Str::limit($file->file_name, 20) }}
                                    </a>
                                @empty
                                    <span class="text-muted small">{{ __('هیچ فایلی برای این رویژن آپلود نشده است.') }}</span>
                                @endforelse
                            </div>

                            <button class="btn btn-sm btn-outline-info mt-2" type="button" wire:click="$toggle('addFileToRevisionId', {{ $revision->id }})">
                                <i class="fas fa-plus me-1"></i> {{ __('افزودن فایل به این رویژن') }}
                            </button>

                            @if($addFileToRevisionId == $revision->id)
                                <form wire:submit.prevent="addFilesToRevision({{ $revision->id }})" class="mt-2 p-2 border rounded bg-white">
                                    <label class="form-label small fw-bold">{{ __('آپلود فایل جدید') }} *</label>
                                    <input type="file" class="form-control form-control-sm @error('new_files_for_revision.*') is-invalid @enderror" wire:model="new_files_for_revision" multiple>
                                    <div wire:loading wire:target="new_files_for_revision" class="text-info mt-1"><i class="fas fa-spinner fa-spin"></i> {{ __('در حال بارگذاری...') }}</div>
                                    @error('new_files_for_revision.*') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                    @error('new_files_for_revision') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                    <button type="submit" class="btn btn-success btn-sm mt-2" wire:loading.attr="disabled">
                                        <span wire:loading wire:target="addFilesToRevision"><i class="fas fa-spinner fa-spin"></i></span>
                                        {{ __('ثبت فایل‌ها') }}
                                    </button>
                                </form>
                            @endif
                        </div>
                    </div>
                @empty
                    <div class="alert alert-warning text-center">
                        <i class="fas fa-exclamation-circle me-1"></i> {{ __('هیچ رویژنی ثبت نشده است.') }}
                    </div>
                @endforelse
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-modern" wire:click="closeRevisionModal">{{ __('بستن') }}</button>
            </div>
        </div>
    </div>
</div>
