<div wire:ignore.self class="modal fade" id="transmittalModal" tabindex="-1" aria-labelledby="transmittalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-info text-white" style="border-radius: 14px 14px 0 0;">
                <h5 class="modal-title" id="transmittalModalLabel">
                    <i class="fas fa-exchange-alt me-2"></i>
                    {{ __('تاریخچه ترنسمیتال‌ها') }}
                </h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closeTransmittalModal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <h6 class="fw-bold mb-3" style="color: var(--brand-dark);">
                    {{ __('مدرک') }}: {{ $selectedDocNumber }}
                </h6>

                @forelse($selectedTransmittals as $td)
                    @php
                        $trans = $td->transmittal;
                        $statusClass = match($trans?->status) {
                            'ارسال شده' => 'bg-primary',
                            'دریافت شده' => 'bg-success',
                            default => 'bg-secondary'
                        };
                    @endphp
                    @if($trans)
                        <div class="card mb-3 shadow-sm border-0 border-end border-3 border-{{ $statusClass == 'bg-success' ? 'success' : 'primary' }}">
                            <div class="card-body p-3">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h6 class="mb-1 fw-bold text-monospace">
                                            <a href="{{ route('transmittals.show', $trans->id) }}" target="_blank" class="text-decoration-none" style="color: var(--brand-dark);">
                                                <i class="fas fa-envelope-open-text me-1"></i> {{ $trans->transmittal_number }}
                                            </a>
                                        </h6>
                                        <p class="mb-1 small text-muted">
                                            {{ __('تاریخ ارسال') }}: {{ $trans->sent_at_formatted }}
                                            @if($trans->received_at) | {{ __('تاریخ دریافت') }}: {{ $trans->received_at_formatted }} @endif
                                        </p>
                                        <p class="mb-1 small">
                                            <i class="fas fa-arrow-up text-primary me-1"></i>
                                            {{ __('فرستنده') }}: {{ $trans->sender?->name ?? 'سیستم' }}
                                        </p>
                                        <p class="mb-1 small">
                                            <i class="fas fa-arrow-down text-info me-1"></i>
                                            {{ __('گیرنده') }}: {{ $trans->receiver?->name ?? 'نامشخص' }}
                                        </p>
                                    </div>
                                    <span class="badge {{ $statusClass }} text-white py-2">{{ $trans->status }}</span>
                                </div>
                                <hr class="my-2">
                                <p class="mb-0 small fst-italic">
                                    <span class="fw-bold">{{ __('رویژن ارسالی') }}:</span> {{ $td->revision_number ?? '-' }}
                                </p>
                            </div>
                        </div>
                    @endif
                @empty
                    <div class="alert alert-light text-center">
                        <i class="fas fa-exclamation-circle me-1"></i> {{ __('این مدرک تاکنون با هیچ ترنسمیتالی ارسال نشده است.') }}
                    </div>
                @endforelse

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-modern" wire:click="closeTransmittalModal">{{ __('بستن') }}</button>
            </div>
        </div>
    </div>
</div>
