<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-gradient-primary-to-secondary d-flex justify-content-between align-items-center">
            <h4 class="mb-0 text-white">مشاهده مدرک</h4>
            <a href="{{ route('admin.mdr.list', $doc->project_id) }}" class="btn btn-sm btn-outline-light">بازگشت</a>
        </div>
        <div class="card-body">

            <dl class="row g-3">
                <dt class="col-md-3 fw-bold">شماره سند:</dt>
                <dd class="col-md-9">{{ $doc->document_number }}</dd>

                <dt class="col-md-3 fw-bold">عنوان:</dt>
                <dd class="col-md-9">{{ $doc->title }}</dd>

                <dt class="col-md-3 fw-bold">پروژه:</dt>
                <dd class="col-md-9">{{ optional($doc->project)->name ?? '-' }}</dd>

                <dt class="col-md-3 fw-bold">رشته:</dt>
                <dd class="col-md-9">{{ optional($doc->discipline)->name ?? '-' }}</dd>

                <dt class="col-md-3 fw-bold">نوع مدرک:</dt>
                <dd class="col-md-9">{{ $doc->document_type }}</dd>

                <dt class="col-md-3 fw-bold">آخرین رویژن:</dt>
                <dd class="col-md-9">{{ $doc->revision ?? '-' }}</dd>

                <dt class="col-md-3 fw-bold">وضعیت:</dt>
                <dd class="col-md-9">
                    @switch($doc->status)
                        @case('valid')
                            <span class="badge bg-success">معتبر</span>
                            @break
                        @case('obsolete')
                            <span class="badge bg-danger">منقضی شده</span>
                            @break
                        @default
                            <span class="badge bg-warning text-dark">نامشخص</span>
                    @endswitch
                </dd>
            </dl>

            <hr>

            <!-- لیست ترنسمیتال‌ها -->
            <h6>لیست ترنسمیتال‌های این مدرک</h6>
            @if($doc->transmittals->isNotEmpty())
                <table class="table table-bordered table-sm mb-4">
                    <thead>
                    <tr>
                        <th>شماره ترنسمیتال</th>
                        <th>فرستنده</th>
                        <th>گیرنده</th>
                        <th>تاریخ</th>
                        <th>هدف</th>
                        <th>وضعیت</th>
                        <th>PDF</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($doc->transmittals as $t)
                        <tr>
                            <td>{{ $t->transmittal_number }}</td>
                            <td>{{ optional($t->sender)->name }}</td>
                            <td>{{ optional($t->receiver)->name }}</td>
                            <td>{{ jdate($t->created_at)->format('Y/m/d') }}</td>
                            <td>{{ $t->purpose }}</td>
                            <td>
                                @switch($t->status)
                                    @case('sent') <span class="badge bg-success">ارسال شده</span> @break
                                    @case('received') <span class="badge bg-info">دریافت شده</span> @break
                                    @case('rejected') <span class="badge bg-danger">رد شده</span> @break
                                    @default <span class="badge bg-warning text-dark">در انتظار</span>
                                @endswitch
                            </td>
                            <td>
                                <a href="{{ route('transmittal.download', $t->id) }}" target="_blank" class="btn btn-sm btn-success">
                                    <i class="fas fa-file-pdf"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted">بدون ترنسمیتال</p>
            @endif

        </div>
    </div>
</div>
