<div class="saraman-v15-clean py-5" x-data="{ step: @entangle('currentStep'), helpOpen: true }">
    <style>
        /* 🕊️ تم پلاتینیوم لوکس و مینیمال */
        .saraman-v15-clean {
            --brand-blue: #0066FF;
            --soft-gray: #F8FAFC;
            --text-main: #1E293B;
            --border-color: #E2E8F0;
            background: #FFFFFF;
            min-height: 100vh; direction: rtl; font-family: 'Vazirmatn', sans-serif;
        }

        /* ✨ بدنه فرم با حاشیه‌های بسیار نرم */
        .main-form-card {
            background: #FFFFFF;
            border-radius: 50px;
            border: 1px solid var(--border-color);
            box-shadow: 0 10px 50px rgba(0,0,0,0.02);
            padding: 4.5rem;
        }

        /* 🏎️ استپر مدرن پیکسلی */
        .minimal-stepper {
            display: flex; justify-content: center; gap: 10px; margin-bottom: 3rem;
        }
        .step-bar {
            height: 6px; width: 60px; border-radius: 10px; background: #F1F5F9; transition: 0.5s;
        }
        .step-bar.active { background: var(--brand-blue); width: 100px; box-shadow: 0 0 15px rgba(0,102,255,0.3); }
        .step-bar.completed { background: #10B981; }

        /* 💎 فیلدها با استایل اپل (Minimal Inputs) */
        .clean-input {
            border: 1.5px solid #F1F5F9; border-radius: 20px; padding: 1.2rem;
            font-weight: 600; transition: 0.3s; background: #F8FAFC; color: var(--text-main);
        }
        .clean-input:focus {
            background: #FFFFFF; border-color: var(--brand-blue);
            box-shadow: 0 0 0 4px rgba(0,102,255,0.05); outline: none;
        }

        /* 🎯 انتخاب هوشمند PR */
        .pr-selection-card {
            border: 1.5px solid #F1F5F9; border-radius: 22px; padding: 1.5rem;
            transition: 0.3s; cursor: pointer; background: #FFFFFF;
        }
        .pr-selection-card.selected {
            border-color: var(--brand-blue); background: #F0F7FF;
            transform: scale(1.02);
        }

        /* 💰 پنل آنالیز مالی شیشه‌ای */
        .financial-summary-panel {
            background: #F8FAFC; border-radius: 35px; padding: 2.5rem;
            border: 1px solid #F1F5F9;
        }

        /* 🔘 دکمه‌های باوقار */
        .btn-luxury-main {
            background: var(--text-main); color: #FFFFFF; border: none;
            padding: 1.3rem 4rem; border-radius: 25px; font-weight: 800;
            transition: 0.4s;
        }
        .btn-luxury-main:hover { background: #000000; transform: translateY(-3px); box-shadow: 0 15px 30px rgba(0,0,0,0.1); }

        .form-label-lux { font-weight: 700; color: #64748B; margin-bottom: 0.8rem; display: block; font-size: 0.85rem; }
    </style>

    <div class="container animate-fade-in">
        <div class="row mb-5 justify-content-center">
            <div class="col-xl-9 text-center">
                <div class="mb-4">
                    <span class="badge bg-light text-muted px-3 py-2 rounded-pill small fw-bold">SECURE TRANSACTION</span>
                </div>
                <h1 class="fw-black text-dark display-5 mb-5" style="letter-spacing: -1.5px;">درخواست صدور وجه <span class="text-primary">رسمی</span></h1>

                <div class="minimal-stepper">
                    <div class="step-bar {{ $currentStep >= 1 ? ($currentStep == 1 ? 'active' : 'completed') : '' }}"></div>
                    <div class="step-bar {{ $currentStep >= 2 ? ($currentStep == 2 ? 'active' : 'completed') : '' }}"></div>
                    <div class="step-bar {{ $currentStep >= 3 ? ($currentStep == 3 ? 'active' : 'completed') : '' }}"></div>
                </div>
            </div>

            <div class="col-xl-11">
                <form wire:submit.prevent="savePaymentRequest">

                    <div x-show="step == 1" x-transition.duration.500ms class="main-form-card animate-slide-up">
                        <div class="row g-5">
                            <div class="col-lg-6 border-start pe-lg-5 text-start">
                                <h4 class="fw-black mb-5 text-dark">۱. تعیین بستر عملیاتی</h4>

                                <div class="mb-5">
                                    <label class="form-label-lux">پروژه هدف را انتخاب کنید</label>
                                    <select class="form-select clean-input" wire:model.live="project_id">
                                        <option value="">-- لیست پروژه‌های فعال --</option>
                                        @foreach($this->projectsList as $p) <option value="{{ $p->id }}">{{ $p->name }}</option> @endforeach
                                    </select>
                                    @error('project_id') <small class="text-danger fw-bold mt-2 d-block">{{ $message }}</small> @enderror
                                </div>

                                @if($project_id)
                                    <div class="p-2">
                                        <label class="form-label-lux">ارجاع به درخواست خرید (PR)</label>
                                        <div class="custom-scroll" style="max-height: 250px; overflow-y: auto;">
                                            @forelse($this->approvedPurchaseRequests as $pr)
                                                <div class="pr-selection-card mb-3 d-flex justify-content-between align-items-center {{ $purchaseRequestId == $pr->id ? 'selected' : '' }}" wire:click="selectPurchaseRequest({{ $pr->id }})">
                                                    <div>
                                                        <span class="fw-black text-dark">PR-{{ $pr->id }}</span>
                                                        <small class="text-muted d-block mt-1 fw-bold">{{ Str::limit($pr->description, 35) }}</small>
                                                    </div>
                                                    @if($purchaseRequestId == $pr->id)
                                                        <i class="ti ti-circle-check-filled text-primary fs-3"></i>
                                                    @else
                                                        <i class="ti ti-circle-plus text-muted opacity-50 fs-4"></i>
                                                    @endif
                                                </div>
                                            @empty
                                                <div class="text-center py-4 text-muted small fw-bold">درخواستی یافت نشد.</div>
                                            @endforelse
                                        </div>
                                    </div>
                                @endif
                            </div>

                            <div class="col-lg-6 ps-lg-5 text-start">
                                <h4 class="fw-black mb-5 text-dark">۲. شناسایی ذینفع</h4>

                                @if(!$selectedPayee)
                                    <div class="mb-4">
                                        <label class="form-label-lux">جستجوی نام پیمانکار یا فروشنده</label>
                                        <div class="position-relative">
                                            <input type="text" class="form-control clean-input ps-5" wire:model.live.debounce="payeeSearch" placeholder="نام یا شناسه ملی...">
                                            <i class="ti ti-search position-absolute top-50 start-0 translate-middle-y ms-4 text-muted"></i>
                                        </div>
                                    </div>
                                    <div class="list-group border-0 gap-2">
                                        @foreach($this->availablePayees as $payee)
                                            <button type="button" wire:click="selectPayee({{ $payee->id }})" class="list-group-item list-group-item-action clean-input border-0 py-3 mb-1">
                                                <span class="fw-black text-dark">{{ $payee->name }}</span>
                                                <small class="text-muted float-end">{{ $payee->national_id }}</small>
                                            </button>
                                        @endforeach
                                    </div>
                                    @error('payeeId') <small class="text-danger fw-black mt-2 d-block">{{ $message }}</small> @enderror
                                @else
                                    <div class="p-5 rounded-4 bg-light border border-dashed d-flex justify-content-between align-items-center animate-fade-in">
                                        <div class="d-flex align-items-center gap-4">
                                            <div class="bg-white text-primary rounded-circle shadow-sm d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                                <i class="ti ti-user-check fs-2"></i>
                                            </div>
                                            <div>
                                                <h5 class="fw-black mb-0 text-dark">{{ $selectedPayee->name }}</h5>
                                                <small class="text-muted fw-bold">شناسه ملی: {{ $selectedPayee->national_id }}</small>
                                            </div>
                                        </div>
                                        <button type="button" class="btn btn-link text-danger fw-bold text-decoration-none" wire:click="resetPayee">تغییر</button>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="mt-5 text-center">
                            <button type="button" class="btn-luxury-main" wire:click="nextStep">ادامه فرآیند تایید <i class="ti ti-arrow-left ms-2"></i></button>
                        </div>
                    </div>

                    <div x-show="step == 2" x-transition.duration.500ms class="main-form-card animate-slide-up">
                        <div class="row g-5 align-items-center">
                            <div class="col-lg-7 text-start pe-lg-5">
                                <h4 class="fw-black mb-5">۳. ارقام و محاسبات نهایی</h4>
                                <div class="row g-4">
                                    <div class="col-md-7">
                                        <label class="form-label-lux">مبلغ ناخالص (ریال)</label>
                                        <input type="text" class="form-control clean-input fs-3 fw-black text-primary" wire:model.live="amount_gross"
                                               oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')">
                                    </div>
                                    <div class="col-md-5">
                                        <label class="form-label-lux">نرخ مالیات بر ارزش افزوده (%)</label>
                                        <input type="number" class="form-control clean-input fw-black" wire:model.live="tax_rate">
                                    </div>
                                    <div class="col-12 mt-4">
                                        <label class="form-label-lux">شرح دقیق بابت درخواست وجه</label>
                                        <textarea class="form-control clean-input" wire:model="purpose" rows="4" placeholder="توضیحات لازم جهت بررسی واحد حسابرسی..."></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-5">
                                <div class="financial-summary-panel animate-fade-in shadow-sm">
                                    <div class="d-flex justify-content-between mb-4 border-bottom pb-3">
                                        <span class="fw-black small text-muted">خلاصه صورت‌حساب</span>
                                        <i class="ti ti-receipt text-primary"></i>
                                    </div>
                                    <div class="d-flex justify-content-between mb-3 fw-bold text-dark"><span>مبلغ پایه:</span><span>{{ number_format((float)str_replace(',', '', $amount_gross)) }}</span></div>
                                    <div class="d-flex justify-content-between mb-5 text-muted fw-bold"><span>مالیات ({{ $tax_rate }}٪):</span><span>+ {{ number_format($tax_amount) }}</span></div>

                                    <div class="p-4 rounded-4 bg-white border border-primary border-opacity-10 text-center shadow-xs">
                                        <small class="text-muted d-block mb-1 fw-bold">جمع کل قابل پرداخت</small>
                                        <h2 class="fw-black text-primary m-0" style="font-size: 2.8rem; letter-spacing: -1px;">{{ number_format($amount) }}</h2>
                                        <small class="fw-bold opacity-50">ریال ایران</small>
                                    </div>

                                    @if($project_id)
                                        <div class="mt-4 pt-4 border-top">
                                            <div class="d-flex justify-content-between mb-2 small fw-black"><span>کنترل بودجه پروژه</span><span class="text-primary">{{ number_format($budget_remaining) }} مانده</span></div>
                                            <div class="progress bg-white border" style="height: 8px; border-radius: 10px;">
                                                <div class="progress-bar bg-primary" style="width: 45%"></div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="mt-5 d-flex justify-content-between pt-5">
                            <button type="button" class="btn btn-light rounded-pill px-5 fw-bold border shadow-xs" wire:click="previousStep">بازگشت</button>
                            <button type="button" class="btn-luxury-main" wire:click="nextStep">تایید اطلاعات <i class="ti ti-arrow-left ms-2"></i></button>
                        </div>
                    </div>

                    <div x-show="step == 3" x-transition class="main-form-card animate-slide-up">
                        <div class="row g-5">
                            <div class="col-lg-6 border-start pe-lg-5 text-start">
                                <h4 class="fw-black mb-5 text-dark">۴. تنظیمات و فوریت</h4>

                                <div class="mb-5">
                                    <label class="form-label-lux">نحوه پرداخت حواله</label>
                                    <div class="row g-3">
                                        @foreach(['transfer'=>'حواله ساتنا', 'check'=>'صدور چک', 'cash'=>'نقدی'] as $k => $v)
                                            <div class="col-4">
                                                <div class="p-3 text-center border rounded-4 cursor-pointer transition-all fw-black small {{ $payment_method == $k ? 'bg-primary text-white border-primary shadow-sm' : 'bg-white text-muted border-light' }}" wire:click="$set('payment_method', '{{$k}}')">
                                                    {{ $v }}
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>

                                <div class="mb-5">
                                    <label class="form-label-lux">مهلت پرداخت (سررسید)</label>
                                    <input type="text" class="form-control clean-input shamsi-date-picker" wire:model="due_date" readonly>
                                </div>

                                <div class="form-check form-switch p-4 bg-light rounded-4 d-flex align-items-center gap-4 border border-light shadow-inner">
                                    <input class="form-check-input ms-0 mt-0" type="checkbox" wire:model="is_urgent" id="uSwitch" style="width: 3.2rem; height: 1.6rem;">
                                    <label class="form-check-label fw-black text-danger mb-0 fs-6" for="uSwitch">درخواست با اولویت فوری</label>
                                </div>
                            </div>

                            <div class="col-lg-6 ps-lg-5 text-start">
                                <h4 class="fw-black mb-5 text-dark">۵. ضمائم و مدارک</h4>
                                <div class="p-5 border-2 border-dashed rounded-5 text-center bg-light transition-all hover-bg-white shadow-xs" style="cursor: pointer;" onclick="document.getElementById('fileInp').click()">
                                    <input type="file" id="fileInp" class="d-none" wire:model="attachments" multiple>
                                    <i class="ti ti-cloud-upload fs-1 text-primary mb-3"></i>
                                    <h6 class="fw-black mb-1 text-dark">آپلود مستندات پیوست</h6>
                                    <small class="text-muted fw-bold">فایل‌های PDF یا تصاویر (حداکثر ۱۰MB)</small>
                                </div>

                                <div class="mt-4">
                                    @foreach($attachments as $index => $file)
                                        <div class="d-flex align-items-center justify-content-between p-3 bg-white border border-light rounded-4 mb-2 animate-slide-up shadow-xs">
                                            <div class="d-flex align-items-center gap-3">
                                                <i class="ti ti-file-description text-primary fs-4"></i>
                                                <span class="small fw-black text-dark text-truncate" style="max-width: 200px;">{{ $file->getClientOriginalName() }}</span>
                                            </div>
                                            <i class="ti ti-trash-x text-danger cursor-pointer fs-4" wire:click="removeAttachment({{ $index }})"></i>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="mt-5 d-flex justify-content-between align-items-center border-top pt-5">
                            <button type="button" class="btn btn-light rounded-pill px-5 fw-bold border shadow-xs" wire:click="previousStep">اصلاح اطلاعات</button>
                            <button type="submit" class="btn-luxury-main shadow-lg px-5" wire:loading.attr="disabled">
                                <span wire:loading.remove><i class="ti ti-circle-check-filled me-2"></i> تایید نهایی و ارسال به کارتابل</span>
                                <span wire:loading><span class="spinner-border spinner-border-sm me-2"></span> در حال ایمن‌سازی...</span>
                            </button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('livewire:navigated', () => {
            $('.shamsi-date-picker').persianDatepicker({
                format: 'YYYY/MM/DD',
                autoClose: true,
                onSelect: function(unix){
                    let date = new persianDate(unix).format('YYYY/MM/DD');
                    @this.dispatch('setDueDate', { date: date });
                }
            });
        });
    </script>
</div>
