<div class="container-fluid py-4 text-end" x-data="{
    expandedId: null,
    viewMode: @entangle('viewMode'),
    // باز و بسته شدن آنی بدون لگ فنی
    toggle(id) {
        if (this.expandedId === id) {
            this.expandedId = null;
        } else {
            this.expandedId = id;
            // اسکرول نرم به سمت ردیف باز شده در لیست‌های طولانی
            $nextTick(() => {
                $el.querySelector(`[data-id='${id}']`)?.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
            });
        }
    },
    confirmDelete(id) {
        Swal.fire({
            title: 'ابطال درخواست وجه',
            text: 'با این کار درخواست شما از چرخه مالی سازمان خارج می‌شود.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'بله، حذف شود',
            cancelButtonText: 'انصراف',
            customClass: { confirmButton: 'btn btn-danger rounded-pill', cancelButton: 'btn btn-light rounded-pill' }
        }).then((result) => { if (result.isConfirmed) $wire.deleteRequest(id); })
    }
}">
    <style>
        /* 💎 Platinum Design Language 2025 */
        :root {
            --p-blue: #4f46e5; --p-indigo: #6366f1; --p-soft-bg: #f8fafc;
            --p-border: #e2e8f0; --p-emerald: #10b981; --p-rose: #f43f5e;
        }

        .lux-card { background: white; border: 1px solid var(--p-border); border-radius: 30px; transition: 0.3s cubic-bezier(0.4, 0, 0.2, 1); }
        .lux-card:hover { border-color: var(--p-blue); box-shadow: 0 20px 40px -10px rgba(79, 70, 229, 0.1); }

        /* 📦 Bento Stats Hub */
        .bento-stat {
            padding: 1.75rem; border-radius: 28px; background: white; border: 1px solid var(--p-border);
            position: relative; overflow: hidden; height: 100%;
        }
        .bento-stat::before { content: ''; position: absolute; top: 0; left: 0; width: 6px; height: 100%; background: var(--b-color); }

        /* 📋 Ultra-Smooth Grid */
        .row-interact { cursor: pointer; transition: 0.25s ease; border-bottom: 1px solid #f1f5f9; }
        .row-interact:hover { background: #f8faff !important; transform: scale(1.002); }
        .row-interact.is-active { background: #f5f7ff !important; border-right: 6px solid var(--p-blue) !important; }

        /* 🔘 وضعیت‌های نئونی */
        .status-pill {
            padding: 6px 14px; border-radius: 12px; font-size: 0.72rem; font-weight: 900;
            display: inline-flex; align-items: center; gap: 6px; box-shadow: 0 2px 5px rgba(0,0,0,0.02);
        }
        .st-pending { background: #fffbeb; color: #9a3412; border: 1px solid #fde68a; }
        .st-approved { background: #ecfdf5; color: #065f46; border: 1px solid #a7f3d0; }
        .st-paid { background: #eef2ff; color: #3730a3; border: 1px solid #c7d2fe; }

        /* 🧪 Timeline & Progress */
        .approval-trail { border-right: 3px solid #f1f5f9; padding-right: 25px; margin-right: 10px; }
        .trail-item { position: relative; padding-bottom: 25px; }
        .trail-item::before {
            content: ''; position: absolute; right: -32px; top: 5px;
            width: 16px; height: 16px; border-radius: 50%;
            background: #e2e8f0; border: 3px solid white; z-index: 2;
        }
        .trail-item.done::before { background: var(--p-emerald); box-shadow: 0 0 12px rgba(16, 185, 129, 0.4); }

        .reveal { animation: revealUp 0.7s cubic-bezier(0, 0, 0.2, 1) both; }
        @keyframes revealUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
    </style>

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-5 gap-4 reveal">
        <div>
            <h1 class="fw-black text-slate-900 mb-1" style="font-size: 2.4rem; letter-spacing: -1.5px;">درخواست‌های وجه <span class="text-primary">من</span></h1>
            <div class="d-flex align-items-center gap-2 text-muted fw-bold">
                <span class="p-1 bg-light rounded-2 small shadow-sm">Dashboard v4.0</span>
                <span>•</span>
                <span>مدیریت هوشمند جریان نقدینگی</span>
            </div>
        </div>
        <div class="d-flex gap-3 bg-white p-2 rounded-pill shadow-sm border">
            <div class="btn-group bg-light rounded-pill p-1">
                <button wire:click="setViewMode('grid')" class="btn {{ $viewMode == 'grid' ? 'btn-white shadow-sm fw-black' : 'text-muted border-0' }} rounded-pill px-4 transition-all">گرید</button>
                <button wire:click="setViewMode('table')" class="btn {{ $viewMode == 'table' ? 'btn-white shadow-sm fw-black' : 'text-muted border-0' }} rounded-pill px-4 transition-all">لیست</button>
            </div>
            <a href="{{ route('admin.payment.create') }}" class="btn btn-primary rounded-pill px-4 fw-black shadow-primary hover-elevate">
                <i class="ti ti-plus me-1"></i> درخواست جدید
            </a>
        </div>
    </div>

    <div class="row g-4 mb-5 text-start reveal" style="animation-delay: 0.1s">
        @foreach([
            ['label' => 'کل پرونده‌ها', 'value' => $this->stats['total_count'], 'color' => '#4f46e5', 'icon' => 'ti-folders', 'progress' => 100],
            ['label' => 'در انتظار تایید (ریال)', 'value' => number_format($this->stats['pending_amount']), 'color' => '#f59e0b', 'icon' => 'ti-clock-play', 'progress' => 45],
            ['label' => 'تسویه شده نهایی', 'value' => number_format($this->stats['paid_amount']), 'color' => '#10b981', 'icon' => 'ti-cash-banknote', 'progress' => $this->stats['completion_rate']],
            ['label' => 'نرخ موفقیت', 'value' => $this->stats['completion_rate'].'%', 'color' => '#0ea5e9', 'icon' => 'ti-chart-pie', 'progress' => $this->stats['completion_rate']]
        ] as $stat)
            <div class="col-md-3">
                <div class="bento-stat shadow-sm" style="--b-color: {{ $stat['color'] }}">
                    <div class="small fw-black text-muted opacity-50 mb-2">{{ $stat['label'] }}</div>
                    <h3 class="fw-black mb-2 text-dark">{{ $stat['value'] }}</h3>
                    <div class="progress bg-light" style="height: 6px; border-radius: 10px;">
                        <div class="progress-bar" style="width: {{ $stat['progress'] }}%; background: {{ $stat['color'] }}; border-radius: 10px;"></div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="lux-card p-4 mb-4 shadow-sm reveal" style="animation-delay: 0.2s">
        <div class="row g-3">
            <div class="col-lg-6">
                <div class="input-group bg-light rounded-4 px-3 py-1 border-0 shadow-inner">
                    <i class="ti ti-search text-muted mt-2 me-2"></i>
                    <input type="text" class="form-control bg-transparent border-0 shadow-none fw-bold small" wire:model.live.debounce.400ms="search" placeholder="جستجو در کد رهگیری، نام ذینفع یا بابت وجه...">
                </div>
            </div>
            <div class="col-lg-3">
                <select class="form-select border-0 bg-light rounded-4 fw-bold small" wire:model.live="statusFilter">
                    <option value="">همه وضعیت‌ها</option>
                    <option value="pending">⏳ معلق</option>
                    <option value="approved">✅ تایید شده</option>
                </select>
            </div>
            <div class="col-lg-3">
                <select class="form-select border-0 bg-light rounded-4 fw-bold small" wire:model.live="projectFilter">
                    <option value="">تمامی پروژه‌ها</option>
                    @foreach($this->projects as $p) <option value="{{ $p->id }}">{{ $p->name }}</option> @endforeach
                </select>
            </div>
        </div>
    </div>

    <div wire:loading.class="opacity-50 transition-all">
        @if($this->paymentRequests->isEmpty())
            <div class="lux-card py-5 text-center shadow-sm opacity-75 reveal">
                <i class="ti ti-database-off display-1 text-muted mb-4"></i>
                <h4 class="fw-black text-slate-400">اطلاعاتی یافت نشد!</h4>
                <p class="text-muted fw-bold">لطفاً فیلترها را تغییر دهید یا درخواست جدید ثبت کنید.</p>
            </div>
        @else
            @if($viewMode === 'grid')
                <div class="row g-4 reveal" style="animation-delay: 0.3s">
                    @foreach($this->paymentRequests as $request)
                        @php $status = $this->getStatusData($request->status); @endphp
                        <div class="col-md-4">
                            <div class="lux-card p-4 h-100 position-relative overflow-hidden"
                                 :class="expandedId === {{ $request->id }} ? 'border-primary shadow-lg ring-2 ring-primary ring-opacity-10' : ''">
                                <div class="d-flex justify-content-between align-items-center mb-4">
                                    <span class="badge bg-primary bg-opacity-10 text-primary fw-black px-3 py-2 rounded-4 small">#{{ $request->id }}</span>
                                    <span class="status-pill {{ 'st-'.$request->status }}">{{ $status['label'] }}</span>
                                </div>

                                <h2 class="fw-black text-slate-800 mb-1">{{ number_format($request->amount) }} <small class="fs-6 opacity-50">ریال</small></h2>
                                <div class="small fw-bold text-muted mb-4 d-flex align-items-center gap-2">
                                    <i class="ti ti-user-circle fs-5 text-primary"></i> {{ $request->recipient_name }}
                                </div>

                                <div class="bg-gray-50 rounded-4 p-4 mb-4 border border-light shadow-inner">
                                    <div class="d-flex justify-content-between mb-3 small fw-bold">
                                        <span class="text-muted">پروژه مرتبط:</span>
                                        <span class="text-slate-700">{{ $request->project->name ?? 'بدون پروژه' }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between small fw-bold">
                                        <span class="text-muted">تاریخ سررسید:</span>
                                        <span class="{{ $request->due_date < now() ? 'text-danger' : 'text-slate-700' }}">{{ $request->due_date_shamsi }}</span>
                                    </div>
                                </div>

                                <div x-show="expandedId === {{ $request->id }}" x-collapse x-cloak>
                                    <div class="mb-4 pt-4 border-top">
                                        <h6 class="fw-black text-primary small mb-2"><i class="ti ti-notes me-1"></i>شرح درخواست:</h6>
                                        <p class="text-muted small fw-bold mb-0 lh-lg" style="text-align: justify;">{{ $request->purpose }}</p>
                                    </div>
                                </div>

                                <div class="d-flex gap-2">
                                    <button @click="toggle({{ $request->id }})" class="btn btn-sm flex-grow-1 rounded-4 fw-black transition-all py-2" :class="expandedId === {{ $request->id }} ? 'btn-primary shadow-primary' : 'btn-light border'">
                                        <i class="ti" :class="expandedId === {{ $request->id }} ? 'ti-chevron-up' : 'ti-eye-check'"></i>
                                        <span x-text="expandedId === {{ $request->id }} ? 'بستن' : 'مشاهده جزئیات'"></span>
                                    </button>
                                    <a href="{{ route('admin.payment.show', $request->id) }}" class="btn btn-sm btn-white border rounded-4 p-2 shadow-sm text-primary"><i class="ti ti-external-link fs-5"></i></a>
                                    @if($request->status === 'pending')
                                        <button @click="confirmDelete({{ $request->id }})" class="btn btn-sm btn-white border rounded-4 p-2 shadow-sm text-danger"><i class="ti ti-trash fs-5"></i></button>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="lux-table-container shadow-lg reveal" style="animation-delay: 0.3s">
                    <div class="table-responsive">
                        <table class="table align-middle mb-0 text-start">
                            <thead class="bg-light">
                            <tr class="text-muted small fw-black">
                                <th class="ps-5 py-4">شناسه و ذینفع</th>
                                <th>پروژه هدف</th>
                                <th class="text-center">ارزش (ریال)</th>
                                <th class="text-center">وضعیت</th>
                                <th class="pe-5 text-center">مدیریت</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($this->paymentRequests as $request)
                                @php $status = $this->getStatusData($request->status); @endphp
                                <tr class="row-interact" :class="expandedId === {{ $request->id }} ? 'is-active' : ''"
                                    @click="toggle({{ $request->id }})" data-id="{{ $request->id }}">
                                    <td class="ps-5">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="p-3 bg-primary bg-opacity-10 text-primary rounded-4 shadow-sm"><i class="ti ti-receipt-2 fs-4"></i></div>
                                            <div>
                                                <div class="fw-black text-dark fs-6">{{ $request->recipient_name }}</div>
                                                <div class="small text-muted fw-bold">#{{ $request->id }} | {{ Str::limit($request->purpose, 45) }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td><span class="badge bg-light text-slate-700 border fw-black px-4 py-2 rounded-pill shadow-xs">{{ $request->project->name ?? 'بدون پروژه' }}</span></td>
                                    <td class="text-center fw-black text-dark fs-5">{{ number_format($request->amount) }}</td>
                                    <td class="text-center"><span class="status-pill {{ 'st-'.$request->status }} shadow-xs">{{ $status['label'] }}</span></td>
                                    <td class="pe-5 text-center">
                                        <div class="d-flex justify-content-center gap-2" @click.stop>
                                            <a href="{{ route('admin.payment.show', $request->id) }}" class="btn btn-sm btn-white border shadow-sm p-3 text-primary rounded-4"><i class="ti ti-external-link fs-5"></i></a>
                                            @if($request->status === 'pending')
                                                <button class="btn btn-sm btn-white border shadow-sm p-3 text-danger rounded-4" @click="confirmDelete({{ $request->id }})"><i class="ti ti-trash fs-5"></i></button>
                                            @endif
                                            <i class="ti fs-4 text-muted ms-3 transition-all" :class="expandedId === {{ $request->id }} ? 'ti-chevron-up text-primary' : 'ti-chevron-down'"></i>
                                        </div>
                                    </td>
                                </tr>
                                <tr x-show="expandedId === {{ $request->id }}" x-collapse.duration.400ms x-cloak>
                                    <td colspan="5" class="p-0 border-0 bg-light bg-opacity-30">
                                        <div class="p-5 border-bottom mx-5 rounded-4 mb-4 bg-white shadow-inner border border-light reveal">
                                            <div class="row g-5 text-start">
                                                <div class="col-md-7 border-start">
                                                    <div class="d-flex align-items-center gap-2 mb-4 text-primary">
                                                        <i class="ti ti-notes fs-4"></i>
                                                        <h6 class="fw-black m-0 small text-uppercase">شرح کامل جزئیات درخواست وجه:</h6>
                                                    </div>
                                                    <div class="p-4 bg-slate-50 rounded-4 border border-light shadow-sm mb-4">
                                                        <p class="text-slate-700 fw-bold lh-lg m-0" style="font-size: 1rem;">{{ $request->purpose }}</p>
                                                    </div>
                                                    <div class="d-flex gap-3">
                                                        <div class="bg-light px-3 py-2 rounded-3 small fw-bold text-muted border">ثبت شده در: {{ $request->created_at_shamsi }}</div>
                                                        <div class="bg-light px-3 py-2 rounded-3 small fw-bold text-muted border">آخرین تغییرات: {{ $request->updated_at_shamsi }}</div>
                                                    </div>
                                                </div>
                                                <div class="col-md-5">
                                                    <h6 class="fw-black text-dark small text-uppercase mb-4"><i class="ti ti-timeline me-2 text-primary"></i>وضعیت لحظه‌ای تاییدات:</h6>
                                                    <div class="approval-trail ms-3">
                                                        @foreach($request->approvals as $app)
                                                            <div class="trail-item {{ $app->is_approved === 1 ? 'done' : '' }}">
                                                                <div class="d-flex align-items-center gap-3 p-2 rounded-4 {{ $app->is_approved === 1 ? 'bg-success bg-opacity-5' : 'bg-slate-50' }}">
                                                                    <img src="https://ui-avatars.com/api/?name={{ urlencode($app->user->name) }}&background=f1f5f9&color=2563eb&bold=true" class="rounded-circle shadow-xs" width="35">
                                                                    <div>
                                                                        <div class="small fw-black {{ $app->is_approved === 1 ? 'text-success' : 'text-muted' }}">{{ $app->user->name }}</div>
                                                                        <div class="fs-xs opacity-50 fw-bold">{{ $app->role->name ?? 'تاییدکننده اداری' }}</div>
                                                                    </div>
                                                                    @if($app->is_approved === 1) <i class="ti ti-circle-check-filled text-success ms-auto fs-4"></i> @endif
                                                                </div>
                                                                @if($app->comment) <div class="mt-2 small text-muted pe-5 fw-bold">« {{ $app->comment }} »</div> @endif
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endif
        @endif
    </div>

    <div class="mt-5 d-flex justify-content-between align-items-center reveal shadow-inner p-4 rounded-pill bg-white border" style="animation-delay: 0.4s">
        <div class="small fw-black text-muted ps-4">نمایش موارد {{ $this->paymentRequests->firstItem() }} تا {{ $this->paymentRequests->lastItem() }}</div>
        {{ $this->paymentRequests->links() }}
    </div>
</div>
