<div class="saraman-platinum-suite py-4" x-data="{ expanded: null, decisionModal: false }">
    <style>
        /* 💎 Platinum UI Design System */
        :root {
            --p-navy: #0f172a; --p-blue: #2563eb; --p-emerald: #10b981;
            --p-rose: #f43f5e; --p-border: #e2e8f0;
        }

        .lux-card { background: white; border: 1px solid var(--p-border); border-radius: 30px; transition: 0.3s; }

        /* 📦 Bento Stats */
        .bento-stat {
            background: white; border-radius: 24px; padding: 1.5rem;
            border: 1px solid #f1f5f9; position: relative; overflow: hidden;
            display: flex; flex-direction: column; justify-content: space-between;
        }
        .bento-stat::after { content: ''; position: absolute; top: -10px; left: -10px; width: 60px; height: 60px; background: var(--p-blue); opacity: 0.05; filter: blur(30px); }

        /* 📋 Table Experience */
        .lux-table thead th { background: #f8fafc; color: #64748b; font-weight: 900; font-size: 0.75rem; padding: 1.2rem 1rem; border-bottom: 2px solid #f1f5f9; }
        .row-interact { cursor: pointer; transition: 0.2s; border-bottom: 1px solid #f8fafc; }
        .row-interact:hover { background: #f9fafb; }
        .row-interact.is-active { background: #f0f7ff; border-right: 5px solid var(--p-blue); }

        /* 🔘 Custom Components */
        .status-pill { padding: 6px 14px; border-radius: 12px; font-size: 0.72rem; font-weight: 900; display: inline-flex; align-items: center; gap: 6px; }
        .st-pending { background: #fffbeb; color: #92400e; border: 1px solid #fef3c7; }
        .st-processed { background: #f0fdf4; color: #166534; border: 1px solid #dcfce7; }

        .urgent-badge { background: #fef2f2; color: #dc2626; border: 1px solid #fee2e2; padding: 4px 10px; border-radius: 8px; font-size: 0.65rem; font-weight: 900; animation: blink 2s infinite; }
        @keyframes blink { 50% { opacity: 0.6; } }

        .btn-lux-confirm { background: var(--p-navy); color: white; border-radius: 14px; padding: 10px 24px; font-weight: 900; border: none; transition: 0.3s; }
        .btn-lux-confirm:hover { background: #000; transform: translateY(-2px); box-shadow: 0 10px 20px rgba(0,0,0,0.1); }
    </style>

    <div class="container-fluid px-lg-5 animate-fade-in">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-5 gap-4">
            <div class="text-end">
                <div class="d-flex align-items-center gap-2 mb-2 text-primary">
                    <i class="ti ti-shield-lock fs-4"></i>
                    <span class="fw-black small text-uppercase tracking-tighter">Approval Control Center</span>
                </div>
                <h1 class="fw-black text-slate-900 mb-0" style="font-size: 2.2rem; letter-spacing: -1.5px;">کارتابل تایید <span class="text-primary">نقدینگی</span></h1>
            </div>
            <div class="d-flex gap-2 bg-white p-2 rounded-pill border shadow-sm">
                <button wire:click="$set('filterStatus', 'pending')" class="btn {{ $filterStatus == 'pending' ? 'btn-primary shadow-primary' : 'btn-light text-muted' }} rounded-pill px-4 fw-black transition-all">⏳ موارد معلق</button>
                <button wire:click="$set('filterStatus', 'processed')" class="btn {{ $filterStatus == 'processed' ? 'btn-primary shadow-primary' : 'btn-light text-muted' }} rounded-pill px-4 fw-black transition-all">✅ سوابق من</button>
            </div>
        </div>

        <div class="row g-4 mb-5 text-start">
            <div class="col-md-4">
                <div class="bento-stat shadow-sm border-start border-4 border-primary">
                    <div class="small fw-black text-muted opacity-50 mb-2">ITEMS PENDING</div>
                    <h2 class="fw-black mb-0">{{ number_format($this->stats['pending_count']) }} <small class="fs-6 opacity-50">پرونده</small></h2>
                </div>
            </div>
            <div class="col-md-4">
                <div class="bento-stat shadow-sm border-start border-4 border-success">
                    <div class="small fw-black text-muted opacity-50 mb-2">TOTAL VOLUME</div>
                    <h2 class="fw-black mb-0 text-success">{{ number_format($this->stats['pending_value']) }} <small class="fs-6 fw-bold">ریال</small></h2>
                </div>
            </div>
            <div class="col-md-4">
                <div class="bento-stat shadow-sm border-start border-4 border-info">
                    <div class="small fw-black text-muted opacity-50 mb-2">MY ACTIONS TODAY</div>
                    <h2 class="fw-black mb-0">{{ $this->stats['my_actions_today'] }} <small class="fs-6 opacity-50">تاییدیه</small></h2>
                </div>
            </div>
        </div>

        <div class="lux-card p-4 mb-4 shadow-sm border-0">
            <div class="position-relative">
                <i class="ti ti-search position-absolute top-50 start-0 translate-middle-y ms-4 text-muted fs-4"></i>
                <input type="text" class="form-control ps-5 border-0 bg-light rounded-4 py-3 fw-bold shadow-none"
                       wire:model.live.debounce.400ms="search" placeholder="جستجوی هوشمند در کارتابل بر اساس شرح، مبلغ یا فرستنده...">
            </div>
        </div>

        <div class="lux-card shadow-lg border-0 overflow-hidden">
            <div class="table-responsive">
                <table class="table align-middle mb-0 text-start">
                    <thead>
                    <tr class="lux-header-row">
                        <th class="ps-4">شناسه و فرستنده</th>
                        <th>پروژه</th>
                        <th>ارزش تراکنش</th>
                        <th class="text-center">وضعیت فعلی</th>
                        <th>زمان‌بندی</th>
                        <th class="pe-4 text-center">مدیریت</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($this->pendingRequests as $request)
                        <tr wire:key="row-{{ $request->id }}" class="row-interact" :class="expanded === {{ $request->id }} ? 'is-active' : ''">
                            <td class="ps-4" x-on:click="expanded === {{ $request->id }} ? expanded = null : expanded = {{ $request->id }}">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="bg-primary bg-opacity-10 text-primary p-3 rounded-4 shadow-sm"><i class="ti ti-user-bolt fs-4"></i></div>
                                    <div>
                                        <div class="fw-black text-dark">{{ $request->user->name }}</div>
                                        <small class="text-muted fw-bold">ID: #{{ $request->id }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                    <span class="badge bg-white text-dark border px-3 py-2 rounded-pill fw-bold shadow-xs">
                                        <i class="ti ti-briefcase me-1 text-primary"></i> {{ $request->project->name ?? 'عمومی' }}
                                    </span>
                            </td>
                            <td>
                                <div class="fw-black text-dark fs-5">{{ number_format($request->amount) }}</div>
                                @if($request->is_urgent) <span class="urgent-badge"><i class="ti ti-alert-triangle me-1"></i>اولویت فوری</span> @endif
                            </td>
                            <td class="text-center">
                                    <span class="status-pill {{ $filterStatus == 'pending' ? 'st-pending' : 'st-processed' }}">
                                        <i class="ti {{ $filterStatus == 'pending' ? 'ti-clock-hour-4' : 'ti-circle-check' }}"></i>
                                        {{ $filterStatus == 'pending' ? 'منتظر اقدام شما' : 'بررسی شده' }}
                                    </span>
                            </td>
                            <td class="text-muted fw-bold small">
                                <div class="mb-1"><i class="ti ti-calendar-event me-1"></i> {{ $request->created_at_shamsi }}</div>
                                <div class="opacity-50 fs-xs">سررسید: {{ $request->due_date_shamsi }}</div>
                            </td>
                            <td class="pe-4 text-center">
                                @if($filterStatus == 'pending')
                                    <button wire:click="openDecisionModal({{ $request->id }})" class="btn-lux-confirm shadow-sm mx-auto">
                                        <i class="ti ti-gavel fs-5"></i> بررسی و تصمیم
                                    </button>
                                @else
                                    <a href="{{ route('admin.payment.show', $request->id) }}" class="btn btn-sm btn-light rounded-pill px-3 fw-bold border">مشاهده جزئیات</a>
                                @endif
                            </td>
                        </tr>

                        <tr x-show="expanded === {{ $request->id }}" x-collapse x-cloak>
                            <td colspan="6" class="p-0 border-0">
                                <div class="p-5 bg-white border-bottom mx-4 rounded-4 mb-4 shadow-inner border border-light">
                                    <div class="row g-5">
                                        <div class="col-md-8 border-start text-end text-md-start">
                                            <h6 class="fw-black text-primary small text-uppercase mb-4"><i class="ti ti-align-right me-2"></i>شرح کامل بابت درخواست وجه:</h6>
                                            <div class="bg-light p-4 rounded-4 border border-white">
                                                <p class="text-slate-700 fw-bold lh-lg m-0">{{ $request->purpose }}</p>
                                            </div>
                                            <div class="mt-4 d-flex gap-2">
                                                @foreach($request->attachments as $file)
                                                    <a href="{{ Storage::url($file->file_path) }}" target="_blank" class="btn btn-white btn-sm border fw-bold rounded-pill px-3 shadow-xs">
                                                        <i class="ti ti-paperclip text-primary"></i> مشاهده ضمیمه فاکتور
                                                    </a>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="col-md-4 text-start">
                                            <h6 class="fw-black text-dark small text-uppercase mb-4"><i class="ti ti-timeline me-2"></i>زنجیره تاییدات:</h6>
                                            <div class="d-flex flex-column gap-3">
                                                @foreach($request->approvals as $app)
                                                    <div class="d-flex align-items-center gap-3 p-2 bg-white rounded-4 border {{ $app->is_approved === 1 ? 'border-success' : 'shadow-xs' }}">
                                                        <img src="https://ui-avatars.com/api/?name={{ urlencode($app->user->name) }}&background=f1f5f9&color=475569" class="rounded-circle" width="28">
                                                        <div>
                                                            <div class="small fw-black {{ $app->is_approved === 1 ? 'text-dark' : 'text-muted' }}">{{ $app->user->name }}</div>
                                                            <div class="fs-xs opacity-50 fw-bold">{{ $app->role->name ?? 'تاییدکننده' }}</div>
                                                        </div>
                                                        @if($app->is_approved === 1) <i class="ti ti-circle-check-filled text-success ms-auto fs-4"></i> @endif
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="py-5 text-center">
                                <div class="opacity-25 py-5 text-center">
                                    <i class="ti ti-confetti display-1 text-primary mb-3"></i>
                                    <h4 class="fw-black">کارتابل شما کاملاً تصفیه شده است!</h4>
                                    <p class="text-muted fw-bold small">در حال حاضر پرونده معلقی برای اقدام شما وجود ندارد.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-4 border-top bg-light bg-opacity-30">{{ $this->pendingRequests->links() }}</div>
        </div>
    </div>

    <div class="modal fade shadow-lg" id="decisionModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 overflow-hidden" style="border-radius: 40px;">
                <div class="p-5 text-start text-md-start">
                    <div class="d-flex align-items-center gap-3 mb-4 justify-content-start">
                        <div class="p-3 bg-primary bg-opacity-10 text-primary rounded-4"><i class="ti ti-shield-check fs-2"></i></div>
                        <h4 class="fw-black mb-0">ثبت تصمیم نهایی مدیر</h4>
                    </div>

                    <div class="mb-4 text-start">
                        <label class="fw-bold text-muted small mb-2 d-block text-start">یادداشت اداری (توضیحات یا دلیل رد):</label>
                        <textarea class="form-control border-0 bg-light rounded-4 p-4 fw-bold shadow-none" wire:model="comment" rows="4" placeholder="در صورت لزوم یادداشت خود را اینجا بنویسید..."></textarea>
                    </div>

                    @error('decision') <div class="alert alert-danger rounded-4 fw-bold small mb-4">{{ $message }}</div> @enderror

                    <div class="row g-3">
                        <div class="col-7">
                            <button wire:click="processDecision(true)" wire:loading.attr="disabled" class="btn btn-lux-confirm w-100 py-3 bg-success text-white shadow-sm d-flex justify-content-center">
                                <span wire:loading.remove><i class="ti ti-circle-check-filled"></i> تایید و امضاء</span>
                                <span wire:loading class="spinner-border spinner-border-sm"></span>
                            </button>
                        </div>
                        <div class="col-5">
                            <button wire:click="processDecision(false)" wire:loading.attr="disabled" class="btn btn-lux-confirm w-100 py-3 bg-light text-danger border border-danger border-opacity-10 d-flex justify-content-center">
                                <i class="ti ti-circle-x-filled"></i> رد درخواست
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        window.addEventListener('open-modal', event => {
            new bootstrap.Modal(document.getElementById(event.detail)).show();
        });
        window.addEventListener('close-modal', event => {
            const modalEl = document.getElementById(event.detail);
            const inst = bootstrap.Modal.getInstance(modalEl);
            if (inst) inst.hide();
        });
    </script>
</div>
