<div class="container-fluid py-4" x-data="{ expanded: null, showBulkActions: @entangle('selectedRows').live }">
    <style>
        /* 🏛️ سیستم طراحی پلاتینیوم - اختصاصی سامانه مالی */
        :root {
            --ir-navy: #0f172a;
            --ir-primary: #2563eb;
            --ir-border: #e2e8f0;
            --ir-success: #059669;
            --ir-danger: #dc2626;
            --ir-warning: #ca8a04;
            --glass-white: rgba(255, 255, 255, 0.95);
        }

        /* ✨ افکت‌های حرکتی و سایه‌ها */
        .hover-elevate { transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); }
        .hover-elevate:hover { transform: translateY(-8px); box-shadow: 0 25px 50px -12px rgba(15, 23, 42, 0.12); }

        /* 📦 کارت‌های شاخص عملکرد (Bento Stats) */
        .kpi-box {
            background: white; border: 1px solid var(--ir-border); border-radius: 30px;
            padding: 1.75rem; position: relative; overflow: hidden;
            display: flex; flex-direction: column; justify-content: space-between;
        }
        .kpi-box::after {
            content: ''; position: absolute; top: -20px; left: -20px; width: 100px; height: 100px;
            background: var(--ir-primary); filter: blur(70px); opacity: 0.05;
        }

        /* 📋 شبکه اطلاعات (Grid) */
        .lux-container {
            background: var(--glass-white); backdrop-filter: blur(20px);
            border-radius: 40px; border: 1px solid var(--ir-border);
            overflow: hidden; box-shadow: 0 10px 30px rgba(0,0,0,0.02);
        }
        .lux-header-row { background: #f8fafc; border-bottom: 2px solid #f1f5f9; }
        .lux-header-row th {
            color: #64748b; font-weight: 900; font-size: 0.75rem;
            padding: 1.5rem 1rem; text-transform: uppercase;
        }

        .row-interact { transition: 0.3s; cursor: pointer; border-bottom: 1px solid #f8fafc; }
        .row-interact:hover { background: #f8faff; }
        .row-interact.is-expanded { background: #f0f7ff; border-right: 5px solid var(--ir-primary); }

        /* 🔘 نشانگرهای وضعیت نئون */
        .status-pill {
            padding: 6px 14px; border-radius: 12px; font-size: 0.72rem; font-weight: 900;
            display: inline-flex; align-items: center; gap: 6px; box-shadow: 0 2px 4px rgba(0,0,0,0.02);
        }
        .st-pending { background: #fffbeb; color: #92400e; border: 1px solid #fef3c7; }
        .st-approved { background: #f0fdf4; color: #166534; border: 1px solid #dcfce7; }
        .st-paid { background: #eff6ff; color: #1e40af; border: 1px solid #dbeafe; }
        .st-rejected { background: #fef2f2; color: #991b1b; border: 1px solid #fee2e2; }

        /* 🛠️ نوار ابزار شناور (Floating Action Bar) */
        .bulk-glass-bar {
            position: fixed; bottom: 3rem; left: 50%; transform: translateX(-50%);
            background: rgba(15, 23, 42, 0.95); backdrop-filter: blur(15px);
            color: white; padding: 1rem 2.5rem; border-radius: 100px; z-index: 1100;
            display: flex; align-items: center; gap: 2rem; border: 1px solid rgba(255,255,255,0.1);
            box-shadow: 0 30px 60px -12px rgba(0,0,0,0.4);
        }

        /* 🚀 انیمیشن‌های ورود */
        .animate-up { animation: fadeInUp 0.5s ease-out both; }
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
    </style>

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-5 gap-4 animate-up">
        <div class="text-end">
            <div class="d-flex align-items-center gap-3 mb-2">
                <span class="p-2 bg-primary bg-opacity-10 text-primary rounded-3"><i class="ti ti-report-money fs-4"></i></span>
                <span class="fw-black text-muted fs-6">سامانه هوشمند مدیریت نقدینگی</span>
            </div>
            <h1 class="fw-black text-slate-900 mb-0" style="font-size: 2.2rem; letter-spacing: -1.5px;">رهگیری درخواست‌های <span class="text-primary">وجه</span></h1>
            <p class="text-muted fw-bold">مدیریت متمرکز گردش کار و پایش بودجه جاری</p>
        </div>
        <div class="d-flex gap-3">
            <div class="dropdown">
                <button class="btn btn-white rounded-4 px-4 border fw-black shadow-sm" data-bs-toggle="dropdown">
                    <i class="ti ti-download me-2 text-success"></i> خروجی گزارشات <i class="ti ti-chevron-down ms-2 small"></i>
                </button>
                <ul class="dropdown-menu shadow-xl border-0 rounded-4 p-2 text-end">
                    <li><button wire:click="exportSelected" class="dropdown-item fw-bold rounded-3 py-2"><i class="ti ti-file-spreadsheet me-2 text-success"></i> دریافت اکسل (Excel)</button></li>
                    <li><button class="dropdown-item fw-bold rounded-3 py-2"><i class="ti ti-file-description me-2 text-danger"></i> دریافت نسخه PDF</button></li>
                </ul>
            </div>
            <a href="{{ route('admin.payment.create') }}" class="btn btn-primary rounded-4 px-4 shadow-primary fw-black hover-elevate">
                <i class="ti ti-plus me-1"></i> ثبت درخواست جدید
            </a>
        </div>
    </div>

    <div class="row g-4 mb-5 text-end animate-up" style="animation-delay: 0.1s">
        <div class="col-md-4">
            <div class="kpi-box hover-elevate border-start border-4 border-primary">
                <div class="small fw-black text-muted opacity-50 mb-3">حجم کل درخواست‌ها</div>
                <h2 class="fw-black mb-0" style="font-size: 2.4rem;">{{ number_format($this->filteredStats['count']) }} <small class="fs-6 fw-bold">فقره</small></h2>
                <div class="mt-3 small fw-bold text-primary"><i class="ti ti-trending-up me-1"></i> تعداد موارد فیلتر شده</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="kpi-box hover-elevate border-start border-4 border-success">
                <div class="small fw-black text-muted opacity-50 mb-3">مجموع اعتبارات در جریان</div>
                <h2 class="fw-black mb-0 text-success" style="font-size: 2.4rem;">{{ number_format($this->filteredStats['sum']) }} <small class="fs-6 fw-bold">ریال</small></h2>
                <div class="progress mt-3" style="height: 6px; background: #f1f5f9;"><div class="progress-bar bg-success rounded-pill" style="width: 80%"></div></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="kpi-box hover-elevate border-start border-4 border-warning">
                <div class="small fw-black text-muted opacity-50 mb-3">میانگین ارزش تراکنش</div>
                <h2 class="fw-black mb-0 text-warning" style="font-size: 2.4rem;">{{ number_format($this->filteredStats['avg']) }}</h2>
                <div class="mt-3 small fw-bold text-slate-400"><i class="ti ti-chart-dots me-1"></i> شاخص میانگین سبد نقدینگی</div>
            </div>
        </div>
    </div>

    <div class="lux-container p-4 mb-4 shadow-sm animate-up text-end" style="animation-delay: 0.2s">
        <div class="row g-4 align-items-end">
            <div class="col-lg-4">
                <label class="small fw-black text-dark mb-2 ms-2">جستجوی هوشمند (شناسه، ذینفع، بابت)</label>
                <div class="input-group bg-light rounded-4 overflow-hidden border-0 px-3 py-1 shadow-inner">
                    <i class="ti ti-search text-muted mt-2 ms-2"></i>
                    <input type="text" class="form-control bg-transparent border-0 shadow-none fw-bold small" wire:model.live.debounce.400ms="search" placeholder="جستجو در تمامی فیلدها...">
                </div>
            </div>
            <div class="col-lg-8">
                <div class="row g-2">
                    <div class="col-md-3">
                        <select class="form-select border-0 bg-light rounded-pill small fw-bold px-3" wire:model.live="statusFilter">
                            <option value="">همه وضعیت‌ها</option>
                            <option value="pending">⏳ در انتظار تایید</option>
                            <option value="approved">✅ تایید شده</option>
                            <option value="paid">💰 تسویه شده</option>
                            <option value="rejected">❌ رد شده</option>
                        </select>
                    </div>
                    <div class="col-md-5">
                        <select class="form-select border-0 bg-light rounded-pill small fw-bold px-3" wire:model.live="projectFilter">
                            <option value="">تمامی پروژه‌های فعال سازمان</option>
                            @foreach($this->projects as $p) <option value="{{ $p->id }}">{{ $p->name }}</option> @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex gap-1">
                            <input type="number" class="form-control border-0 bg-light rounded-pill small fw-bold text-center" wire:model.live.debounce.500ms="minAmount" placeholder="حداقل (ریال)">
                            <input type="number" class="form-control border-0 bg-light rounded-pill small fw-bold text-center" wire:model.live.debounce.500ms="maxAmount" placeholder="حداکثر (ریال)">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="lux-container shadow-lg animate-up" style="animation-delay: 0.3s">
        <div class="table-responsive" wire:loading.class="opacity-50">
            <table class="table align-middle mb-0 text-end">
                <thead class="lux-header-row">
                <tr>
                    <th class="ps-4" style="width: 60px;">
                        <input type="checkbox" class="form-check-input ms-0" wire:model.live="selectAll">
                    </th>
                    <th>ذینفع و پروژه هدف</th>
                    <th class="text-center">ارزش ناخالص</th>
                    <th class="text-center">وضعیت فعلی</th>
                    <th class="text-center">ثبت / سررسید</th>
                    <th class="pe-4 text-center">مدیریت</th>
                </tr>
                </thead>
                <tbody>
                @forelse($this->paymentRequests as $request)
                    @php($status = $this->getStatusData($request->status))
                    <tr class="row-interact" :class="expanded === {{ $request->id }} ? 'is-expanded' : ''">
                        <td class="ps-4">
                            <input type="checkbox" class="form-check-input ms-0" wire:model.live="selectedRows" value="{{ $request->id }}">
                        </td>
                        <td x-on:click="expanded === {{ $request->id }} ? expanded = null : expanded = {{ $request->id }}">
                            <div class="d-flex align-items-center">
                                <div class="p-3 bg-primary bg-opacity-10 rounded-4 me-3 text-primary shadow-sm"><i class="ti ti-receipt-2 fs-4"></i></div>
                                <div>
                                    <div class="fw-black text-slate-800 fs-6">{{ $request->recipient_name }}</div>
                                    <div class="small text-muted fw-bold d-flex align-items-center gap-2 mt-1">
                                        <span class="badge bg-light text-dark fw-black">#{{ $request->id }}</span>
                                        <span class="text-slate-300">|</span>
                                        <i class="ti ti-building me-1 opacity-50"></i>{{ $request->project->name ?? 'پروژه عمومی' }}
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td class="text-center" x-on:click="expanded = {{ $request->id }}">
                            <div class="fw-black text-slate-900 fs-5">{{ number_format($request->amount) }}</div>
                            @if($request->is_urgent) <span class="badge bg-danger-subtle text-danger smaller px-2 py-1 mt-1 rounded-pill fw-black"><i class="ti ti-urgent me-1"></i>اولویت فوری</span> @endif
                        </td>
                        <td class="text-center">
                            <span class="status-pill st-{{ $request->status }}">
                                <i class="{{ $status['icon'] }}"></i> {{ $status['label'] }}
                            </span>
                        </td>
                        <td class="text-center" x-on:click="expanded = {{ $request->id }}">
                            <div class="fw-bold small text-slate-700 mb-1">{{ $request->created_at_shamsi }}</div>
                            <div class="small fw-bold text-muted opacity-50">مهلت: {{ $request->due_date_shamsi }}</div>
                        </td>
                        <td class="pe-4 text-center">
                            <div class="d-flex justify-content-center gap-2">
                                <a href="{{ route('admin.payment.show', $request->id) }}" class="btn btn-sm btn-white rounded-3 border-0 shadow-sm p-2"><i class="ti ti-external-link text-primary fs-5"></i></a>
                                <button class="btn btn-sm btn-white rounded-3 border-0 shadow-sm p-2" x-on:click="expanded === {{ $request->id }} ? expanded = null : expanded = {{ $request->id }}"><i class="ti ti-layout-bottombar-expand text-muted fs-5"></i></button>
                            </div>
                        </td>
                    </tr>

                    <tr x-show="expanded === {{ $request->id }}" x-collapse x-cloak>
                        <td colspan="6" class="p-0 border-0">
                            <div class="p-5 border-bottom bg-slate-50 bg-opacity-40 mx-4 rounded-4 mb-4 border border-light shadow-inner">
                                <div class="row g-5">
                                    <div class="col-md-8 border-start text-end">
                                        <div class="d-flex align-items-center gap-2 mb-4 text-primary">
                                            <i class="ti ti-notes fs-4"></i>
                                            <h6 class="fw-black m-0 small text-uppercase">شرح کامل درخواست وجه و بابت تراکنش</h6>
                                        </div>
                                        <div class="bg-white p-4 rounded-4 shadow-sm border border-light">
                                            <p class="text-slate-700 fw-bold lh-lg m-0" style="font-size: 0.95rem;">{{ $request->purpose }}</p>
                                        </div>

                                        <div class="mt-5">
                                            <h6 class="fw-black text-dark small mb-3"><i class="ti ti-timeline me-2"></i>گزارش زنجیره تاییدات:</h6>
                                            <div class="d-flex flex-wrap gap-2">
                                                @foreach($request->approvals as $approval)
                                                    <div class="d-flex align-items-center gap-2 bg-white px-3 py-2 rounded-4 border shadow-xs">
                                                        <img src="https://ui-avatars.com/api/?name={{ urlencode($approval->user->name) }}&background=2563eb&color=fff" class="rounded-circle" width="22">
                                                        <span class="small fw-black text-slate-700">{{ $approval->user->name }}</span>
                                                        @if($approval->is_approved === 1) <i class="ti ti-circle-check-filled text-success fs-5"></i> @endif
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 text-start">
                                        <div class="bg-white p-4 rounded-4 shadow-sm border border-light h-100 text-center">
                                            <h6 class="fw-black text-dark mb-4 small">تحلیل مصرف بودجه پروژه</h6>
                                            <div class="d-flex justify-content-center mb-4">
                                                <div class="p-4 rounded-circle border border-5 border-primary border-opacity-10 shadow-sm position-relative">
                                                    <h3 class="fw-black m-0">65%</h3>
                                                </div>
                                            </div>
                                            <p class="text-muted small fw-bold">این درخواست <b>۸٪</b> از نقدینگی باقی‌مانده پروژه را به خود اختصاص می‌دهد.</p>
                                            <hr class="opacity-10 my-4">
                                            <div class="d-flex gap-2">
                                                <button class="btn btn-sm btn-outline-secondary w-100 fw-black rounded-3 small border-2">پیوست‌ها ({{ $request->attachments->count() }})</button>
                                                <button class="btn btn-sm btn-primary w-100 fw-black rounded-3 shadow-primary small">پرونده مالی</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="6" class="py-5 text-center opacity-50"><i class="ti ti-database-off display-3"></i><h5 class="fw-black">هیچ تراکنشی یافت نشد.</h5></td></tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="px-4 py-4 bg-light bg-opacity-30 border-top d-flex justify-content-between align-items-center">
            <div class="small fw-black text-muted">نمایش موارد {{ $this->paymentRequests->firstItem() }} تا {{ $this->paymentRequests->lastItem() }}</div>
            {{ $this->paymentRequests->links() }}
        </div>
    </div>

    <div class="bulk-glass-bar animate-up" x-show="showBulkActions.length > 0" x-transition x-cloak>
        <div class="d-flex align-items-center gap-3">
            <div class="bg-white text-dark rounded-pill px-4 py-1 fw-black small shadow-sm">
                <span x-text="showBulkActions.length"></span> تراکنش انتخاب شده
            </div>
            <div class="vr opacity-20" style="height: 30px;"></div>
            <button wire:click="bulkChangeStatus('approved')" class="btn btn-success rounded-pill btn-sm px-4 fw-black border-0">تایید گروهی تاییدات</button>
            <button wire:click="bulkChangeStatus('paid')" class="btn btn-info rounded-pill btn-sm px-4 fw-black text-white border-0">تسویه نهایی مالی</button>
            <button wire:click="exportSelected" class="btn btn-white rounded-pill btn-sm px-4 fw-black border-0 shadow-sm"><i class="ti ti-file-export me-1"></i> اکسل</button>
            <button @click="$wire.set('selectedRows', [])" class="btn btn-link text-white text-decoration-none small opacity-75 fw-bold">لغو انتخاب</button>
        </div>
    </div>
</div>
