<div class="container-fluid py-4 text-end" style="background: linear-gradient(135deg, #f8fafc 0%, #f0f7ff 100%); min-height: 100vh; font-family: 'Vazirmatn', sans-serif;">
    <style>
        :root {
            --p-indigo: #6366f1;
            --p-indigo-light: #818cf8;
            --p-emerald: #10b981;
            --p-emerald-light: #34d399;
            --p-rose: #f43f5e;
            --p-amber: #f59e0b;
            --p-amber-light: #fbbf24;
            --p-border: #e2e8f0;
            --p-dark: #0f172a;
            --p-dark-light: #1e293b;
            --p-glass: rgba(255, 255, 255, 0.7);
            --p-glass-dark: rgba(15, 23, 42, 0.8);
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        @keyframes shimmer {
            0% { background-position: -200% center; }
            100% { background-position: 200% center; }
        }

        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes pulse-glow {
            0%, 100% { box-shadow: 0 0 20px rgba(99, 102, 241, 0.3); }
            50% { box-shadow: 0 0 30px rgba(99, 102, 241, 0.6); }
        }

        .lux-card {
            background: var(--p-glass);
            backdrop-filter: blur(10px);
            border-radius: 24px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow:
                0 8px 32px rgba(0, 0, 0, 0.05),
                inset 0 1px 0 rgba(255, 255, 255, 0.6);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
            position: relative;
        }

        .lux-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--p-indigo), var(--p-emerald));
            border-radius: 24px 24px 0 0;
            opacity: 0.8;
        }

        .lux-card:hover {
            transform: translateY(-5px);
            box-shadow:
                0 15px 40px rgba(99, 102, 241, 0.15),
                inset 0 1px 0 rgba(255, 255, 255, 0.8);
        }

        /* 🌳 درخت‌واره پیشرفته با انیمیشن */
        .tree-scroll-area {
            display: flex;
            gap: 25px;
            padding: 20px;
            overflow-x: auto;
            scrollbar-width: thin;
            scrollbar-color: var(--p-indigo) transparent;
            animation: fadeInUp 0.6s ease-out;
        }

        .tree-scroll-area::-webkit-scrollbar {
            height: 6px;
        }

        .tree-scroll-area::-webkit-scrollbar-thumb {
            background: linear-gradient(90deg, var(--p-indigo), var(--p-emerald));
            border-radius: 10px;
        }

        .tree-node {
            min-width: 280px;
            background: linear-gradient(145deg, #ffffff, #f8faff);
            border: none;
            border-radius: 20px;
            padding: 25px;
            position: relative;
            transition: all 0.3s ease;
            flex-shrink: 0;
            animation: fadeInUp 0.4s ease-out;
            animation-fill-mode: both;
        }

        .tree-node:nth-child(1) { animation-delay: 0.1s; }
        .tree-node:nth-child(2) { animation-delay: 0.2s; }
        .tree-node:nth-child(3) { animation-delay: 0.3s; }
        .tree-node:nth-child(4) { animation-delay: 0.4s; }
        .tree-node:nth-child(5) { animation-delay: 0.5s; }

        .tree-node::before {
            content: '';
            position: absolute;
            top: -1px;
            left: -1px;
            right: -1px;
            bottom: -1px;
            background: linear-gradient(45deg, var(--p-indigo), var(--p-emerald), var(--p-amber));
            border-radius: 21px;
            z-index: -1;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .tree-node:hover::before {
            opacity: 0.3;
        }

        .tree-node.completed {
            background: linear-gradient(145deg, #f0fdf4, #dcfce7);
            border-left: 4px solid var(--p-emerald);
        }

        .tree-node.current {
            background: linear-gradient(145deg, #f5f7ff, #e0e7ff);
            border-left: 4px solid var(--p-indigo);
            animation: pulse-glow 2s infinite;
        }

        .tree-node.pending {
            background: linear-gradient(145deg, #f8fafc, #f1f5f9);
            border-left: 4px solid #cbd5e1;
        }

        .node-connector {
            position: absolute;
            left: -30px;
            top: 50%;
            width: 30px;
            height: 2px;
            background: linear-gradient(90deg, var(--p-emerald), var(--p-indigo));
            transform: translateY(-50%);
        }

        .node-connector::after {
            content: '';
            position: absolute;
            right: -3px;
            top: 50%;
            width: 8px;
            height: 8px;
            background: var(--p-indigo);
            border-radius: 50%;
            transform: translateY(-50%);
        }

        /* 💳 کارت مجازی مدرن */
        .v-card-master {
            background: linear-gradient(135deg,
            var(--p-dark) 0%,
            var(--p-dark-light) 50%,
            #1e1b4b 100%);
            border-radius: 24px;
            padding: 30px;
            color: #fff;
            position: relative;
            overflow: hidden;
            box-shadow:
                0 20px 60px rgba(15, 23, 42, 0.4),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
            animation: float 6s ease-in-out infinite;
        }

        .v-card-master::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle,
            rgba(99, 102, 241, 0.1) 0%,
            rgba(99, 102, 241, 0.05) 25%,
            transparent 70%);
            animation: shimmer 8s linear infinite;
        }

        .v-card-master::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg,
            transparent,
            rgba(255, 255, 255, 0.3),
            transparent);
        }

        .bank-chip {
            width: 60px;
            height: 45px;
            background: linear-gradient(135deg,
            #fcd34d 0%,
            #d97706 50%,
            #92400e 100%);
            border-radius: 12px;
            margin-bottom: 25px;
            position: relative;
            z-index: 1;
            box-shadow: 0 4px 12px rgba(146, 64, 14, 0.3);
        }

        .bank-chip::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 80%;
            height: 80%;
            background: linear-gradient(135deg,
            rgba(255, 255, 255, 0.2),
            transparent);
            border-radius: 8px;
            transform: translate(-50%, -50%);
        }

        /* 📂 آکاردئون مدرن */
        .accordion-lux .accordion-item {
            background: var(--p-glass);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 20px !important;
            margin-bottom: 16px;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .accordion-lux .accordion-item:hover {
            border-color: var(--p-indigo-light);
        }

        .accordion-lux .accordion-button {
            padding: 1.5rem;
            font-weight: 900;
            color: var(--p-dark);
            background: transparent;
            border: none;
            font-size: 1.1rem;
            transition: all 0.3s ease;
        }

        .accordion-lux .accordion-button:not(.collapsed) {
            background: linear-gradient(90deg,
            rgba(99, 102, 241, 0.1),
            rgba(99, 102, 241, 0.05));
            color: var(--p-indigo);
            box-shadow: none;
        }

        .accordion-lux .accordion-button::after {
            transform: rotate(90deg);
            transition: transform 0.3s ease;
        }

        .accordion-lux .accordion-button:not(.collapsed)::after {
            transform: rotate(-90deg);
        }

        /* اعداد بزرگ پویا */
        .monetary-epic {
            font-size: 4.5rem;
            font-weight: 950;
            letter-spacing: -3px;
            background: linear-gradient(135deg,
            var(--p-indigo) 0%,
            var(--p-emerald) 50%,
            var(--p-amber) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            line-height: 1;
            position: relative;
            display: inline-block;
        }

        .monetary-epic::after {
            content: attr(data-amount);
            position: absolute;
            top: 2px;
            left: 2px;
            background: linear-gradient(135deg,
            var(--p-indigo) 0%,
            var(--p-emerald) 50%,
            var(--p-amber) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            filter: blur(8px);
            opacity: 0.5;
            z-index: -1;
        }

        /* برچسب‌های داده */
        .data-label {
            color: #64748b;
            font-size: 0.75rem;
            font-weight: 800;
            text-transform: uppercase;
            letter-spacing: 1px;
            position: relative;
            display: inline-block;
            padding-bottom: 4px;
        }

        .data-label::after {
            content: '';
            position: absolute;
            bottom: 0;
            right: 0;
            width: 40%;
            height: 2px;
            background: linear-gradient(90deg, transparent, var(--p-indigo));
            border-radius: 2px;
        }

        /* Timeline مدرن */
        .workflow-trail {
            position: relative;
            padding-right: 35px;
        }

        .workflow-trail::before {
            content: '';
            position: absolute;
            right: 12px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: linear-gradient(to bottom,
            var(--p-emerald),
            var(--p-indigo),
            var(--p-amber));
            border-radius: 2px;
        }

        .wf-item {
            position: relative;
            margin-bottom: 30px;
            animation: fadeInUp 0.5s ease-out;
            animation-fill-mode: both;
        }

        .wf-item:nth-child(1) { animation-delay: 0.1s; }
        .wf-item:nth-child(2) { animation-delay: 0.2s; }
        .wf-item:nth-child(3) { animation-delay: 0.3s; }
        .wf-item:nth-child(4) { animation-delay: 0.4s; }

        .wf-item::before {
            content: '';
            position: absolute;
            right: -28px;
            top: 2px;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background: var(--p-dark);
            border: 3px solid #fff;
            z-index: 2;
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.2);
            transition: all 0.3s ease;
        }

        .wf-item.approved::before {
            background: var(--p-emerald);
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.3),
            0 0 20px rgba(16, 185, 129, 0.4);
        }

        .wf-item.rejected::before {
            background: var(--p-rose);
            box-shadow: 0 0 0 3px rgba(244, 63, 94, 0.3),
            0 0 20px rgba(244, 63, 94, 0.4);
        }

        .wf-item.pending::before {
            background: #e2e8f0;
            animation: pulse-glow 2s infinite;
        }

        /* دکمه‌های مدرن */
        .btn-modern {
            background: linear-gradient(135deg, var(--p-indigo), var(--p-indigo-light));
            border: none;
            border-radius: 12px;
            padding: 10px 24px;
            color: white;
            font-weight: 700;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .btn-modern::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg,
            transparent,
            rgba(255, 255, 255, 0.2),
            transparent);
            transition: left 0.6s ease;
        }

        .btn-modern:hover::before {
            left: 100%;
        }

        .btn-modern:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(99, 102, 241, 0.4);
        }

        /* Progress Bar مدرن */
        .progress-modern {
            height: 10px;
            background: rgba(99, 102, 241, 0.1);
            border-radius: 10px;
            overflow: hidden;
            position: relative;
        }

        .progress-modern::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            background: linear-gradient(90deg,
            var(--p-indigo),
            var(--p-emerald));
            width: var(--progress);
            border-radius: 10px;
            transition: width 1s cubic-bezier(0.4, 0, 0.2, 1);
            animation: shimmer 3s infinite linear;
        }

        /* Badge مدرن */
        .badge-modern {
            background: linear-gradient(135deg, var(--p-indigo), var(--p-indigo-light));
            color: white;
            padding: 6px 16px;
            border-radius: 20px;
            font-weight: 800;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
            box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
        }

        /* انیمیشن‌های کلی */
        .reveal-up {
            animation: fadeInUp 0.6s ease-out;
        }

        .hover-lift {
            transition: all 0.3s ease;
        }

        .hover-lift:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }

        .no-print {
            @media print { display: none !important; }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .monetary-epic {
                font-size: 3rem;
            }

            .tree-node {
                min-width: 240px;
            }

            .v-card-master {
                padding: 20px;
            }
        }
    </style>

    <!-- Floating Background Elements -->
    <div style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; pointer-events: none; z-index: -1;">
        <div style="position: absolute; top: 10%; left: 5%; width: 300px; height: 300px;
                    background: radial-gradient(circle, rgba(99, 102, 241, 0.1) 0%, transparent 70%);
                    border-radius: 50%; animation: float 8s ease-in-out infinite;"></div>
        <div style="position: absolute; bottom: 10%; right: 5%; width: 400px; height: 400px;
                    background: radial-gradient(circle, rgba(16, 185, 129, 0.08) 0%, transparent 70%);
                    border-radius: 50%; animation: float 10s ease-in-out infinite reverse;"></div>
    </div>

    <div class="row justify-content-center">
        <div class="col-12 col-xxl-11">

            <!-- Header با طراحی مدرن -->
            <div class="lux-card p-5 mb-5 border-0 reveal-up">
                <div class="d-flex align-items-center justify-content-between mb-4 pb-4 border-bottom border-opacity-10">
                    <div class="d-flex align-items-center gap-4">
                        <div class="p-3 bg-primary bg-opacity-10 rounded-4"
                             style="background: linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(99, 102, 241, 0.05));">
                            <i class="ti ti-git-branch fs-2 text-primary"></i>
                        </div>
                        <div>
                            <h4 class="fw-black m-0 text-dark">پایش زنجیره تامین و پرداخت (Digital Audit)</h4>
                            <span class="text-muted small fw-bold d-flex align-items-center gap-2 mt-2">
                                <i class="ti ti-qrcode text-primary"></i>
                                شناسه رهگیری: <span class="font-monospace text-primary">PRQ-{{ $paymentRequest->id }}</span>
                            </span>
                        </div>
                    </div>
                    <div class="no-print">
                        <button onclick="window.print()" class="btn-modern d-flex align-items-center gap-2">
                            <i class="ti ti-printer fs-5"></i>
                            چاپ سند رسمی
                        </button>

                        <button wire:click="downloadPdf" wire:loading.attr="disabled" class="btn btn-sm btn-outline-dark rounded-pill px-4 fw-black">
                            <span wire:loading.remove><i class="ti ti-file-download me-1 text-primary"></i> دانلود نسخه PDF</span>
                            <span wire:loading><i class="ti ti-loader rotate me-1"></i> در حال پردازش...</span>
                        </button>

                    </div>
                </div>

                <!-- Progress Bar -->
                <div class="mb-4">
                    <div class="d-flex justify-content-between mb-2">
                        <span class="data-label">پیشرفت فرآیند</span>
                        <span class="fw-black text-primary">{{ $this->financialMetrics['progress_percent'] ?? 75 }}%</span>
                    </div>
                    <div class="progress-modern" style="--progress: {{ $this->financialMetrics['progress_percent'] ?? 75 }}%"></div>
                </div>

                <!-- Workflow Tree با طراحی جدید -->
                <div class="tree-scroll-area" dir="ltr">
                    @foreach($this->workflowSteps as $index => $step)
                        <div class="tree-node {{ $step['status'] }} hover-lift">
                            @if(!$loop->first) <div class="node-connector"></div> @endif
                            <div class="d-flex align-items-center gap-3 mb-3">
                                <div class="p-3 rounded-4 d-flex align-items-center justify-content-center"
                                     style="width: 50px; height: 50px;
                                            {{ $step['status'] === 'completed' ?
                                               'background: linear-gradient(135deg, var(--p-emerald), var(--p-emerald-light));' :
                                               ($step['status'] === 'current' ?
                                                'background: linear-gradient(135deg, var(--p-indigo), var(--p-indigo-light));' :
                                                'background: linear-gradient(135deg, #cbd5e1, #94a3b8);') }}">
                                    <i class="ti {{ $step['icon'] }} fs-4 text-white"></i>
                                </div>
                                <div>
                                    <div class="fw-black text-dark fs-5" dir="rtl">{{ $step['title'] }}</div>
                                    <div class="text-muted fw-bold mt-1" style="font-size: 11px; letter-spacing: 0.5px;">
                                        مرحله {{ $index + 1 }} از {{ count($this->workflowSteps) }}
                                    </div>
                                </div>
                            </div>
                            <div class="text-end" dir="rtl">
                                <div class="text-muted fw-bold mb-3" style="font-size: 12px; line-height: 1.6;">{{ $step['desc'] }}</div>
                                <div class="d-flex justify-content-between align-items-center border-top border-opacity-10 pt-3 mt-3">
                                    <span class="text-indigo font-monospace d-flex align-items-center gap-1" style="font-size: 11px;">
                                        <i class="ti ti-calendar"></i>
                                        {{ $step['date'] }}
                                    </span>
                                    @if($step['link'])
                                        <a href="{{ $step['link'] }}" class="btn btn-outline-primary btn-sm rounded-pill fw-bold d-flex align-items-center gap-1 px-3 py-1">
                                            <i class="ti ti-external-link fs-4"></i>
                                            مشاهده مبدأ
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="row g-4">
                <div class="col-lg-8 text-end">

                    <!-- کارت مبلغ با طراحی جدید -->
                    <div class="lux-card p-5 mb-5 border-0 text-center reveal-up" style="animation-delay: 0.2s;">
                        <span class="data-label opacity-60 mb-3 d-block">خالص قابل پرداخت به ذینفع (Net Settlement)</span>
                        <div class="d-flex align-items-baseline justify-content-center gap-3 my-4">
                            <div class="monetary-epic" data-amount="{{ number_format($paymentRequest->amount) }}">
                                {{ number_format($paymentRequest->amount) }}
                            </div>
                            <span class="fw-black text-muted fs-4">ریال</span>
                        </div>

                        <div class="row g-4 mt-5 justify-content-center">
                            <div class="col-md-5">
                                <div class="p-4 bg-white rounded-4 border border-light shadow-sm hover-lift">
                                    <span class="data-label opacity-50">جمع کل ناخالص (Gross):</span>
                                    <div class="fw-black mt-2 text-dark fs-4">{{ number_format($this->financialMetrics['gross_amount']) }}</div>
                                    <div class="progress-modern mt-3" style="--progress: 100%; height: 6px;"></div>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="p-4 rounded-4 border border-light shadow-sm hover-lift"
                                     style="background: linear-gradient(135deg, rgba(244, 63, 94, 0.05), rgba(244, 63, 94, 0.02));">
                                    <span class="data-label text-rose opacity-75">مالیات و کسورات قانونی:</span>
                                    <div class="fw-black mt-2 text-rose fs-4">{{ number_format($this->financialMetrics['tax_amount']) }}</div>
                                    <div class="progress-modern mt-3"
                                         style="--progress: {{ $this->financialMetrics['tax_percent'] ?? 20 }}%;
                                                height: 6px;
                                                background: rgba(244, 63, 94, 0.1);"></div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-5 pt-4 border-top border-opacity-10">
                            <div class="row justify-content-center">
                                <div class="col-md-4">
                                    <div class="p-3 rounded-4 bg-light">
                                        <span class="data-label opacity-50">نرخ مالیات:</span>
                                        <div class="fw-black mt-1 text-dark fs-5">{{ $this->financialMetrics['tax_percent'] ?? 9 }}%</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- آکاردئون‌ها -->
                    <div class="accordion accordion-lux" id="mainAccordion">

                        <!-- کارت بانکی -->
                        <div class="accordion-item shadow-sm border-0 reveal-up" style="animation-delay: 0.3s;">
                            <h2 class="accordion-header">
                                <button class="accordion-button rounded-4" type="button" data-bs-toggle="collapse" data-bs-target="#payeeCollapse">
                                    <div class="p-3 rounded-4 me-3"
                                         style="background: linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(99, 102, 241, 0.05));">
                                        <i class="ti ti-building-bank fs-3 text-indigo"></i>
                                    </div>
                                    <div class="text-start">
                                        <span class="fw-black fs-5">مشخصات بانکی و شناسنامه ذینفع وجه</span>
                                        <div class="text-muted small fw-bold mt-1">اطلاعات کامل درگاه پرداخت</div>
                                    </div>
                                </button>
                            </h2>
                            <div id="payeeCollapse" class="accordion-collapse collapse show">
                                <div class="accordion-body p-4">
                                    <div class="row g-4 align-items-center">
                                        <div class="col-md-5">
                                            <div class="pe-4 border-end border-4 border-primary border-opacity-20">
                                                <span class="data-label mb-2 d-block">نام دریافت‌کننده:</span>
                                                <h4 class="fw-black text-dark mb-4 d-flex align-items-center gap-2">
                                                    {{ $paymentRequest->payee->name ?? $paymentRequest->recipient_name }}
                                                    <span class="badge-modern">
                                                        {{ ($paymentRequest->payee && $paymentRequest->payee->type === 'company') ? 'حقوقی' : 'حقیقی' }}
                                                    </span>
                                                </h4>

                                                <div class="mb-4">
                                                    <span class="data-label mb-2 d-block">شناسه ملی / کد ملی:</span>
                                                    <div class="font-monospace fs-5 fw-black text-primary p-3 px-4 rounded-4 bg-primary bg-opacity-10 d-inline-block">
                                                        {{ $paymentRequest->payee->national_id ?? 'ثبت نشده' }}
                                                    </div>
                                                </div>

                                                <div class="mt-4 p-3 bg-light rounded-4">
                                                    <span class="data-label mb-1 d-block">کد اقتصادی:</span>
                                                    <div class="fw-bold text-dark">{{ $paymentRequest->payee->economic_code ?? '---' }}</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-7">
                                            <div class="v-card-master">
                                                <div class="d-flex justify-content-between align-items-start mb-5 position-relative z-2">
                                                    <div class="d-flex flex-column gap-3">
                                                        <div class="bank-chip"></div>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="p-2 bg-white bg-opacity-10 rounded-3">
                                                                <i class="ti ti-shield-check text-emerald"></i>
                                                            </div>
                                                            <span class="fs-xs opacity-75">پرداخت امن SSL/TLS</span>
                                                        </div>
                                                    </div>
                                                    <div class="text-start">
                                                        <div class="fw-black fs-4">{{ $this->iranianBanks()[$paymentRequest->payee->bank_name ?? ''] ?? 'بانک مقصد' }}</div>
                                                        <span class="fs-xs opacity-50 fw-bold">Secure Digital Settlement Protocol</span>
                                                    </div>
                                                </div>
                                                <div class="text-start position-relative z-2">
                                                    <span class="fs-xs fw-bold opacity-30 d-block mb-2">IBAN / شماره شبا</span>
                                                    <div class="fs-3 fw-black font-monospace tracking-widest" dir="ltr"
                                                         style="background: linear-gradient(90deg, #fbbf24, #f59e0b);
                                                                -webkit-background-clip: text;
                                                                -webkit-text-fill-color: transparent;
                                                                background-clip: text;">
                                                        <span class="opacity-50">IR</span>
                                                        {{ wordwrap($paymentRequest->payee->sheba ?? '000000000000000000000000', 4, ' ', true) }}
                                                    </div>
                                                </div>
                                                <div class="mt-5 position-relative z-2">
                                                    <div class="row">
                                                        <div class="col-6">
                                                            <span class="small opacity-50 fw-bold d-block mb-1">شماره حساب:</span>
                                                            <div class="font-monospace text-white fw-bold">{{ $paymentRequest->payee->account_number ?? '---' }}</div>
                                                        </div>
                                                        <div class="col-6">
                                                            <span class="small opacity-50 fw-bold d-block mb-1">نوع حساب:</span>
                                                            <div class="text-white fw-bold">{{ $paymentRequest->payee->account_type ?? 'جاری' }}</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- کارت توضیحات -->
                        <div class="accordion-item shadow-sm border-0 reveal-up" style="animation-delay: 0.4s;">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#purposeCollapse">
                                    <div class="p-3 rounded-4 me-3"
                                         style="background: linear-gradient(135deg, rgba(245, 158, 11, 0.1), rgba(245, 158, 11, 0.05));">
                                        <i class="ti ti-notes fs-3 text-amber"></i>
                                    </div>
                                    <div class="text-start">
                                        <span class="fw-black fs-5">شرح ضرورت و بابت درخواست تسویه</span>
                                        <div class="text-muted small fw-bold mt-1">توضیحات کامل درخواست پرداخت</div>
                                    </div>
                                </button>
                            </h2>
                            <div id="purposeCollapse" class="accordion-collapse collapse">
                                <div class="accordion-body p-4">
                                    <div class="p-5 rounded-4 position-relative overflow-hidden"
                                         style="background: linear-gradient(135deg, #f8fafc, #f1f5f9);">
                                        <div class="position-absolute top-0 start-0 w-100 h-100 opacity-10">
                                            <i class="ti ti-notes position-absolute" style="font-size: 8rem; top: 20px; left: 20px;"></i>
                                        </div>
                                        <p class="lh-lg m-0 fw-bold text-dark text-justify position-relative z-1"
                                           style="font-size: 1.1rem; line-height: 1.8;">
                                            {{ $paymentRequest->purpose }}
                                        </p>
                                    </div>

                                    @if($paymentRequest->additional_notes)
                                        <div class="mt-4 p-4 rounded-4 border border-amber border-opacity-20 bg-amber bg-opacity-5">
                                            <span class="data-label text-amber mb-2 d-block">یادداشت‌های تکمیلی:</span>
                                            <p class="text-dark m-0">{{ $paymentRequest->additional_notes }}</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- کارت اقلام -->
                        @if($paymentRequest->purchaseRequest)
                            <div class="accordion-item shadow-sm border-0 reveal-up" style="animation-delay: 0.5s;">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#itemsCollapse">
                                        <div class="p-3 rounded-4 me-3"
                                             style="background: linear-gradient(135deg, rgba(16, 185, 129, 0.1), rgba(16, 185, 129, 0.05));">
                                            <i class="ti ti-list-details fs-3 text-emerald"></i>
                                        </div>
                                        <div class="text-start">
                                            <span class="fw-black fs-5">آنالیز اقلام سفارش خرید مرتبط</span>
                                            <div class="text-muted small fw-bold mt-1">Linked Items Analysis</div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="itemsCollapse" class="accordion-collapse collapse">
                                    <div class="accordion-body p-0">
                                        <div class="table-responsive">
                                            <table class="table table-hover align-middle mb-0">
                                                <thead class="bg-light">
                                                <tr class="text-end">
                                                    <th class="ps-5 py-4">شرح کالا / خدمات</th>
                                                    <th class="text-center">تعداد</th>
                                                    <th class="text-center">قیمت واحد</th>
                                                    <th class="pe-5 text-start">جمع ردیف (ریال)</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($paymentRequest->purchaseRequest->items as $item)
                                                    <tr class="text-end hover-lift">
                                                        <td class="ps-5 py-4">
                                                            <div class="fw-black text-dark fs-6">{{ $item->item->name ?? 'خدمات' }}</div>
                                                            <div class="small text-muted fw-bold opacity-60 mt-1">{{ Str::limit($item->description, 70) }}</div>
                                                            @if($item->item_code)
                                                                <div class="mt-2">
                                                                    <span class="badge bg-light text-dark rounded-pill px-2 py-1 fs-xs">
                                                                        کد: {{ $item->item_code }}
                                                                    </span>
                                                                </div>
                                                            @endif
                                                        </td>
                                                        <td class="text-center">
                                                            <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill px-3 py-2 fw-black">
                                                                {{ number_format($item->quantity) }}
                                                            </span>
                                                        </td>
                                                        <td class="text-center">
                                                            <span class="fw-bold text-dark">{{ number_format($item->unit_price) }}</span>
                                                        </td>
                                                        <td class="pe-5 text-start">
                                                            <div class="fw-black text-primary fs-5">{{ number_format($item->total_price) }}</div>
                                                            <div class="progress-modern mt-2"
                                                                 style="--progress: {{ ($item->total_price / $this->financialMetrics['gross_amount']) * 100 }}%;
                                                                        height: 4px;"></div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                                <tfoot class="bg-light">
                                                <tr>
                                                    <td colspan="3" class="text-end fw-black ps-5 py-4">جمع کل:</td>
                                                    <td class="text-start fw-black text-primary fs-5 pe-5">
                                                        {{ number_format($paymentRequest->purchaseRequest->items->sum('total_price')) }}
                                                    </td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="col-lg-4">
                    <!-- کارت پروژه -->
                    <div class="lux-card p-4 mb-4 reveal-up" style="animation-delay: 0.3s;">
                        <div class="p-5 rounded-4 text-center shadow-lg position-relative overflow-hidden mb-4"
                             style="background: linear-gradient(135deg, var(--p-dark), var(--p-dark-light));">
                            <div class="position-relative z-index-2">
                                <div class="mb-3">
                                    <i class="ti ti-folders text-white opacity-50 fs-1"></i>
                                </div>
                                <h5 class="fw-black m-0 mb-1 text-white">{{ $paymentRequest->project->name ?? 'مرکز هزینه عمومی' }}</h5>
                                <div class="small opacity-50 fw-bold text-white-50 mt-2">
                                    کد پروژه: <span class="font-monospace">{{ $paymentRequest->project->code ?? 'N/A' }}</span>
                                </div>
                            </div>
                            <i class="ti ti-binary position-absolute opacity-5" style="font-size: 8rem; left: -20px; bottom: -30px;"></i>
                        </div>

                        <div class="mb-4">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="data-label">مصرف بودجه پروژه</span>
                                <span class="fw-black text-primary">{{ $this->financialMetrics['usage_percent'] }}%</span>
                            </div>
                            <div class="progress-modern" style="--progress: {{ $this->financialMetrics['usage_percent'] }}%;"></div>
                        </div>

                        <div class="row g-3">
                            <div class="col-6">
                                <div class="p-3 bg-light rounded-4 text-center">
                                    <span class="data-label d-block mb-1">بودجه کل</span>
                                    <div class="fw-black text-dark">{{ number_format($paymentRequest->project->budget ?? 0) }}</div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="p-3 bg-light rounded-4 text-center">
                                    <span class="data-label d-block mb-1">مصرف شده</span>
                                    <div class="fw-black text-emerald">{{ number_format($this->financialMetrics['used_budget'] ?? 0) }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Timeline تاییدها -->
                    <div class="lux-card p-4 reveal-up" style="animation-delay: 0.4s;">
                        <h6 class="fw-black mb-5 d-flex align-items-center gap-3">
                            <div class="p-2 rounded-3"
                                 style="background: linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(99, 102, 241, 0.05));">
                                <i class="ti ti-history text-primary"></i>
                            </div>
                            <span class="text-dark">Audit Trail / چرخه تایید</span>
                        </h6>
                        <div class="workflow-trail">
                            @foreach($paymentRequest->approvals->sortBy('priority') as $approval)
                                <div class="wf-item {{ $approval->is_approved === 1 ? 'approved' : ($approval->is_approved === 0 ? 'rejected' : 'pending') }}">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <div class="d-flex align-items-center gap-2">
                                            <div class="p-2 rounded-3 bg-light">
                                                <i class="ti ti-user-circle text-dark"></i>
                                            </div>
                                            <div>
                                                <div class="fw-black small text-dark">{{ $approval->user->name ?? 'نامشخص' }}</div>
                                                <div class="text-muted fw-bold" style="font-size: 10px;">
                                                    {{ strtoupper($approval->role->name ?? 'ADMIN') }}
                                                </div>
                                            </div>
                                        </div>
                                        @if($approval->is_approved !== null)
                                            <span class="badge {{ $approval->is_approved ? 'bg-success' : 'bg-danger' }} bg-opacity-10 text-{{ $approval->is_approved ? 'success' : 'danger' }} rounded-pill px-3 py-1 d-flex align-items-center gap-1">
                                                <i class="ti ti-{{ $approval->is_approved ? 'check' : 'x' }} fs-4"></i>
                                                {{ \Morilog\Jalali\Jalalian::fromCarbon($approval->updated_at)->format('H:i') }}
                                            </span>
                                        @endif
                                    </div>
                                    @if($approval->comment)
                                        <div class="mt-3 p-3 rounded-3 fs-xs text-dark opacity-75 border-end border-3 border-dark bg-light">
                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                            « {{ $approval->comment }} »
                                        </div>
                                    @endif
                                    <div class="mt-2 text-muted fs-xs">
                                        <i class="ti ti-clock me-1"></i>
                                        {{ \Morilog\Jalali\Jalalian::fromCarbon($approval->created_at)->format('Y/m/d') }}
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- فایل‌های ضمیمه -->
                    @if($paymentRequest->attachments->isNotEmpty())
                        <div class="lux-card p-4 mt-4 reveal-up" style="animation-delay: 0.5s;">
                            <h6 class="fw-black mb-4 d-flex align-items-center gap-3">
                                <div class="p-2 rounded-3"
                                     style="background: linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(99, 102, 241, 0.05));">
                                    <i class="ti ti-paperclip text-primary fs-4"></i>
                                </div>
                                <span class="text-dark">مستندات و ضمائم دیجیتال</span>
                            </h6>
                            <div class="d-grid gap-3">
                                @foreach($paymentRequest->attachments as $file)
                                    <a href="{{ Storage::url($file->file_path) }}" target="_blank"
                                       class="p-3 border rounded-4 text-decoration-none d-flex align-items-center gap-3 bg-white hover-lift transition-all shadow-sm">
                                        <div class="p-2 rounded-3 flex-shrink-0"
                                             style="background: linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(99, 102, 241, 0.05));">
                                            <i class="ti ti-file-text text-primary fs-4"></i>
                                        </div>
                                        <div class="overflow-hidden flex-grow-1">
                                            <div class="small fw-black text-dark text-truncate">{{ $file->original_name }}</div>
                                            <div class="d-flex justify-content-between align-items-center mt-1">
                                                <span class="text-muted fw-bold" style="font-size: 10px;">
                                                    {{ strtoupper(pathinfo($file->original_name, PATHINFO_EXTENSION)) }}
                                                </span>
                                                <span class="text-muted fw-bold" style="font-size: 10px;">
                                                    SIZE: {{ number_format($file->file_size / 1024, 1) }} KB
                                                </span>
                                            </div>
                                        </div>
                                        <i class="ti ti-download text-muted flex-shrink-0"></i>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Footer ثابت -->
    <div class="fixed-bottom p-4 no-print reveal-up" style="animation-delay: 0.6s;">
        <div class="container d-flex justify-content-center">
            <div class="p-3 px-5 rounded-4 d-flex align-items-center gap-5 shadow-2xl"
                 style="backdrop-filter: blur(20px);
                        background: rgba(15, 23, 42, 0.85);
                        border: 1px solid rgba(255, 255, 255, 0.1);
                        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);">
                <div class="d-flex align-items-center gap-3">
                    <div class="p-1 rounded-3 bg-emerald bg-opacity-20">
                        <div class="p-1 bg-emerald rounded-circle" style="width: 10px; height: 10px;"></div>
                    </div>
                    <div class="small fw-black text-white">REF-ID: {{ $paymentRequest->id }}</div>
                </div>
                <div class="small fw-bold text-white-50">ISSUED AT: {{ \Morilog\Jalali\Jalalian::now()->format('Y/m/d H:i') }}</div>
                <div class="d-flex align-items-center gap-2">
                    <i class="ti ti-shield-check text-emerald"></i>
                    <span class="small fw-bold text-white-50">امنیت سطح A+</span>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // انیمیشن‌های اضافی
    document.addEventListener('DOMContentLoaded', function() {
        // انیمیشن اسکرول برای timeline
        const timelineItems = document.querySelectorAll('.wf-item');
        timelineItems.forEach((item, index) => {
            item.style.animationDelay = `${index * 0.1}s`;
        });

        // انیمیشن برای کارت‌ها
        const cards = document.querySelectorAll('.lux-card');
        cards.forEach((card, index) => {
            card.style.animationDelay = `${index * 0.1}s`;
        });

        // افکت hover برای tree nodes
        const treeNodes = document.querySelectorAll('.tree-node');
        treeNodes.forEach(node => {
            node.addEventListener('mouseenter', function() {
                this.style.transform = 'scale(1.02)';
            });
            node.addEventListener('mouseleave', function() {
                this.style.transform = 'scale(1)';
            });
        });

        // نمایش پیشرفت انیمیشن‌ها
        const progressBars = document.querySelectorAll('.progress-modern');
        progressBars.forEach(bar => {
            const width = bar.style.getPropertyValue('--progress');
            bar.style.setProperty('--progress-animated', width);
        });
    });
</script>
