<div class="container py-4">
    <!-- اعلان موفقیت -->
    @if(session()->has('success'))
        <div class="alert alert-success alert-dismissible fade show rounded-3 shadow-sm mb-4" role="alert">
            <i class="ti ti-check me-2"></i>
            <span class="fw-semibold">{{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- --------------------------------------------------- -->
    <!--  فرم ثبت / ویرایش مجوز -->
    <!-- --------------------------------------------------- -->
    <div class="card shadow-lg border-0 rounded-4 mb-5 card-hover-effect">
        <div class="card-header bg-deep-blue text-white rounded-top-4 py-3">
            <h4 class="fw-bold mb-0">
                <i class="ti ti-shield-lock me-2"></i> {{ $isEditMode ? 'ویرایش مجوز: ' . ($label ?? '---') : 'ثبت مجوز جدید' }}
            </h4>
        </div>
        <div class="card-body p-4">
            <form wire:submit.prevent="{{ $isEditMode ? 'updatePermission' : 'SavePermission' }}">
                <div class="row g-4 align-items-center">

                    <!-- نام فنی (Name) -->
                    <div class="col-md-4">
                        <label for="name" class="form-label fw-medium">نام فنی (Code)</label>
                        <input
                            type="text"
                            class="form-control form-control-lg rounded-pill @error('name') is-invalid @enderror"
                            wire:model.live.debounce.300ms="name"
                            id="name"
                            placeholder="مثال: manage_users"
                            {{ $isEditMode ? 'disabled' : '' }}
                        >
                        @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        @if($isEditMode) <div class="form-text">نام فنی پس از ثبت، قابل ویرایش نیست.</div> @endif
                    </div>

                    <!-- نام نمایشی (Label) -->
                    <div class="col-md-4">
                        <label for="label" class="form-label fw-medium">نام نمایشی (فارسی)</label>
                        <input
                            type="text"
                            class="form-control form-control-lg rounded-pill @error('label') is-invalid @enderror"
                            wire:model.defer="label"
                            id="label"
                            placeholder="مثال: مدیریت کامل کاربران"
                        >
                        @error('label') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <!-- گروه (Group) -->
                    <div class="col-md-4">
                        <label for="group" class="form-label fw-medium">گروه (ماژول)</label>
                        <input
                            type="text"
                            class="form-control form-control-lg rounded-pill @error('group') is-invalid @enderror"
                            wire:model.defer="group"
                            id="group"
                            placeholder="مثال: projects یا finance"
                        >
                        @error('group') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>


                    <div class="col-12 pt-3 d-flex justify-content-end gap-2">
                        @if($isEditMode)
                            <button type="button" wire:click="resetInput" class="btn btn-outline-secondary font-medium rounded-pill px-4">
                                <i class="ti ti-x me-2 fs-4"></i> انصراف
                            </button>
                        @endif
                        <button type="submit" class="btn btn-action-primary font-medium rounded-pill px-4">
                            <div class="d-flex align-items-center">
                                <i class="ti ti-{{ $isEditMode ? 'refresh' : 'send' }} me-2 fs-4"></i>
                                {{ $isEditMode ? 'بروزرسانی مجوز' : 'ثبت مجوز' }}
                            </div>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- --------------------------------------------------- -->
    <!--  جدول لیست مجوزها -->
    <!-- --------------------------------------------------- -->
    <div class="card shadow-lg rounded-4 overflow-hidden">
        <div class="card-header bg-light border-bottom py-3">
            <h5 class="fw-semibold mb-0 text-primary-dark">
                <i class="ti ti-list-check me-2"></i> لیست مجوزهای ثبت شده
            </h5>
        </div>
        <div class="table-responsive">
            <!-- استفاده از گروه بندی مجوزها -->
            @forelse($permissions->groupBy('group') as $groupName => $groupPermissions)
                <table class="table table-striped table-hover align-middle mb-0">
                    <thead class="bg-secondary-light text-primary-dark border-bottom-0">
                    <tr>
                        <th colspan="4" class="fw-bold py-3 px-4 border-bottom-0" style="background-color: #f0f4f9;">
                            <i class="ti ti-tag me-2"></i> گروه: {{ $groupName }}
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($groupPermissions as $permission)
                        <tr class="table-row-hover">
                            <td class="px-4 fw-medium text-primary-dark" style="width: 35%;">
                                <span class="badge bg-action-primary me-2">{{ $permission->group }}</span>
                                {{ $permission->label }}
                            </td>
                            <td class="text-muted small d-none d-md-table-cell" style="width: 35%;"><code>{{ $permission->name }}</code></td>
                            <!-- FIX: نمایش تاریخ شمسی با استایل مدرن -->
                            <td class="text-center fw-medium text-muted" style="width: 15%;">{{ Morilog\Jalali\Jalalian::fromDateTime($permission->created_at)->format('Y/m/d') }}</td>
                            <td class="text-end text-nowrap px-4" style="width: 15%;">
                                <button wire:click="editPermission({{ $permission->id }})" class="btn btn-sm btn-outline-secondary rounded-pill px-3" title="ویرایش">
                                    <i class="ti ti-edit fs-5"></i>
                                </button>
                                <button wire:click="deletePermission({{ $permission->id }})"
                                        wire:confirm="آیا مطمئن هستید مجوز {{ $permission->label }} حذف شود؟"
                                        class="btn btn-sm btn-outline-danger rounded-pill px-3" title="حذف">
                                    <i class="ti ti-trash fs-5"></i>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            @empty
                <div class="alert alert-info rounded-3 m-4 fw-medium text-center">
                    <i class="ti ti-info-circle me-2"></i> هیچ مجوزی برای نمایش ثبت نشده است.
                </div>
            @endforelse
        </div>


    </div>
    <script>
        // FIX: این اسکریپت تنها برای حذف دستی backdrop از modal است
        window.addEventListener('hide-modal', (event) => {
            document.body.classList.remove('modal-open');
            document.querySelectorAll('.modal-backdrop').forEach(el => el.remove());
        });
    </script>

    <style>
        :root {
            --primary-dark: #1A2538;
            --action-color: #4361EE;
        }
        .bg-deep-blue { background-color: var(--primary-dark) !important; }
        .text-primary-dark { color: var(--primary-dark) !important; }
        .bg-action-primary { background-color: var(--action-color) !important; }
        .btn-action-primary:hover { background-color: #3A4FCD !important; }

        .card-hover-effect:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }
        .table-row-hover:hover { background-color: #f0f4ff; }
        .rounded-pill { border-radius: 50rem !important; }
        .form-control, .form-select { border-radius: .8rem; }
        .bg-secondary-light { background-color: #f0f4f9 !important; }

        .form-control-lg, .form-select-lg {
            font-size: 1rem;
            height: calc(3rem + 2px); /* هماهنگی ارتفاع Input Group */
            padding: 0.5rem 1.5rem;
        }

    </style>
</div>
