<div>
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-xl-9">
                <div class="card border-0 shadow-xl rounded-5 overflow-hidden">
                    <div class="card-header bg-primary text-white py-4 px-4 border-0">
                        <div class="d-flex align-items-center">
                            <div class="bg-white text-primary rounded-circle d-flex align-items-center justify-content-center me-3 shadow-sm" style="width: 52px; height: 52px;">
                                <i class="fas fa-wallet fa-xl"></i>
                            </div>
                            <div>
                                <h3 class="mb-1 fw-bold">ایجاد درخواست هزینه جزء</h3>
                                <p class="mb-0 opacity-90">لطفاً اطلاعات درخواست خود را با دقت وارد کنید.</p>
                            </div>
                        </div>
                    </div>

                    <div class="card-body p-5">
                        <form wire:submit.prevent="save">

                            <div class="mb-4">
                                <label class="form-label fw-bold text-dark">دلیل درخواست <span class="text-danger">*</span></label>
                                <div class="input-group input-group-lg shadow-sm rounded-pill overflow-hidden">
                                <span class="input-group-text bg-light border-0">
                                    <i class="fas fa-sticky-note text-primary"></i>
                                </span>
                                    <input type="text"
                                           wire:model="reason"
                                           class="form-control border-0 @error('reason') is-invalid @enderror"
                                           placeholder="مثال: خرید لوازم اداری، سفر کاری، و...">
                                </div>
                                @error('reason') <div class="text-danger mt-2 small fw-semibold">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-4">
                                <label class="form-label fw-bold text-dark">پروژه‌های مرتبط</label>
                                <select wire:model="project_ids" class="form-select form-select-lg rounded-3 shadow-sm" multiple>
                                    <option value="" disabled>انتخاب کنید...</option>
                                    @foreach($projects as $project)
                                        <option value="{{ $project->id }}">{{ $project->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="mb-4 p-4 border rounded-4 bg-light-subtle">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <label class="form-label fw-bold text-dark mb-0 h5">
                                        <i class="fas fa-list-ul me-2 text-primary"></i> اقلام درخواستی <span class="text-danger">*</span>
                                    </label>
                                    <button type="button" wire:click="addDetail" class="btn btn-primary btn-sm px-4 rounded-pill shadow-sm hover-scale">
                                        <i class="fas fa-plus me-1"></i> افزودن آیتم
                                    </button>
                                </div>

                                @if(empty($details))
                                    <div class="text-center py-5 bg-white rounded-4 border-dashed border-2 border-primary border-opacity-50 shadow-sm">
                                        <i class="fas fa-box-open fa-2x text-primary mb-3"></i>
                                        <p class="text-muted mb-0">برای شروع، یک آیتم اضافه کنید.</p>
                                    </div>
                                @else
                                    <div class="table-responsive shadow-sm rounded-3">
                                        <table class="table table-striped align-middle mb-0">
                                            <thead class="table-dark">
                                            <tr>
                                                <th style="width: 40%;">نام آیتم</th>
                                                <th style="width: 15%;" class="text-center">تعداد</th>
                                                <th style="width: 25%;" class="text-end">قیمت واحد (تومان)</th>
                                                <th style="width: 15%;" class="text-center">جمع</th>
                                                <th style="width: 5%;" class="text-end"></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($details as $index => $detail)
                                                <tr>
                                                    <td>
                                                        <input type="text"
                                                               wire:model.blur="details.{{ $index }}.item"
                                                               class="form-control form-control-sm @error("details.{$index}.item") is-invalid @enderror"
                                                               placeholder="نام کالا یا خدمت">
                                                        @error("details.{$index}.item") <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                                    </td>
                                                    <td>
                                                        <input type="number"
                                                               wire:model.live.debounce.300ms="details.{{ $index }}.qty"
                                                               class="form-control form-control-sm text-center @error("details.{$index}.qty") is-invalid @enderror"
                                                               min="1" step="1">
                                                    </td>
                                                    <td>
                                                        <input type="text"
                                                               wire:model.live.debounce.300ms="details.{{ $index }}.price"
                                                               class="form-control form-control-sm text-end @error("details.{$index}.price") is-invalid @enderror"
                                                               placeholder="0"
                                                               x-data="{ price: '{{ number_format($detail['price'] ?? 0) }}' }"
                                                               x-model="price"
                                                               x-on:focus="price = price.replace(/,/g, '')"
                                                               x-on:blur="price = new Intl.NumberFormat('en-US').format(price)">
                                                    </td>
                                                    <td class="text-center fw-bold text-success small">
                                                        {{ number_format(($detail['qty'] ?? 0) * ($detail['price'] ?? 0)) }}
                                                    </td>
                                                    <td class="text-end">
                                                        <button type="button"
                                                                wire:click="removeDetail({{ $index }})"
                                                                class="btn btn-sm btn-outline-danger rounded-circle p-1"
                                                                title="حذف آیتم">
                                                            <i class="fas fa-times fa-sm"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @endif
                                @error('details') <div class="text-danger mt-2 small fw-semibold">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-4">
                                <label class="form-label fw-bold text-dark">مبلغ کل (تومان) <span class="text-danger">*</span></label>
                                <div class="input-group input-group-lg shadow-sm rounded-pill overflow-hidden">
                                <span class="input-group-text bg-light border-0">
                                    <i class="fas fa-coins text-primary"></i>
                                </span>
                                    <input type="text"
                                           wire:model="amount"
                                           class="form-control border-0 text-end fw-bold bg-white @error('amount') is-invalid @enderror"
                                           placeholder="0"
                                           readonly
                                           value="{{ number_format($amount) }}">
                                </div>
                                @error('amount') <div class="text-danger mt-2 small fw-semibold">{{ $message }}</div> @enderror
                            </div>

                            <div class="d-flex gap-3 pt-3">
                                <a href="{{ route('admin.petty-cash.index') }}" class="btn btn-outline-secondary px-4 py-2 rounded-pill hover-scale">
                                    <i class="fas fa-arrow-right me-2"></i> بازگشت
                                </a>
                                <button type="submit" class="btn btn-primary btn-lg px-5 py-2 ms-auto d-flex align-items-center rounded-pill shadow-lg hover-scale">
                                    <i class="fas fa-paper-plane me-2"></i> ثبت درخواست
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @script
    <script>
        // نام کلید Local Storage
        const DRAFT_KEY = 'petty_cash_draft_{{ auth()->id() }}';

        // 1. بارگذاری پیش‌نویس
        $wire.on('loadDraft', () => {
            const draft = localStorage.getItem(DRAFT_KEY);
            if (draft) {
                const data = JSON.parse(draft);
                // ارسال داده به Livewire
                $wire.set('reason', data.reason || '');
                $wire.set('project_ids', data.project_ids || []);
                $wire.set('details', data.details || [{ item: '', qty: 1, price: 0 }]);

                // نمایش alert
                alert('پیش‌نویس قبلی با موفقیت بازیابی شد.');
                // نیازی به set کردن amount نیست چون با updatedDetails محاسبه می‌شود
                $wire.call('recalculateAmount');
            }
        });

        // 2. ذخیره پیش‌نویس
        $wire.on('saveDraft', (data) => {
            localStorage.setItem(DRAFT_KEY, JSON.stringify(data[0]));
        });

        // 3. پاک کردن پیش‌نویس
        $wire.on('clearDraft', () => {
            localStorage.removeItem(DRAFT_KEY);
        });

        // 4. ذخیره خودکار هنگام خروج یا بستن صفحه
        window.addEventListener('beforeunload', () => {
            $wire.call('saveDraft');
        });
    </script>
    @endscript

    <style>
        .bg-light-subtle {
            background-color: #f7f9fa !important;
        }
        .border-dashed {
            border-style: dashed !important;
        }
        /* افکت‌های Hover */
        .hover-scale {
            transition: transform 0.2s ease-in-out;
        }
        .hover-scale:hover {
            transform: scale(1.03);
        }
        /* کلاس برای تمیز کردن Input numbers در آیتم‌ها (اختیاری) */
        /* [x-data] برای تمیز کردن قیمت واحد استفاده شده است. */
    </style>

</div>
