<div class="container-fluid py-4 modern-approval-rules">

    @if(session()->has('alert'))
        @php $alert = session('alert'); @endphp
        <div class="alert alert-{{ $alert['type'] }} alert-dismissible fade show rounded-3 shadow-sm mb-4 d-flex align-items-center">
            <i class="ti ti-{{ $alert['type'] == 'success' ? 'check-circle' : 'alert-triangle' }} me-2 fs-5"></i>
            <span class="fw-semibold">{{ $alert['message'] }}</span>
            <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="بستن"></button>
        </div>
    @endif

    {{-- 🛑 هدر اصلی و دکمه افزودن --}}
    <div class="d-flex justify-content-between align-items-center mb-4 pb-2 border-bottom">
        <h4 class="fw-bold text-dark-primary h3">
            <i class="ti ti-gavel me-2 text-action-primary"></i> قوانین تأیید هزینه‌های جزء
        </h4>
        <button wire:click="create" class="btn btn-action-primary px-4 rounded-pill shadow-md hover-grow">
            <i class="ti ti-plus me-2"></i> قانون جدید
        </button>
    </div>

    {{-- 🔍 فیلتر و جستجو --}}
    <div class="card shadow-lg-md border-0 rounded-4 p-4 mb-5 bg-white">
        <div class="row g-3 align-items-center">
            <div class="col-md-4">
                <div class="input-group input-group-lg rounded-pill overflow-hidden shadow-input">
                    <span class="input-group-text bg-white border-0"><i class="ti ti-search text-muted"></i></span>
                    <input type="text" wire:model.debounce.300ms="searchApprovers" class="form-control border-0 py-3" placeholder="جستجوی نام کاربر یا مبلغ...">
                </div>
            </div>

            {{-- 🛑 فیلتر شرکت (جدید) --}}
            <div class="col-md-3">
                <select wire:model.live="companyIdFilter" class="form-select form-select-lg rounded-pill shadow-input">
                    <option value="">همه شرکت‌ها</option>
                    @foreach($companies as $company)
                        <option value="{{ $company->id }}">{{ $company->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-3">
                <select wire:model.live="roleFilter" class="form-select form-select-lg rounded-pill shadow-input">
                    @foreach($roles as $key => $label)
                        <option value="{{ $key }}">{{ Str::title($label) }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2 text-md-end d-flex align-items-center justify-content-end gap-2">
                <p class="small text-muted mb-0 fw-semibold">نمایش {{ $rules->total() }} نتیجه</p>
            </div>
        </div>
    </div>

    {{-- 📋 جدول قوانین --}}
    <div class="card shadow-xl rounded-4 border-0 overflow-hidden">
        <div class="card-body p-0">
            @if($rules->isEmpty())
                <div class="text-center py-6 text-muted">
                    <i class="ti ti-ruler-off fs-1 mb-3 text-action-primary opacity-50"></i>
                    <h5 class="fw-semibold text-dark-primary">قانونی تعریف نشده است.</h5>
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle table-striped">
                        <thead class="bg-primary-dark-table text-white">
                        <tr>
                            <th class="py-3 px-4" style="width: 20%;">محدوده مبلغ (تومان)</th>
                            <th class="py-3" style="width: 45%;">تأییدکنندگان مجاز</th>
                            <th class="py-3" style="width: 10%;">تعداد لازم</th>
                            <th class="py-3 px-4" style="width: 25%;">اقدام</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($rules as $rule)
                            <tr class="hover-row">
                                <td class="px-4 fw-medium text-dark-primary">
                                    <span class="badge bg-soft-primary text-action-primary fw-bold">{{ number_format($rule->min_amount) }}</span>
                                    @if($rule->max_amount)
                                        <span class="text-muted small mx-1"> تا </span>
                                        <span class="badge bg-soft-secondary text-secondary fw-bold">{{ number_format($rule->max_amount) }}</span>
                                    @else
                                        <span class="badge bg-dark-primary text-white fw-bold ms-2">نامحدود</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach($rule->approver_ids as $id)
                                            @php($user = \App\Models\User::find($id))
                                            @if($user)
                                                <span class="badge badge-user-chip bg-soft-info text-info fw-normal py-1 px-3 rounded-pill shadow-sm-hover"
                                                      title="{{ $user->department->name ?? '—' }}">
                                                    {{ $user->name }}
                                                </span>
                                            @endif
                                        @endforeach
                                    </div>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-soft-success text-success fw-bold px-3 py-2 rounded-pill">
                                        {{ $rule->required_approvals }} نفر
                                    </span>
                                </td>
                                <td class="text-end px-4">
                                    <div class="btn-group btn-group-sm">
                                        <button wire:click="edit({{ $rule->id }})" class="btn btn-outline-primary rounded-circle p-2 shadow-sm hover-scale" title="ویرایش">
                                            <i class="ti ti-pencil fs-5"></i>
                                        </button>
                                        <button wire:click="delete({{ $rule->id }})" class="btn btn-outline-danger rounded-circle p-2 shadow-sm hover-scale"
                                                wire:confirm="آیا مطمئن هستید که این قانون را حذف می‌کنید؟"
                                                title="حذف">
                                            <i class="ti ti-trash fs-5"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="card-footer bg-white border-top d-flex justify-content-center py-3 px-4">
                    <div class="text-muted small">
                        نمایش {{ $rules->firstItem() }} تا {{ $rules->lastItem() }} از **{{ $rules->total() }}** نتیجه
                    </div>
                    <div>
                        {{ $rules->links() }}
                    </div>
                </div>
            @endif
        </div>
    </div>

    {{-- 🛑 Modal ایجاد/ویرایش قانون --}}
    <div wire:ignore.self class="modal fade" id="ruleModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content border-0 shadow-xl rounded-4">
                <div class="modal-header bg-primary-dark-table text-white rounded-top-4">
                    <h5 class="modal-title fw-bold">
                        <i class="ti ti-{{ $ruleId ? 'pencil' : 'plus' }} me-2"></i> {{ $ruleId ? 'ویرایش قانون' : 'ایجاد قانون جدید' }}
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form wire:submit.prevent="save">
                    <div class="modal-body p-5">

                        {{-- 🎯 بخش ۱: محدوده مبلغ --}}
                        <div class="mb-5 p-4 rounded-4 bg-light-soft border-bottom-primary">
                            <h6 class="fw-bold text-dark mb-4"><i class="ti ti-cash me-2 text-primary"></i> محدوده مبلغ</h6>
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">حداقل مبلغ (تومان) <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="text" wire:model.blur="min_amount" dir="ltr" class="form-control rounded-pill-end @error('min_amount') is-invalid @enderror" placeholder="مثال: 100000">
                                        <span class="input-group-text rounded-pill-start">تومان</span>
                                    </div>
                                    @error('min_amount') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">حداکثر مبلغ (تومان) <small class="text-muted">(اختیاری)</small></label>
                                    <div class="input-group">
                                        <input type="text" wire:model.blur="max_amount" dir="ltr" class="form-control rounded-pill-end @error('max_amount') is-invalid @enderror" placeholder="مثال: 500000">
                                        <span class="input-group-text rounded-pill-start">تومان</span>
                                    </div>
                                    @error('max_amount') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        {{-- 🎯 بخش ۲: انتخاب تأییدکنندگان --}}
                        <div class="p-4 rounded-4 bg-light-soft border-bottom-primary">
                            <h6 class="fw-bold text-dark mb-4"><i class="ti ti-users me-2 text-primary"></i> انتخاب تأییدکنندگان</h6>

                            <div class="row g-3 mb-3">
                                {{-- فیلتر شرکت --}}
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">فیلتر شرکت</label>
                                    <select wire:model.live="companyIdFilter" class="form-select rounded-pill shadow-sm">
                                        <option value="">همه شرکت‌ها</option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- فیلتر نقش --}}
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">فیلتر بر اساس نقش</label>
                                    <select wire:model.live="roleFilter" class="form-select rounded-pill shadow-sm">
                                        @foreach($roles as $key => $label)
                                            <option value="{{ $key }}">{{ Str::title($label) }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- جستجوی کاربر --}}
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">جستجوی نام کاربر</label>
                                    <div class="input-group shadow-sm rounded-pill overflow-hidden">
                                        <span class="input-group-text bg-white border-0"><i class="ti ti-search text-muted"></i></span>
                                        <input type="text"
                                               wire:model.live.debounce.300ms="searchApprovers"
                                               class="form-control border-0"
                                               placeholder="نام کاربر را جستجو کنید...">
                                    </div>
                                </div>
                            </div>

                            {{-- لیست کاربران قابل انتخاب --}}
                            <div class="border rounded-3 p-3 bg-white shadow-inner user-list-modal" style="max-height: 250px; overflow-y: auto;">
                                <div class="row g-2">
                                    @forelse($this->approvers as $user)
                                        <div class="col-sm-6">
                                            <div class="form-check border rounded-2 p-3 shadow-sm-hover bg-white hover-light-primary">
                                                <input class="form-check-input me-3" type="checkbox"
                                                       id="user_{{ $user->id }}"
                                                       wire:model="approver_ids"
                                                       value="{{ $user->id }}">
                                                <label class="form-check-label d-flex align-items-center gap-2" for="user_{{ $user->id }}">
                                                    <img src="{{ $user->image ? asset('storage/' . $user->image) : asset('assets/img/avatar.png') }}"
                                                         class="rounded-circle user-avatar-small" width="30" height="30" alt="{{ $user->name }}">
                                                    <div class="small fw-medium">
                                                        {{ $user->name }}
                                                        <span class="badge bg-soft-primary text-primary ms-1">{{ Str::title($user->role) }}</span>
                                                        @if($user->department)
                                                            <span class="d-block text-secondary-light" style="font-size:0.75em">{{ $user->department->name }}</span>
                                                        @endif
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    @empty
                                        <small class="text-muted text-center w-100 py-3">کاربری با این مشخصات یافت نشد.</small>
                                    @endforelse
                                </div>
                            </div>
                            @error('approver_ids') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        {{-- 🎯 بخش ۳: تعداد تأییدیه‌ها --}}
                        <div class="mt-5 p-4 rounded-4 bg-light-soft border-bottom-primary">
                            <label class="form-label fw-semibold text-dark">تعداد تأییدهای لازم <span class="text-danger">*</span></label>
                            <input type="number"
                                   wire:model="required_approvals"
                                   class="form-control rounded-pill @error('required_approvals') is-invalid @enderror"
                                   min="1"
                                   max="{{ count($this->approver_ids) ?: 1 }}"
                                   placeholder="حداکثر {{ count($this->approver_ids) ?: 1 }}">
                            <small class="text-muted mt-1 d-block">باید بین ۱ تا تعداد تأییدکنندگان انتخابی باشد ({{ count($this->approver_ids) }} نفر انتخاب شده).</small>
                            @error('required_approvals') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div class="modal-footer border-top p-4 d-flex justify-content-between">
                        <button type="button" class="btn btn-outline-secondary px-4 rounded-pill" data-bs-dismiss="modal">لغو</button>
                        <button type="submit" class="btn btn-action-primary px-5 rounded-pill shadow-btn-primary">
                            <i class="ti ti-device-floppy me-2"></i> {{ $ruleId ? 'به‌روزرسانی قانون' : 'ایجاد قانون' }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @script
    <script>
        $wire.on('openModal', ({ name }) => {
            if (name === 'rule-modal') {
                const modal = new bootstrap.Modal(document.getElementById('ruleModal'));
                modal.show();
            }
        });

        // 🎯 FIX: مدیریت بسته شدن Modal از JS
        document.addEventListener('DOMContentLoaded', () => {
            Livewire.on('closeModal', () => {
                const modal = bootstrap.Modal.getInstance(document.getElementById('ruleModal'));
                modal?.hide();
            });
        });

        // 🎯 تأیید حذف با استفاده از JavaScript
        $wire.on('showConfirmDelete', ({ id }) => {
            if (confirm('آیا مطمئن هستید که می‌خواهید این قانون را حذف کنید؟ این عمل غیرقابل بازگشت است.')) {
                $wire.dispatch('confirmedDelete');
            }
        });
    </script>
    @endscript

    <style>
        /* --- General Variables --- */
        :root {
            --action-color: #4361EE;
            --action-dark-hover: #3A4FCD;
            --primary-dark-table: #1A2538; /* Deep Navy for headers */
            --bg-light-soft: #F9FAFB; /* Light warm background for sections */
            --success-color: #10B981;
            --danger-color: #EF4444;
            --info-color: #3498DB;
            --border-color: #E5E7EB;
            --primary-light: #EEF4FF; /* Soft background */
            --dark-primary: #1F2937;
            --secondary-light: #6B7280;
            --warning-color: #F59E0B;
        }

        /* --- Base Aesthetics --- */
        .text-dark-primary { color: var(--dark-primary) !important; }
        .text-action-primary { color: var(--action-color) !important; }
        .fw-bold { font-weight: 700; }
        .card { border-radius: 1rem; }
        .shadow-xl { box-shadow: 0 10px 25px rgba(0,0,0,0.15); }
        .hover-grow:hover { transform: translateY(-2px) scale(1.02); }

        /* --- Header & Table --- */
        .bg-primary-dark-table { background-color: var(--primary-dark-table) !important; color: white !important; }
        .btn-action-primary { background-color: var(--action-color); border-color: var(--action-color); color: white; }
        .btn-action-primary:hover { background-color: var(--action-dark-hover); }
        .shadow-btn-primary { box-shadow: 0 4px 12px rgba(67, 97, 238, 0.3); }

        /* --- Input Customization --- */
        .form-control, .form-select { border-color: var(--border-color); }
        .form-control:focus { box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15); }
        .rounded-pill-end { border-radius: 0 50rem 50rem 0 !important; }
        .rounded-pill-start { border-radius: 50rem 0 0 50rem !important; }
        .input-group-text { background-color: #F8FAFC; }

        /* --- Sections in Modal --- */
        .border-bottom-primary { border-bottom: 3px solid var(--primary-light) !important; }
        .bg-light-soft { background-color: var(--bg-light-soft); }

        /* --- User List (Checkbox Design) --- */
        .form-check { border: 1px solid var(--border-color); border-radius: 0.75rem; }
        .form-check-input:checked { background-color: var(--action-color); }
        .hover-light-primary:hover { background-color: var(--primary-light) !important; }
        .user-avatar-small { object-fit: cover; border-radius: 50%; }

        /* Badges */
        .bg-soft-primary { background-color: var(--primary-light) !important; color: var(--action-color) !important; }
        .bg-soft-secondary { background-color: var(--gray-light) !important; color: var(--secondary-light) !important; }
        .bg-soft-success { background-color: #EBF9F3 !important; color: var(--success-color) !important; }
        .badge-user-chip { padding: 0.35rem 0.65rem; }

        /* Table Styles */
        .table-striped > tbody > tr:nth-of-type(odd) > * { background-color: var(--bg-light-soft); }
        .hover-row:hover { background-color: #F8FAFA !important; }

        /* Action Buttons */
        .btn-outline-primary { color: var(--action-color); border-color: var(--action-color); }
        .btn-outline-danger { color: var(--danger-color); border-color: var(--danger-color); }
    </style>
</div>
