<div class="container-fluid py-4">

    {{-- ✅ نمایش اطلاعات پروژه در بالای صفحه --}}
    @if($projectId)
        @php
            $project = \App\Models\Project::withTrashed()->find($projectId);
        @endphp
        <div class="alert alert-primary border-0 rounded-3 mb-4 d-flex align-items-center shadow-sm bg-gradient" style="background: linear-gradient(90deg, #e6f7ff 0%, #f0f9ff 100%);">
            <i class="fas fa-project-diagram fa-lg text-primary me-3"></i>
            <div class="flex-grow-1">
                <strong class="text-dark">درخواست‌های تنخواه پروژه:</strong>
                <span class="mx-2 px-3 py-1 bg-white text-primary rounded fw-bold shadow-sm">
                    {{ $project?->name ?? 'پروژه حذف‌شده یا ناموجود (#' . $projectId . ')' }}
                </span>
                <a href="{{ $project ? route('single.project.dashboard', $projectId) : '#' }}"
                   class="btn btn-sm btn-outline-primary rounded-pill ms-2 shadow-sm hover-lift"
                   @if(!$project) disabled @endif
                   wire:navigate>
                    <i class="fas fa-folder-open me-1"></i> مشاهده پروژه
                </a>
            </div>
            <button type="button" class="btn-close" wire:click="$set('projectId', null)" title="پاک کردن فیلتر پروژه"></button>
        </div>
    @endif

    {{-- ✅ بقیه محتوا دقیقاً مانند list-requests — فقط با به‌روزرسانی نام متغیرها --}}
    <div class="row g-4 mb-5 justify-content-center">

        @php
            $statsConfig = [
                'pending'  => ['icon' => 'fas fa-clock',          'color' => 'warning', 'label' => 'در انتظار',     'bg' => 'bg-warning-light'],
                'approved' => ['icon' => 'fas fa-check-circle',   'color' => 'primary', 'label' => 'تأیید شده',    'bg' => 'bg-primary-light'],
                'rejected' => ['icon' => 'fas fa-times-circle',   'color' => 'danger',  'label' => 'رد شده',       'bg' => 'bg-danger-light'],
                'paid'     => ['icon' => 'fas fa-money-bill-wave','color' => 'success', 'label' => 'پرداخت شده',  'bg' => 'bg-success-light'],
                'total'    => ['icon' => 'fas fa-file-invoice',   'color' => 'info',    'label' => 'کل درخواست‌ها','bg' => 'bg-info-light'],
            ];
            $statKeys = ['pending', 'approved', 'rejected', 'paid', 'total'];
        @endphp

        @foreach($statKeys as $key)
            <div class="col-6 col-md-4 col-lg-2 {{ $loop->last ? 'col-xl-2' : 'col-xl-2-4' }}">
                <div class="card border-0 shadow-lg rounded-4 h-100 p-3 hover-lift {{ $statsConfig[$key]['bg'] }}">
                    <div class="card-body p-2 d-flex flex-column justify-content-between">
                        <div class="d-flex justify-content-between align-items-center">
                            <h6 class="mb-1 text-muted fw-bold small text-uppercase">{{ $statsConfig[$key]['label'] }}</h6>
                            <div class="text-{{ $statsConfig[$key]['color'] }} opacity-50 icon-pulse" style="font-size: 2.2rem;">
                                <i class="{{ $statsConfig[$key]['icon'] }}"></i>
                            </div>
                        </div>
                        <h2 class="mb-0 fw-bolder text-dark display-6 mt-3">{{ $stats[$key] ?? 0 }}</h2>
                    </div>
                    <div class="position-absolute bottom-0 start-0 w-100 bg-{{ $statsConfig[$key]['color'] }} opacity-25 rounded-bottom-4" style="height: 5px;"></div>
                </div>
            </div>
        @endforeach
    </div>

    <hr class="text-primary opacity-50 mb-4">

    <div class="d-flex flex-wrap justify-content-between align-items-center mb-5">
        <div>
            <h2 class="h3 fw-bolder text-dark mb-1">
                <i class="fas fa-hand-holding-usd text-success me-2"></i>
                مدیریت هزینه‌های جزء (پروژه‌محور)
            </h2>
            <p class="text-muted mb-0 small">فقط درخواست‌های مرتبط با پروژه انتخاب‌شده</p>
        </div>
        <div class="d-flex gap-3 mt-3 mt-sm-0">
            @if($projectId)
                <a href="{{ route('admin.petty-cash.create', ['project_id' => $projectId]) }}"
                   class="btn btn-success px-4 rounded-pill shadow-lg hover-lift">
                    <i class="fas fa-plus me-2"></i>درخواست جدید
                </a>
            @else
                <a href="{{ route('admin.petty-cash.create') }}"
                   class="btn btn-outline-success px-4 rounded-pill shadow-lg hover-lift">
                    <i class="fas fa-plus me-2"></i>درخواست جدید
                </a>
            @endif
            <a href="{{ route('admin.petty-cash.rules') }}" class="btn btn-outline-info px-4 rounded-pill hover-lift">
                <i class="fas fa-gavel me-2"></i>قوانین تأیید
            </a>
        </div>
    </div>

    <div class="card border-0 shadow-lg rounded-4 mb-4 filter-card">
        <div class="card-body p-4">
            <div class="row g-3 align-items-end">
                <div class="col-md-6 col-lg-4">
                    <label class="form-label fw-bold text-dark small">جستجو در درخواست‌ها</label>
                    <div class="input-group input-group-lg">
                        <span class="input-group-text bg-light border-end-0 rounded-start-pill border-0">
                            <i class="fas fa-search text-primary"></i>
                        </span>
                        <input type="text"
                               wire:model.live.debounce.300ms="search"
                               class="form-control border-start-0 rounded-end-pill shadow-none"
                               placeholder="دلیل، نام کاربر یا مبلغ...">
                    </div>
                </div>

                <div class="col-md-4 col-lg-3">
                    <label class="form-label fw-bold text-dark small">فیلتر بر اساس وضعیت</label>
                    <select wire:model.live="statusFilter" class="form-select form-select-lg rounded-pill shadow-none">
                        <option value="all">همه وضعیت‌ها</option>
                        <option value="pending">در انتظار ({{ $stats['pending'] ?? 0 }})</option>
                        <option value="approved">تأیید شده ({{ $stats['approved'] ?? 0 }})</option>
                        <option value="rejected">رد شده ({{ $stats['rejected'] ?? 0 }})</option>
                        <option value="paid">پرداخت شده ({{ $stats['paid'] ?? 0 }})</option>
                    </select>
                </div>

                <div class="col-md-2 col-lg-2">
                    <button wire:click="resetFilters" class="btn btn-outline-secondary px-4 rounded-pill w-100 hover-lift mt-auto" title="پاک کردن فیلترها">
                        <i class="fas fa-trash-restore-alt me-2"></i> ریست
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow-2xl rounded-4 overflow-hidden">
        <div class="card-body p-0">
            @if($requests->isEmpty())
                <div class="text-center py-5 text-muted">
                    <div class="mb-3">
                        <i class="fas fa-box-open fa-4x text-warning opacity-50"></i>
                    </div>
                    <h5 class="mb-2 fw-semibold">هیچ درخواستی برای این پروژه یافت نشد</h5>
                    <p class="mb-0 text-muted">
                        @if($projectId)
                            فیلترها را تنظیم کنید یا درخواست جدیدی برای این پروژه ثبت نمایید.
                        @else
                            لطفاً یک پروژه انتخاب کنید.
                        @endif
                    </p>
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0 align-middle">
                        <thead class="bg-primary-subtle text-dark fw-bolder">
                        <tr>
                            <th class="text-center" style="width: 5%">#</th>
                            <th style="width: 15%">درخواست‌دهنده</th>
                            <th style="width: 10%">مبلغ</th>
                            <th>دلیل</th>
                            <th class="text-center" style="width: 10%">وضعیت</th>
                            <th style="width: 30%">سیر تأییدیه‌ها</th>
                            <th class="text-center" style="width: 10%">اقدامات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($requests as $index => $req)
                            @php
                                $currentUserId = auth()->id();
                                $isApprover = $req->isApprover($currentUserId);
                                $hasFinalAction = $req->approvals
                                    ->where('user_id', $currentUserId)
                                    ->whereIn('status', [\App\Models\PettyCashApproval::STATUS_APPROVED, \App\Models\PettyCashApproval::STATUS_REJECTED])
                                    ->isNotEmpty();

                                $isNearBottom = ($requests->count() - $loop->iteration) < 3;
                                $dropdownClass = $isNearBottom ? 'dropup' : 'dropstart';
                            @endphp

                            <tr class="hover-row">
                                <td class="text-center text-muted fw-medium">{{ $requests->firstItem() + $index }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <img src="{{ $this->getUserProfilePhotoUrl($req->user) }}"
                                             class="rounded-circle me-3 border border-2 border-primary shadow-sm"
                                             width="36" height="36" alt="{{ $req->user->name }}">
                                        <span class="fw-bold text-dark">{{ Str::limit($req->user->name, 15) }}</span>
                                    </div>
                                </td>
                                <td class="fw-bolder text-success" dir="ltr">{{ number_format($req->amount) }} <span class="small text-muted">تومان</span></td>
                                <td>
                                    <button wire:click="viewDetails({{ $req->id }})"
                                            class="btn btn-sm btn-link p-0 text-decoration-none text-dark fw-medium text-start text-truncate"
                                            title="مشاهده جزئیات کامل: {{ $req->reason }}" style="max-width: 180px;">
                                        {{ Str::limit($req->reason, 40) }}
                                    </button>
                                </td>
                                <td class="text-center">
                                        <span class="badge bg-{{ $req->statusColor() }} rounded-pill px-3 py-2 fw-bold shadow-sm status-badge">
                                            {{ $req->statusLabel() }}
                                        </span>
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap gap-1 align-items-center">
                                        @forelse($req->approvals->take(3) as $ap)
                                            <span class="d-flex align-items-center bg-white border border-{{ $ap->statusColor() }} rounded-pill px-2 py-1 small text-dark shadow-sm-hover approver-pill"
                                                  data-bs-toggle="tooltip" title="{{ $ap->approver->name . ' - ' . $ap->statusLabel() . ($ap->comments ? ' (با نظر)' : '') }}">
                                                    <i class="fas fa-{{ $ap->status === \App\Models\PettyCashApproval::STATUS_APPROVED ? 'check text-success' : 'times text-danger' }} me-1" style="font-size: 10px;"></i>
                                                    <span class="text-truncate fw-medium" style="max-width: 60px;">{{ Str::limit($ap->approver->name, 7) }}</span>
                                                </span>
                                        @empty
                                            <span class="badge bg-light text-muted fw-normal border">در انتظار اقدام...</span>
                                        @endforelse

                                        @if($req->approvals->count() > 3)
                                            <span class="badge bg-secondary rounded-pill px-2 py-1 small">+{{ $req->approvals->count() - 3 }}</span>
                                        @endif
                                    </div>
                                    <small class="text-muted d-block mt-1 fw-bold">
                                        <i class="fas fa-chart-bar me-1 text-primary"></i>
                                        **{{ $req->approved_count }}** / {{ $req->getRequiredApprovalsCount() }} تأیید لازم
                                    </small>
                                </td>
                                <td class="text-center">
                                    <div class="dropdown {{ $dropdownClass }}">
                                        <button class="btn btn-sm btn-outline-secondary rounded-circle p-2 hover-lift" type="button" data-bs-toggle="dropdown" aria-expanded="false" title="اقدامات">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <ul class="dropdown-menu text-end shadow-lg border-0 rounded-4" style="min-width: 180px;">
                                            <li><button wire:click="viewDetails({{ $req->id }})" class="dropdown-item rounded fw-medium"><i class="fas fa-eye me-2 text-info"></i>مشاهده جزئیات</button></li>
                                            <li><a class="dropdown-item rounded" href="{{ route('petty-cash.show', $req->id) }}" wire:navigate><i class="fas fa-file-alt me-2 text-primary"></i>مشاهده کامل درخواست</a></li>

                                            @if($req->status === \App\Models\PettyCash::STATUS_APPROVED)
                                                <li><hr class="dropdown-divider"></li>
                                                <li><a class="dropdown-item text-info rounded" href="{{ route('admin.petty-cash.pdf', $req->id) }}" target="_blank"><i class="fas fa-file-pdf me-2"></i>دانلود PDF</a></li>
                                            @endif

                                            @if($req->status === \App\Models\PettyCash::STATUS_PENDING && $isApprover && !$hasFinalAction)
                                                <li><hr class="dropdown-divider"></li>
                                                <li><button wire:click="confirmAction({{ $req->id }}, 'approve')" class="dropdown-item text-success rounded fw-bold"><i class="fas fa-check-double me-2"></i>تأیید نهایی</button></li>
                                                <li><button wire:click="confirmAction({{ $req->id }}, 'reject')" class="dropdown-item text-danger rounded fw-bold"><i class="fas fa-times-circle me-2"></i>رد کردن</button></li>
                                            @endif

                                            @if($req->status === \App\Models\PettyCash::STATUS_APPROVED && $this->isCurrentUserAdmin())
                                                <li><hr class="dropdown-divider"></li>
                                                <li><button wire:click="markAsPaid({{ $req->id }})" class="dropdown-item text-warning rounded fw-bold" onclick="return confirm('آیا مطمئنید درخواست شماره {{ $req->id }} را به عنوان پرداخت شده ثبت می‌کنید؟')"><i class="fas fa-money-bill-wave me-2"></i>ثبت پرداخت شد</button></li>
                                            @endif
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="card-footer bg-light-subtle border-top d-flex flex-wrap justify-content-between align-items-center py-3 px-4 rounded-bottom-4 shadow-sm">
                    <div class="text-muted small mb-2 mb-md-0 fw-medium">
                        نمایش **{{ $requests->firstItem() }} تا {{ $requests->lastItem() }}** از **{{ $requests->total() }}** نتیجه
                    </div>
                    <div class="pagination-container">
                        {{ $requests->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            @endif
        </div>
    </div>

    {{-- Modalهای تأیید و جزئیات — کاملاً بدون تغییر --}}
    <div wire:ignore.self class="modal fade" id="approvalModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content border-0 shadow-2xl rounded-4">
                <div class="modal-header bg-{{ $action === 'approve' ? 'success' : 'danger' }} text-white rounded-top-4 p-3">
                    <h5 class="modal-title fw-bolder">
                        <i class="fas fa-{{ $action === 'approve' ? 'check-circle' : 'ban' }} me-2"></i>
                        {{ $action === 'approve' ? 'تأیید نهایی درخواست' : 'رد کامل درخواست' }}
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form wire:submit.prevent="submit">
                    <div class="modal-body p-4">
                        <p class="text-muted small mb-3">لطفاً برای ثبت اقدام خود، توضیحات لازم را (اختیاری) وارد نمایید.</p>
                        <div class="mb-3">
                            <label class="form-label fw-bold text-dark">توضیحات / علت تصمیم</label>
                            <textarea wire:model="comments" class="form-control rounded-3 shadow-sm" rows="4" placeholder="دلیل تأیید یا رد را بنویسید..."></textarea>
                            @error('comments') <div class="text-danger mt-2 small">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="modal-footer d-flex justify-content-between border-top p-3 bg-light-subtle">
                        <button type="button" class="btn btn-outline-secondary rounded-pill px-4 hover-lift" data-bs-dismiss="modal">لغو</button>
                        <button type="submit" class="btn btn-{{ $action === 'approve' ? 'success' : 'danger' }} rounded-pill px-4 fw-bold shadow-lg hover-lift">
                            <i class="fas fa-save me-2"></i> {{ $action === 'approve' ? 'ثبت تأیید' : 'ثبت رد' }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @if($detailRequest)
        <div wire:ignore.self class="modal fade" id="detailsModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content border-0 shadow-2xl rounded-4">
                    <div class="modal-header bg-primary text-white rounded-top-4 p-3">
                        <h5 class="modal-title fw-bolder">جزئیات کامل درخواست #{{ $detailRequest->id }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="row mb-4 bg-light p-4 rounded-3 border-end border-5 border-primary shadow-sm hover-lift">
                            <div class="col-md-6 border-md-end">
                                <p class="mb-2 small text-primary fw-bold">درخواست‌دهنده:</p>
                                <div class="d-flex align-items-center mb-3">
                                    <img src="{{ $this->getUserProfilePhotoUrl($detailRequest->user) }}"
                                         class="rounded-circle me-3 border border-2 border-primary" width="45" height="45" alt="{{ $detailRequest->user->name }}">
                                    <span class="fw-bolder text-dark h5 mb-0">{{ $detailRequest->user->name }}</span>
                                </div>
                                <p class="mb-0 small text-muted">
                                    تاریخ ثبت:
                                    <span class="fw-medium text-dark">
                                        {{ $detailRequest->created_at ? \Morilog\Jalali\Jalalian::fromCarbon($detailRequest->created_at)->format('Y/m/d H:i') : 'نامشخص' }}
                                    </span>
                                </p>

                                @if($detailRequest->projects->isNotEmpty())
                                    <p class="mb-0 mt-3 small text-muted">پروژه‌های مرتبط:</p>
                                    @foreach($detailRequest->projects as $projectItem)
                                        <span class="badge bg-secondary rounded-pill me-1 fw-medium">{{ $projectItem->name ?? 'پروژه نامشخص' }}</span>
                                    @endforeach
                                @endif
                            </div>

                            <div class="col-md-6 text-md-end mt-4 mt-md-0">
                                <h1 class="mb-1 text-success fw-bolder display-6" dir="ltr">{{ number_format($detailRequest->amount) }}</h1>
                                <p class="mb-3 text-muted">مبلغ کل (تومان)</p>
                                <p class="mb-1 small text-primary fw-bold">وضعیت فعلی:</p>
                                <span class="badge bg-{{ $detailRequest->statusColor() }} px-3 py-2 fw-bold rounded-pill shadow-lg status-badge-lg">
                                    {{ $detailRequest->statusLabel() }}
                                </span>
                            </div>
                        </div>

                        <h6 class="mt-4 mb-3 fw-bold text-primary border-bottom pb-2"><i class="fas fa-clipboard-list me-2"></i> دلیل درخواست</h6>
                        <p class="alert alert-info rounded-3 text-dark fw-medium p-3">{{ $detailRequest->reason }}</p>

                        @if($detailRequest->details_json)
                            <h6 class="mt-4 mb-3 fw-bold text-primary border-bottom pb-2"><i class="fas fa-boxes me-2"></i> اقلام درخواستی</h6>
                            <div class="table-responsive border rounded-3 shadow-sm">
                                <table class="table table-striped table-hover mb-0 small">
                                    <thead class="table-primary">
                                    <tr><th>آیتم</th><th>تعداد</th><th>قیمت واحد</th><th>جمع</th></tr>
                                    </thead>
                                    <tbody>
                                    @foreach($detailRequest->details_json as $item)
                                        <tr class="hover-row-sm">
                                            <td>{{ $item['item'] }}</td>
                                            <td>{{ $item['qty'] }}</td>
                                            <td dir="ltr">{{ number_format($item['price']) }} <span class="small text-muted">تومان</span></td>
                                            <td class="fw-bold" dir="ltr">{{ number_format($item['qty'] * $item['price']) }} <span class="small text-muted">تومان</span></td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @endif

                        <h6 class="mt-4 mb-3 fw-bold text-primary border-bottom pb-2"><i class="fas fa-stream me-2"></i> سیر تأیید درخواست</h6>
                        <div class="list-group list-group-flush border rounded-3 shadow-lg">
                            <div class="list-group-item d-flex align-items-center bg-info-light border-0 border-bottom py-3">
                                <i class="fas fa-file-invoice me-3 text-primary fa-lg"></i>
                                <div>
                                    <div class="fw-bold">درخواست توسط متقاضی ثبت شد</div>
                                    <div class="small text-muted">
                                        {{ $detailRequest->created_at ? \Morilog\Jalali\Jalalian::fromCarbon($detailRequest->created_at)->format('Y/m/d H:i') : 'نامشخص' }}
                                    </div>
                                </div>
                            </div>

                            @forelse($detailRequest->approvals as $ap)
                                <div class="list-group-item d-flex align-items-start border-0 border-bottom py-3 approval-step">
                                    <div class="d-flex align-items-center me-3" style="width: 40px; flex-shrink: 0;">
                                        <i class="fas fa-{{ $ap->status === \App\Models\PettyCashApproval::STATUS_APPROVED ? 'check-circle text-success' : 'times-circle text-danger' }} fa-lg"></i>
                                    </div>
                                    <img src="{{ $this->getUserProfilePhotoUrl($ap->approver) }}"
                                         class="rounded-circle me-3 border shadow-sm" width="40" height="40" alt="{{ $ap->approver->name }}">
                                    <div>
                                        <div class="fw-bold">{{ $ap->approver->name }}</div>
                                        <span class="badge bg-{{ $ap->statusColor() }} px-2 py-1 fw-medium">{{ $ap->statusLabel() }}</span>
                                        @if($ap->comments)
                                            <div class="small text-dark mt-1 fst-italic alert alert-light p-2 rounded-3 border-start border-3 border-info">
                                                <i class="fas fa-comment-dots me-1 text-muted"></i>
                                                «{{ $ap->comments }}»
                                            </div>
                                        @endif
                                        <div class="small text-muted mt-1">
                                            {{ $ap->approved_at ? \Morilog\Jalali\Jalalian::fromCarbon($ap->approved_at)->format('Y/m/d H:i') : 'هنوز اقدام نشده' }}
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="list-group-item text-center text-muted py-3"><i class="fas fa-ellipsis-h me-1"></i>منتظر اولین اقدام تأییدکننده...</div>
                            @endforelse

                            @if($detailRequest->status !== \App\Models\PettyCash::STATUS_PENDING)
                                <div class="list-group-item d-flex align-items-center bg-{{ $detailRequest->statusColor() }} text-white border-0 rounded-bottom-3 py-3">
                                    <i class="fas fa-flag-checkered me-3 fa-lg"></i>
                                    <div class="fw-bolder h5 mb-0">وضعیت نهایی: {{ $detailRequest->statusLabel() }}</div>
                                </div>
                            @endif
                        </div>

                        @if($detailRequest->status === \App\Models\PettyCash::STATUS_PENDING)
                            @php
                                $currentUserId = auth()->id();
                                $isApprover = $detailRequest->isApprover($currentUserId);
                                $hasFinalAction = $detailRequest->approvals
                                    ->where('user_id', $currentUserId)
                                    ->whereIn('status', [\App\Models\PettyCashApproval::STATUS_APPROVED, \App\Models\PettyCashApproval::STATUS_REJECTED])
                                    ->isNotEmpty();
                            @endphp

                            @if($isApprover && !$hasFinalAction)
                                <div class="mt-4 pt-3 border-top border-dashed">
                                    <h6 class="fw-bold text-primary mb-3"><i class="fas fa-user-check me-2"></i>عملیات مورد نیاز</h6>
                                    <div class="d-flex gap-3">
                                        <button wire:click="confirmAction({{ $detailRequest->id }}, 'approve')"
                                                type="button"
                                                class="btn btn-success flex-grow-1 rounded-pill py-2 shadow-lg hover-lift"
                                                data-bs-dismiss="modal"
                                                title="تأیید درخواست">
                                            <i class="fas fa-check me-2"></i> تأیید نهایی
                                        </button>
                                        <button wire:click="confirmAction({{ $detailRequest->id }}, 'reject')"
                                                type="button"
                                                class="btn btn-danger flex-grow-1 rounded-pill py-2 shadow-lg hover-lift"
                                                data-bs-dismiss="modal"
                                                title="رد درخواست">
                                            <i class="fas fa-times me-2"></i> رد کردن
                                        </button>
                                    </div>
                                </div>
                            @elseif($hasFinalAction)
                                <div class="mt-4 pt-3 border-top border-dashed">
                                    <div class="alert alert-success rounded-pill text-center py-2 fw-medium shadow-sm">
                                        <i class="fas fa-check-circle me-2"></i> اقدام شما قبلاً ثبت شده است.
                                    </div>
                                </div>
                            @endif
                        @endif
                    </div>
                    <div class="modal-footer bg-light-subtle">
                        <button type="button" class="btn btn-secondary rounded-pill hover-lift" data-bs-dismiss="modal">بستن پنجره</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @script
    <script>
        $wire.on('openModal', ({ name }) => {
            const modalId = name === 'approval-modal' ? 'approvalModal' : 'detailsModal';
            const modal = new bootstrap.Modal(document.getElementById(modalId));
            modal.show();

            document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(tooltipEl => {
                new bootstrap.Tooltip(tooltipEl);
            });
        });

        $wire.on('closeModal', ({ name }) => {
            const modalId = name === 'approval-modal' ? 'approvalModal' : 'detailsModal';
            const modal = bootstrap.Modal.getInstance(document.getElementById(modalId));
            modal?.hide();
        });

        $wire.on('alert', ({ type, message }) => {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer);
                    toast.addEventListener('mouseleave', Swal.resumeTimer);
                }
            });
            Toast.fire({
                icon: type,
                title: message,
                background: '#fff',
                padding: '1rem',
                customClass: {
                    title: 'fw-bold'
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(tooltipEl => {
                new bootstrap.Tooltip(tooltipEl);
            });
        });
    </script>
    @endscript

    <style>
        :root {
            --primary-main: #007bff;
            --primary-light: #e6f7ff;
            --success-main: #28a745;
            --border-color: var(--bs-border-color);
            --text-muted: var(--bs-secondary-color);
        }

        @media (min-width: 1200px) {
            .col-xl-2-4 {
                flex: 0 0 auto;
                width: 20%;
            }
        }

        .shadow-2xl {
            box-shadow: 0 1rem 3rem rgba(0,0,0,.175)!important;
        }

        .hover-lift {
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        }
        .hover-lift:hover {
            transform: translateY(-5px);
            box-shadow: 0 0.8rem 1.5rem rgba(0,0,0,.15)!important;
        }

        .icon-pulse:hover i {
            animation: pulse-icon 0.5s ease-in-out infinite alternate;
        }
        @keyframes pulse-icon {
            from { transform: scale(1); }
            to { transform: scale(1.1); }
        }

        .hover-row:hover {
            background-color: var(--bs-table-hover-bg) !important;
            box-shadow: 0 0.1rem 0.5rem rgba(0,0,0,.08);
            transform: translateY(-2px);
            transition: all 0.2s ease-in-out;
        }

        .bg-primary-light { background-color: #e6f7ff !important; }
        .bg-success-light { background-color: #eaf8ea !important; }
        .bg-warning-light { background-color: #fff9e6 !important; }
        .bg-danger-light { background-color: #ffeeee !important; }
        .bg-info-light { background-color: #e5f6ff !important; }
        .bg-primary-subtle { background-color: #e0f0ff !important; }

        .status-badge, .status-badge-lg {
            letter-spacing: 0.5px;
        }
        .status-badge { min-width: 90px; }
        .status-badge-lg { font-size: 1.1rem; min-width: 120px; }

        .approver-pill {
            transition: all 0.2s;
        }
        .approver-pill:hover {
            background-color: #f0f0f0 !important;
        }

        .pagination-container .page-link {
            border-radius: 50px !important;
            min-width: 40px;
            height: 40px;
            padding-top: 8px;
            font-weight: 500;
        }
        .pagination-container .page-item.active .page-link {
            box-shadow: 0 4px 10px rgba(0, 123, 255, 0.4);
        }
    </style>

</div>
