<div>
    <div class="container-fluid py-5">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-11">
                <div class="card shadow-lg rounded-5 border-0 animate__animated animate__fadeIn" id="petty-cash-document">

                    <div class="card-header bg-primary text-white py-4 px-5 rounded-top-5 border-0">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h3 class="mb-1 fw-bold text-shadow">
                                    <i class="fas fa-file-invoice me-2"></i> جزئیات کامل درخواست تنخواه #{{ $pettyCash->id }}
                                </h3>
                                <p class="mb-0 opacity-90 text-shadow-sm">
                                    توسط: {{ $pettyCash->user->name }} در تاریخ {{ $pettyCash->created_at->format('Y/m/d H:i') }}
                                </p>
                            </div>
                            <div class="text-end">
                                <h3 class="mb-1 fw-bold text-white text-shadow-sm">{{ number_format($pettyCash->amount) }}</h3>
                                <span class="badge bg-{{ $pettyCash->statusColor() }} rounded-pill px-4 py-2 fs-6 shadow">
                                {{ $pettyCash->statusLabel() }}
                            </span>
                            </div>
                        </div>
                    </div>

                    <div class="card-body p-5">

                        <div class="p-4 mb-5 bg-light rounded-4 border-end border-5 border-primary shadow-sm">
                            <div class="row">
                                <div class="col-md-8">
                                    <h5 class="fw-bold text-dark mb-2">
                                        <i class="fas fa-sticky-note me-2 text-primary"></i> دلیل درخواست
                                    </h5>
                                    <p class="mb-0 text-muted">{{ $pettyCash->reason }}</p>
                                </div>
                                <div class="col-md-4 text-md-end border-start">
                                    <h5 class="fw-bold text-dark mb-2">
                                        <i class="fas fa-clock me-2 text-primary"></i> وضعیت تأیید
                                    </h5>
                                    <p class="mb-0 text-dark fw-bold">
                                        {{ $pettyCash->approved_count }} از {{ $this->getRequiredCount() }} تأیید لازم است.
                                    </p>
                                </div>
                            </div>
                        </div>

                        @if($pettyCash->details_json)
                            <div class="mb-5">
                                <h4 class="fw-bold text-dark mb-4 border-bottom pb-2">
                                    <i class="fas fa-list-ul me-2 text-info"></i> اقلام درخواستی
                                </h4>
                                <div class="table-responsive shadow-sm rounded-4 overflow-hidden">
                                    <table class="table table-striped mb-0">
                                        <thead class="bg-dark text-white">
                                        <tr>
                                            <th class="py-3">نام آیتم</th>
                                            <th class="text-center py-3">تعداد</th>
                                            <th class="text-end py-3">قیمت واحد</th>
                                            <th class="text-end py-3">جمع</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($pettyCash->details_json as $item)
                                            <tr>
                                                <td>{{ $item['item'] ?? '—' }}</td>
                                                <td class="text-center">{{ $item['qty'] ?? 0 }}</td>
                                                <td class="text-end">{{ number_format($item['price'] ?? 0) }} تومان</td>
                                                <td class="text-end fw-bold text-success">{{ number_format(($item['qty'] ?? 0) * ($item['price'] ?? 0)) }} تومان</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                        <tfoot class="table-light fw-bold">
                                        <tr>
                                            <td colspan="3" class="text-end py-3">جمع کل مورد نیاز:</td>
                                            <td class="text-end py-3 text-primary">{{ number_format($pettyCash->amount) }} تومان</td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        @endif

                        @if($pettyCash->projects->isNotEmpty())
                            <div class="mb-5">
                                <h4 class="fw-bold text-dark mb-3 border-bottom pb-2">
                                    <i class="fas fa-project-diagram me-2 text-info"></i> پروژه‌های مرتبط
                                </h4>
                                <div class="d-flex flex-wrap gap-3">
                                    @foreach($pettyCash->projects as $project)
                                        <span class="badge bg-info-subtle text-info fw-bold py-2 px-3 rounded-pill shadow-sm-hover">
                                        {{ $project->name }}
                                    </span>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        <div class="mb-4">
                            <h4 class="fw-bold text-dark mb-4 border-bottom pb-2">
                                <i class="fas fa-check-double me-2 text-primary"></i> سیر تأیید درخواست
                            </h4>

                            @if($pettyCash->approvals->isEmpty())
                                <div class="alert alert-warning border-0 rounded-pill shadow-sm text-center">هنوز تأییدیه‌ای ثبت نشده است.</div>
                            @else
                                <div class="d-flex flex-column gap-4">
                                    @foreach($pettyCash->approvals as $approval)
                                        <div class="d-flex align-items-start border-start border-4 border-{{ $approval->statusColor() }} ps-4 animate__animated animate__fadeInLeft">

                                            <div class="me-3 mt-1">
                                                <i class="fas fa-{{ $approval->status === \App\Models\PettyCashApproval::STATUS_APPROVED ? 'check-circle text-success' : 'times-circle text-danger' }} fa-lg"></i>
                                            </div>

                                            <div>
                                                <div class="d-flex align-items-center mb-1">
                                                    <img src="{{ $approval->approver->image ? asset('storage/' . $approval->approver->image) : asset('assets/img/avatar.png') }}"
                                                         class="rounded-circle me-2 shadow-sm" width="36" height="36" alt="">
                                                    <strong class="text-dark me-2">{{ $approval->approver->name }}</strong>

                                                    <span class="badge bg-{{ $approval->statusColor() }} rounded-pill px-3 py-1 shadow-sm">
                                                    {{ $approval->statusLabel() }}
                                                </span>
                                                </div>

                                                @if($approval->comments)
                                                    <p class="mb-1 text-dark fst-italic p-2 bg-light rounded-3 border-start border-3 border-secondary-subtle">
                                                        <i class="fas fa-comment-dots me-1 text-muted"></i> «{{ $approval->comments }}»
                                                    </p>
                                                @endif
                                                @if($approval->approved_at)
                                                    <small class="text-muted d-block mt-1">در تاریخ: {{ $approval->approved_at->format('Y/m/d H:i') }}</small>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="card-footer bg-light border-0 py-4 px-5 d-flex justify-content-between rounded-bottom-5">
                        <a href="{{ route('admin.petty-cash.index') }}" class="btn btn-outline-secondary px-4 rounded-pill hover-scale">
                            <i class="fas fa-arrow-right me-1"></i> بازگشت به لیست
                        </a>

                        <button wire:click="printPdf" class="btn btn-info px-4 rounded-pill shadow-sm hover-grow" title="دانلود و چاپ درخواست">
                            <i class="fas fa-print me-1"></i> چاپ درخواست (PDF)
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @script
    <script>
        // 🎯 هندلر رویداد Livewire برای هدایت به صفحه چاپ/دانلود
        $wire.on('printDocument', ({ url }) => {
            window.open(url, '_blank');
        });
    </script>
    @endscript

    <style>
        .bg-primary-light { background-color: #e6f7ff !important; }
        .bg-success-light { background-color: #eaf8ea !important; }
        .bg-warning-light { background-color: #fff9e6 !important; }
        .bg-danger-light { background-color: #ffeeee !important; }
        .bg-info-subtle { background-color: #e5f6ff !important; }
        .bg-light { background-color: #f7f9fc !important; } /* برای باکس دلیل درخواست */

        .rounded-5 { border-radius: 1.5rem !important; }
        .rounded-top-5 { border-top-left-radius: 1.5rem !important; border-top-right-radius: 1.5rem !important; }
        .rounded-bottom-5 { border-bottom-left-radius: 1.5rem !important; border-bottom-right-radius: 1.5rem !important; }

        .text-shadow { text-shadow: 1px 1px 2px rgba(0,0,0,0.2); }
        .text-shadow-sm { text-shadow: 0.5px 0.5px 1px rgba(0,0,0,0.1); }

        /* افکت‌های Hover */
        .hover-scale {
            transition: transform 0.2s ease-in-out;
        }
        .hover-scale:hover {
            transform: scale(1.05);
        }
        .shadow-sm-hover {
            transition: box-shadow 0.2s ease-in-out;
        }
        .shadow-sm-hover:hover {
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,.1)!important;
        }
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f8f9fa;
        }
        .table-striped tbody tr:nth-of-type(even) {
            background-color: #ffffff;
        }
    </style>

</div>
