<div class="container-fluid py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-xxl-9">

            {{-- Flash Messages --}}
            @if(session()->has('success') || session()->has('error'))
                <div
                    class="alert alert-{{ session()->has('success') ? 'success' : 'danger' }} alert-dismissible fade show d-flex align-items-center mb-4 border-0 shadow-sm rounded-4 notification-alert"
                    role="alert"
                >
                    <i class="ti ti-{{ session()->has('success') ? 'check-circle' : 'alert-octagon' }} fs-4 me-3"></i>
                    <div class="flex-grow-1 fw-medium">
                        {{ session('success') ?? session('error') }}
                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- Header --}}
            <div class="bg-gradient-header rounded-4 p-5 mb-4 text-white position-relative overflow-hidden shadow-lg header-card">
                <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 position-relative">
                    <div>
                        <h2 class="mb-1 fw-bold fs-3">📝 پست‌های من</h2>
                        <p class="mb-0 opacity-90">
                            مدیریت و مشاهده {{ $this->posts->total() }} پست ثبت‌شده توسط شما
                        </p>
                    </div>
                    <a href="{{ route('admin.create.post') }}"
                       class="btn btn-light text-primary-dark rounded-pill px-4 py-2 fw-bold shadow-sm hover-scale">
                        <i class="ti ti-plus fs-5 me-2"></i> ایجاد پست جدید
                    </a>
                </div>
                <div class="header-card-icon">
                    <i class="ti ti-news opacity-50"></i>
                </div>
            </div>

            {{-- فیلتر و جستجو --}}
            <div class="bg-white rounded-4 p-4 shadow-sm mb-4 filter-container">
                <div class="row g-3 align-items-center">

                    {{-- تعداد در صفحه --}}
                    <div class="col-6 col-md-3">
                        <label class="form-label small text-muted mb-1">تعداد در صفحه</label>
                        <select class="form-select form-select-sm rounded-3 shadow-sm filter-select-improved" wire:model="perPage">
                            <option value="5">۵ در صفحه</option>
                            <option value="10">۱۰ در صفحه</option>
                            <option value="15">۱۵ در صفحه</option>
                            <option value="20">۲۰ در صفحه</option>
                            <option value="50">۵۰ در صفحه</option>
                        </select>
                    </div>

                    {{-- فیلتر وضعیت --}}
                    <div class="col-12 col-md-4">
                        <label class="form-label small text-muted mb-1">وضعیت پست‌ها</label>
                        <div class="d-flex flex-wrap gap-2">
                            @php
                                $filters = [
                                    ['key' => 'all',       'label' => 'همه',          'class' => 'btn-outline-secondary'],
                                    ['key' => 'published', 'label' => 'منتشر شده',   'class' => 'btn-outline-success'],
                                    ['key' => 'draft',     'label' => 'پیش‌نویس',     'class' => 'btn-outline-warning'],
                                ];
                            @endphp

                            @foreach($filters as $filter)
                                <button
                                    type="button"
                                    wire:click="$set('statusFilter', '{{ $filter['key'] }}')"
                                    class="btn btn-sm rounded-pill fw-medium px-3 {{ $statusFilter === $filter['key'] ? 'btn-' . Str::after($filter['class'], 'btn-outline-') : $filter['class'] }}"
                                >
                                    {{ $filter['label'] }}
                                </button>
                            @endforeach
                        </div>
                    </div>

                    {{-- جستجو --}}
                    <div class="col-12 col-md-5">
                        <label class="form-label small text-muted mb-1">جستجو در عنوان پست</label>
                        <div class="input-group input-group-sm search-box-improved">
                            <span class="input-group-text bg-white">
                                <i class="ti ti-search text-primary"></i>
                            </span>
                            <input
                                type="search"
                                class="form-control shadow-none"
                                placeholder="عنوان پست را وارد کنید..."
                                wire:model.debounce.300ms="search"
                            >
                        </div>
                    </div>
                </div>
            </div>

            {{-- لودینگ کوچک --}}
            <div wire:loading.delay class="text-center my-3">
                <div class="spinner-border spinner-border-sm text-primary" role="status">
                    <span class="visually-hidden">در حال به‌روزرسانی...</span>
                </div>
            </div>

            {{-- کارت لیست پست‌ها --}}
            <div class="bg-white rounded-4 border border-light shadow-sm overflow-hidden">
                @if($this->posts->isNotEmpty())
                    <div class="table-responsive">
                        <table class="table align-middle mb-0">
                            <thead class="bg-gray-50 border-bottom">
                            <tr class="text-muted small">
                                <th scope="col" class="px-4" style="width: 70px;">#</th>

                                {{-- عنوان --}}
                                <th
                                    scope="col"
                                    class="px-4 cursor-pointer"
                                    wire:click="sort('title')"
                                    style="min-width: 220px;"
                                >
                                    <div class="d-flex align-items-center justify-content-between gap-2">
                                        <span>عنوان پست</span>
                                        @if($sortBy === 'title')
                                            <span class="text-primary small">
                                                    {!! $sortDirection === 'asc' ? '▲' : '▼' !!}
                                                </span>
                                        @endif
                                    </div>
                                </th>

                                {{-- وضعیت --}}
                                <th scope="col" class="px-4" style="width: 140px;">وضعیت</th>

                                {{-- تاریخ --}}
                                <th
                                    scope="col"
                                    class="px-4 cursor-pointer"
                                    wire:click="sort('created_at')"
                                    style="width: 180px;"
                                >
                                    <div class="d-flex align-items-center justify-content-between gap-2">
                                        <span>تاریخ ایجاد</span>
                                        @if($sortBy === 'created_at')
                                            <span class="text-primary small">
                                                    {!! $sortDirection === 'asc' ? '▲' : '▼' !!}
                                                </span>
                                        @endif
                                    </div>
                                </th>

                                {{-- عملیات --}}
                                <th scope="col" class="text-center px-4" style="width: 120px;">عملیات</th>
                            </tr>
                            </thead>
                            <tbody class="small">
                            @foreach($this->posts as $post)
                                <tr class="row-hover-soft">
                                    <td class="px-4 text-muted fw-semibold">
                                        #{{ $post->id }}
                                    </td>

                                    <td class="px-4">
                                        <div class="fw-semibold text-dark text-truncate" title="{{ $post->title }}">
                                            {{ $post->title }}
                                        </div>
                                    </td>

                                    <td class="px-4">
                                        @if($post->is_published)
                                            <span class="badge rounded-pill bg-success-subtle text-success d-inline-flex align-items-center gap-1 px-3 py-2">
                                                    <span class="rounded-circle bg-success d-inline-block" style="width: 6px; height: 6px;"></span>
                                                    منتشر شده
                                                </span>
                                        @else
                                            <span class="badge rounded-pill bg-warning-subtle text-warning d-inline-flex align-items-center gap-1 px-3 py-2">
                                                    <span class="rounded-circle bg-warning d-inline-block" style="width: 6px; height: 6px;"></span>
                                                    پیش‌نویس
                                                </span>
                                        @endif
                                    </td>

                                    <td class="px-4 text-muted">
                                        <div class="fw-semibold">
                                            {{ \Morilog\Jalali\Jalalian::fromCarbon($post->created_at)->format('Y/m/d') }}
                                        </div>
                                        <div class="small text-secondary">
                                            ({{ \Morilog\Jalali\Jalalian::fromCarbon($post->created_at)->ago() }})
                                        </div>
                                    </td>

                                    <td class="px-4 text-center">
                                        <div class="dropdown">
                                            <button
                                                class="btn btn-sm btn-light rounded-circle shadow-xs"
                                                type="button"
                                                id="postActions{{ $post->id }}"
                                                data-bs-toggle="dropdown"
                                                aria-expanded="false"
                                            >
                                                <i class="ti ti-dots-vertical"></i>
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0 rounded-3" aria-labelledby="postActions{{ $post->id }}">
                                                <li>
                                                    <a class="dropdown-item d-flex align-items-center gap-2"
                                                       href="{{ route('admin.posts.edit', $post->id) }}">
                                                        <i class="ti ti-pencil"></i>
                                                        <span>ویرایش پست</span>
                                                    </a>
                                                </li>
                                                <li><hr class="dropdown-divider"></li>
                                                <li>
                                                    <button
                                                        type="button"
                                                        class="dropdown-item text-danger d-flex align-items-center gap-2"
                                                        onclick="if(!confirm('آیا از حذف این پست مطمئن هستید؟ این عمل غیرقابل بازگشت است.')) { event.stopImmediatePropagation(); return false; }"
                                                        wire:click="deletePost({{ $post->id }})"
                                                    >
                                                        <i class="ti ti-trash"></i>
                                                        <span>حذف دائمی</span>
                                                    </button>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                    {{-- Pagination --}}
                    <div class="p-3 border-top bg-gray-50">
                        <div class="d-flex justify-content-center justify-content-md-end">
                            <div class="pagination-wrapper rounded-pill shadow-lg p-2 bg-white">
                                {{ $this->posts->links('pagination.custom-modern') }}
                            </div>
                        </div>
                    </div>
                @else
                    {{-- Empty State --}}
                    <div class="text-center py-5 bg-white">
                        <div class="p-4 bg-gray-50 rounded-circle d-inline-block mb-4 shadow-sm">
                            <i class="ti ti-notes fs-1 text-muted opacity-50"></i>
                        </div>
                        <h4 class="text-muted fw-bold mb-2">هیچ پستی پیدا نشد</h4>
                        <p class="text-muted mb-4">
                            پستی مطابق با جستجو یا فیلترهای فعلی یافت نشد. فیلترها را تغییر دهید یا یک پست جدید بسازید.
                        </p>
                        <a href="{{ route('admin.create.post') }}" class="btn btn-primary rounded-pill px-5 shadow-lg hover-scale">
                            <i class="ti ti-plus fs-5 me-2"></i> ایجاد پست جدید
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- استایل‌های اختصاصی (هم‌خانواده با صفحه اطلاعیه‌ها) --}}
    <style>
        :root {
            --primary: #0f766e;
            --primary-light: #ccfbf1;
            --primary-dark: #115e59;
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
            --gray-200: #e5e7eb;
        }

        .bg-gradient-header {
            background: linear-gradient(135deg, var(--primary-dark), var(--primary));
        }

        .hover-scale { transition: transform 0.2s ease, box-shadow 0.2s ease; }
        .hover-scale:hover { transform: scale(1.03); box-shadow: 0 4px 10px rgba(0,0,0,0.1); }

        .header-card-icon {
            position: absolute;
            top: -20px;
            left: -20px;
            font-size: 10rem;
            color: rgba(255, 255, 255, 0.1);
            transform: rotate(-15deg);
        }

        .notification-alert {
            background: linear-gradient(135deg, #10b981, #059669) !important;
            color: white !important;
        }
        .btn-close-white { filter: brightness(0) invert(1); }

        .search-box-improved .input-group-text,
        .search-box-improved .form-control {
            border: 1px solid var(--gray-200) !important;
            box-shadow: none !important;
        }
        .search-box-improved .input-group-text {
            background-color: var(--gray-50) !important;
        }

        .row-hover-soft:hover {
            background-color: #f8fafc !important;
        }

        .pagination-wrapper {
            box-shadow: 0 4px 15px rgba(0,0,0,0.06);
            border-radius: 50px;
        }
        .pagination-wrapper .pagination { margin-bottom: 0; }

        .pagination-modern-nav .page-link {
            border: none;
            color: #0f766e;
            font-weight: 500;
            margin: 0 4px;
            min-width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            transition: all 0.2s ease;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        .pagination-modern-nav .page-arrow {
            background-color: var(--gray-100);
            color: #115e59;
        }
        .pagination-modern-nav .page-item.active .page-link {
            background-color: #0f766e !important;
            color: #fff !important;
            font-weight: 700;
            box-shadow: 0 3px 8px rgba(0,0,0,0.2);
        }
        .pagination-modern-nav .page-link:hover:not(.page-item.disabled .page-link):not(.page-item.active .page-link) {
            background-color: var(--primary-light) !important;
            color: #115e59;
        }
        .pagination-modern-nav .page-item.disabled .page-link {
            opacity: 0.4;
            pointer-events: none;
        }
    </style>
</div>
