<div class="container-fluid py-5 px-lg-5" dir="rtl" style="font-family: 'Vazirmatn', sans-serif; background: radial-gradient(circle at top right, #fcfdfe, #f0f7ff); min-height: 100vh;">
    <style>
        :root {
            --p-azure: #0ea5e9;
            --p-indigo: #4361ee;
            --p-slate: #0f172a;
            --p-border: rgba(226, 232, 240, 0.6);
            --p-glass-bg: rgba(255, 255, 255, 0.85);
        }

        .reveal-up { animation: luxFadeUp 1s cubic-bezier(0.16, 1, 0.3, 1) both; }
        @keyframes luxFadeUp { from { opacity: 0; transform: translateY(40px) scale(0.98); } to { opacity: 1; transform: translateY(0) scale(1); } }

        /* 🏔️ هدر کپسولی فوق پیشرفته (Command Center v2) */
        .sky-command-center {
            background: linear-gradient(110deg, #1e293b 0%, #0f172a 100%);
            border-radius: 40px; padding: 70px 60px; color: white;
            position: relative; overflow: hidden;
            box-shadow: 0 45px 80px -20px rgba(15, 23, 42, 0.4);
            margin-bottom: 65px; border: 1px solid rgba(255,255,255,0.08);
        }

        /* افکت‌های نوری پس‌زمینه هدر */
        .sky-command-center::before {
            content: ''; position: absolute; top: -15%; left: -5%; width: 600px; height: 600px;
            background: radial-gradient(circle, rgba(14, 165, 233, 0.25) 0%, transparent 75%);
            filter: blur(50px);
        }
        .sky-command-center::after {
            content: ''; position: absolute; bottom: -20%; right: 10%; width: 400px; height: 400px;
            background: radial-gradient(circle, rgba(67, 97, 238, 0.15) 0%, transparent 70%);
            filter: blur(40px);
        }

        /* ویجت حجم مجاز (Metric Widget) */
        .metric-glass-box {
            background: rgba(255, 255, 255, 0.03);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 30px; padding: 25px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
            transition: 0.4s ease;
        }
        .metric-glass-box:hover {
            background: rgba(255, 255, 255, 0.07);
            border-color: var(--p-azure);
            transform: scale(1.03);
        }

        /* نشان وضعیت (Status Badge) */
        .status-pill-lux {
            background: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.2);
            color: var(--p-azure);
            padding: 8px 20px; border-radius: 100px;
            font-size: 0.75rem; font-weight: 900;
            letter-spacing: 1px; display: inline-flex; align-items: center;
            margin-bottom: 20px;
        }

        /* سایر استایل‌ها ... */
        .modern-bento-card {
            background: var(--p-glass-bg); backdrop-filter: blur(30px);
            border-radius: 45px; border: 1px solid #fff;
            box-shadow: 0 20px 50px -12px rgba(0, 0, 0, 0.04);
            overflow: hidden; transition: 0.5s ease;
        }
        .lux-input {
            border-radius: 20px !important; border: 1.5px solid #edf2f7 !important; padding: 16px 28px !important;
            background: #fff !important; transition: 0.4s; font-weight: 700; color: var(--p-slate);
        }
        .lux-input:focus { border-color: var(--p-azure) !important; box-shadow: 0 0 0 8px rgba(14, 165, 233, 0.08) !important; transform: translateY(-2px); }
        .neon-drop-zone {
            border: 2px dashed #bae6fd; border-radius: 35px; padding: 75px 20px;
            background: rgba(240, 249, 255, 0.4); transition: 0.4s; cursor: pointer; position: relative;
        }
        .btn-neon-sync {
            background: var(--p-slate); color: white; border-radius: 22px;
            padding: 22px 50px; font-weight: 900; border: none; transition: 0.4s;
            box-shadow: 0 20px 40px -10px rgba(15, 23, 42, 0.3);
            letter-spacing: 0.5px;
        }
        .btn-neon-sync:hover { background: var(--p-azure); transform: scale(1.02); box-shadow: 0 25px 50px -10px rgba(14, 165, 233, 0.4); }
        .file-entry {
            background: rgba(255,255,255,0.6); border: 1px solid #fff; border-radius: 22px;
            padding: 20px 25px; margin-bottom: 15px; display: flex; align-items: center;
            justify-content: space-between; transition: 0.3s;
        }
    </style>

    <div class="sky-command-center reveal-up">
        <div class="row align-items-center position-relative z-index-2">
            <div class="col-lg-7">

                <h1 class="fw-black display-3 mb-3 text-white">بایگانی هوشمند اسناد</h1>
                <p class="opacity-50 fs-5 lh-lg mb-0 pe-lg-5 fw-medium">
                    مدیریت متمرکز دارایی‌های دیجیتال با پروتکل امنیتی
                    <span class="text-info">End-to-End Encryption</span>
                    و سیستم طبقه‌بندی هوشمند پروژه‌های سازمان.
                </p>
            </div>

            <div class="col-lg-5 mt-5 mt-lg-0">
                <div class="d-flex justify-content-lg-end justify-content-center">
                    <div class="metric-glass-box d-flex align-items-center gap-4">
                        <div class="icon-box p-3 bg-info text-white rounded-4 shadow-lg d-flex align-items-center justify-content-center" style="width: 70px; height: 70px;">
                            <i class="ti ti-cloud-lock fs-1"></i>
                        </div>
                        <div class="text-end border-end border-white border-opacity-10 pe-4">
                            <span class="d-block fw-black fs-1 text-white" style="line-height: 1;">100<small class="fs-5 opacity-40 ms-1">MB</small></span>
                            <small class="small opacity-40 d-block fw-bold tracking-widest text-uppercase mt-2" style="font-size: 0.65rem;">Per Layer Capacity</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="position-absolute bottom-0 start-0 w-100 h-10 opacity-10 bg-gradient-to-t from-white to-transparent"></div>
    </div>

    <div class="row g-5">
        <div class="col-xl-8">
            <div class="modern-bento-card p-4 p-md-5 reveal-up" style="animation-delay: 0.1s">
                <form wire:submit.prevent="save">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <label class="form-label fw-black text-dark mb-3 ms-2 small opacity-50">TARGET PROJECT / مقصد</label>
                            <select wire:model.live="project_id" class="form-select lux-input">
                                <option value="">جستجو در پروژه‌ها...</option>
                                @foreach($this->projects as $p)
                                    <option value="{{ $p->id }}">{{ $p->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-black text-dark mb-3 ms-2 small opacity-50">OPERATIONAL PHASE / فاز</label>
                            <select wire:model="section_id" class="form-select lux-input" {{ empty($sections) ? 'disabled' : '' }}>
                                <option value="">{{ empty($sections) ? 'انتخاب پروژه الزامیست...' : 'تعیین فاز عملیاتی...' }}</option>
                                @foreach($sections as $s)
                                    <option value="{{ $s['id'] }}">{{ $s['name'] }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12">
                            <label class="form-label fw-black text-dark mb-3 ms-2 small opacity-50">DOCUMENT TITLE / عنوان</label>
                            <input type="text" wire:model="name" class="form-control lux-input" placeholder="مانند: نقشه‌های فاز ۲ - پارت نهم">
                        </div>

                        <div class="col-12">
                            <div class="neon-drop-zone"
                                 x-data="{ isDragging: false }"
                                 :class="{ 'border-info bg-white': isDragging }"
                                 @dragover.prevent="isDragging = true"
                                 @dragleave.prevent="isDragging = false"
                                 @drop.prevent="isDragging = false">

                                <input type="file" wire:model="files" class="position-absolute w-100 h-100 top-0 start-0 opacity-0 cursor-pointer" style="z-index: 5;" multiple>

                                <div class="text-center" wire:loading.remove wire:target="files">
                                    <div class="p-4 bg-info bg-opacity-10 rounded-circle d-inline-flex mb-4">
                                        <i class="ti ti-cloud-upload fs-1 text-info"></i>
                                    </div>
                                    <h4 class="fw-black text-dark">بارگذاری دیجیتال</h4>
                                    <p class="text-muted fw-bold mb-0">اسناد را به این ناحیه بکشید یا کلیک کنید</p>
                                </div>

                                <div wire:loading wire:target="files" class="w-100 text-center py-5">
                                    <div class="spinner-grow text-info" style="width: 3.5rem; height: 3.5rem;"></div>
                                    <h5 class="fw-black text-info mt-4">در حال انتقال ایمن داده‌ها...</h5>
                                </div>
                            </div>
                        </div>

                        @if(count($files) > 0)
                            <div class="col-12 mt-4 reveal-up">
                                <div class="p-4 bg-white rounded-4 border border-light shadow-sm">
                                    <h6 class="fw-black text-dark mb-4 d-flex align-items-center gap-2">
                                        <i class="ti ti-layers-intersect text-info fs-4"></i> لیست انتظار آپلود ({{ count($files) }} مورد)
                                    </h6>
                                    @foreach($files as $index => $file)
                                        <div class="file-entry" wire:key="file-{{ $index }}">
                                            <div class="d-flex align-items-center gap-3">
                                                <div class="p-2 bg-info bg-opacity-10 text-info rounded-3">
                                                    @php $ext = $file->getClientOriginalExtension(); @endphp
                                                    <i class="ti ti-file-type-{{ $ext }} fs-3"></i>
                                                </div>
                                                <div>
                                                    <span class="fw-black d-block text-dark small">{{ $file->getClientOriginalName() }}</span>
                                                    <small class="text-muted fw-bold opacity-75">{{ number_format($file->getSize() / 1024 / 1024, 2) }} MB</small>
                                                </div>
                                            </div>
                                            <button type="button" wire:click="removeFile({{ $index }})" class="btn btn-icon btn-white border shadow-sm rounded-circle text-danger p-2 hover-lift">
                                                <i class="ti ti-trash-x-filled fs-4"></i>
                                            </button>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        <div class="col-12 pt-4 text-center">
                            <button type="submit" class="btn-neon-sync w-100 fs-5 py-4" wire:loading.attr="disabled" wire:target="files, save">
                                <span wire:loading.remove wire:target="save"><i class="ti ti-device-floppy me-2"></i> تایید و آرشیو مستندات در مخزن پروژه</span>
                                <span wire:loading wire:target="save"><i class="spinner-border spinner-border-sm me-2"></i> در حال رمزنگاری و ثبت نهایی...</span>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-xl-4">
            <div class="modern-bento-card bg-dark p-5 h-100 shadow-3xl" style="background: #0f172a !important; border: 1px solid rgba(255,255,255,0.05);">
                <h4 class="fw-black text-white mb-5 d-flex align-items-center gap-3 border-bottom border-secondary pb-4">
                    <span class="p-2 bg-info rounded-3 text-white shadow-info"><i class="ti ti-shield-code fs-4"></i></span>
                    امنیت و پایداری
                </h4>
                <div class="d-flex flex-column gap-5">
                    <div class="reveal-up">
                        <h6 class="fw-black text-info mb-2 small letter-spacing-1">LIVE VIRUS SCANNING</h6>
                        <p class="text-white opacity-40 small lh-lg fw-bold mb-0 text-justify">تمامی فایل‌ها پیش از آپلود نهایی توسط آنتی‌ویروس BitDefender Cloud پاکسازی می‌شوند.</p>
                    </div>
                    <div class="reveal-up">
                        <h6 class="fw-black text-info mb-2 small letter-spacing-1">ENCRYPTION PROTOCOL</h6>
                        <p class="text-white opacity-40 small lh-lg fw-bold mb-0 text-justify">اسناد به صورت خودکار با متد AES-256 رمزنگاری شده و تنها مدیران پروژه مجاز به بازگشایی هستند.</p>
                    </div>
                </div>
                <div class="mt-auto pt-5 text-center opacity-10">
                    <i class="ti ti-binary fs-1" style="font-size: 15rem; color: white;"></i>
                </div>
            </div>
        </div>
    </div>
</div>
