<div class="container py-4">
    <div class="card shadow-sm">
        @if(session()->has('message'))
            <div class="alert alert-success alert-dismissible fade show m-3">
                {{ session('message') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <form wire:submit.prevent="upload">
            <div class="card-body p-4">
                <h5 class="fs-4 fw-semibold mb-4">آپلود فایل به مسیر Project/File</h5>

                <!-- انتخاب فایل -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">
                        <i class="fas fa-file-upload me-2"></i>
                        انتخاب فایل‌ها (چند انتخابی)
                    </label>
                    <input
                        type="file"
                        class="form-control"
                        wire:model="files"
                        multiple
                        required
                    >
                    @error('files.*') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                </div>

                <!-- لیست فایل‌های انتخاب شده -->
                @if(count($uploadedFiles) > 0)
                    <div class="mb-4">
                        <div class="list-group">
                            @foreach($uploadedFiles as $index => $file)
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <div class="d-flex align-items-center gap-2">
                                        <i class="fas fa-file text-primary"></i>
                                        <span>{{ $file->getClientOriginalName() }}</span>
                                    </div>
                                    <button
                                        type="button"
                                        class="btn btn-sm btn-outline-danger"
                                        wire:click="removeFile({{ $index }})"
                                    >
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- دکمه آپلود -->
                <button
                    type="submit"
                    class="btn btn-primary w-100 py-3"
                    wire:loading.attr="disabled"
                >
                    <i class="fas fa-upload me-2"></i>
                    <span wire:loading.remove>آپلود فایل‌ها ({{ count($uploadedFiles) }})</span>
                    <span wire:loading>در حال آپلود...</span>
                </button>
            </div>
        </form>
    </div>
</div>
