<div class="container-fluid py-5" dir="rtl" style="background: linear-gradient(135deg, #f0f4f8 0%, #ffffff 100%); min-height: 100vh; font-family: 'Vazirmatn', sans-serif;">
    <style>
        :root {
            --primary: #4f46e5;
            --primary-light: #818cf8;
            --accent: #10b981;
            --glass-bg: rgba(255, 255, 255, 0.7);
            --border-light: rgba(255, 255, 255, 0.5);
            --shadow-soft: 0 20px 40px -15px rgba(0, 0, 0, 0.05);
        }

        .reveal-up { animation: fadeInUp 0.8s cubic-bezier(0.16, 1, 0.3, 1) both; }
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(40px); } to { opacity: 1; transform: translateY(0); } }

        /* 🏔️ طراحی هدر مدرن پانوراما */
        .panorama-header {
            background: #fff;
            border-radius: 40px;
            padding: 40px;
            border: 1px solid var(--border-light);
            box-shadow: var(--shadow-soft);
            margin-bottom: 40px;
            position: relative;
            overflow: hidden;
        }
        .panorama-header::before {
            content: ''; position: absolute; top: -50%; left: -10%; width: 300px; height: 300px;
            background: radial-gradient(circle, rgba(79, 70, 229, 0.08) 0%, transparent 70%);
        }

        /* 📦 کارت‌های مدرن نئومورفیسم نرم */
        .premium-card {
            background: var(--glass-bg);
            backdrop-filter: blur(25px);
            border-radius: 35px;
            border: 1px solid #fff;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.03), inset 0 0 0 1px rgba(255, 255, 255, 0.5);
            transition: all 0.4s ease;
        }
        .premium-card:hover { transform: translateY(-10px); box-shadow: 0 30px 60px rgba(0,0,0,0.06); }

        /* 🖋️ فیلدها و ورودی‌ها */
        .lux-input {
            border-radius: 22px; border: 1.5px solid #eef2f6; padding: 18px 24px;
            background: #fff; transition: 0.3s; font-weight: 600; color: #1e293b;
        }
        .lux-input:focus {
            border-color: var(--primary-light); box-shadow: 0 0 0 5px rgba(79, 70, 229, 0.08); outline: none;
        }

        /* 🔘 دکمه اکشن متالیک */
        .btn-action {
            background: linear-gradient(135deg, var(--primary) 0%, #3730a3 100%);
            color: white; border-radius: 25px; padding: 20px 50px;
            font-weight: 900; border: none; transition: 0.4s;
            box-shadow: 0 15px 30px rgba(79, 70, 229, 0.25);
        }
        .btn-action:hover { transform: scale(1.03); box-shadow: 0 20px 40px rgba(79, 70, 229, 0.35); }

        /* 📊 استایل مینی‌داشبورد */
        .stat-block {
            background: #f8fafc; border-radius: 24px; padding: 20px;
            border: 1px solid #edf2f7; transition: 0.3s;
        }
        .stat-block:hover { background: #fff; border-color: var(--primary-light); }

        .code-tag {
            background: #f1f5f9; color: #475569; padding: 6px 14px;
            border-radius: 12px; font-family: 'JetBrains Mono', monospace; font-size: 0.85rem; font-weight: 700;
        }
    </style>

    <div class="panorama-header reveal-up">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="d-flex align-items-center gap-3 mb-3 text-primary">
                    <i class="ti ti-layers-intersect fs-2"></i>
                    <span class="fw-black letter-spacing-1 small">SYSTEM ARCHITECT v3.0</span>
                </div>
                <h1 class="fw-black display-5 text-dark mb-3">تعریف کانون پروژه</h1>
                <p class="text-muted fs-5 lh-lg pe-lg-5">ایجاد هویت یکپارچه برای مدیریت مراکز هزینه و جریان‌های نقدی پروژه در بستر هوش مالی.</p>
            </div>
            <div class="col-lg-6">
                <div class="row g-3">
                    <div class="col-6">
                        <div class="stat-block text-center shadow-sm">
                            <div class="text-primary fs-2 fw-black mb-1">{{ \App\Models\Project::count() }}</div>
                            <div class="small text-muted fw-bold text-uppercase">پروژه ثبت شده</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="stat-block text-center shadow-sm">
                            <div class="text-accent fs-2 fw-black mb-1">{{ \App\Models\ProjectType::count() }}</div>
                            <div class="small text-muted fw-bold text-uppercase">تنوع دسته‌بندی</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-5">
        <div class="col-xl-8">
            <div class="premium-card p-5 reveal-up" style="animation-delay: 0.2s;">
                <form wire:submit.prevent="saveProject">
                    <div class="mb-5 d-flex justify-content-between align-items-end">
                        <div>
                            <h4 class="fw-black m-0 text-dark">اطلاعات ساختاری</h4>
                            <div class="bg-primary mt-2" style="width: 50px; height: 4px; border-radius: 2px;"></div>
                        </div>
                        <i class="ti ti-id-badge fs-1 opacity-10"></i>
                    </div>

                    <div class="row g-4">
                        <div class="col-12">
                            <label class="form-label">نام کامل پروژه (فارسی)</label>
                            <input type="text" wire:model.live="name" class="form-control lux-input @error('name') is-invalid @enderror" placeholder="مثلاً: فاز دوم توسعه زیرساخت هوشمند...">
                            @error('name') <div class="text-danger small fw-bold mt-2"><i class="ti ti-alert-circle me-1"></i>{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">شناسه یکتا (UID)</label>
                            <div class="position-relative">
                                <input type="text" wire:model.live="code" class="form-control lux-input text-start font-monospace" placeholder="PRJ-CODE">
                                <i class="ti ti-lock position-absolute top-50 start-0 translate-middle-y ms-3 text-muted opacity-30"></i>
                            </div>
                            @error('code') <div class="text-danger small fw-bold mt-2">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">ماهیت پروژه</label>
                            <select wire:model.live="project_type_id" class="form-select lux-input">
                                <option value="">انتخاب از لیست...</option>
                                @foreach($this->projectTypes as $type)
                                    <option value="{{ $type->id }}">{{ $type->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="mt-5 pt-4 d-flex justify-content-between align-items-center">
                        <div class="text-muted small fw-bold d-flex align-items-center gap-2">
                            <span class="p-1 bg-success rounded-circle"></span>
                            تاییدیه امنیتی اطلاعات
                        </div>
                        <button type="submit" class="btn-action shadow-lg" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="saveProject">تایید و ایجاد پروژه</span>
                            <span wire:loading wire:target="saveProject" class="spinner-border spinner-border-sm me-2"></span>
                            <i class="ti ti-circle-chevron-left ms-2 fs-5"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-xl-4">
            <div class="premium-card p-4 mb-4 border-0" style="background: linear-gradient(135deg, #f8fafc 0%, #eef2ff 100%);">
                <h5 class="fw-black text-primary mb-3 d-flex align-items-center gap-2">
                    <i class="ti ti-bulb fs-3"></i> استانداردهای مالی
                </h5>
                <p class="small text-muted lh-lg">
                    سیستم به صورت هوشمند بودجه را از <span class="fw-black text-dark">آخرین الحاقیه قرارداد</span> استخراج می‌کند. لطفاً کدینگ را مطابق سرفصل‌های دفتر مرکزی انتخاب کنید.
                </p>
            </div>

            <div class="premium-card p-4">
                <h5 class="fw-black text-dark mb-4 d-flex align-items-center justify-content-between">
                    <span>ثبت‌شده‌های اخیر</span>
                    <i class="ti ti-history text-muted"></i>
                </h5>
                <div class="d-flex flex-column gap-3">
                    @forelse($this->projects as $p)
                        <div class="p-3 rounded-4 bg-white border d-flex justify-content-between align-items-center hover-lift border-light shadow-sm">
                            <div class="d-flex align-items-center gap-3">
                                <div class="bg-primary text-white rounded-3 p-2 d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                    <i class="ti ti-folder" style="font-size: 1rem;"></i>
                                </div>
                                <div>
                                    <div class="fw-black text-dark small">{{ Str::limit($p->name, 22) }}</div>
                                    <span class="code-tag mt-1 d-inline-block">{{ $p->code }}</span>
                                </div>
                            </div>
                            <i class="ti ti-arrow-left-circle text-primary opacity-50"></i>
                        </div>
                    @empty
                        <div class="text-center py-4 text-muted small">پروژه‌ای یافت نشد.</div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
