<div class="container-fluid py-4" x-data="{ showModal: false, attachments: [], modalTitle: '' }">
    {{-- 🎯 Toast Notification (بدون session) --}}
    <div x-data="{ show: @entangle('saved').live }"
         x-show="show"
         x-init="setTimeout(() => show = false, 3000)"
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0 transform translate-y-2"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         x-transition:leave="transition ease-in duration-300"
         x-transition:leave-start="opacity-100 transform translate-y-0"
         x-transition:leave-end="opacity-0 transform translate-y-2"
         class="fixed top-4 left-1/2 transform -translate-x-1/2 z-[110] max-w-md w-full px-4"
    >
        <div class="bg-gradient-to-r from-emerald-500 to-teal-600 text-white rounded-2xl shadow-lg p-4 flex items-center gap-3">
            <i class="ti ti-circle-check fs-4"></i>
            <span class="font-medium">✅ عملیات با موفقیت انجام شد.</span>
        </div>
    </div>

    {{-- 🛑 هدر پروژه --}}
    <div class="card bg-gradient-to-r from-slate-800 to-slate-900 text-white shadow-xl border-0 rounded-3xl overflow-hidden mb-5">
        <div class="card-body p-5">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                <div>
                    <h2 class="mb-1 fw-bold d-flex align-items-center gap-2">
                        <i class="ti ti-shield-half fs-4 text-cyan-300"></i>
                        <span>مدیریت بیمه پروژه</span>
                        <span class="text-cyan-200">·</span>
                        <span class="text-cyan-100">{{ $projectName }}</span>
                    </h2>
                    <p class="mb-0 opacity-80 text-sm">
                        <i class="ti ti-hash me-1"></i> کد: <span class="fw-semibold">{{ $projectCode }}</span>
                    </p>
                </div>
                <a href="{{ route('single.project.dashboard', $projectId) }}"
                   class="btn btn-outline-cyan-300 hover:bg-cyan-500/10 px-4 py-2 rounded-full d-flex align-items-center gap-2">
                    <i class="ti ti-arrow-back-up fs-5"></i>
                    <span class="d-none d-md-inline">بازگشت به داشبورد</span>
                </a>
            </div>
        </div>
    </div>

    {{-- 🛑 فرم اصلی --}}
    <div class="card bg-white border-0 shadow-lg rounded-3xl overflow-hidden mb-5">
        <div class="card-header bg-gradient-primary text-white p-4">
            <h4 class="mb-0 d-flex align-items-center gap-2">
                <i class="ti ti-forms fs-4"></i>
                {{ $editing ? 'ویرایش قرارداد بیمه' : 'افزودن قرارداد بیمه جدید' }}
            </h4>
        </div>
        <div class="card-body p-5">
            <form wire:submit.prevent="saveInsurance">
                <div class="row g-4">
                    <div class="col-lg-6">
                        <label class="form-label text-slate-700 fw-bold">شرکت بیمه‌گر</label>
                        <div class="relative">
                            <i class="ti ti-building absolute top-1/2 left-3 transform -translate-y-1/2 text-slate-400"></i>
                            <select class="form-select ps-10 py-2 rounded-2xl border-slate-200 focus:border-cyan-500" wire:model="company_id">
                                <option value="">انتخاب کنید...</option>
                                @foreach($companies as $c)
                                    <option value="{{ $c->id }}">{{ $c->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        @error('company_id') <div class="text-rose-600 text-sm mt-1">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-lg-3">
                        <label class="form-label text-slate-700 fw-bold">تاریخ شروع</label>
                        <div class="relative">
                            <i class="ti ti-calendar-plus absolute top-1/2 left-3 transform -translate-y-1/2 text-slate-400"></i>
                            <input type="date" class="form-control ps-10 py-2 rounded-2xl" wire:model="start_date">
                        </div>
                        @if($start_date)
                            <div class="mt-1 text-sm text-emerald-600">
                                <i class="ti ti-calendar me-1"></i> شمسی: <span class="fw-semibold">{{ $this->getPersianDate($start_date) }}</span>
                            </div>
                        @endif
                        @error('start_date') <div class="text-rose-600 text-sm mt-1">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-lg-3">
                        <label class="form-label text-slate-700 fw-bold">تاریخ پایان</label>
                        <div class="relative">
                            <i class="ti ti-calendar-minus absolute top-1/2 left-3 transform -translate-y-1/2 text-slate-400"></i>
                            <input type="date" class="form-control ps-10 py-2 rounded-2xl" wire:model="end_date">
                        </div>
                        @if($end_date)
                            <div class="mt-1 text-sm text-rose-600">
                                <i class="ti ti-calendar me-1"></i> شمسی: <span class="fw-semibold">{{ $this->getPersianDate($end_date) }}</span>
                            </div>
                        @endif
                        @error('end_date') <div class="text-rose-600 text-sm mt-1">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-12">
                        <label class="form-label text-slate-700 fw-bold">مدت پوشش (روز)</label>
                        <div class="relative">
                            <i class="ti ti-hourglass absolute top-1/2 left-3 transform -translate-y-1/2 text-slate-400"></i>
                            <input type="number" min="1" class="form-control ps-10 py-2 rounded-2xl" wire:model="execution_duration" placeholder="مثال: 365">
                        </div>
                        @error('execution_duration') <div class="text-rose-600 text-sm mt-1">{{ $message }}</div> @enderror
                    </div>

                    {{-- 📎 پیوست‌ها --}}
                    <div class="col-12">
                        <label class="form-label text-slate-700 fw-bold d-flex align-items-center gap-2">
                            <i class="ti ti-paperclip"></i>
                            مدارک پیوست (حداکثر 5 فایل — PDF, JPG, PNG)
                        </label>
                        <div class="border-2 border-dashed border-slate-300 rounded-3xl p-4 text-center hover:bg-slate-50 transition-colors cursor-pointer"
                             x-on:click="$refs.fileInput.click()"
                        >
                            <i class="ti ti-cloud-upload fs-2 text-slate-400 mb-2"></i>
                            <p class="text-slate-600 mb-1">فایل‌های خود را اینجا بکشید یا کلیک کنید</p>
                            <input type="file" class="d-none" wire:model="newAttachments" x-ref="fileInput" multiple>
                        </div>
                        @error('newAttachments.*') <div class="text-rose-600 text-sm mt-1">{{ $message }}</div> @enderror

                        {{-- نمایش فایل‌های جدید --}}
                        @if(count($newAttachments))
                            <div class="mt-3 d-flex flex-wrap gap-2">
                                @foreach($newAttachments as $key => $file)
                                    <div class="badge bg-cyan-100 text-cyan-800 d-flex align-items-center gap-2 py-2 px-3 rounded-2xl">
                                        <i class="ti ti-file fs-5"></i>
                                        <span>{{ \Illuminate\Support\Str::limit($file->getClientOriginalName(), 15) }}</span>
                                        <button type="button" class="btn-close btn-close-xs" wire:click="removeNewAttachment({{ $key }})" aria-label="حذف"></button>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        {{-- نمایش فایل‌های موجود (در حالت ویرایش) --}}
                        @if($editing && $currentAttachments->isNotEmpty())
                            <div class="mt-3">
                                <p class="text-slate-600 fw-medium mb-2">مدارک فعلی:</p>
                                <div class="d-flex flex-wrap gap-2">
                                    @foreach($currentAttachments as $att)
                                        @if(!in_array($att->id, $deletedAttachmentIds))
                                            <div class="badge bg-slate-200 text-slate-800 d-flex align-items-center gap-2 py-2 px-3 rounded-2xl">
                                                <i class="ti ti-file fs-5"></i>
                                                <span>{{ \Illuminate\Support\Str::limit($att->file_name, 15) }}</span>
                                                <button type="button" class="btn-close btn-close-xs" wire:click="removeExistingAttachment({{ $att->id }})" aria-label="حذف"></button>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="mt-5 d-flex gap-2 justify-content-end">
                    @if($editing)
                        <button type="button" class="btn btn-outline-slate-500 px-4 py-2 rounded-2xl" wire:click="resetForm">
                            <i class="ti ti-x me-1"></i> انصراف
                        </button>
                    @endif
                    <button type="submit" class="btn btn-cyan-600 px-5 py-2 rounded-2xl d-flex align-items-center gap-2">
                        <span wire:loading.remove>
                            <i class="ti ti-device-floppy me-1"></i>
                            {{ $editing ? 'به‌روزرسانی' : 'ذخیره بیمه' }}
                        </span>
                        <span wire:loading class="d-flex align-items-center">
                            <span class="spinner-border spinner-border-sm me-1" role="status"></span>
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    {{-- 📋 تاریخچه بیمه‌ها --}}
    @if($insurances->isNotEmpty())
        <div class="card bg-white border-0 shadow-lg rounded-3xl overflow-hidden">
            <div class="card-header bg-gradient-to-r from-slate-700 to-slate-800 text-white p-4">
                <h4 class="mb-0 d-flex align-items-center gap-2">
                    <i class="ti ti-history fs-4"></i>
                    تاریخچه بیمه‌های ثبت‌شده
                </h4>
            </div>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-slate-800 text-white">
                    <tr>
                        <th class="py-3 px-4">شرکت</th>
                        <th class="py-3">شروع (شمسی)</th>
                        <th class="py-3">پایان (شمسی)</th>
                        <th class="py-3">مدت (روز)</th>
                        <th class="py-3 text-center">مدارک</th>
                        <th class="py-3 text-end px-4">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($insurances as $ins)
                        <tr class="hover:bg-slate-50/70">
                            <td class="px-4 fw-semibold text-slate-800">{{ $ins->company->name ?? '—' }}</td>
                            <td class="text-emerald-600">{{ $this->getPersianDate($ins->start_date) }}</td>
                            <td class="text-rose-600">{{ $this->getPersianDate($ins->end_date) }}</td>
                            <td>{{ $ins->execution_duration ? number_format($ins->execution_duration) : '—' }}</td>
                            <td class="text-center">
                                @if($ins->attachments->count())
                                    <button class="btn btn-sm btn-soft-cyan rounded-pill px-3"
                                            x-on:click="showModal = true; attachments = {{ json_encode($ins->attachments->map(fn($a) => [
                                                    'id' => $a->id,
                                                    'name' => $a->file_name,
                                                    'url' => Storage::disk('public')->url($a->file_path),
                                                    'size' => $a->file_size ? number_format($a->file_size / 1024, 1).' KB' : '—',
                                                    'is_image' => in_array(pathinfo($a->file_path, PATHINFO_EXTENSION), ['jpg','jpeg','png'])
                                                ])) }}; modalTitle = 'پیوست‌های بیمه: {{ $ins->company->name ?? '—' }}'"
                                    >
                                        <i class="ti ti-files me-1"></i> {{ $ins->attachments->count() }}
                                    </button>
                                @else
                                    <span class="text-slate-400">—</span>
                                @endif
                            </td>
                            <td class="text-end px-4">
                                <div class="d-flex gap-1 justify-content-end">
                                    <button class="btn btn-sm btn-soft-cyan rounded-circle p-2"
                                            wire:click="editInsurance({{ $ins->id }})"
                                            title="ویرایش">
                                        <i class="ti ti-edit fs-5"></i>
                                    </button>
                                    <button class="btn btn-sm btn-soft-rose rounded-circle p-2"
                                            wire:click="deleteInsurance({{ $ins->id }})"
                                            wire:confirm="آیا از حذف بیمه «{{ $ins->company->name ?? '—' }}» مطمئن هستید؟"
                                            title="حذف">
                                        <i class="ti ti-trash fs-5"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif

    {{-- 📎 مودال نمایش پیوست‌ها — بدون wire:ignore، فقط با Alpine.js --}}
    <div x-show="showModal"
         x-cloak
         class="fixed inset-0 z-50 overflow-y-auto bg-black/50 flex items-center justify-center p-4"
         x-on:click.self="showModal = false"
    >
        <div class="bg-white rounded-3xl shadow-2xl w-full max-w-3xl max-h-[90vh] overflow-hidden"
             x-on:click.away="showModal = false"
        >
            <div class="modal-header bg-gradient-to-r from-cyan-600 to-cyan-800 text-white p-5">
                <h5 class="modal-title fw-bold d-flex align-items-center gap-2">
                    <i class="ti ti-paperclip fs-4"></i>
                    <span x-text="modalTitle"></span>
                </h5>
                <button type="button" class="btn-close btn-close-white opacity-80 hover:opacity-100" @click="showModal = false"></button>
            </div>
            <div class="modal-body p-0">
                <div class="max-h-[60vh] overflow-y-auto">
                    <template x-if="attachments.length === 0">
                        <div class="p-5 text-center text-slate-500">
                            <i class="ti ti-file-off fs-2 d-block mb-2"></i>
                            <p>پیوستی برای نمایش وجود ندارد.</p>
                        </div>
                    </template>
                    <div class="p-4 space-y-3" x-show="attachments.length > 0">
                        <template x-for="att in attachments" :key="att.id">
                            <div class="border border-slate-200 rounded-2xl p-4 hover:bg-slate-50 transition-colors">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-cyan-100 text-cyan-700 d-flex align-items-center justify-content-center">
                                            <i class="ti ti-file fs-5"></i>
                                        </div>
                                        <div>
                                            <div class="fw-semibold text-slate-800" x-text="att.name"></div>
                                            <div class="text-sm text-slate-500" x-text="att.size"></div>
                                        </div>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <!-- Preview for images -->
                                        <template x-if="att.is_image">
                                            <a :href="att.url" target="_blank" class="btn btn-sm btn-outline-cyan rounded-2xl">
                                                <i class="ti ti-eye me-1"></i> پیش‌نمایش
                                            </a>
                                        </template>
                                        <a :href="att.url" target="_blank" class="btn btn-sm btn-cyan-600 text-white rounded-2xl d-flex align-items-center gap-1">
                                            <i class="ti ti-download"></i> دانلود
                                        </a>
                                        <button class="btn btn-sm btn-outline-slate-400 rounded-2xl"
                                                title="کپی لینک"
                                                x-on:click="$clipboard(att.url); $notify('لینک کپی شد.')"
                                        >
                                            <i class="ti ti-link"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
            <div class="modal-footer p-4 bg-slate-50 border-top d-flex justify-content-end">
                <button class="btn btn-outline-slate-500 px-4 py-2 rounded-2xl" @click="showModal = false">
                    بستن
                </button>
            </div>
        </div>
    </div>

    <style>
        :root {
            --cyan-500: #06b6d4;
            --cyan-600: #0891b2;
            --rose-500: #f43f5e;
            --emerald-500: #10b981;
        }

        .btn-soft-cyan {
            background-color: rgba(6, 182, 212, 0.1);
            color: var(--cyan-600);
            border: none;
        }
        .btn-soft-cyan:hover {
            background-color: rgba(6, 182, 212, 0.2);
            transform: scale(1.05);
        }
        .btn-soft-rose {
            background-color: rgba(244, 63, 94, 0.1);
            color: var(--rose-500);
            border: none;
        }
        .btn-soft-rose:hover {
            background-color: rgba(244, 63, 94, 0.2);
            transform: scale(1.05);
        }
        .btn-cyan-600 {
            background: linear-gradient(90deg, #0891b2, #0e7490);
            color: white;
            border: none;
        }
        .bg-gradient-primary {
            background: linear-gradient(90deg, #4361ee, #3a0ca3);
        }

        [x-cloak] { display: none !important; }
    </style>

    @push('scripts')
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('clipboard', () => ({
                    $clipboard(text) {
                        navigator.clipboard.writeText(text).then(() => {
                            this.$notify('لینک کپی شد.');
                        });
                    },
                    $notify(message) {
                        const toast = document.createElement('div');
                        toast.innerHTML = `<div class="fixed bottom-4 right-4 bg-emerald-500 text-white rounded-xl px-4 py-2 shadow-lg">${message}</div>`;
                        document.body.appendChild(toast);
                        setTimeout(() => toast.remove(), 2000);
                    }
                }));
            });
        </script>
    @endpush
</div>
