<div class="container-fluid py-4" dir="rtl" style="font-family: 'Vazirmatn', sans-serif; background: #f8fafc; min-height: 100vh;">
    <style>
        :root { --p-indigo: #4f46e5; --p-slate: #1e293b; --p-emerald: #10b981; --p-border: #e2e8f0; }

        .reveal-up { animation: fadeInUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) both; }
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }

        /* ✨ کارت‌های شیشه‌ای مدرن */
        .lux-card {
            background: rgba(255, 255, 255, 0.9); backdrop-filter: blur(10px);
            border-radius: 28px; border: 1px solid var(--p-border);
            box-shadow: 0 10px 30px -10px rgba(0,0,0,0.04); transition: 0.4s;
        }
        .lux-card:hover { transform: translateY(-5px); box-shadow: 0 20px 40px -10px rgba(79, 70, 229, 0.1); border-color: var(--p-indigo); }

        /* 📊 استایل آمار Bento */
        .bento-stat { padding: 25px; border-radius: 24px; position: relative; overflow: hidden; border: 1px solid var(--p-border); }
        .stat-icon { position: absolute; left: -10px; bottom: -10px; font-size: 5rem; opacity: 0.08; transform: rotate(-15deg); }

        /* 📋 جدول مهندسی شده */
        .lux-table thead th { background: #f1f5f9; color: #64748b; font-weight: 800; font-size: 0.75rem; letter-spacing: 0.5px; padding: 18px 15px; border: none; }
        .lux-table tbody tr { border-bottom: 1px solid #f1f5f9; transition: 0.2s; }
        .lux-table tbody tr:hover { background: rgba(79, 70, 229, 0.02); }

        /* 🔘 منوی عملیات لوکس */
        .dropdown-menu-lux { border-radius: 20px; border: none; box-shadow: 0 15px 50px rgba(0,0,0,0.15); padding: 12px; min-width: 250px; }
        .dropdown-item-lux { border-radius: 12px; padding: 10px 15px; font-weight: 600; color: #475569; transition: 0.2s; display: flex; align-items: center; gap: 10px; }
        .dropdown-item-lux:hover { background: #f5f7ff; color: var(--p-indigo); }
        .dropdown-header-lux { font-size: 0.7rem; font-weight: 800; color: #94a3b8; text-transform: uppercase; letter-spacing: 1px; padding: 10px 15px; margin-top: 5px; }

        /* 🟢 وضعیت فعال با Glow */
        .status-glow { width: 10px; height: 10px; border-radius: 50%; display: inline-block; position: relative; }
        .status-glow.active { background: var(--p-emerald); box-shadow: 0 0 10px var(--p-emerald); }
        .status-glow.inactive { background: #94a3b8; }
    </style>

    <div class="sticky-top z-10 bg-white border-bottom mb-4 p-3 rounded-4 shadow-sm reveal-up">
        <div class="d-flex justify-content-between align-items-center">
            <div class="d-flex align-items-center gap-4">
                <div class="p-2 bg-indigo-subtle rounded-3 text-primary"><i class="ti ti-layers-intersect fs-3"></i></div>
                <div>
                    <h4 class="fw-black m-0 text-slate-900">مدیریت پورتفولیو پروژه‌ها</h4>
                    <p class="text-muted small m-0 fw-bold">نظارت بر جریان‌های کاری و بودجه عملیاتی</p>
                </div>
            </div>
            <div class="d-flex align-items-center gap-2">
                <div class="d-flex bg-light p-1 rounded-3 gap-1 me-3 border">
                    <div wire:click="setViewMode('table')" class="btn {{ $viewMode == 'table' ? 'bg-white shadow-sm border-0' : 'btn-light border-0' }} btn-sm rounded-2"><i class="ti ti-layout-list"></i></div>
                    <div wire:click="setViewMode('grid')" class="btn {{ $viewMode == 'grid' ? 'bg-white shadow-sm border-0' : 'btn-light border-0' }} btn-sm rounded-2"><i class="ti ti-layout-grid"></i></div>
                </div>
                <a href="{{ route('projects.createOrRename', 0) }}" class="btn btn-primary rounded-pill px-4 fw-black shadow-lg" wire:navigate>
                    <i class="ti ti-plus me-1"></i> تعریف پروژه جدید
                </a>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-5 reveal-up" style="animation-delay: 0.1s">
        <div class="col-md-3">
            <div class="bento-stat bg-white shadow-sm">
                <span class="text-muted small fw-bold">کل پروژه‌های ثبت شده</span>
                <h2 class="fw-black mt-2 mb-0 text-dark">{{ $this->stats['total'] }}</h2>
                <i class="ti ti-folders stat-icon text-primary"></i>
            </div>
        </div>
        <div class="col-md-3">
            <div class="bento-stat bg-white shadow-sm">
                <span class="text-muted small fw-bold">واحدهای فعال عملیاتی</span>
                <h2 class="fw-black mt-2 mb-0 text-success">{{ $this->stats['active'] }}</h2>
                <i class="ti ti-activity stat-icon text-success"></i>
            </div>
        </div>
        <div class="col-md-6 text-end">
            <div class="bento-stat bg-dark text-white shadow-lg border-0">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <span class="opacity-60 small fw-bold">مجموع بودجه تخصیصی (Budget Cap)</span>
                        <h2 class="fw-black mt-2 mb-0">{{ number_format($this->stats['total_budget']) }} <small class="fs-6 opacity-50">ریال</small></h2>
                    </div>
                    <div class="p-3 bg-white bg-opacity-10 rounded-4"><i class="ti ti-coin fs-1 text-primary"></i></div>
                </div>
                <i class="ti ti-chart-dots stat-icon text-white"></i>
            </div>
        </div>
    </div>

    <div class="input-group input-group-lg border-0 shadow-sm rounded-pill overflow-hidden mb-5 bg-white px-3 reveal-up" style="animation-delay: 0.2s">
        <span class="input-group-text bg-transparent border-0 text-muted"><i class="ti ti-search fs-4"></i></span>
        <input type="text" wire:model.live.debounce.400ms="search" class="form-control border-0 py-3 text-end" placeholder="جستجو در نام، کدینگ پروژه یا فازها...">
    </div>

    @if($viewMode == 'table')
        <div class="lux-card overflow-hidden border-0 shadow-sm reveal-up" style="animation-delay: 0.3s">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0 lux-table">
                    <thead>
                    <tr class="text-end">
                        <th class="ps-5 py-4">شناسنامه پروژه</th>
                        <th>کدینگ</th>
                        <th>وضعیت ساختار</th>
                        <th>تیم فنی</th>
                        <th>تاریخ ایجاد</th>
                        <th class="text-center">مدیریت و ابزارها</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($this->projects as $project)
                        <tr class="text-end" wire:key="p-row-{{ $project->id }}">
                            <td class="ps-5">
                                <div class="d-flex align-items-center gap-3 flex-row-reverse">
                                    <span class="status-glow {{ $project->is_active ? 'active' : 'inactive' }}"></span>
                                    <div>
                                        <a href="{{ route('single.project.dashboard', $project->id) }}" class="fw-black text-dark text-decoration-none d-block fs-6 hover-text-primary">
                                            {{ $project->name }}
                                        </a>
                                        <small class="text-muted fw-bold">مرکز هزینه اصلی</small>
                                    </div>
                                </div>
                            </td>
                            <td><span class="badge bg-light text-dark border font-monospace fw-bold">{{ $project->code ?? 'N/A' }}</span></td>
                            <td>
                                <div class="d-flex gap-2 justify-content-end">
                                    <span class="badge bg-info-subtle text-info rounded-pill px-3">{{ $project->sections_count }} فاز</span>
                                    <span class="badge bg-primary-subtle text-primary rounded-pill px-3">{{ $project->purchase_requests_count }} سفارش</span>
                                </div>
                            </td>
                            <td><span class="small fw-black text-muted"><i class="ti ti-users me-1"></i> {{ $project->members_count }} نفر</span></td>
                            <td><span class="small text-muted fw-bold">{{ jdate($project->created_at)->format('%d %B %Y') }}</span></td>
                            <td class="text-center">
                                <div class="dropdown">
                                    <button class="btn btn-icon-light rounded-circle shadow-xs" data-bs-toggle="dropdown"><i class="ti ti-dots-vertical"></i></button>
                                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-lux text-end border-0 shadow-lg">
                                        <li><a class="dropdown-item dropdown-item-lux text-primary" href="{{ route('single.project.dashboard', $project) }}" wire:navigate><i class="ti ti-layout-dashboard"></i> داشبورد مدیریتی</a></li>
                                        <li><hr class="dropdown-divider opacity-50"></li>

                                        <div class="dropdown-header-lux">مدیریت مالی و قراردادی</div>
                                        <li><a class="dropdown-item dropdown-item-lux" href="{{ route('projects.details', $project->id) }}"><i class="ti ti-forms"></i> قرارداد و مشتری</a></li>
                                        <li><a class="dropdown-item dropdown-item-lux" href="{{ route('projects.contract', $project->id) }}"><i class="ti ti-currency-rial"></i> بودجه و هزینه</a></li>
                                        <li><a class="dropdown-item dropdown-item-lux" href="{{ route('admin.create.insurance.detail', $project->id) }}"><i class="ti ti-shield"></i> بیمه‌نامه‌ها</a></li>
                                        <li><a class="dropdown-item dropdown-item-lux" href="{{ route('admin.create.project.schedule', $project->id) }}"><i class="ti ti-calendar"></i> زمان‌بندی و مهلت‌ها</a></li>

                                        <div class="dropdown-header-lux">مهندسی و اسناد (MDR)</div>
                                        <li><a class="dropdown-item dropdown-item-lux" href="{{ route('projects.section', $project->id) }}"><i class="ti ti-list-check"></i> مدیریت فازهای اجرایی</a></li>
                                        <li><a class="dropdown-item dropdown-item-lux" href="{{ route('mdr.list', $project->id) }}"><i class="ti ti-file-text"></i> لیست مدارک فنی</a></li>
                                        <li><a class="dropdown-item dropdown-item-lux" href="{{ route('transmittal.create', $project->id) }}"><i class="ti ti-paper-plane"></i> ایجاد ترنسمیتال</a></li>
                                        <li><a class="dropdown-item dropdown-item-lux" href="{{ route('admin.project.members', $project->id) }}"><i class="ti ti-users"></i> مدیریت اعضای تیم</a></li>

                                        <li><hr class="dropdown-divider opacity-50"></li>
                                        <li><a class="dropdown-item dropdown-item-lux text-warning" href="{{ route('projects.createOrRename', $project->id) }}"><i class="ti ti-edit"></i> ویرایش شناسنامه</a></li>
                                        <li><a class="dropdown-item dropdown-item-lux text-danger" href="#" wire:click="deleteProject({{ $project->id }})" wire:confirm="آیا از حذف کامل پروژه و تمامی وابستگی‌ها اطمینان دارید؟"><i class="ti ti-trash"></i> حذف کامل پروژه</a></li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="row g-4 reveal-up">
            @foreach($this->projects as $project)
                <div class="col-xl-4 col-md-6" wire:key="p-card-{{ $project->id }}">
                    <div class="lux-card p-4 d-flex flex-column h-100 text-end">
                        <div class="d-flex justify-content-between align-items-start mb-4">
                            <div class="dropdown">
                                <button class="btn btn-icon-light rounded-circle shadow-xs" data-bs-toggle="dropdown"><i class="ti ti-dots"></i></button>
                            </div>
                            <div class="p-3 bg-indigo-soft rounded-4 text-primary shadow-sm">
                                <i class="ti ti-folder fs-1"></i>
                            </div>
                        </div>

                        <h5 class="fw-black text-dark mb-1">{{ $project->name }}</h5>
                        <div class="badge bg-light text-muted font-monospace w-fit ms-auto mb-4 border">{{ $project->code }}</div>

                        <div class="row g-2 mb-4">
                            <div class="col-4">
                                <div class="p-2 bg-light rounded-3 text-center border">
                                    <small class="text-muted d-block fw-bold">فازها</small>
                                    <span class="fw-black">{{ $project->sections_count }}</span>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="p-2 bg-light rounded-3 text-center border">
                                    <small class="text-muted d-block fw-bold">اعضا</small>
                                    <span class="fw-black">{{ $project->members_count }}</span>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="p-2 bg-light rounded-3 text-center border">
                                    <small class="text-muted d-block fw-bold">سفارشات</small>
                                    <span class="fw-black text-primary">{{ $project->purchase_requests_count }}</span>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex gap-2 mt-auto pt-3 border-top">
                            <a href="{{ route('single.project.dashboard', $project->id) }}" class="btn btn-primary rounded-pill flex-grow-1 fw-black shadow-sm">ورود به داشبورد پروژه</a>
                            <button wire:click="openAddSectionModal({{ $project->id }}, '{{ $project->name }}')" class="btn btn-outline-primary rounded-pill px-3" title="افزودن فاز اجرایی"><i class="ti ti-plus"></i></button>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif

    <div class="mt-5 d-flex justify-content-center">{{ $this->projects->links() }}</div>
</div>
