<div>
    <div class="container py-4">
        @if(session()->has('success') || session()->has('error'))
            <div class="alert {{ session()->has('success') ? 'alert-success' : 'alert-danger' }} rounded-4 shadow-sm mb-4" role="alert">
                <i class="ti ti-{{ session()->has('success') ? 'check-circle' : 'alert-triangle' }} me-2"></i>
                <span class="fw-semibold">{{ session('success') ?? session('error') }}</span>
            </div>
        @endif

        <div class="card shadow-lg border-0 rounded-4">
            <div class="card-header bg-dark-deep text-white rounded-top-4 p-4">
                <h4 class="fw-bold mb-0">
                    <i class="ti ti-handshake me-2"></i> تعیین طرفین قرارداد و مسئولین اصلی
                </h4>
            </div>
            <div class="card-body p-5">

                <form wire:submit.prevent="saveContractRoles">
                    <div class="row g-5">

                        <div class="col-md-6 border-end">
                            <h5 class="fw-bold text-action-primary mb-4 border-bottom pb-2">
                                <i class="ti ti-users me-2"></i> کارفرما و مشاور
                            </h5>

                            <div class="mb-5 pb-3 border-bottom">
                                <label class="form-label fw-bold text-primary-dark fs-5">کارفرمای اصلی</label>
                                <div class="mb-3">
                                    <select wire:model.live="main_client_id" class="form-select form-select-lg rounded-pill @error('main_client_id') is-invalid @enderror">
                                        <option value="">انتخاب شرکت...</option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('main_client_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="mt-3">
                                    <label class="form-label fw-medium small text-muted">مسئول تماس از طرف کارفرما</label>
                                    <select wire:model.defer="main_client_user_id" class="form-select rounded-pill" @disabled(!$main_client_id)>
                                        <option value="">انتخاب کاربر (عضو شرکت)...</option>
                                        @foreach($mainClientUsers as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('main_client_user_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <div class="mb-4">
                                <label class="form-label fw-bold text-primary-dark fs-5">مشاور پروژه</label>
                                <div class="mb-3">
                                    <select wire:model.live="consultant_id" class="form-select form-select-lg rounded-pill @error('consultant_id') is-invalid @enderror">
                                        <option value="">انتخاب شرکت...</option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('consultant_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="mt-3">
                                    <label class="form-label fw-medium small text-muted">مسئول تماس از طرف مشاور</label>
                                    <select wire:model.defer="consultant_user_id" class="form-select rounded-pill" @disabled(!$consultant_id)>
                                        <option value="">انتخاب کاربر (عضو شرکت)...</option>
                                        @foreach($consultantUsers as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('consultant_user_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <h5 class="fw-bold text-danger-custom mb-4 border-bottom pb-2">
                                <i class="ti ti-hammer me-2"></i> پیمانکاران و سایر طرفین
                            </h5>

                            <div class="mb-5 pb-3 border-bottom">
                                <label class="form-label fw-bold text-primary-dark fs-5">پیمانکار اصلی</label>
                                <div class="mb-3">
                                    <select wire:model.live="contractor_id" class="form-select form-select-lg rounded-pill @error('contractor_id') is-invalid @enderror">
                                        <option value="">انتخاب شرکت...</option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('contractor_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="mt-3">
                                    <label class="form-label fw-medium small text-muted">مسئول تماس از طرف پیمانکار</label>
                                    <select wire:model.defer="contractor_user_id" class="form-select rounded-pill" @disabled(!$contractor_id)>
                                        <option value="">انتخاب کاربر (عضو شرکت)...</option>
                                        @foreach($contractorUsers as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('contractor_user_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <div class="mb-4">
                                <label class="form-label fw-bold text-primary-dark fs-5">کارفرمای فرعی (اختیاری)</label>
                                <div class="mb-3">
                                    <select wire:model.live="sub_client_id" class="form-select form-select-lg rounded-pill @error('sub_client_id') is-invalid @enderror">
                                        <option value="">انتخاب شرکت...</option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('sub_client_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="mt-3">
                                    <label class="form-label fw-medium small text-muted">مسئول تماس از طرف کارفرمای فرعی</label>
                                    <select wire:model.defer="sub_client_user_id" class="form-select rounded-pill" @disabled(!$sub_client_id)>
                                        <option value="">انتخاب کاربر (عضو شرکت)...</option>
                                        @foreach($subClientUsers as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('sub_client_user_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end pt-4 border-top mt-4">
                        <button type="submit" class="btn btn-action-primary fw-bold rounded-pill px-5 py-2">
                            <span wire:loading.remove><i class="ti ti-device-floppy me-2"></i> ذخیره نقش‌های قراردادی</span>
                            <span wire:loading><span class="spinner-border spinner-border-sm me-2"></span> در حال ذخیره...</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <style>
        /* Custom Styles */
        .bg-dark-deep { background-color: #1A2538 !important; }
        .text-action-primary { color: #4361EE !important; }
        .text-danger-custom { color: #e74c3c !important; }
        .text-primary-dark { color: #1A2538 !important; }

        .card-header {
            background-color: #1A2538 !important;
        }

        .form-select-lg {
            padding: 0.75rem 1.5rem;
        }
        .btn-action-primary {
            background-color: #4361EE !important;
            border-color: #4361EE;
        }
        .btn-action-primary:hover {
            background-color: #3A4FCD !important;
        }
    </style>

</div>
