<div class="container-fluid py-5 px-3 px-lg-5 dashboard-wrapper overflow-visible">

    {{-- هدر استراتژیک با طراحی لوکس --}}
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-5 gap-4 animate-fade-in header-glass-container p-4 shadow-sm border-0">
        <div class="d-flex align-items-center gap-4">
            <div class="brand-logo-sq shadow-sm">
                <i class="ti ti-chart-dots fs-1"></i>
            </div>
            <div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-1 smaller tracking-wider fw-black text-uppercase">
                        <li class="breadcrumb-item text-muted">سامانه مرکزی</li>
                        <li class="breadcrumb-item active text-emerald">مرکز عملیات</li>
                    </ol>
                </nav>
                <h1 class="fw-black text-dark mb-0 h2 letter-spacing-n1">میز کار مدیریت پروژه‌ها</h1>
                <div class="d-flex align-items-center gap-3 mt-1">
                    <div class="d-flex align-items-center gap-2">
                        <span class="status-dot-pulse-emerald"></span>
                        <p class="text-secondary smaller fw-bold mb-0">سیستم آماده به کار</p>
                    </div>
                    <span class="v-divider"></span>
                    <p class="text-secondary smaller fw-bold mb-0">{{ number_format($this->projects->total()) }} پروژه در پایگاه داده</p>
                </div>
            </div>
        </div>
        <div class="d-flex gap-3 align-items-center">
            <div class="date-capsule d-none d-lg-flex shadow-sm border bg-white">
                <div class="date-icon shadow-xs"><i class="ti ti-calendar-event"></i></div>
                <div class="date-text fw-black text-dark">{{ jdate()->format('%A، %d %B %Y') }}</div>
            </div>
            <button class="btn-refresh-circle shadow-sm border bg-white" wire:click="$refresh">
                <i class="ti ti-refresh"></i>
            </button>
        </div>
    </div>

    {{-- کارت‌های آمار بنتو با اصطلاحات فارسی --}}
    <div class="row g-4 mb-5 animate-slide-up">
        @php
            $stats = $this->totalStats;
            $statItems = [
                ['icon'=>'ti ti-stack-2', 'color'=>'#10b981', 'label'=>'مجموع پروژه‌ها', 'value'=>$this->projects->total(), 'trend' => 'بایگانی کل'],
                ['icon'=>'ti ti-hierarchy-2', 'color'=>'#3b82f6', 'label'=>'بخش‌های فعال', 'value'=>$stats['totalSections'], 'trend' => 'گره‌های درختی'],
                ['icon'=>'ti ti-flame', 'color'=>'#f59e0b', 'label'=>'ثبت جدید (ماه)', 'value'=>$stats['newProjects'], 'trend' => 'رشد دوره‌ای'],
                ['icon'=>'ti ti-shopping-cart-bolt', 'color'=>'#f43f5e', 'label'=>'درخواست خرید', 'value'=>$stats['totalPurchaseRequests'], 'trend' => 'لجستیک فعال']
            ];
        @endphp
        @foreach($statItems as $stat)
            <div class="col-6 col-xl-3">
                <div class="premium-stat-card border-0 h-100 shadow-sm">
                    <div class="p-4">
                        <div class="d-flex justify-content-between mb-3">
                            <div class="p-icon shadow-xs" style="color: {{ $stat['color'] }}; background: {{ $stat['color'] }}12">
                                <i class="{{ $stat['icon'] }}"></i>
                            </div>
                            <span class="smaller fw-black text-muted opacity-50">{{ $stat['trend'] }}</span>
                        </div>
                        <h2 class="stat-value-v2 mb-1">{{ number_format($stat['value']) }}</h2>
                        <span class="stat-label-v2">{{ $stat['label'] }}</span>
                    </div>
                    <div class="bottom-progress" style="background: linear-gradient(90deg, {{ $stat['color'] }} 0%, {{ $stat['color'] }}33 100%)"></div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="row overflow-visible justify-content-center">
        {{-- لیست پروژه‌ها (عریض شده) --}}
        <div class="col-xl-11 col-12 overflow-visible">
            <div class="d-flex flex-wrap gap-3 mb-4 align-items-center">
                <div class="search-box-v2 flex-grow-1 shadow-sm rounded-4 bg-white border px-3 d-flex align-items-center border-2 transition-all">
                    <i class="ti ti-search fs-4 text-muted"></i>
                    <input type="text" wire:model.live.debounce.400ms="search" class="form-control border-0 bg-transparent py-3 fw-bold" placeholder="جستجوی هوشمند در پروژه‌ها (نام، کد یا پارامتر فنی)...">
                </div>
                <a href="{{ route('projects.createOrRename', ['projectId' => 0]) }}" wire:navigate class="btn-neo-primary shadow-lg">
                    <i class="ti ti-plus"></i> ایجاد پروژه جدید
                </a>
            </div>

            <div class="project-list-container overflow-visible">
                @forelse($this->projects as $project)
                    <div class="project-row-premium animate-slide-up bg-white shadow-sm border rounded-5 mb-4 position-relative overflow-visible">
                        <div class="p-4 d-flex align-items-center flex-wrap gap-4 position-relative z-1">
                            <div class="project-icon-sq shadow-xs">
                                <span class="fw-black text-emerald">{{ mb_substr($project->name, 0, 1) }}</span>
                            </div>

                            <div class="flex-grow-1">
                                <div class="d-flex align-items-center gap-3 mb-1">
                                    <h5 class="mb-0 fw-black">
                                        <a href="{{ route('single.project.dashboard', ['project' => $project->id]) }}" wire:navigate class="text-dark text-decoration-none hover-emerald transition-all">
                                            {{ $project->name }}
                                        </a>
                                    </h5>
                                    <span class="project-id-badge">{{ $project->code }}</span>
                                </div>
                                <div class="d-flex gap-3 smaller text-muted fw-bold">
                                    <span class="d-flex align-items-center gap-1"><i class="ti ti-calendar-plus opacity-50"></i>تاریخ ثبت: {{ jdate($project->created_at)->format('Y/m/d') }}</span>
                                    <span class="v-divider"></span>
                                    <span class="d-flex align-items-center gap-1 text-emerald"><i class="ti ti-circle-check-filled opacity-50"></i>وضعیت: فعال</span>
                                </div>
                            </div>

                            <div class="dropdown operation-hub">
                                <button class="btn-hub-trigger shadow-sm border-2" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                                    <i class="ti ti-adjustments-bolt fs-5"></i>
                                </button>

                                <div class="dropdown-menu dropdown-menu-end shadow-2xl border-0 rounded-5 p-0 glass-dark-dropdown animate-pop overflow-hidden">
                                    <div class="hub-header p-4 position-relative">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="hub-avatar">{{ mb_substr($project->name, 0, 1) }}</div>
                                            <div>
                                                <h6 class="text-white fw-black mb-0">پنل مدیریت عملیات</h6>
                                                <small class="text-white-50 smaller tracking-widest uppercase">کد شناسایی: {{ $project->code }}</small>
                                            </div>
                                        </div>
                                        <div class="hub-header-icon"><i class="ti ti-brand-abstract"></i></div>
                                    </div>

                                    <div class="accordion accordion-flush hub-accordion p-2" id="hub-acc-{{ $project->id }}">

                                        {{-- مدیریت (آبی) --}}
                                        <div class="accordion-item bg-transparent">
                                            <h2 class="accordion-header">
                                                <button class="accordion-button collapsed fw-black py-3 px-4 shadow-none text-white-50" type="button" data-bs-toggle="collapse" data-bs-target="#hub1-{{ $project->id }}">
                                                    <i class="ti ti-shield-check me-2 text-primary"></i> تنظیمات و سازماندهی
                                                </button>
                                            </h2>
                                            <div id="hub1-{{ $project->id }}" class="accordion-collapse collapse" data-bs-parent="#hub-acc-{{ $project->id }}">
                                                <div class="accordion-body p-1">
                                                    <a class="hub-link link-blue" href="{{ route('single.project.dashboard', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-layout-dashboard"></i>داشبورد مدیریتی</a>
                                                    <a class="hub-link link-blue" href="{{ route('projects.section', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-list-check"></i>مدیریت بخش‌ها (WBS)</a>
                                                    <a class="hub-link link-blue" href="{{ route('projects.createOrRename', ['projectId' => $project->id]) }}" wire:navigate><i class="ti ti-edit"></i>اصلاح نام و مشخصات</a>
                                                    <a class="hub-link link-blue" href="#" data-bs-toggle="modal" data-bs-target="#addSectionModal" wire:click="openAddSectionModal({{ $project->id }}, '{{ $project->name }}')"><i class="ti ti-plus text-success"></i>افزودن زیرمجموعه</a>
                                                    <a class="hub-link link-blue border-0" href="{{ route('admin.create.insurance.detail', ['projectId' => $project->id]) }}" wire:navigate><i class="ti ti-shield-lock"></i>جزئیات بیمه‌نامه</a>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- مالی (سبز) --}}
                                        <div class="accordion-item bg-transparent">
                                            <h2 class="accordion-header">
                                                <button class="accordion-button collapsed fw-black py-3 px-4 shadow-none text-white-50" type="button" data-bs-toggle="collapse" data-bs-target="#hub2-{{ $project->id }}">
                                                    <i class="ti ti-coin me-2 text-success"></i> امور مالی و تدارکات
                                                </button>
                                            </h2>
                                            <div id="hub2-{{ $project->id }}" class="accordion-collapse collapse" data-bs-parent="#hub-acc-{{ $project->id }}">
                                                <div class="accordion-body p-1">
                                                    <a class="hub-link link-green" href="{{ route('admin.purchase_request', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-shopping-cart"></i>درخواست‌های خرید</a>
                                                    <a class="hub-link link-green" href="{{ route('admin.payment.create', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-cash"></i>درخواست وجه نقد</a>
                                                    <a class="hub-link link-green" href="{{ route('projects.details', ['projectId' => $project->id]) }}" wire:navigate><i class="ti ti-file-certificate text-warning"></i>اطلاعات قرارداد پروژه</a>
                                                    <a class="hub-link link-green border-0" href="{{ route('admin.create.project.schedule', ['projectId' => $project->id]) }}" wire:navigate><i class="ti ti-calendar-time"></i>زمانبندی و مهلت‌ها</a>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- اسناد (نارنجی) --}}
                                        <div class="accordion-item bg-transparent border-0">
                                            <h2 class="accordion-header">
                                                <button class="accordion-button collapsed fw-black py-3 px-4 shadow-none text-white-50" type="button" data-bs-toggle="collapse" data-bs-target="#hub3-{{ $project->id }}">
                                                    <i class="ti ti-mail-forward me-2 text-warning"></i> اسناد و ارتباطات تیم
                                                </button>
                                            </h2>
                                            <div id="hub3-{{ $project->id }}" class="accordion-collapse collapse" data-bs-parent="#hub-acc-{{ $project->id }}">
                                                <div class="accordion-body p-1">
                                                    <a class="hub-link link-orange" href="{{ route('admin.projects.letters.create', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-file-plus"></i>ایجاد نامه جدید</a>
                                                    <a class="hub-link link-orange" href="{{ route('admin.projects.letters.list', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-inbox"></i>لیست نامه‌های ثبت شده</a>
                                                    <a class="hub-link link-orange" href="{{ route('mdr.list', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-file-text"></i>مدارک مهندسی (MDR)</a>
                                                    <a class="hub-link link-orange" href="{{ route('transmittal.create', ['project_id' => $project->id]) }}" wire:navigate><i class="ti ti-send"></i>ارسال ترنسمیتال</a>
                                                    <a class="hub-link link-orange" href="{{ route('admin.project.members', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-users"></i>اعضای تیم اجرایی</a>
                                                    <a class="hub-link link-orange border-0" href="{{ route('admin.project.task.list', ['project' => $project->id]) }}" wire:navigate><i class="ti ti-list-check"></i>تسک‌ها و وقایع</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

{{--                                    <div class="p-3 bg-dark bg-opacity-10 border-top d-flex gap-2">--}}
{{--                                        <button class="btn btn-danger btn-sm rounded-4 flex-grow-1 fw-black py-2 shadow-sm border-0" wire:click="deleteProject({{ $project->id }})" wire:confirm="حذف پروژه غیرقابل بازگشت است.">--}}
{{--                                            <i class="ti ti-trash-x me-1"></i> حذف کامل پروژه--}}
{{--                                        </button>--}}
{{--                                    </div>--}}
                                </div>
                            </div>
                        </div>
                        <div class="premium-progress-wrapper shadow-xs">
                            <div class="premium-progress-bar" style="width: {{ $project->progress ?? 15 }}%"></div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-5 shadow-sm mt-5 border rounded-5 bg-white animate-slide-up">
                        <i class="ti ti-search-off display-1 text-muted opacity-20"></i>
                        <p class="text-muted mt-3 fw-bold fs-5">داده‌ای یافت نشد</p>
                    </div>
                @endforelse
            </div>

            <div class="mt-5 d-flex justify-content-center">
                {{ $this->projects->links() }}
            </div>
        </div>
    </div>

    <style>
        /* --- استایل‌های پلاتینیوم نهایی --- */
        :root {
            --emerald: #10b981;
            --emerald-dark: #064e3b;
            --charcoal: #111827;
            --slate-bg: #f4f7fa;
            --primary-blue: #3b82f6;
            --shadow-2xl: 0 30px 60px -12px rgba(0, 0, 0, 0.35);
            --border-color: #e2e8f0;
        }

        .dashboard-wrapper { background: var(--slate-bg); font-family: 'Vazirmatn', sans-serif; }
        .fw-black { font-weight: 900 !important; }
        .letter-spacing-n1 { letter-spacing: -1px; }

        /* Header UI */
        .header-glass-container { background: rgba(255, 255, 255, 0.95); border-radius: 2rem; border: 1px solid #fff; }
        .brand-logo-sq { width: 64px; height: 64px; background: var(--charcoal); color: #fff; border-radius: 1.5rem; display: flex; align-items: center; justify-content: center; }
        .date-capsule { border-radius: 50px; display: flex; align-items: center; padding: 6px 20px; gap: 12px; }
        .date-icon { width: 34px; height: 34px; background: #fff; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: var(--emerald); border: 1px solid var(--border-color); }
        .v-divider { width: 1px; height: 20px; background: #cbd5e1; }

        /* Premium Stat Cards */
        .premium-stat-card { background: #fff; border-radius: 2.5rem; position: relative; overflow: hidden; transition: 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
        .premium-stat-card:hover { transform: translateY(-10px); box-shadow: 0 20px 40px -10px rgba(0,0,0,0.1); }
        .p-icon { width: 58px; height: 58px; border-radius: 1.5rem; display: flex; align-items: center; justify-content: center; font-size: 1.8rem; }
        .stat-value-v2 { font-weight: 900; font-size: 2.8rem; color: var(--charcoal); letter-spacing: -3px; }
        .stat-label-v2 { font-weight: 800; color: #94a3b8; font-size: 0.8rem; text-transform: uppercase; }

        /* Project Rows */
        .project-row-premium { border-radius: 2.5rem; transition: 0.3s cubic-bezier(0.4, 0, 0.2, 1); z-index: 1; border-color: #fff !important; }
        .project-row-premium:hover { border-color: var(--emerald) !important; transform: translateX(-8px); box-shadow: 0 15px 40px -15px rgba(0,0,0,0.1) !important; z-index: 1000 !important; }
        .project-icon-sq { width: 64px; height: 64px; background: #fff; border-radius: 1.5rem; border: 2px solid var(--border-color); display: flex; align-items: center; justify-content: center; font-size: 1.6rem; }
        .project-id-badge { background: #f1f5f9; border: 1px solid #e2e8f0; padding: 4px 14px; border-radius: 50px; font-size: 0.8rem; font-weight: 900; color: #475569; }
        .premium-progress-wrapper { height: 6px; background: #f1f5f9; border-radius: 0 0 2.5rem 2.5rem; overflow: hidden; }
        .premium-progress-bar { height: 100%; background: linear-gradient(90deg, #10b981 0%, #6ee7b7 100%); }

        /* Hub Dropdown */
        .glass-dark-dropdown {
            width: 380px; background: rgba(15, 23, 42, 0.98) !important; backdrop-filter: blur(40px);
            border: 1px solid rgba(255,255,255,0.15) !important; z-index: 10000 !important;
            box-shadow: var(--shadow-2xl) !important; margin-top: 10px !important;
        }
        .bg-gradient-dark { background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%); border-bottom: 1px solid rgba(255,255,255,0.1); }
        .hub-avatar { width: 45px; height: 45px; background: var(--emerald); color: #fff; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-weight: 900; font-size: 1.2rem; }

        .hub-link { padding: 12px 15px; border-radius: 14px; color: rgba(255,255,255,0.7) !important; font-weight: 700; font-size: 0.85rem; display: flex; align-items: center; transition: 0.3s; text-decoration: none; margin-bottom: 3px; gap: 12px; }

        /* رنگ‌بندی لینک‌ها */
        .link-blue:hover { background: rgba(59, 130, 246, 0.15); color: #60a5fa !important; transform: translateX(-6px); }
        .link-green:hover { background: rgba(16, 185, 129, 0.15); color: #34d399 !important; transform: translateX(-6px); }
        .link-orange:hover { background: rgba(245, 158, 11, 0.15); color: #fbbf24 !important; transform: translateX(-6px); }

        .hub-accordion .accordion-button { background: transparent !important; color: #f8fafc !important; font-weight: 900; font-size: 0.9rem; border-radius: 12px; }
        .hub-accordion .accordion-button:not(.collapsed) { background: rgba(255,255,255,0.03) !important; }
        .hub-accordion .accordion-button::after { filter: invert(1); }
        .hub-header-icon { position: absolute; left: 20px; top: 30px; font-size: 3.5rem; color: rgba(255,255,255,0.03); transform: rotate(-15deg); }

        /* Buttons */
        .btn-neo-primary { background: #0f172a; color: #fff; padding: 14px 35px; border-radius: 1.25rem; font-weight: 900; border: none; transition: 0.3s; }
        .btn-neo-primary:hover { background: var(--emerald); transform: translateY(-3px); box-shadow: 0 10px 20px rgba(16, 185, 129, 0.3); }
        .btn-hub-trigger { width: 48px; height: 48px; border-radius: 1rem; border: 2px solid #e2e8f0; background: #fff; color: #64748b; transition: 0.3s; }
        .btn-hub-trigger:hover { border-color: var(--charcoal); background: var(--charcoal); color: #fff; }
        .btn-refresh-circle { width: 45px; height: 45px; border-radius: 50%; background: #fff; border: 1px solid var(--border-color); color: var(--primary-blue); transition: 0.3s; }
        .btn-refresh-circle:hover { transform: rotate(180deg); background: var(--primary-blue); color: #fff; }

        .status-dot-pulse-emerald { width: 10px; height: 10px; background: var(--emerald); border-radius: 50%; box-shadow: 0 0 0 0 rgba(16, 185, 129, 0.4); animation: pulse-emerald 2s infinite; }
        @keyframes pulse-emerald { 0% { box-shadow: 0 0 0 0 rgba(16, 185, 129, 0.7); } 100% { box-shadow: 0 0 0 12px rgba(16, 185, 129, 0); } }

        /* Animations */
        .animate-fade-in { animation: fadeIn 0.8s ease-out; }
        .animate-slide-up { animation: slideUp 0.7s cubic-bezier(0.23, 1, 0.32, 1); }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        @keyframes slideUp { from { opacity: 0; transform: translateY(40px); } to { opacity: 1; transform: translateY(0); } }
    </style>

    <script>
        document.addEventListener('livewire:initialized', () => {
            const dropdowns = document.querySelectorAll('.operation-hub');
            dropdowns.forEach(el => {
                el.addEventListener('click', (e) => {
                    if (e.target.closest('.accordion-button')) {
                        e.stopPropagation();
                    }
                });
            });
        });
    </script>
</div>
