<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-9">
            <div class="card shadow">
                <div class="card-header bg-primary text-light d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><i class="bi bi-building"></i> فرم پروژه مدرن</h4>
                    <span class="badge bg-light text-primary">واکنش‌گرا و مطمئن</span>
                </div>
                <div class="card-body">

                    @if(session()->has('message'))
                        <div class="alert alert-success"><i class="bi bi-check-circle-fill"></i> {{ session('message') }}</div>
                    @endif
                    @if(session()->has('error'))
                        <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i> {{ session('error') }}</div>
                    @endif

                    <form wire:submit.prevent="save">
                        <div class="row g-3 mb-3">
                            <div class="col-md-4">
                                <label class="form-label">کد پروژه</label>
                                <input type="text" wire:model.defer="project_code" class="form-control"/>
                                @error('project_code') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">کد مالیاتی</label>
                                <input type="text" wire:model.defer="tax_code" class="form-control"/>
                                @error('tax_code') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">وضعیت پروژه</label>
                                <select wire:model.defer="status" class="form-select">
                                    <option value="">انتخاب وضعیت</option>
                                    <option value="شروع نشده">شروع نشده</option>
                                    <option value="در حال اجرا">در حال اجرا</option>
                                    <option value="اتمام">اتمام</option>
                                </select>
                                @error('status') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="row g-3 mb-3">
                            <div class="col-md-6">
                                <label class="form-label">نوع پروژه (انتخاب چندگانه)</label>
                                <select wire:model.defer="project_types" class="form-select" multiple>
                                    @foreach($projectTypes as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                                @error('project_types') <span class="text-danger">{{ $message }}</span> @enderror
                                <div class="mt-2 d-flex flex-wrap gap-1">
                                    <span class="fw-bold">انتخاب شده:</span>
                                    @foreach($project_types as $typeId)
                                        <span class="badge bg-info">{{ $projectTypes->firstWhere('id', $typeId)?->name }}</span>
                                    @endforeach
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">شرکت مدیر پروژه</label>
                                <select wire:model="manager_company_id" class="form-select">
                                    <option value="">انتخاب شرکت</option>
                                    @foreach($companies as $company)
                                        <option value="{{ $company->id }}">{{ $company->name }}</option>
                                    @endforeach
                                </select>
                                @error('manager_company_id') <span class="text-danger">{{ $message }}</span> @enderror

                                <label class="form-label mt-2">دپارتمان مدیر پروژه</label>
                                <select wire:model="manager_department_id" class="form-select">
                                    <option value="">انتخاب دپارتمان</option>
                                    @foreach($managerDepartments as $dept)
                                        <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                                    @endforeach
                                </select>

                                <label class="form-label mt-2">مدیر پروژه</label>
                                <select wire:model="manager_id" class="form-select">
                                    <option value="">انتخاب مدیر</option>
                                    @foreach($managerCandidates as $manager)
                                        <option value="{{ $manager->id }}">{{ $manager->name }}</option>
                                    @endforeach
                                </select>
                                @if($managerCandidates && count($managerCandidates)==0)
                                    <div class="text-warning small mt-1">هیچ مدیر فعالی در این شرکت یا دپارتمان وجود ندارد.</div>
                                @endif
                                @error('manager_id') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="mb-3 border p-2 rounded bg-light">
                            <strong>نقش‌های پروژه</strong>
                            @foreach($roles as $i => $role)
                                <div class="row mb-2 align-items-center" wire:key="role-{{ $i }}">
                                    <div class="col-md-5">
                                        <select wire:model.defer="roles.{{ $i }}.role_type" class="form-select">
                                            <option value="">نقش</option>
                                            <option value="کارفرمای اصلی">کارفرمای اصلی</option>
                                            <option value="کارفرمای فرعی">کارفرمای فرعی</option>
                                            <option value="مشاور">مشاور</option>
                                        </select>
                                    </div>
                                    <div class="col-md-5">
                                        <select wire:model.defer="roles.{{ $i }}.company_id" class="form-select">
                                            <option value="">شرکت</option>
                                            @foreach($companies as $company)
                                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-2 text-center">
                                        <button type="button" wire:click="removeRole({{ $i }})" class="btn btn-outline-danger btn-sm px-3">
                                            حذف <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                            <button type="button" wire:click="addRole" class="btn btn-outline-primary btn-sm mt-2 w-100">
                                <i class="bi bi-plus-circle"></i> افزودن نقش جدید
                            </button>
                            @if($roleDuplicateError)
                                <div class="text-warning mt-2"><i class="bi bi-exclamation-triangle"></i> نقش/شرکت تکراری است.</div>
                            @endif
                        </div>
                        <button type="submit" class="btn btn-success w-100 mt-3" wire:loading.attr="disabled">
                            <span wire:loading.remove>ذخیره</span>
                            <span wire:loading>
                                <span class="spinner-border spinner-border-sm"></span> در حال ذخیره...
                            </span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
