<div class="container-fluid">
    <!-- Success Message -->
    @if(session()->has('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    <!-- Dynamic Roles Section -->
    <form wire:submit.prevent="saveRoles">
        <div class="mb-3">
            <label for="roles" class="form-label">نقش‌ها:</label>
            @foreach($roles as $index => $role)
                <div class="mb-2 d-flex justify-content-between">
                    <div class="w-45">
                        <select wire:model.defer="roles.{{ $index }}.role_type" class="form-select">
                            <option value="">انتخاب نقش</option>
                            @foreach($roleTypes as $roleType)
                                <option value="{{ $roleType }}">{{ $roleType }}</option>
                            @endforeach
                        </select>
                        @error("roles.{$index}.role_type") <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <div class="w-45">
                        <select wire:model.defer="roles.{{ $index }}.company_id" class="form-select">
                            <option value="">انتخاب شرکت</option>
                            @foreach($companies as $company)
                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                            @endforeach
                        </select>
                        @error("roles.{$index}.company_id") <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <button type="button" wire:click="removeRole({{ $index }})" class="btn btn-danger btn-sm">حذف</button>
                </div>
            @endforeach
            <button type="button" wire:click="addRole" class="btn btn-secondary btn-sm">اضافه کردن نقش</button>
        </div>

        <button type="submit" class="btn btn-primary">ذخیره نقش‌ها</button>
    </form>
</div>
