<div class="container-fluid">
    <div class="card bg-light-info shadow-none position-relative overflow-hidden">
        <div class="card-body px-4 py-3">
            <h4 class="fw-semibold mb-8">جزئیات پروژه</h4>

            <!-- نمایش اطلاعات پروژه -->
            @if ($project)
                <div class="mb-3">
                    <strong>نام پروژه:</strong> {{ $project->name }}
                </div>

                <div class="mb-3">
                    <strong>کد پروژه:</strong> {{ $project->details->project_code ?? 'اطلاعات موجود نیست' }}
                </div>

                <div class="mb-3">
                    <strong>کد مالیاتی:</strong> {{ $project->details->tax_code ?? 'اطلاعات موجود نیست' }}
                </div>

                <div class="mb-3">
                    <strong>کارفرمای اصلی:</strong> {{ $project->details->mainClient->name ?? 'اطلاعات موجود نیست' }}
                </div>

                <div class="mb-3">
                    <strong>کارفرمای فرعی:</strong> {{ $project->details->subClient->name ?? 'اطلاعات موجود نیست' }}
                </div>

                <div class="mb-3">
                    <strong>پیمانکار:</strong> {{ $project->details->contractor->name ?? 'اطلاعات موجود نیست' }}
                </div>

                <div class="mb-3">
                    <strong>مدیر پروژه:</strong> {{ $project->details->manager->name ?? 'اطلاعات موجود نیست' }}
                </div>

                <div class="mb-3">
                    <strong>وضعیت پروژه:</strong> {{ $project->details->status ?? 'اطلاعات موجود نیست' }}
                </div>

                <div class="mb-3">
                    <strong>انواع پروژه:</strong>
                    <ul>
                        @foreach ($project->projectTypes as $type)
                            <li>{{ $type->name }}</li>
                        @endforeach
                    </ul>
                </div>

                <!-- بخش زمان‌بندی پروژه -->
                <div class="mt-5">
                    <h5 class="fw-semibold mb-4">زمان‌بندی پروژه</h5>
                    @if ($project->schedule)
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>تاریخ واگذاری (LOA)</th>
                                <th>تاریخ قرارداد</th>
                                <th>تاریخ پایان واقعی</th>
                                <th>مدت زمان اجرا (روز)</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>{{ $project->schedule->LOA_date ?? 'اطلاعات موجود نیست' }}</td>
                                <td>{{ $project->schedule->contract_date ?? 'اطلاعات موجود نیست' }}</td>
                                <td>{{ $project->schedule->actual_completion_date ?? 'اطلاعات موجود نیست' }}</td>
                                <td>{{ $project->schedule->execution_duration ?? 'اطلاعات موجود نیست' }} روز</td>
                            </tr>
                            </tbody>
                        </table>
                    @else
                        <p>هیچ زمان‌بندی برای این پروژه ثبت نشده است.</p>
                    @endif
                </div>

                <!-- بخش بیمه‌های پروژه -->
                <div class="mt-5">
                    <h5 class="fw-semibold mb-4">بیمه‌های پروژه</h5>
                    @if ($project->insurances->isNotEmpty())
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>شرکت بیمه</th>
                                <th>تاریخ شروع</th>
                                <th>تاریخ پایان</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($project->insurances as $insurance)
                                <tr>
                                    <td>{{ $insurance->company->name ?? 'اطلاعات موجود نیست' }}</td>
                                    <td>{{ $insurance->start_date ?? 'اطلاعات موجود نیست' }}</td>
                                    <td>{{ $insurance->end_date ?? 'اطلاعات موجود نیست' }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    @else
                        <p>هیچ بیمه‌ای برای این پروژه ثبت نشده است.</p>
                    @endif
                </div>

            @else
                <p>پروژه یافت نشد.</p>
            @endif

            <a href="{{ route('admin.list.projects') }}" class="btn btn-secondary mt-3">بازگشت به لیست پروژه‌ها</a>
        </div>
    </div>
</div>
