<div class="container py-4">
    <div class="project-wall-container" wire:poll.5000ms>
        {{-- Input Area (Sticky) --}}
        <div class="card modern-card shadow-2xl mb-4 sticky-input-card border-0 rounded-4">
            <div class="card-body p-5">
                <div class="d-flex align-items-center mb-4 gap-3 border-bottom pb-3">
                    @if(Auth::check())
                        <div class="position-relative">
                            <img src="{{ Auth::user()->image ? asset('storage/' . Auth::user()->image) : asset('panel/dist/images/profile/user-1.jpg') }}"
                                 class="rounded-circle user-avatar" width="50" height="50" alt="{{ Auth::user()->name }}">
                            <span class="user-status-indicator bg-success"></span>
                        </div>
                        <div>
                            <h5 class="fw-bold mb-0 text-primary-dark">
                                ثبت گزارش جدید
                            </h5>
                            <p class="text-muted small mb-0">توسط: <span class="text-action-primary">{{ Auth::user()->name }}</span></p>
                        </div>
                    @else
                        <div class="d-flex align-items-center gap-2">
                            <i class="ti ti-user-circle fs-4 text-muted"></i>
                            <h5 class="fw-bold mb-0 text-primary-dark">برای ثبت گزارش، وارد شوید.</h5>
                        </div>
                    @endif
                </div>

                @if(session()->has('wall-success'))
                    <div class="alert alert-success small py-3 px-4 rounded-lg shadow-sm d-flex align-items-center">
                        <i class="ti ti-circle-check me-2 fs-5"></i>
                        <span>{{ session('wall-success') }}</span>
                        <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                @if(session()->has('wall-error'))
                    <div class="alert alert-danger small py-3 px-4 rounded-lg shadow-sm d-flex align-items-center">
                        <i class="ti ti-alert-circle me-2 fs-5"></i>
                        <span>{{ session('wall-error') }}</span>
                        <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                {{-- فرم ویرایش --}}
                @if ($editingPostId)
                    @php $editingPost = \App\Models\ProjectWallPost::with('attachments')->find($editingPostId); @endphp
                    <form wire:submit.prevent="updatePost" class="edit-form">
                        <div class="d-flex align-items-center mb-3">
                            <span class="badge bg-warning-subtle text-warning rounded-pill px-3 py-2">
                                <i class="ti ti-edit me-1"></i> در حال ویرایش پست #{{ $editingPostId }}
                            </span>
                            <button type="button" class="btn-close ms-auto" wire:click="cancelEdit" aria-label="انصراف"></button>
                        </div>

                        <div class="input-group mb-3">
                            <select wire:model.defer="editingPostType" class="form-select post-type-select rounded-lg me-2">
                                @foreach($availableTypes as $key => $label)
                                    <option value="{{ $key }}">{{ $label }}</option>
                                @endforeach
                            </select>
                            <textarea wire:model.defer="editingContent" class="form-control post-content-input rounded-lg @error('editingContent') is-invalid @enderror" rows="3" placeholder="متن به‌روزرسانی شده..."></textarea>
                            @error('editingContent') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                        </div>

                        {{-- بخش پیوست‌ها در ویرایش --}}
                        <div class="file-upload-section mt-4 p-3 border rounded-lg bg-light-subtle-2">
                            <label for="editingAttachments" class="form-label small fw-bold text-muted mb-2 d-flex align-items-center">
                                <i class="ti ti-paperclip me-1"></i> پیوست فایل (حداکثر 5 فایل، 5MB)
                            </label>
                            <div class="file-upload-area border-dashed rounded-lg p-4 text-center" onclick="document.getElementById('editingAttachments').click()">
                                <i class="ti ti-cloud-upload fs-2 text-muted mb-2 d-block"></i>
                                <span class="text-muted small">برای آپلود فایل‌ها اینجا کلیک کنید یا فایل‌ها را بکشید و رها کنید</span>
                                <input type="file" wire:model="editingAttachments" id="editingAttachments" multiple class="d-none">
                            </div>

                            @error('editingAttachments') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            @error('editingAttachments.*') <div class="text-danger small mt-1">{{ $message }}</div> @enderror

                            {{-- لیست پیوست‌های موجود --}}
                            @if ($editingPost && $editingPost->attachments->count() > 0)
                                <div class="mt-3 pt-3 border-top">
                                    <span class="small fw-bold text-primary-dark d-block mb-2">پیوست‌های موجود ({{ $editingPost->attachments->count() - count($deletedAttachmentIds) }}):</span>
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach ($editingPost->attachments as $attachment)
                                            @if (!in_array($attachment->id, $deletedAttachmentIds))
                                                <div class="file-badge d-flex align-items-center bg-secondary-subtle text-secondary fw-normal py-2 px-3 rounded-pill shadow-sm">
                                                    <i class="ti ti-file me-1"></i>
                                                    {{ \Illuminate\Support\Str::limit($attachment->file_name, 20) }}
                                                    <button type="button" class="btn-close btn-close-sm ms-2 p-0" aria-label="Remove" wire:click="removeExistingAttachment({{ $attachment->id }})"></button>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            {{-- لیست پیوست‌های جدید --}}
                            @if (count($editingAttachments) > 0)
                                <div class="mt-3 pt-3 border-top">
                                    <span class="small fw-bold text-primary-dark d-block mb-2">پیوست‌های جدید ({{ count($editingAttachments) }}):</span>
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach ($editingAttachments as $key => $file)
                                            <div class="file-badge d-flex align-items-center bg-secondary-subtle text-secondary fw-normal py-2 px-3 rounded-pill shadow-sm">
                                                <i class="ti ti-file-upload me-1"></i>
                                                {{ \Illuminate\Support\Str::limit($file->getClientOriginalName(), 20) }}
                                                <button type="button" class="btn-close btn-close-sm ms-2 p-0" aria-label="Remove" wire:click="removeEditingAttachment({{ $key }})"></button>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <div x-data="{ isUploading: false, progress: 0 }" x-on:livewire-upload-start="isUploading = true" x-on:livewire-upload-finish="isUploading = false" x-on:livewire-upload-error="isUploading = false" x-on:livewire-upload-progress="progress = $event.detail.progress">
                                <div x-show="isUploading" class="upload-progress mt-3">
                                    <div class="d-flex justify-content-between small mb-1">
                                        <span>در حال آپلود...</span>
                                        <span x-text="progress + '%'"></span>
                                    </div>
                                    <div class="progress" style="height: 6px;">
                                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-action-primary" role="progressbar" :style="`width: ${progress}%`"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-4 gap-2">
                            <button type="button" class="btn btn-outline-secondary rounded-pill px-4 py-2 d-flex align-items-center" wire:click="cancelEdit">
                                <i class="ti ti-x me-1"></i> انصراف
                            </button>
                            <button type="submit" class="btn btn-warning rounded-pill px-4 py-2 fw-bold d-flex align-items-center" wire:loading.attr="disabled">
                                <i class="ti ti-check me-1"></i>
                                <span wire:loading.remove>به‌روزرسانی</span>
                                <span wire:loading>
                                    <span class="spinner-border spinner-border-sm me-2"></span> در حال به‌روزرسانی...
                                </span>
                            </button>
                        </div>
                    </form>
                @else
                    {{-- فرم ثبت جدید --}}
                    <form wire:submit.prevent="postUpdate" class="new-post-form">
                        <div class="input-group mb-3">
                            <select wire:model.defer="newPostType" class="form-select post-type-select rounded-lg me-2">
                                @foreach($availableTypes as $key => $label)
                                    <option value="{{ $key }}">{{ $label }}</option>
                                @endforeach
                            </select>
                            <textarea wire:model.defer="newPostContent" class="form-control post-content-input rounded-lg @error('newPostContent') is-invalid @enderror" rows="3" placeholder="وضعیت جدید، مشکل یا نقطه عطف را وارد کنید..."></textarea>
                            @error('newPostContent') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                        </div>

                        {{-- بخش آپلود فایل --}}
                        <div class="file-upload-section mt-4 p-3 border rounded-lg bg-light-subtle-2">
                            <label for="attachments" class="form-label small fw-bold text-muted mb-2 d-flex align-items-center">
                                <i class="ti ti-paperclip me-1"></i> پیوست فایل (حداکثر 5 فایل، 5MB)
                            </label>
                            <div class="file-upload-area border-dashed rounded-lg p-4 text-center" onclick="document.getElementById('attachments').click()">
                                <i class="ti ti-cloud-upload fs-2 text-muted mb-2 d-block"></i>
                                <span class="text-muted small">برای آپلود فایل‌ها اینجا کلیک کنید یا فایل‌ها را بکشید و رها کنید</span>
                                <input type="file" wire:model="attachments" id="attachments" multiple class="d-none">
                            </div>

                            @error('attachments') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            @error('attachments.*') <div class="text-danger small mt-1">{{ $message }}</div> @enderror

                            @if (count($attachments) > 0)
                                <div class="mt-3 pt-3 border-top">
                                    <span class="small fw-bold text-primary-dark d-block mb-2">فایل‌های انتخاب شده ({{ count($attachments) }}):</span>
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach ($attachments as $key => $file)
                                            <div class="file-badge d-flex align-items-center bg-secondary-subtle text-secondary fw-normal py-2 px-3 rounded-pill shadow-sm">
                                                <i class="ti ti-file me-1"></i>
                                                {{ \Illuminate\Support\Str::limit($file->getClientOriginalName(), 20) }}
                                                <button type="button" class="btn-close btn-close-sm ms-2 p-0" aria-label="Remove" wire:click="removeAttachment({{ $key }})"></button>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <div x-data="{ isUploading: false, progress: 0 }" x-on:livewire-upload-start="isUploading = true" x-on:livewire-upload-finish="isUploading = false" x-on:livewire-upload-error="isUploading = false" x-on:livewire-upload-progress="progress = $event.detail.progress">
                                <div x-show="isUploading" class="upload-progress mt-3">
                                    <div class="d-flex justify-content-between small mb-1">
                                        <span>در حال آپلود...</span>
                                        <span x-text="progress + '%'"></span>
                                    </div>
                                    <div class="progress" style="height: 6px;">
                                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-action-primary" role="progressbar" :style="`width: ${progress}%`"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-4">
                            <button type="submit" class="btn btn-action-primary rounded-pill px-5 py-2 fw-bold text-white-final d-flex align-items-center" wire:loading.attr="disabled">
                                <i class="ti ti-send me-2"></i>
                                <span wire:loading.remove>ثبت وضعیت</span>
                                <span wire:loading>
                                    <span class="spinner-border spinner-border-sm me-2"></span> در حال ارسال...
                                </span>
                            </button>
                        </div>
                    </form>
                @endif
            </div>
        </div>

        {{-- Timeline Feed --}}
        <div class="timeline-feed mt-5">
            {{-- بخش جستجو و فیلتر --}}
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-4">
                <h5 class="fw-bold text-primary-dark mb-0 d-flex align-items-center">
                    <i class="ti ti-history me-2 fs-5 text-action-primary"></i> تاریخچه وضعیت‌ها
                    <span class="badge bg-light text-primary ms-2">{{ $posts->total() }}</span>
                </h5>
                <div class="d-flex gap-3 align-items-center mt-3 mt-sm-0">
                    <div class="search-box position-relative">
                        <i class="ti ti-search position-absolute top-50 start-3 translate-middle-y text-muted"></i>
                        <input type="text" wire:model.live.debounce.400ms="searchQuery" placeholder="جستجو در محتوا..." class="form-control form-control-sm rounded-pill shadow-sm ps-5" style="width: 220px;">
                    </div>
                    <select wire:model.live="filterType" class="form-select form-select-sm rounded-pill shadow-sm" style="max-width: 160px;">
                        <option value="all">همه انواع گزارش</option>
                        @foreach($availableTypes as $key => $label)
                            <option value="{{ $key }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="border-top pt-4">
                @forelse($posts as $post)
                    <div class="timeline-item" wire:key="post-{{ $post->id }}">
                        <div class="timeline-dot timeline-dot-{{ $post->type }}"></div>
                        <div class="timeline-content card modern-card shadow-sm rounded-lg p-4 card-glow-hover">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="post-user fw-bold text-primary-dark d-flex align-items-center gap-2">
                                    <div class="position-relative">
                                        @if($post->user->image)
                                            <img src="{{ asset('storage/' . $post->user->image) }}" class="rounded-circle" width="40" height="40" alt="{{ $post->user->name }}">
                                        @else
                                            <div class="user-initials bg-warning-color text-white fw-bold rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px; font-size: 14px;">
                                                {{ mb_substr($post->user->name, 0, 1) }}
                                            </div>
                                        @endif
                                    </div>
                                    <div>
                                        <span>{{ $post->user->name ?? 'کاربر حذف شده' }}</span>
                                        <div class="post-time small text-muted mt-1">
                                            <i class="ti ti-clock me-1"></i>
                                            {{ function_exists('verta') ? verta($post->created_at)->format('Y/m/d H:i') : $post->created_at->diffForHumans() }}
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex flex-column align-items-end gap-2">
                                    <div class="action-buttons-group d-flex gap-2">
                                        @if ($this->canEdit($post))
                                            <button wire:click="startEdit({{ $post->id }})" class="btn btn-sm btn-outline-secondary rounded-circle p-1" title="ویرایش" aria-label="ویرایش پست">
                                                <i class="ti ti-edit fs-5"></i>
                                            </button>
                                        @endif
                                        @if ($this->canDelete($post))
                                            <button wire:click="deletePost({{ $post->id }})" wire:confirm="آیا مطمئن هستید که این پست حذف شود؟" class="btn btn-sm btn-outline-danger rounded-circle p-1" title="حذف" aria-label="حذف پست">
                                                <i class="ti ti-trash fs-5"></i>
                                            </button>
                                        @endif
                                    </div>
                                    <div class="d-flex flex-column align-items-end">
                                        <span class="badge status-badge-{{ $post->type }} rounded-pill px-3 py-1">
                                            {{ $availableTypes[$post->type] ?? $post->type }}
                                        </span>
                                        @if ($this->canDelete($post))
                                            <span class="text-danger small fw-bold mt-1">
                                                <i class="ti ti-clock me-1"></i>
                                                مهلت حذف: {{ \Carbon\Carbon::parse($post->created_at)->addHours(48)->diffForHumans() }} باقی مانده
                                            </span>
                                        @endif
                                        @if ($this->canEdit($post) && !$this->canDelete($post))
                                            <span class="text-warning small fw-bold mt-1">
                                                <i class="ti ti-clock me-1"></i>
                                                مهلت ویرایش: {{ \Carbon\Carbon::parse($post->created_at)->addHours(240)->diffForHumans() }} باقی مانده
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <p class="post-content mb-0">{{ $post->content }}</p>

                            {{-- بخش نمایش پیوست‌ها --}}
                            @if($post->attachments->count() > 0)
                                <div class="attachments-list mt-3 pt-3 border-top">
                                    <span class="small fw-bold text-primary-dark d-block mb-2">
                                        <i class="ti ti-files me-1"></i> پیوست‌ها ({{ $post->attachments->count() }})
                                    </span>
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach($post->attachments as $attachment)
                                            @php $fileUrl = Storage::disk('public')->url($attachment->file_path); @endphp
                                            <a href="{{ $fileUrl }}" target="_blank" class="file-badge d-flex align-items-center bg-secondary-subtle text-action-primary fw-medium py-2 px-3 rounded-pill attachment-badge shadow-sm animate-hover">
                                                <i class="ti ti-download me-1"></i>
                                                {{ \Illuminate\Support\Str::limit($attachment->file_name, 25) }}
                                            </a>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            {{-- بخش نظرات و پاسخ‌ها --}}
                            @if ($post->comments->isNotEmpty() || Auth::check())
                                <div class="comments-section mt-4 pt-3 border-top">
                                    <h6 class="fw-bold text-primary-dark mb-3 d-flex align-items-center">
                                        <i class="ti ti-message-dots me-1"></i> نظرات ({{ $post->comments->count() }})
                                    </h6>
                                    <div class="comments-list mt-3 d-flex flex-column gap-3">
                                        @foreach($post->comments->take(2) as $comment)
                                            <div class="comment-item p-3 rounded-lg bg-light-subtle-2">
                                                <div class="d-flex align-items-center gap-2 mb-2">
                                                    <img src="{{ $comment->user->image ?? asset('panel/dist/images/profile/user-1.jpg') }}" class="rounded-circle" width="28" height="28" alt="{{ $comment->user->name ?? 'ناشناس' }}">
                                                    <span class="fw-semibold small">{{ $comment->user->name ?? 'ناشناس' }}</span>
                                                    <span class="text-muted small ms-auto">{{ $comment->created_at->diffForHumans() }}</span>
                                                </div>
                                                <p class="mb-0 small ps-2">{{ $comment->content }}</p>
                                            </div>
                                        @endforeach
                                        @if ($post->comments->count() > 2)
                                            <button wire:click="loadAllComments({{ $post->id }})" class="btn btn-sm btn-outline-secondary w-100 mt-2 d-flex align-items-center justify-content-center">
                                                <i class="ti ti-arrow-down me-1"></i>
                                                مشاهده {{ $post->comments->count() - 2 }} نظر دیگر
                                            </button>
                                        @endif
                                    </div>
                                    @if (Auth::check())
                                        <div class="comment-input-form mt-4">
                                            <form wire:submit.prevent="postComment({{ $post->id }})" wire:key="comment-form-{{ $post->id }}">
                                                <textarea wire:model.defer="newCommentText.{{ $post->id }}" class="form-control rounded-lg mb-2" rows="2" placeholder="نظر خود را بنویسید..."></textarea>
                                                <div class="d-flex justify-content-end">
                                                    <button type="submit" class="btn btn-sm btn-action-primary rounded-pill fw-bold d-flex align-items-center" wire:loading.attr="disabled">
                                                        <i class="ti ti-send me-1"></i> ارسال نظر
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>
                @empty
                    <div class="empty-state text-center my-5 py-5">
                        <i class="ti ti-message-off fs-1 text-muted mb-3 d-block"></i>
                        <h5 class="text-muted">هنوز هیچ گزارشی ثبت نشده است.</h5>
                        <p class="text-muted small">اولین نفری باشید که وضعیت پروژه را گزارش می‌دهد.</p>
                    </div>
                @endforelse

                <div class="d-flex justify-content-center mt-5">
                    {{ $posts->links() }}
                </div>
            </div>
        </div>

        {{-- مودال نمایش تمام کامنت‌ها --}}
        @if ($showAllCommentsModal)
            <div class="modal fade show d-block" tabindex="-1" role="dialog" wire:ignore.self style="background-color: rgba(0,0,0,0.5);">
                <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                    <div class="modal-content rounded-lg shadow-lg border-0">
                        <div class="modal-header border-bottom bg-primary text-white rounded-top-lg">
                            <h5 class="modal-title fw-bold d-flex align-items-center">
                                <i class="ti ti-message-dots me-2"></i>
                                تمام نظرات پست #{{ $currentPostIdForComments }}
                            </h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeCommentsModal" aria-label="بستن"></button>
                        </div>
                        <div class="modal-body p-4" style="max-height: 500px; overflow-y: auto;">
                            @if ($currentPostComments->isNotEmpty())
                                <div class="d-flex flex-column gap-3">
                                    @foreach ($currentPostComments as $comment)
                                        <div class="comment-item p-3 rounded-lg bg-light-subtle-2 border">
                                            <div class="d-flex align-items-center gap-2 mb-2">
                                                <img src="{{ $comment->user->image ?? asset('panel/dist/images/profile/user-1.jpg') }}" class="rounded-circle" width="35" height="35" alt="{{ $comment->user->name ?? 'ناشناس' }}">
                                                <div>
                                                    <span class="fw-semibold">{{ $comment->user->name ?? 'ناشناس' }}</span>
                                                    <div class="text-muted small">{{ $comment->created_at->diffForHumans() }}</div>
                                                </div>
                                            </div>
                                            <p class="mb-0 ps-2">{{ $comment->content }}</p>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="ti ti-message-off fs-2 text-muted mb-2 d-block"></i>
                                    <p class="text-muted">هیچ نظری موجود نیست.</p>
                                </div>
                            @endif
                        </div>
                        <div class="modal-footer border-top">
                            <button type="button" class="btn btn-secondary rounded-pill d-flex align-items-center" wire:click="closeCommentsModal">
                                <i class="ti ti-x me-1"></i> بستن
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <style>
            /* استایل‌های نهایی و مدرن برای Project Wall */
            :root {
                --primary-dark: #1A2538;
                --action-color: #4361EE;
                --action-dark-hover: #3A4FCD;
                --warning-color: #F59E0B;
                --success-color: #10B981;
                --danger-color: #EF4444;
                --bg-light-input: #F8FAFC;
                --indigo-color: #6366F1;
                --teal-color: #14B8A6;
                --purple-color: #8B5CF6;
            }

            .project-wall-container { max-width: 800px; margin: 0 auto; }
            .text-primary-dark { color: var(--primary-dark); }
            .text-action-primary { color: var(--action-color); }
            .text-white-final { color: white !important; }

            /* Modern Card */
            .modern-card {
                background-color: white;
                border: 1px solid #E5E7EB;
                transition: all 0.3s ease;
            }

            /* Sticky Input */
            .sticky-input-card {
                top: 20px;
                z-index: 10;
                background-color: white;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08) !important;
            }

            /* User Avatar */
            .user-avatar {
                object-fit: cover;
                border: 2px solid #E5E7EB;
            }

            .user-status-indicator {
                position: absolute;
                bottom: 2px;
                right: 2px;
                width: 12px;
                height: 12px;
                border-radius: 50%;
                border: 2px solid white;
            }

            /* Form Controls */
            .form-control, .form-select {
                border-color: #D1D5DB;
                transition: all 0.2s ease;
            }

            .form-control:focus, .form-select:focus {
                border-color: var(--action-color);
                box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.15);
            }

            .post-type-select {
                max-width: 160px;
                font-weight: 500;
            }

            .post-content-input {
                resize: none;
            }

            /* Buttons */
            .btn-action-primary {
                background-color: var(--action-color);
                border-color: var(--action-color);
                transition: all 0.2s ease;
                color: white !important;
            }

            .btn-action-primary:hover {
                background-color: var(--action-dark-hover);
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(67, 97, 238, 0.3);
            }

            /* File Upload Section */
            .file-upload-section {
                border: 1px solid #E5E7EB;
            }

            .file-upload-area {
                border: 2px dashed #D1D5DB;
                background-color: rgba(248, 250, 252, 0.5);
                cursor: pointer;
                transition: all 0.3s ease;
            }

            .file-upload-area:hover {
                border-color: var(--action-color);
                background-color: rgba(67, 97, 238, 0.05);
            }

            .border-dashed {
                border-style: dashed !important;
            }

            .file-badge {
                transition: all 0.2s ease;
            }

            .file-badge:hover {
                transform: translateY(-2px);
            }

            /* Upload Progress */
            .upload-progress .progress {
                border-radius: 10px;
            }

            /* Timeline Structure */
            .timeline-feed {
                position: relative;
                padding-left: 30px;
            }

            .timeline-item {
                margin-bottom: 40px;
                position: relative;
                padding-left: 50px;
            }

            .timeline-feed:before {
                content: '';
                position: absolute;
                top: 60px;
                bottom: 0;
                left: 0;
                width: 3px;
                background: linear-gradient(to bottom, #E5E7EB, #E5E7EB);
                border-radius: 2px;
            }

            .timeline-dot {
                position: absolute;
                width: 20px;
                height: 20px;
                border-radius: 50%;
                border: 4px solid white;
                top: 20px;
                left: -10px;
                box-shadow: 0 0 0 3px #4361EE;
                z-index: 2;
            }

            /* رنگ‌های نوع پست */
            .timeline-dot-status { background-color: var(--success-color); box-shadow: 0 0 0 3px var(--success-color); }
            .timeline-dot-report { background-color: var(--warning-color); box-shadow: 0 0 0 3px var(--warning-color); }
            .timeline-dot-issue { background-color: var(--danger-color); box-shadow: 0 0 0 3px var(--danger-color); }
            .timeline-dot-milestone { background-color: var(--action-color); box-shadow: 0 0 0 3px var(--action-color); }
            .timeline-dot-visit { background-color: var(--indigo-color); box-shadow: 0 0 0 3px var(--indigo-color); }
            .timeline-dot-knowledge { background-color: var(--teal-color); box-shadow: 0 0 0 3px var(--teal-color); }

            /* Content Card */
            .timeline-content {
                border-radius: 12px;
                border: 1px solid #F3F4F6;
                transition: all 0.3s ease;
            }

            .card-glow-hover:hover {
                transform: translateY(-5px);
                box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1) !important;
                border-color: var(--action-color);
            }

            .post-user img {
                border-radius: 50%;
                object-fit: cover;
                border: 2px solid #E5E7EB;
            }

            .user-initials {
                border: 2px solid white;
                background-color: var(--warning-color);
            }

            /* Badges */
            .status-badge-status { background-color: #D1FAE5; color: #059669; font-weight: 600; }
            .status-badge-report { background-color: #FEF3C7; color: #D97706; font-weight: 600; }
            .status-badge-issue { background-color: #FEE2E2; color: var(--danger-color); font-weight: 600; }
            .status-badge-milestone { background-color: #EFF6FF; color: var(--action-color); font-weight: 600; }
            .status-badge-visit { background-color: #E0E7FF; color: var(--indigo-color); font-weight: 600; }
            .status-badge-knowledge { background-color: #D1FAE5; color: var(--teal-color); font-weight: 600; }

            .bg-secondary-subtle { background-color: #F1F5F9 !important; }

            .attachment-badge:hover {
                background-color: #E2E8F0 !important;
                text-decoration: none;
            }

            /* Action Buttons */
            .action-buttons-group .btn {
                transition: all 0.2s ease;
            }

            .action-buttons-group .btn:hover {
                transform: translateY(-2px);
            }

            /* Empty State */
            .empty-state {
                opacity: 0.7;
            }

            /* Utility */
            .btn-sm.p-1 {
                padding: 0.4rem 0.5rem !important;
                width: 34px;
                height: 34px;
            }

            .comment-item {
                border: 1px solid #E5E7EB;
                transition: all 0.2s ease;
            }

            .comment-item:hover {
                border-color: #D1D5DB;
            }

            .bg-light-subtle-2 { background-color: #F4F7FF !important; }

            /* Search Box */
            .search-box .form-control {
                padding-left: 2.5rem;
            }

            .search-box i {
                left: 1.2rem;
                z-index: 3;
            }

            /* Animations */
            .animate-hover {
                transition: all 0.3s ease;
            }

            .animate-hover:hover {
                transform: translateY(-2px);
            }

            /* Responsive */
            @media (max-width: 768px) {
                .project-wall-container {
                    padding: 0 10px;
                }

                .timeline-feed {
                    padding-left: 20px;
                }

                .timeline-item {
                    padding-left: 35px;
                }

                .timeline-dot {
                    width: 16px;
                    height: 16px;
                    left: -8px;
                }

                .sticky-input-card .card-body {
                    padding: 1.5rem;
                }
            }
        </style>

        <script>
            // اضافه کردن قابلیت drag and drop برای آپلود فایل
            document.addEventListener('DOMContentLoaded', function() {
                const fileUploadAreas = document.querySelectorAll('.file-upload-area');

                fileUploadAreas.forEach(area => {
                    area.addEventListener('dragover', function(e) {
                        e.preventDefault();
                        this.style.borderColor = '#4361EE';
                        this.style.backgroundColor = 'rgba(67, 97, 238, 0.1)';
                    });

                    area.addEventListener('dragleave', function(e) {
                        e.preventDefault();
                        this.style.borderColor = '#D1D5DB';
                        this.style.backgroundColor = 'rgba(248, 250, 252, 0.5)';
                    });

                    area.addEventListener('drop', function(e) {
                        e.preventDefault();
                        this.style.borderColor = '#D1D5DB';
                        this.style.backgroundColor = 'rgba(248, 250, 252, 0.5)';

                        const files = e.dataTransfer.files;
                        const input = this.querySelector('input[type="file"]');

                        if (input) {
                            input.files = files;
                            // trigger change event for Livewire
                            const event = new Event('change', { bubbles: true });
                            input.dispatchEvent(event);
                        }
                    });
                });
            });
        </script>
    </div>
</div>
