<div class="container-fluid py-5" dir="rtl" style="font-family: 'Vazirmatn', sans-serif; background: #fdfeff; min-height: 100vh;">
    <style>
        :root {
            --p-indigo: #4361ee;
            --p-slate: #0f172a;
            --p-emerald: #10b981;
            --p-border: #e2e8f0;
            --p-glass-soft: rgba(255, 255, 255, 0.9);
        }

        /* ✨ انیمیشن نرم ورود */
        .reveal-up { animation: fadeInUp 0.8s cubic-bezier(0.16, 1, 0.3, 1) both; }
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(40px); } to { opacity: 1; transform: translateY(0); } }

        /* 🏔️ طراحی هدر پانوراما (Platinum Concept) */
        .panorama-header {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            border-radius: 35px; padding: 50px; color: white;
            position: relative; overflow: hidden;
            box-shadow: 0 25px 50px -12px rgba(15, 23, 42, 0.2);
            margin-bottom: 50px;
        }
        .panorama-header::after {
            content: ''; position: absolute; top: -50%; right: -10%; width: 400px; height: 400px;
            background: radial-gradient(circle, rgba(67, 97, 238, 0.2) 0%, transparent 70%);
        }

        /* 📦 کارت‌های پریمیوم */
        .lux-card {
            background: #fff;
            border-radius: 32px;
            border: 1px solid var(--p-border);
            box-shadow: 0 10px 40px -15px rgba(0,0,0,0.04);
            transition: all 0.4s ease;
        }
        .lux-card:hover { transform: translateY(-8px); border-color: var(--p-indigo); box-shadow: 0 30px 60px -20px rgba(0,0,0,0.08); }

        /* 🖋️ فیلد ورودی مدرن */
        .input-group-modern {
            background: #f8fafc; border-radius: 20px; padding: 12px 18px;
            border: 2px solid #f1f5f9; transition: 0.3s;
        }
        .input-group-modern:focus-within {
            background: #fff; border-color: var(--p-indigo); box-shadow: 0 0 0 5px rgba(67, 97, 238, 0.1);
        }

        /* 🔘 دکمه اکشن (Deep Indigo) */
        .btn-action-lux {
            background: var(--p-indigo);
            color: white; border-radius: 20px; padding: 18px 35px;
            font-weight: 900; border: none; transition: 0.4s;
            box-shadow: 0 15px 30px -5px rgba(67, 97, 238, 0.4);
            display: flex; align-items: center; justify-content: center; gap: 12px;
        }
        .btn-action-lux:hover { transform: scale(1.03); filter: brightness(1.1); box-shadow: 0 20px 40px -5px rgba(67, 97, 238, 0.5); }

        /* 📋 استایل ردیف‌های شناور جدول */
        .lux-table thead th {
            color: #94a3b8; font-weight: 800; font-size: 0.75rem;
            text-transform: uppercase; letter-spacing: 1px; border: none; padding-bottom: 25px;
        }
        .lux-table tbody tr { transition: 0.3s; }
        .lux-table tbody tr td { padding: 20px 15px; border-bottom: 1px solid #f8fafc; }
        .lux-table tbody tr:hover { background: rgba(67, 97, 238, 0.03); }

        .icon-box-prime {
            width: 54px; height: 54px; border-radius: 18px;
            display: flex; align-items: center; justify-content: center;
            box-shadow: 0 10px 20px rgba(0,0,0,0.03);
        }
    </style>

    <div class="panorama-header reveal-up">
        <div class="row align-items-center position-relative z-index-2">
            <div class="col-lg-8">
                <div class="d-flex align-items-center gap-3 mb-4 text-primary">
                    <i class="ti ti-settings-automation fs-1"></i>
                    <span class="fw-black letter-spacing-1 small text-white opacity-50">CORE SYSTEM CONFIG v7.0</span>
                </div>
                <h1 class="fw-black display-4 mb-3 text-white">معماری پورتفولیو پروژه‌ها</h1>
                <p class="opacity-70 fs-5 lh-lg pe-lg-5">لایه‌های دسته‌بندی استراتژیک سازمان را جهت یکپارچگی گزارشات مالی و مرکز هزینه مهندسی کنید.</p>
            </div>
            <div class="col-lg-4 text-start d-none d-lg-block">
                <div class="d-inline-flex bg-white bg-opacity-10 shadow-2xl p-4 rounded-4 backdrop-blur border border-white border-opacity-10">
                    <div class="text-center px-4 border-start border-white border-opacity-20">
                        <div class="fs-1 fw-black text-white">{{ count($this->projectTypes) }}</div>
                        <div class="small opacity-50 fw-bold">Active Classes</div>
                    </div>
                    <div class="icon-box-prime bg-indigo text-white ms-3">
                        <i class="ti ti-category fs-2"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-5">
        <div class="col-xl-5 col-lg-6 reveal-up" style="animation-delay: 0.1s">
            <div class="lux-card card border-0 p-5 h-100 shadow-sm">
                <div class="d-flex align-items-center gap-4 mb-5">
                    <div class="icon-box-prime bg-primary bg-opacity-10 text-primary"><i class="ti ti-plus fs-3"></i></div>
                    <div>
                        <h4 class="fw-black m-0 text-dark">ثبت دسته‌بندی جدید</h4>
                        <small class="text-muted fw-bold">افزودن هویت ساختاری به دیتابیس مرکزی</small>
                    </div>
                </div>

                <form wire:submit.prevent="saveType">
                    <div class="mb-5">
                        <label class="form-label fw-black text-slate small mb-3 ms-2">عنوان رسمی لایه پروژه</label>
                        <div class="input-group-modern d-flex align-items-center">
                            <i class="ti ti-tag-filled text-primary fs-4 ms-2 opacity-30"></i>
                            <input type="text" wire:model.live="name" class="form-control border-0 shadow-none fw-bold text-dark fs-5 bg-transparent" placeholder="مانند: پروژه‌های عمرانی ملی">
                        </div>
                        @error('name') <div class="text-danger small fw-bold mt-3 pe-2"><i class="ti ti-alert-circle-filled me-1"></i>{{ $message }}</div> @enderror
                    </div>

                    <div class="p-4 rounded-4 mb-5" style="background: #f8faff; border: 1px solid #eef2ff;">
                        <h6 class="fw-black small text-primary mb-2 d-flex align-items-center gap-2">
                            <i class="ti ti-bulb-filled text-warning"></i> پروتکل استاندارد
                        </h6>
                        <p class="text-muted small mb-0 lh-lg opacity-75">نام انتخابی باید در کل سیستم <strong>یکتا</strong> باشد. این عنوان به صورت خودکار به کدینگ داخلی تبدیل شده و در تمام فیلترهای گزارش‌گیری استفاده خواهد شد.</p>
                    </div>

                    <button type="submit" class="btn-action-lux w-100 py-4 shadow-lg" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="saveType">تایید و ثبت نهایی لایه</span>
                        <span wire:loading wire:target="saveType" class="spinner-border spinner-border-sm me-2"></span>
                        <i class="ti ti-arrow-left fs-4"></i>
                    </button>
                </form>
            </div>
        </div>

        <div class="col-xl-7 col-lg-6 reveal-up" style="animation-delay: 0.2s">
            <div class="lux-card card border-0 p-5 h-100 shadow-sm">
                <div class="d-flex justify-content-between align-items-center mb-5 border-bottom pb-4">
                    <div>
                        <h4 class="fw-black m-0 text-dark">دیکشنری لایه‌ها</h4>
                        <span class="text-muted small fw-bold">Live Asset Feed</span>
                    </div>
                    <i class="ti ti-layers-subtract text-primary opacity-30 fs-1"></i>
                </div>

                <div class="table-responsive">
                    <table class="table align-middle lux-table">
                        <thead>
                        <tr class="text-end">
                            <th class="ps-4">نام دسته‌بندی</th>
                            <th>کدینگ سیستمی (Slug)</th>
                            <th class="text-center">عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($this->projectTypes as $type)
                            <tr wire:key="t-{{ $type->id }}" class="text-end">
                                <td class="ps-4">
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="bg-light rounded-3 d-flex align-items-center justify-content-center" style="width: 38px; height: 38px;"><i class="ti ti-hash text-primary"></i></div>
                                        <span class="fw-black text-slate fs-6">{{ $type->name }}</span>
                                    </div>
                                </td>
                                <td><code class="bg-indigo-soft px-3 py-1 rounded-pill text-primary fw-black" style="font-size: 0.75rem;">{{ $type->slug }}</code></td>
                                <td class="text-center">
                                    <button wire:click="deleteType({{ $type->id }})" wire:confirm="حذف کامل این دسته؟" class="btn btn-icon btn-white border rounded-circle p-2 hover-lift shadow-xs">
                                        <i class="ti ti-trash-x fs-4 text-danger"></i>
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center py-5">
                                    <div class="opacity-10 py-5">
                                        <i class="ti ti-database-off fs-1 d-block mb-3"></i>
                                        <p class="fw-bold fs-4">دیتابیس در حال حاضر خالی است.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
