<div class="container-fluid">
    <style>
        .text-primary-dark { color: #004d99 !important; }
        .bg-primary-darker { background-color: #004d99 !important; }
        .bg-primary-subtle { background-color: #f0f3f8 !important; }
        .btn-action-sm { padding: 0.5rem 1.2rem; font-size: 0.9rem; font-weight: bold; }
        .btn.rounded-pill { border-radius: 50px !important; }
        .text-success-dark { color: #155724 !important; }
        .table-responsive thead th { font-weight: bold; }
        .card-shadow-wide { box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08) !important; }
    </style>

    <div class="card bg-primary-subtle shadow-sm border-0 rounded-3 mb-4">
        <div class="card-body px-4 py-3">
            @if(session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show shadow-sm rounded-3">
                    <i class="ti ti-check me-2"></i>
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            <div class="row align-items-center">
                <div class="col-12">
                    <h4 class="fw-semibold mb-1 text-primary-dark">صندوق تأیید درخواست‌ها</h4>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a class="text-muted text-decoration-none" href="{{ route('admin.dashboard') }}">داشبورد</a></li>
                            <li class="breadcrumb-item active" aria-current="page">تأیید درخواست‌ها</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <section>
        <div class="card mb-4 shadow-sm border-0 rounded-3 card-shadow-wide">
            <div class="card-body">
                <div class="input-group">
                    <span class="input-group-text bg-primary-subtle"><i class="ti ti-search text-primary-dark"></i></span>
                    <input type="text" class="form-control" wire:model.live.debounce.300ms="search" placeholder="جستجو بر اساس شرح یا پروژه...">
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="card shadow-lg border-0 rounded-3 card-shadow-wide">
            <div class="card-body">
                <h5 class="mb-4 text-primary-dark fw-bold border-bottom pb-2">
                    لیست درخواست‌های در انتظار اقدام شما ({{ $this->pendingRequests->total() }})
                </h5>
                <div class="table-responsive">
                    <table class="table table-hover align-middle table-striped">
                        <thead class="bg-primary-darker text-white">
                        <tr>
                            <th>پروژه</th>
                            <th>کاربر</th>
                            <th>مبلغ کل</th>
                            <th>تاریخ ثبت</th>
                            <th>شرح مختصر</th>
                            <th>توضیحات شما</th>
                            <th>اقدام</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($this->pendingRequests as $request)
                            <tr wire:key="request-{{ $request->id }}">
                                <td><span class="fw-bold">{{ $request->project->name }}</span></td>
                                <td>{{ $request->user->name }}</td>
                                <td>
                                    <span class="fw-bold text-success-dark">{{ number_format($request->total_price) }}</span> ریال
                                </td>
                                <td>{{ \Morilog\Jalali\Jalalian::fromCarbon($request->created_at)->format('Y/m/d') }}</td>
                                <td>{{ Str::limit($request->description, 30) }}</td>
                                <td>
                                    <textarea class="form-control form-control-sm" wire:model.defer="comment.{{ $request->id }}" placeholder="توضیحات (اختیاری)" rows="2"></textarea>
                                </td>
                                <td>
                                    <div class="d-grid gap-2">
                                        <button class="btn btn-action-sm btn-success rounded-pill" wire:click="approveRequest({{ $request->id }})">
                                            <i class="ti ti-check me-1"></i>تأیید
                                        </button>
                                        <button class="btn btn-action-sm btn-danger rounded-pill" wire:click="rejectRequest({{ $request->id }})">
                                            <i class="ti ti-x me-1"></i>رد
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-4 text-muted">هیچ درخواستی در انتظار اقدام شما نیست.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    {{ $this->pendingRequests->links() }}
                </div>
            </div>
        </div>
    </section>
</div>
