<div class="container-fluid" x-data="{}">

    <div class="mb-3 d-flex justify-content-between align-items-center">
        <span class="badge status-badge
            @if($status == 'approved') bg-success
            @elseif($status == 'rejected') bg-danger
            @else bg-info text-white
            @endif
            fs-6 px-4 py-2 shadow-sm rounded-pill">
            <i class="ti me-1
                @if($status == 'approved') ti-check
                @elseif($status == 'rejected') ti-x
                @else ti-clock
                @endif
            "></i>
            وضعیت:
            @if($status == 'approved') تأیید نهایی شده
            @elseif($status == 'rejected') رد شده
            @else در انتظار ویرایش
            @endif
        </span>
        <a href="{{ route('purchase.my-requests') }}" class="btn btn-outline-secondary rounded-pill px-4 shadow-sm">
            <i class="ti ti-arrow-back-up me-1"></i>بازگشت به لیست
        </a>
    </div>

    <div class="row g-3 mb-4">
        <div class="col-md-6">
            <div class="alert alert-success-subtle text-success d-flex justify-content-between align-items-center py-3 rounded-3 shadow-sm">
                <i class="ti ti-coins fs-4"></i>
                <div>
                    <span class="fw-bold me-2">جمع مبلغ کل:</span>
                    <span class="fs-5 fw-bold">{{ number_format($this->totalAmount) }}</span> ریال
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="alert alert-primary-subtle text-primary d-flex justify-content-between align-items-center py-3 rounded-3 shadow-sm">
                <i class="ti ti-package fs-4"></i>
                <div>
                    <span class="fw-bold me-2">تعداد کل آیتم‌ها:</span>
                    <span class="fs-5 fw-bold">{{ number_format($this->totalCount) }}</span> عدد
                </div>
            </div>
        </div>
    </div>

    @if(isset($projectBudget) && $this->totalAmount > $projectBudget)
        <div class="alert alert-danger shadow-sm rounded-3">
            <i class="ti ti-alert-triangle me-2"></i>
            **هشدار بودجه:** مبلغ کل درخواست ({{ number_format($this->totalAmount) }} ریال) از سقف بودجه پروژه ({{ number_format($projectBudget) }} ریال) بیشتر است!
        </div>
    @endif

    <div class="card shadow-lg border-0 rounded-3">
        <div class="card-body">
            <h4 class="mb-4 text-primary-darker d-flex align-items-center gap-2 border-bottom pb-2">
                <i class="ti ti-edit fs-3"></i>
                ویرایش درخواست خرید #{{ $requestId }}
            </h4>

            @if(session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show shadow-sm rounded-3">
                    <i class="ti ti-check me-2"></i>
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form wire:submit.prevent="updateRequest">
                <div class="row g-3 mb-4 p-3 bg-light-subtle rounded-3 shadow-sm">
                    <div class="col-md-6">
                        <label class="form-label fw-semibold text-primary-darker">پروژه</label>
                        <select class="form-select shadow-sm @error('project_id') is-invalid @enderror" wire:model="project_id">
                            <option value="">انتخاب پروژه</option>
                            @foreach($this->projects as $project)
                                <option value="{{ $project->id }}">{{ $project->name }}</option>
                            @endforeach
                        </select>
                        @error('project_id') <span class="text-danger small"><i class="ti ti-alert-circle"></i> {{ $message }}</span> @enderror
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold text-primary-darker">توضیحات</label>
                        <textarea class="form-control shadow-sm @error('description') is-invalid @enderror" wire:model="description" rows="2" placeholder="توضیح تکمیلی یا دلیل درخواست"></textarea>
                        @error('description') <span class="text-danger small"><i class="ti ti-alert-circle"></i> {{ $message }}</span> @enderror
                    </div>
                </div>

                <h6 class="mt-4 mb-2 text-primary-darker fw-bold d-flex align-items-center gap-2 border-bottom pb-1">
                    <i class="ti ti-list-details"></i> اقلام درخواستی (ویرایش)
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover align-middle bg-white rounded-3 shadow-sm">
                        <thead class="bg-primary-darker text-white">
                        <tr>
                            <th>آیتم / خدمت</th>
                            <th>تعداد</th>
                            <th>قیمت واحد (ریال)</th>
                            <th>جمع (ریال)</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($items as $index => $item)
                            @php
                                $sum = (float)($item['quantity'] ?? 0) * (float)($item['price'] ?? 0);
                                $isService = empty($item['item_id']) && !empty($item['id']); // آیتم قبلی که بدون item_id است، خدمت است
                            @endphp
                            <tr class="align-middle">
                                <td class="item-selector-cell">
                                    @if($isService)
                                        <textarea class="form-control shadow-sm bg-info-subtle" wire:model="items.{{ $index }}.name" rows="2" placeholder="شرح خدمت"></textarea>
                                        <span class="badge bg-info mt-1">خدمت آزاد</span>
                                    @else
                                        <select class="form-select shadow-sm @error('items.' . $index . '.item_id') is-invalid @enderror" wire:model="items.{{ $index }}.item_id">
                                            <option value="">انتخاب کالا</option>
                                            @foreach($this->availableItems as $itm)
                                                <option value="{{ $itm->id }}">{{ $itm->name }} ({{ $itm->code }})</option>
                                            @endforeach
                                        </select>
                                    @endif
                                    @error('items.' . $index . '.item_id') <span class="text-danger small"><i class="ti ti-alert-circle"></i> {{ $message }}</span> @enderror
                                </td>
                                <td>
                                    <input type="number" min="1" class="form-control shadow-sm @error('items.' . $index . '.quantity') is-invalid @enderror" wire:model="items.{{ $index }}.quantity">
                                    @error('items.' . $index . '.quantity') <span class="text-danger small"><i class="ti ti-alert-circle"></i> {{ $message }}</span> @enderror
                                </td>
                                <td>
                                    <input type="number" min="0" class="form-control shadow-sm @error('items.' . $index . '.price') is-invalid @enderror" wire:model="items.{{ $index }}.price">
                                    @error('items.' . $index . '.price') <span class="text-danger small"><i class="ti ti-alert-circle"></i> {{ $message }}</span> @enderror
                                </td>
                                <td>
                                    <span class="fw-bold text-success">{{ number_format($sum) }}</span>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-danger rounded-pill"
                                            wire:click="removeItemRow({{ $index }})"
                                            @if(count($items) == 1) disabled @endif>
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                        <tr class="table-primary-subtle">
                            <td colspan="3" class="text-end fw-bold text-primary-darker">جمع کل:</td>
                            <td class="fw-bold text-success fs-5">{{ number_format($this->totalAmount) }}</td>
                            <td></td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <button type="button" class="btn btn-outline-primary-darker rounded-pill px-4 shadow-sm" wire:click="addItemRow">
                    <i class="ti ti-plus"></i> افزودن آیتم
                </button>

                <div class="mt-5 d-flex justify-content-end align-items-center gap-3">
                    <button type="submit" class="btn btn-success rounded-pill px-5 py-2 shadow-lg">
                        <i class="ti ti-edit me-1"></i> ذخیره تغییرات
                    </button>
                </div>
            </form>
        </div>
    </div>
    <style>
        .status-badge {
            border-radius: 1rem;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            font-weight: 600;
        }
        .text-primary-darker { color: #004d99 !important; }
        .bg-primary-darker { background-color: #004d99 !important; }
        .btn-outline-primary-darker {
            --bs-btn-color: #004d99;
            --bs-btn-border-color: #004d99;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #004d99;
        }
        .alert-success-subtle { background-color: #e6fbe6 !important; border-color: #c8e6c8; }
        .alert-primary-subtle { background-color: #e0f2ff !important; border-color: #b3d9ff; }
        .table-primary-subtle { background-color: #e0f2ff !important; }
        .form-select, .form-control { border-radius: 0.7rem !important; }
        .table thead th { font-weight: bold; }
        .shadow-sm { box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05) !important; }
    </style>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
</div>
