<div class="container-fluid py-4" dir="rtl" style="font-family: 'Vazirmatn', sans-serif; background: #f8fafc; min-height: 100vh;">
    <style>
        :root {
            --p-indigo: #4f46e5;
            --p-slate: #0f172a;
            --p-emerald: #10b981;
            --p-rose: #f43f5e;
            --p-glass: rgba(255, 255, 255, 0.9);
        }

        /* ✨ انیمیشن‌های پیشرفته */
        .reveal-up { animation: fadeInUp 0.5s ease-out both; }
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }

        /* 📦 استایل کارت‌ها (Neo-Glass) */
        .lux-card {
            background: var(--p-glass);
            backdrop-filter: blur(15px);
            border-radius: 28px;
            border: 1px solid rgba(255, 255, 255, 0.6);
            box-shadow: 0 10px 30px -10px rgba(0,0,0,0.05);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .lux-card:hover { transform: translateY(-5px); box-shadow: 0 20px 40px -10px rgba(0,0,0,0.1); }

        /* 📊 کارت‌های Bento Stats */
        .bento-stat {
            padding: 24px; border-radius: 24px; color: white; position: relative;
            overflow: hidden; height: 100%; display: flex; flex-direction: column; justify-content: center;
        }

        /* 📋 استایل پیشرفته جدول */
        .lux-table thead th {
            background: #f1f5f9; color: #64748b; font-weight: 800;
            font-size: 0.75rem; letter-spacing: 0.5px; padding: 18px 15px; border: none;
        }
        .lux-table tbody tr { transition: 0.2s; border-bottom: 1px solid #f1f5f9; }
        .lux-table tbody tr:hover { background: rgba(79, 70, 229, 0.03) !important; }

        /* 🔗 استایل سورت */
        .sort-link { cursor: pointer; color: #64748b; font-weight: 700; text-decoration: none; display: flex; align-items: center; gap: 6px; }
        .sort-active { color: var(--p-indigo) !important; text-shadow: 0 0 10px rgba(79, 70, 229, 0.2); }

        /* 🔘 المان‌های گرافیکی */
        .avatar-ui {
            width: 50px; height: 50px; border-radius: 18px;
            display: flex; align-items: center; justify-content: center;
            font-weight: 900; font-size: 1.4rem; box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        .search-box { border-radius: 18px; border: 2px solid #e2e8f0; padding: 14px 25px; transition: 0.3s; }
        .search-box:focus { border-color: var(--p-indigo); box-shadow: 0 0 0 5px rgba(79, 70, 229, 0.1); outline: none; }

        .no-print { @media print { display: none !important; } }
    </style>

    <div class="row g-4 mb-5 reveal-up">
        <div class="col-xl-3 col-md-6">
            <div class="bento-stat shadow-lg" style="background: var(--p-slate);">
                <span class="opacity-60 d-block mb-1 fw-bold">ذینفعان ثبت شده</span>
                <h3 class="fw-black m-0">{{ number_format($this->stats['total_count']) }}</h3>
                <i class="ti ti-users position-absolute opacity-10" style="font-size: 6rem; left: -10px; bottom: -10px;"></i>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="bento-stat shadow-lg" style="background: var(--p-indigo);">
                <span class="opacity-60 d-block mb-1 fw-bold">کل واریزی‌ها</span>
                <h3 class="fw-black m-0">{{ number_format($this->stats['total_paid']) }} <small class="fs-6 opacity-50">ریال</small></h3>
                <i class="ti ti-currency-dollar position-absolute opacity-10" style="font-size: 6rem; left: -10px; bottom: -10px;"></i>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="bento-stat shadow-lg" style="background: #fbbf24; color: #78350f;">
                <span class="opacity-70 d-block mb-1 fw-bold">در انتظار پرداخت</span>
                <h3 class="fw-black m-0">{{ number_format($this->stats['pending_amount']) }} <small class="fs-6 opacity-50">ریال</small></h3>
                <i class="ti ti-clock-hour-4 position-absolute opacity-10" style="font-size: 6rem; left: -10px; bottom: -10px;"></i>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="bento-stat shadow-lg" style="background: var(--p-emerald);">
                <span class="opacity-60 d-block mb-1 fw-bold">تعاملات ۳۰ روز اخیر</span>
                <h3 class="fw-black m-0">{{ $this->stats['recent_active'] }}</h3>
                <i class="ti ti-bolt position-absolute opacity-10" style="font-size: 6rem; left: -10px; bottom: -10px;"></i>
            </div>
        </div>
    </div>

    <div class="lux-card p-4 mb-4 reveal-up shadow-sm border-0">
        <div class="row g-3 align-items-center">
            <div class="col-md-6">
                <div class="position-relative">
                    <i class="ti ti-search position-absolute top-50 start-0 translate-middle-y ms-3 text-muted"></i>
                    <input type="text" class="form-control search-box ps-5 w-100" wire:model.live.debounce.400ms="search" placeholder="جستجو در نام، شناسه ملی یا شماره شبا...">
                </div>
            </div>
            <div class="col-md-3">
                <select class="form-select search-box w-100" wire:model.live="filter_type">
                    <option value="">همه دسته‌بندی‌ها</option>
                    <option value="person">شخص حقیقی</option>
                    <option value="company">شرکت حقوقی</option>
                </select>
            </div>
            <div class="col-md-3 text-start">
                <button class="btn btn-dark rounded-pill w-100 py-3 fw-black shadow-lg">
                    <i class="ti ti-plus me-1"></i> تعریف ذینفع جدید
                </button>
            </div>
        </div>
    </div>

    <div class="lux-card overflow-hidden reveal-up shadow-sm border-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 lux-table">
                <thead>
                <tr>
                    <th class="ps-5">
                        <a wire:click="sortBy('name')" class="sort-link {{ $sortField === 'name' ? 'sort-active' : '' }}">
                            پروفایل ذینفع @if($sortField === 'name') <i class="ti ti-chevron-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i> @endif
                        </a>
                    </th>
                    <th>شناسه هویتی</th>
                    <th>درگاه بانکی</th>
                    <th>
                        <a wire:click="sortBy('total_paid')" class="sort-link {{ $sortField === 'total_paid' ? 'sort-active' : '' }}">
                            گردش مالی @if($sortField === 'total_paid') <i class="ti ti-chevron-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i> @endif
                        </a>
                    </th>
                    <th>وضعیت اسناد</th>
                    <th class="text-center">مدیریت</th>
                </tr>
                </thead>
                <tbody>
                @forelse($this->payees as $payee)
                    <tr wire:key="payee-{{ $payee->id }}">
                        <td class="ps-5">
                            <div class="d-flex align-items-center gap-3">
                                <div class="avatar-ui {{ $payee->type == 'company' ? 'bg-indigo text-white shadow-indigo' : 'bg-emerald text-white shadow-emerald' }}"
                                     style="background: {{ $payee->type == 'company' ? '#4f46e5' : '#10b981' }}">
                                    {{ mb_substr($payee->name, 0, 1) }}
                                </div>
                                <div>
                                    <div class="fw-black text-dark fs-6">{{ $payee->name }}</div>
                                    <div class="text-muted small fw-bold mt-1">
                                        <i class="ti ti-tag me-1"></i> {{ $payee->type == 'company' ? 'حقوقی' : 'حقیقی' }}
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td><span class="badge bg-light text-dark border font-monospace fw-bold" style="letter-spacing: 1px;">{{ $payee->national_id }}</span></td>
                        <td>
                            <div class="d-flex align-items-center gap-2">
                                <div class="p-2 bg-white rounded-3 shadow-xs border"><i class="ti ti-building-bank text-primary"></i></div>
                                <div class="small">
                                    <div class="fw-black text-dark">بانک متصل</div>
                                    <div class="text-muted opacity-70 font-monospace">IR{{ wordwrap($payee->sheba, 4, ' ', true) }}</div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="fw-black text-indigo fs-6">{{ number_format($payee->total_paid ?? 0) }}</div>
                        </td>
                        <td>
                            @if($payee->pending_requests > 0)
                                <span class="badge bg-warning bg-opacity-10 text-warning rounded-pill px-3 py-2 fw-black">
                                    {{ $payee->pending_requests }} سند معلق
                                </span>
                            @else
                                <span class="badge bg-success bg-opacity-10 text-success rounded-pill px-3 py-2 fw-black">تصفیه شده</span>
                            @endif
                        </td>
                        <td class="text-center">
                            <button wire:click="showFinancialHistory({{ $payee->id }})" class="btn btn-icon btn-white border rounded-circle p-2 shadow-sm">
                                <i class="ti ti-eye fs-4 text-indigo"></i>
                            </button>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center py-5">
                            <i class="ti ti-database-off fs-1 text-muted opacity-20 d-block mb-3"></i>
                            <span class="text-muted fw-bold">هیچ ذینفعی با این مشخصات یافت نشد.</span>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4 border-top bg-light bg-opacity-50">
            {{ $this->payees->links() }}
        </div>
    </div>

    @if($payeeHistory)
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(15, 23, 42, 0.7); backdrop-filter: blur(10px);">
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content border-0 shadow-2xl overflow-hidden" style="border-radius: 35px;">
                    <div class="modal-header border-0 p-5 pb-0">
                        <div class="d-flex align-items-center gap-4">
                            <div class="avatar-ui bg-dark text-white" style="width: 70px; height: 70px; font-size: 2.2rem;">{{ mb_substr($payeeHistory->name, 0, 1) }}</div>
                            <div>
                                <h2 class="modal-title fw-black text-dark m-0">پروفایل مالی: {{ $payeeHistory->name }}</h2>
                                <span class="text-muted fw-bold mt-2 d-block">گزارش تجمعی اسناد و تراکنش‌های خزانه‌داری</span>
                            </div>
                        </div>
                        <button type="button" class="btn-close ms-0 me-auto shadow-none" wire:click="closeHistoryModal"></button>
                    </div>
                    <div class="modal-body p-5">
                        <div class="row g-4 mb-5">
                            <div class="col-md-4">
                                <div class="p-4 rounded-4 border-start border-4 border-indigo bg-light">
                                    <span class="text-muted small d-block mb-1 fw-bold">مجموع دریافتی تایید شده</span>
                                    <h3 class="fw-black text-indigo mb-0">{{ number_format($payeeHistory->grand_total ?? 0) }} <small class="fs-6">ریال</small></h3>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="p-4 rounded-4 border-start border-4 border-dark bg-light">
                                    <span class="text-muted small d-block mb-1 fw-bold">شناسه اقتصادی / ملی</span>
                                    <h3 class="fw-black text-dark mb-0 font-monospace">{{ $payeeHistory->national_id }}</h3>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="p-4 rounded-4 border-start border-4 border-emerald bg-light">
                                    <span class="text-muted small d-block mb-1 fw-bold">تعداد کل تعاملات</span>
                                    <h3 class="fw-black text-dark mb-0">{{ $payeeHistory->paymentRequests->count() }} <small class="fs-6">سند</small></h3>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive rounded-4 border shadow-inner">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="bg-light">
                                <tr class="text-end">
                                    <th class="ps-4">کد رهگیری سند</th>
                                    <th>پروژه مربوطه</th>
                                    <th>مبلغ نهایی</th>
                                    <th>تاریخ سررسید</th>
                                    <th>وضعیت نهایی</th>
                                    <th class="pe-4">توضیحات بابت</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($payeeHistory->paymentRequests as $pr)
                                    <tr class="text-end">
                                        <td class="ps-4 fw-bold font-monospace text-primary">#PRQ-{{ $pr->id }}</td>
                                        <td><div class="fw-bold text-dark">{{ $pr->project->name ?? 'عمومی' }}</div></td>
                                        <td class="fw-black text-indigo">{{ number_format($pr->amount) }}</td>
                                        <td><span class="small text-muted fw-bold">{{ jdate($pr->due_date)->format('Y/m/d') }}</span></td>
                                        <td>
                                            @php
                                                $st = match($pr->status) {
                                                    'paid' => ['bg' => 'success', 'text' => 'تسویه شده'],
                                                    'pending' => ['bg' => 'warning', 'text' => 'در جریان'],
                                                    default => ['bg' => 'danger', 'text' => 'ابطال']
                                                };
                                            @endphp
                                            <span class="status-badge bg-{{ $st['bg'] }} bg-opacity-10 text-{{ $st['bg'] }} fw-black px-3 py-1 rounded-pill small">
                                                {{ $st['text'] }}
                                            </span>
                                        </td>
                                        <td class="pe-4 small text-muted opacity-75">{{ Str::limit($pr->purpose, 45) }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer border-0 p-5 pt-0">
                        <button type="button" class="btn btn-secondary rounded-pill px-5 py-2 fw-black shadow-sm" wire:click="closeHistoryModal">بستن پرونده</button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
