<div class="container-fluid py-4 text-end" x-data="{
    expanded: null,
    type: @entangle('type'),
    sheba: @entangle('sheba'),
    toggle(id) {
        this.expanded = (this.expanded === id) ? null : id;
    },
    formatSheba(val) {
        if (!val) return '•••• •••• •••• •••• •••• ••••';
        let cleaned = val.replace(/\D/g, '');
        return cleaned.padEnd(24, '•').replace(/(.{4})/g, '$1 ').trim();
    }
}">
    <style>
        /* 🎨 سیستم طراحی مدرن و شیشه‌ای */
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --accent-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --dark-bg: #0f172a;
            --card-bg: rgba(255, 255, 255, 0.95);
            --glass-border: rgba(255, 255, 255, 0.2);
            --text-primary: #1e293b;
        }

        body { background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); min-height: 100vh; }

        .glass-card {
            background: var(--card-bg); backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border); border-radius: 28px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1); transition: all 0.4s ease;
        }

        .stat-card { position: relative; overflow: hidden; padding: 2rem; border-radius: 24px; }
        .stat-icon {
            width: 60px; height: 60px; border-radius: 18px; display: flex;
            align-items: center; justify-content: center; font-size: 1.6rem; color: white;
        }

        .modern-input {
            background: rgba(248, 250, 252, 0.8); border: 2px solid transparent;
            border-radius: 16px; padding: 0.8rem 1.2rem; font-weight: 600; transition: 0.3s;
        }
        .modern-input:focus { border-color: #667eea; background: white; box-shadow: 0 10px 20px rgba(102, 126, 234, 0.1); outline: none; }

        .sheba-input-wrapper { display: flex; align-items: center; direction: ltr; }
        .sheba-prefix-box {
            background: var(--primary-gradient); color: white; padding: 0.8rem 1.2rem;
            border-radius: 0 16px 16px 0; font-weight: 900;
        }
        .sheba-main-input { border-radius: 16px 0 0 16px !important; letter-spacing: 2px; }

        .modern-card {
            background: linear-gradient(135deg, var(--dark-bg) 0%, #1e293b 100%);
            border-radius: 24px; padding: 2rem; color: white; position: relative; overflow: hidden;
        }
        .card-chip-modern {
            width: 50px; height: 38px; background: linear-gradient(135deg, #f6d365 0%, #fda085 100%);
            border-radius: 10px; margin-bottom: 1.5rem;
        }

        .btn-modern {
            background: var(--primary-gradient); color: white; border: none;
            border-radius: 16px; padding: 14px 28px; font-weight: 900; transition: 0.3s;
        }
        .btn-modern:hover { transform: translateY(-3px); box-shadow: 0 15px 30px rgba(102, 126, 234, 0.4); }

        .reveal { opacity: 0; transform: translateY(20px); animation: reveal 0.6s ease forwards; }
        @keyframes reveal { to { opacity: 1; transform: translateY(0); } }

        [x-cloak] { display: none !important; }
    </style>

    <div class="row g-4 mb-5">
        @foreach([
            ['label' => 'کل ذینفعان نقدینگی', 'value' => $this->stats['total'], 'icon' => 'ti-chart-bar', 'gradient' => 'var(--primary-gradient)'],
            ['label' => 'نهادهای حقوقی', 'value' => $this->stats['company'], 'icon' => 'ti-building-skyscraper', 'gradient' => 'var(--secondary-gradient)'],
            ['label' => 'تامین‌کنندگان حقیقی', 'value' => $this->stats['person'], 'icon' => 'ti-user-bolt', 'gradient' => 'var(--accent-gradient)']
        ] as $stat)
            <div class="col-md-4 reveal">
                <div class="stat-card glass-card">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="stat-icon" style="background: {{ $stat['gradient'] }}">
                            <i class="ti {{ $stat['icon'] }}"></i>
                        </div>
                        <span class="badge rounded-pill px-3 py-2" style="background: {{ $stat['gradient'] }}; color: white; opacity: 0.8;">Live Data</span>
                    </div>
                    <h2 class="fw-black m-0 display-6 text-dark mb-1">{{ $stat['value'] }}</h2>
                    <p class="text-muted fw-bold mb-0 opacity-75 small">{{ $stat['label'] }}</p>
                </div>
            </div>
        @endforeach
    </div>

    <div class="row g-5">
        <div class="col-xl-5">
            <div class="glass-card p-4 sticky-top reveal" style="top: 25px;">
                <div class="d-flex align-items-center gap-3 mb-5">
                    <div class="p-3 rounded-3 shadow-sm" style="background: var(--primary-gradient);">
                        <i class="ti ti-id-badge-2 fs-3 text-white"></i>
                    </div>
                    <div>
                        <h4 class="fw-black m-0 text-dark">{{ $payeeId ? 'ویرایش پرونده دیجیتال' : 'تشکیل پرونده جدید' }}</h4>
                        <p class="text-muted mb-0 opacity-75 small">مدیریت هویت مالی و حساب‌های بانکی</p>
                    </div>
                </div>

                <form wire:submit.prevent="savePayee">
                    <div class="row g-4 text-start">
                        <div class="col-12">
                            <label class="form-label fw-bold text-dark mb-2 small">ماهیت قانونی ذینفع</label>
                            <div class="d-flex bg-light p-1 rounded-4 gap-1 border">
                                <button type="button" @click="type = 'company'" class="btn flex-grow-1 rounded-3 py-2 fw-bold transition-all"
                                        :style="type === 'company' ? 'background: var(--primary-gradient); color: white;' : 'background: transparent; color: #64748b;'">
                                    شرکت / حقوقی
                                </button>
                                <button type="button" @click="type = 'person'" class="btn flex-grow-1 rounded-3 py-2 fw-bold transition-all"
                                        :style="type === 'person' ? 'background: var(--primary-gradient); color: white;' : 'background: transparent; color: #64748b;'">
                                    شخص / حقیقی
                                </button>
                            </div>
                        </div>

                        <div class="col-12">
                            <label class="form-label fw-bold text-dark mb-1 small">نام کامل رسمی</label>
                            <input type="text" class="modern-input form-control fw-bold" wire:model.blur="name" placeholder="مثلا: شرکت مهندسی آریا">
                            @error('name') <span class="text-danger fw-bold" style="font-size: 11px;">{{ $message }}</span> @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-bold text-dark mb-1 small" x-text="type === 'company' ? 'شناسه ملی' : 'کد ملی'"></label>
                            <input type="text" class="modern-input form-control text-center font-monospace" wire:model.blur="national_id">
                            @error('national_id') <span class="text-danger fw-bold" style="font-size: 11px;">{{ $message }}</span> @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-bold text-dark mb-1 small">نام رابط / مسئول</label>
                            <input type="text" class="modern-input form-control" wire:model="contact_person">
                        </div>

                        <div class="col-12">
                            <label class="form-label fw-bold text-primary mb-1 small">شماره شبا (IBAN)</label>
                            <div class="sheba-input-wrapper shadow-sm">
                                <span class="sheba-prefix-box">IR</span>
                                <input type="text" class="modern-input form-control sheba-main-input fw-bold"
                                       wire:model.live="sheba" maxlength="24" placeholder="24 رقم بدون فاصله">
                            </div>
                            @error('sheba') <span class="text-danger fw-bold d-block mt-1" style="font-size: 11px;">{{ $message }}</span> @enderror
                        </div>

                        <div class="col-12">
                            <div class="modern-card shadow-lg">
                                <div class="d-flex justify-content-between align-items-start mb-4">
                                    <div class="card-chip-modern"></div>
                                    @if($bank_name && isset($this->iranianBanks[$bank_name]))
                                        <div class="text-start">
                                            <div class="fw-black fs-5 text-white">{{ $this->iranianBanks[$bank_name]['name'] }}</div>
                                            <span class="fs-xs opacity-50 text-white">Verified Account</span>
                                        </div>
                                    @endif
                                </div>
                                <div class="mb-3 text-start">
                                    <label class="fs-xs fw-bold opacity-30 d-block mb-1 text-white">ACCOUNT HOLDER IBAN</label>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="fw-black fs-4 text-warning">IR</span>
                                        <div class="font-monospace fs-4 fw-bold text-white tracking-widest" x-text="formatSheba(sheba)"></div>
                                    </div>
                                </div>
                                <div class="row g-2 mt-auto">
                                    <div class="col-6">
                                        <select class="form-select bg-white bg-opacity-10 border-0 text-white rounded-3 fw-bold shadow-none small" wire:model.live="bank_name">
                                            <option value="" class="text-dark">تغییر بانک عامل</option>
                                            @foreach($this->iranianBanks as $code => $bank)
                                                <option value="{{ $code }}" class="text-dark">{{ $bank['name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-6">
                                        <input type="text" class="form-control bg-white bg-opacity-10 border-0 text-white rounded-3 fw-bold text-start shadow-none" wire:model="account_number" placeholder="شماره حساب">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 mt-4">
                            <button type="submit" class="btn-modern w-100 d-flex align-items-center justify-content-center gap-2 py-3 shadow-lg">
                                <i class="ti ti-{{ $payeeId ? 'edit' : 'device-floppy' }} fs-5"></i>
                                <span>{{ $payeeId ? 'به‌روزرسانی نهایی پرونده' : 'تایید نهایی و ثبت در سیستم' }}</span>
                            </button>
                            @if($payeeId)
                                <button type="button" wire:click="resetForm" class="btn btn-link w-100 mt-2 text-muted text-decoration-none small fw-bold">انصراف و فرم جدید</button>
                            @endif
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-xl-7">
            <div class="glass-card p-4 reveal" style="animation-delay: 0.2s">
                <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-5 gap-3">
                    <div class="d-flex align-items-center gap-3">
                        <div class="p-2 rounded-3 text-white shadow-sm" style="background: var(--primary-gradient);">
                            <i class="ti ti-database-search fs-4"></i>
                        </div>
                        <h4 class="fw-black m-0 text-dark">مانیتورینگ تامین‌کنندگان</h4>
                    </div>
                    <div class="input-group bg-light rounded-pill px-4 py-1 border shadow-inner" style="max-width: 350px;">
                        <i class="ti ti-search text-muted mt-2 me-2"></i>
                        <input type="text" class="form-control bg-transparent border-0 shadow-none fw-bold small"
                               wire:model.live.debounce.400ms="search" placeholder="جستجو در نام، شناسه یا شبا...">
                    </div>
                </div>

                <div class="table-responsive rounded-4 border overflow-hidden">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                        <tr class="text-end">
                            <th class="ps-4 py-3">پروفایل ذینفع</th>
                            <th>شناسه سیستم</th>
                            <th class="text-center pe-4">وضعیت</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($this->payeesList as $payee)
                            <tr :class="expanded === {{ $payee->id }} ? 'bg-light bg-opacity-50' : ''"
                                class="cursor-pointer transition-all" @click="toggle({{ $payee->id }})">
                                <td class="ps-4 py-3 text-end">
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="p-2 rounded-4 text-white shadow-sm" style="background: var(--primary-gradient)">
                                            <i class="ti ti-{{ $payee->type === 'company' ? 'building-community' : 'user-circle' }} fs-4"></i>
                                        </div>
                                        <div>
                                            <div class="fw-black text-dark fs-6">{{ $payee->name }}</div>
                                            <span class="badge bg-light text-muted fw-bold border" style="font-size: 10px;">{{ $payee->type === 'company' ? 'حقوقی' : 'حقیقی' }}</span>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-end font-monospace">
                                    <span class=" bg-opacity-10 text-primary px-3 py-1 rounded-pill fw-bold small">{{ $payee->national_id }}</span>
                                </td>
                                <td class="text-center pe-4">
                                    <i class="ti fs-5 text-muted transition-all" :class="expanded === {{ $payee->id }} ? 'ti-chevron-up text-primary' : 'ti-chevron-down'"></i>
                                </td>
                            </tr>
                            <tr x-show="expanded === {{ $payee->id }}" x-collapse x-cloak>
                                <td colspan="3" class="p-0 border-0 bg-light bg-opacity-30">
                                    <div class="p-4 border-top border-bottom border-light">
                                        <div class="row g-4 text-end">
                                            <div class="col-md-7">
                                                <div class="p-3 bg-white rounded-4 border shadow-sm h-100">
                                                    <label class="small fw-bold text-muted mb-2 d-block">اطلاعات حساب بانکی:</label>
                                                    <div class="bg-light p-3 rounded-3 font-monospace fw-black text-center border mb-3 fs-5">
                                                        <span class="opacity-30">IR</span>{{ $payee->sheba }}
                                                    </div>
                                                    <div class="d-flex justify-content-between align-items-center px-2">
                                                        <span class="small fw-bold text-muted">بانک عامل: <strong class="text-dark">{{ $this->iranianBanks[$payee->bank_name]['name'] ?? '—' }}</strong></span>
                                                        <span class="small fw-bold text-muted">شماره حساب: <strong class="text-dark">{{ $payee->account_number ?? '—' }}</strong></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-5 d-flex flex-column gap-3">
                                                <div class="p-3 bg-white rounded-4 border shadow-sm flex-grow-1">
                                                    <label class="small fw-bold text-muted mb-1 d-block">مسئول پیگیری:</label>
                                                    <div class="fw-black text-primary">{{ $payee->contact_person ?? 'تعیین نشده' }}</div>
                                                </div>
                                                <div class="d-flex gap-2">
                                                    <button wire:click.stop="editPayee({{ $payee->id }})" class="btn btn-white border border-primary text-primary flex-grow-1 rounded-3 py-2 fw-black small shadow-sm"><i class="ti ti-edit me-1"></i> ویرایش</button>
                                                    <button wire:click.stop="deletePayee({{ $payee->id }})" onclick="confirm('حذف شود؟') || event.stopImmediatePropagation()" class="btn btn-white border border-danger text-danger flex-grow-1 rounded-3 py-2 fw-black small shadow-sm"><i class="ti ti-trash me-1"></i> حذف</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="3" class="text-center py-5 opacity-40 fw-bold">بانک اطلاعاتی خالی است.</td></tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-4 d-flex justify-content-center">
                    {{ $this->payeesList->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
