<div class="container-fluid py-4" style="background: #f4f7fe; min-height: 100vh;">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;700;900&display=swap');

        .fw-black { font-weight: 900 !important; }
        .glass-card {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.4);
            border-radius: 1.5rem;
            transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
        }
        .glass-card:hover { transform: translateY(-7px); box-shadow: 0 20px 40px rgba(0,0,0,0.06) !important; }

        .stat-icon { width: 52px; height: 52px; border-radius: 14px; display: flex; align-items: center; justify-content: center; box-shadow: 0 8px 16px rgba(0,0,0,0.08); }
        .progress-lux { height: 8px; background: #e2e8f0; border-radius: 10px; overflow: hidden; }
        .progress-bar-glow { box-shadow: 0 0 12px rgba(67, 56, 202, 0.3); }

        .approval-step {
            width: 12px; height: 12px; border-radius: 50%; display: inline-block;
            margin-left: 5px; position: relative; border: 2px solid #fff; box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .approval-step:hover { transform: scale(1.3); transition: 0.2s; }

        .table thead th { border-top: none; text-transform: uppercase; font-size: 0.7rem; letter-spacing: 0.05rem; color: #64748b; font-weight: 800; }
        .avatar-sm { width: 35px; height: 35px; border: 2px solid #fff; border-radius: 10px; object-fit: cover; }

        /* تداخل‌زدایی با ApexCharts */
        .apexcharts-canvas { margin: 0 auto; }
        .apexcharts-tooltip { border-radius: 12px !important; border: none !important; box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1) !important; font-family: inherit !important; }
    </style>

    <div class="row g-4 mb-5">
        <div class="col-xl-3 col-md-6">
            <div class="card glass-card shadow-sm border-0 p-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-3">
                        <div class="stat-icon bg-primary text-white"><i class="ti ti-layers-linked fs-3"></i></div>
                        <span class="badge bg-primary-subtle text-primary rounded-pill px-3 py-1 fw-bold">حجم کل</span>
                    </div>
                    <h6 class="text-muted fw-bold small">ارزش کل درخواست‌های خرید</h6>
                    <h3 class="fw-black mb-0 text-dark">{{ number_format($totalAmount / 1000000, 1) }} <small class="fs-6 opacity-50">م. ریال</small></h3>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card glass-card shadow-sm border-0 p-3 border-bottom border-warning border-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-3">
                        <div class="stat-icon bg-warning text-white shadow-warning"><i class="ti ti-clock-share fs-3"></i></div>
                        <span class="badge bg-warning-subtle text-warning rounded-pill px-3 py-1 fw-bold">نیاز به نقدینگی</span>
                    </div>
                    <h6 class="text-muted fw-bold small">در صف تایید نهایی</h6>
                    <h3 class="fw-black mb-0 text-dark">{{ number_format($pendingAmount / 1000000, 1) }} <small class="fs-6 opacity-50">م. ریال</small></h3>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card glass-card shadow-sm border-0 p-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-3">
                        <div class="stat-icon bg-{{ $efficiency['color'] }} text-white shadow-{{ $efficiency['color'] }}"><i class="ti ti-bolt fs-3"></i></div>
                        <span class="badge bg-{{ $efficiency['color'] }}-subtle text-{{ $efficiency['color'] }} rounded-pill px-3 py-1 fw-bold">بهره‌وری</span>
                    </div>
                    <h6 class="text-muted fw-bold small">سرعت چرخه تاییدات</h6>
                    <h3 class="fw-black mb-0 text-dark">{{ $efficiency['days'] }} <small class="fs-6 opacity-50">روز</small></h3>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card glass-card shadow-sm border-0 p-3" style="background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);">
                <div class="card-body text-white">
                    <div class="d-flex justify-content-between mb-3">
                        <div class="stat-icon bg-white bg-opacity-10 text-white"><i class="ti ti-shield-check fs-3"></i></div>
                        <i class="ti ti-trending-down opacity-50 fs-4"></i>
                    </div>
                    <h6 class="text-white-50 fw-bold small">نرخ رد (تضمین کیفیت)</h6>
                    <h3 class="fw-black mb-0 text-white">{{ $efficiency['rejection_rate'] }}٪</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-5">
        <div class="col-lg-8">
            <div class="card glass-card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-0 p-4 d-flex justify-content-between align-items-center">
                    <h5 class="fw-black text-dark mb-0"><i class="ti ti-chart-line text-primary me-2"></i>تحلیل هوشمند روند تقاضا</h5>
                    <div class="bg-light p-1 rounded-pill">
                        <button wire:click="$set('chartRange', 7)" class="btn btn-sm rounded-pill px-4 {{ $chartRange == 7 ? 'bg-white shadow-sm fw-bold text-primary' : 'border-0 text-muted' }}">هفته</button>
                        <button wire:click="$set('chartRange', 30)" class="btn btn-sm rounded-pill px-4 {{ $chartRange == 30 ? 'bg-white shadow-sm fw-bold text-primary' : 'border-0 text-muted' }}">ماه</button>
                    </div>
                </div>
                <div class="card-body p-4 pt-0">
                    <div id="apexTrendChart" style="min-height: 320px;"></div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card glass-card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-0 p-4 pb-0 text-center">
                    <h5 class="fw-black text-dark mb-0">ساختار وضعیت پرونده‌ها</h5>
                </div>
                <div class="card-body d-flex flex-column align-items-center justify-content-center">
                    <div id="apexDonutChart" style="min-height: 250px;"></div>
                    <div class="w-100 mt-4 px-3">
                        <div class="d-flex justify-content-between py-2 border-bottom border-light">
                            <span class="small fw-bold text-muted"><i class="ti ti-circle-filled text-warning me-1"></i>در جریان</span>
                            <span class="fw-black text-dark">{{ $statusData['pending'] }}</span>
                        </div>
                        <div class="d-flex justify-content-between py-2 border-bottom border-light">
                            <span class="small fw-bold text-muted"><i class="ti ti-circle-filled text-success me-1"></i>تایید شده</span>
                            <span class="fw-black text-dark">{{ $statusData['approved'] }}</span>
                        </div>
                        <div class="d-flex justify-content-between py-2">
                            <span class="small fw-bold text-muted"><i class="ti ti-circle-filled text-danger me-1"></i>رد شده</span>
                            <span class="fw-black text-dark">{{ $statusData['rejected'] }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-5">
        <div class="col-lg-6">
            <div class="card glass-card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent py-4 px-4 border-0">
                    <h5 class="fw-black text-dark mb-0"><i class="ti ti-flame text-danger me-2"></i>نقاط بحرانی بودجه</h5>
                </div>
                <div class="card-body px-4 pt-0">
                    @forelse($criticalProjects as $project)
                        <div class="mb-4 p-3 rounded-4 bg-light bg-opacity-40 border border-white">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="fw-bold text-dark fs-6">{{ Str::limit($project->name, 35) }}</span>
                                <span class="badge bg-{{ $project->utilization > 85 ? 'danger' : 'primary' }} text-white rounded-pill px-3 fw-black">{{ $project->utilization }}%</span>
                            </div>
                            <div class="progress-lux">
                                <div class="progress-bar progress-bar-glow"
                                     style="width: {{ $project->utilization }}%; background: {{ $project->utilization > 85 ? '#ef4444' : '#4f46e5' }}; transition: 1s;"></div>
                            </div>
                            <div class="mt-2 d-flex justify-content-between fs-xs fw-bold text-muted">
                                <span>صرف شده: {{ number_format($project->spent / 1000000, 1) }} م.ر</span>
                                <span>سقف مجاز: {{ number_format($project->budget / 1000000, 1) }} م.ر</span>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-5 text-muted fw-bold small">اطلاعات بودجه‌ای یافت نشد.</div>
                    @endforelse
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card glass-card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent py-4 px-4 border-0 d-flex justify-content-between align-items-center">
                    <h5 class="fw-black text-dark mb-0"><i class="ti ti-clipboard-check text-primary me-2"></i>کارتابل تاییدات آنی</h5>
                    <span class="badge bg-danger rounded-circle p-2">{{ count($myPendingApprovals) }}</span>
                </div>
                <div class="card-body px-4 pt-0">
                    @forelse($myPendingApprovals as $approval)
                        <div class="d-flex align-items-center p-3 mb-3 rounded-4 bg-white border border-light shadow-xs hover-translate-top transition-all">
                            <img src="{{ $approval->request->user->profile_photo_url ?? asset('panel/dist/images/default-avatar.png') }}" class="avatar-sm me-3 shadow-sm">
                            <div class="flex-grow-1">
                                <h6 class="fw-black text-dark mb-0 small">{{ Str::limit($approval->request->project->name, 25) }}</h6>
                                <small class="text-muted fw-bold">ثبت: {{ $approval->request->user->name }}</small>
                            </div>
                            <div class="text-end">
                                <div class="fw-black text-primary small mb-1">{{ number_format($approval->request->total_price) }}</div>
                                <a href="{{ route('admin.purchase.approval') }}" class="btn btn-sm btn-dark rounded-pill px-3 fw-black smaller-8 shadow-sm">بررسی</a>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-5 opacity-40">
                            <i class="ti ti-circle-check fs-1 mb-2 text-success"></i>
                            <p class="fw-bold small">کارتابل شما خالی است.</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <div class="card glass-card border-0 shadow-sm overflow-hidden border border-white">
        <div class="card-header bg-white py-4 px-4 border-0 d-flex justify-content-between align-items-center">
            <h5 class="fw-black text-dark mb-0">نظارت سیستمی بر آخرین وقایع</h5>
            <a href="{{ route('admin.all_purchase') }}" class="btn btn-light rounded-pill px-4 fw-bold small border shadow-sm">آرشیو کامل</a>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light bg-opacity-50">
                <tr class="text-muted small fw-black text-uppercase">
                    <th class="ps-4">پروژه و شناسنامه پرونده</th>
                    <th>ارزش برآورد</th>
                    <th>وضعیت تایید</th>
                    <th>تاریخ ثبت</th>
                    <th class="text-center">زنجیره امضاها</th>
                    <th class="text-center">اقدام</th>
                </tr>
                </thead>
                <tbody>
                @foreach($latestRequests as $req)
                    <tr>
                        <td class="ps-4 py-3">
                            <div class="fw-black text-dark fs-6">{{ $req->project->name }}</div>
                            <small class="text-muted fw-bold">ID: #{{ $req->id }} • {{ $req->user->name }}</small>
                        </td>
                        <td class="fw-black text-primary fs-5">{{ number_format($req->total_price) }}</td>
                        <td>
                            @php
                                $map = [ 'approved' => ['success', 'تایید نهایی'], 'rejected' => ['danger', 'رد شده'], 'pending' => ['warning', 'در جریان'] ];
                                $st = $map[$req->status] ?? ['secondary', 'نامشخص'];
                            @endphp
                            <span class="badge bg-{{ $st[0] }}-subtle text-{{ $st[0] }} fw-bold px-3 py-2 rounded-pill small border border-{{ $st[0] }} border-opacity-10">{{ $st[1] }}</span>
                        </td>
                        <td class="text-muted fw-bold small">{{ Verta::instance($req->created_at)->format('Y/m/d H:i') }}</td>
                        <td class="text-center">
                            <div class="d-flex justify-content-center">
                                @foreach($req->approvals->sortBy('priority') as $appr)
                                    <span class="approval-step shadow-sm"
                                          style="background: {{ $appr->is_approved === true ? '#10b981' : ($appr->is_approved === false ? '#ef4444' : '#cbd5e1') }}"
                                          data-bs-toggle="tooltip"
                                          title="{{ $appr->user->name }} ({{ $appr->role->name }})"></span>
                                @endforeach
                            </div>
                        </td>
                        <td class="text-center">
                            <button class="btn btn-icon btn-white border rounded-circle shadow-sm" data-bs-toggle="modal" data-bs-target="#detailModal{{ $req->id }}">
                                <i class="ti ti-external-link text-primary fs-5"></i>
                            </button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <script src="{{ asset('panel/dist/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
    <script>
        document.addEventListener('livewire:initialized', () => {
            let trendChart, donutChart;

            const renderCharts = () => {
                // --- ۱. نمودار روند (Area Chart) ---
                const trendOptions = {
                    series: [{
                        name: 'تعداد درخواست‌ها',
                        data: @json($trendData)
                    }],
                    chart: {
                        type: 'area',
                        height: 320,
                        toolbar: { show: false },
                        fontFamily: 'inherit',
                        zoom: { enabled: false }
                    },
                    colors: ['#4f46e5'],
                    dataLabels: { enabled: false },
                    stroke: { curve: 'smooth', width: 4 },
                    fill: {
                        type: 'gradient',
                        gradient: {
                            shadeIntensity: 1,
                            opacityFrom: 0.4,
                            opacityTo: 0,
                            stops: [0, 90, 100]
                        }
                    },
                    xaxis: {
                        categories: @json($trendLabels),
                        axisBorder: { show: false },
                        axisTicks: { show: false },
                        labels: { style: { colors: '#64748b', fontWeight: 600 } }
                    },
                    yaxis: { labels: { style: { colors: '#64748b', fontWeight: 600 } } },
                    grid: { borderColor: '#f1f5f9', strokeDashArray: 5 },
                    tooltip: { theme: 'light', x: { show: true } }
                };

                if (trendChart) trendChart.destroy();
                trendChart = new ApexCharts(document.querySelector("#apexTrendChart"), trendOptions);
                trendChart.render();

                // --- ۲. نمودار دونات وضعیت ---
                const donutOptions = {
                    series: [@json($statusData['pending']), @json($statusData['approved']), @json($statusData['rejected'])],
                    chart: {
                        type: 'donut',
                        height: 280
                    },
                    labels: ['Pending', 'Approved', 'Rejected'],
                    colors: ['#ffc107', '#10b981', '#ef4444'],
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '82%',
                                labels: {
                                    show: true,
                                    total: {
                                        show: true,
                                        label: 'مجموع پرونده‌ها',
                                        fontSize: '12px',
                                        fontWeight: 800,
                                        color: '#1e293b'
                                    }
                                }
                            }
                        }
                    },
                    stroke: { show: false },
                    dataLabels: { enabled: false },
                    legend: { show: false },
                    tooltip: { theme: 'dark' }
                };

                if (donutChart) donutChart.destroy();
                donutChart = new ApexCharts(document.querySelector("#apexDonutChart"), donutOptions);
                donutChart.render();
            };

            renderCharts();

            // گوش دادن به رویداد ریفرش لایووایر
            Livewire.on('refreshCharts', () => {
                setTimeout(() => { renderCharts(); }, 100);
            });
        });
    </script>
</div>
