<div class="saraman-purchase-v18 pb-5 overflow-visible"
     x-data="purchaseFormState()"
     x-init="initializeShamsiPicker(); @this.on('request-reset-success', () => { resetFormState(); })">

    <style>
        /* 🏛️ Pinnacle Corporate Design System */
        .saraman-purchase-v18 {
            --exec-navy: #0f172a;
            --exec-indigo: #6366f1;
            --exec-slate: #64748b;
            --exec-border: #e2e8f0;
            --exec-bg: #f8fafc;
            background: var(--exec-bg);
            min-height: 100vh; font-family: 'Peyda', 'Vazirmatn', sans-serif; direction: rtl; color: var(--exec-navy);
        }

        /* 🏔️ Bento Header (بجای هدر چسبنده) */
        .bento-info-header {
            background: white;
            border: 1px solid var(--exec-border);
            border-radius: 30px;
            padding: 2rem 3rem;
            margin-bottom: 2.5rem;
            display: flex; justify-content: space-between; align-items: center;
            box-shadow: 0 10px 25px -5px rgba(0,0,0,0.02);
        }

        /* 📦 Executive Workstation */
        .exec-station-v18 {
            background: white; border-radius: 35px; border: 1px solid var(--exec-border);
            box-shadow: 0 30px 60px -15px rgba(15, 23, 42, 0.04); overflow: hidden; margin-bottom: 3.5rem;
        }
        .exec-card-header {
            background: #fcfcfd; padding: 2rem 2.5rem; border-bottom: 1px solid var(--exec-border);
            display: flex; align-items: center; gap: 15px;
        }

        /* 🛠️ Modern Form Controls */
        .field-label-v18 { font-size: 0.8rem; font-weight: 800; color: var(--exec-slate); margin-bottom: 10px; display: block; letter-spacing: -0.2px; }
        .input-v18 {
            border-radius: 16px; border: 1.5px solid #e5e7eb; padding: 14px 20px;
            font-weight: 700; transition: 0.3s cubic-bezier(0.4, 0, 0.2, 1); background: #fff;
        }
        .input-v18:focus { border-color: var(--exec-indigo); box-shadow: 0 0 0 5px rgba(99, 102, 241, 0.08); outline: none; }

        /* 📋 Accordion v18 - Layered Rows */
        .accordion-lux-v18 .accordion-item {
            border: 1px solid var(--exec-border) !important; border-radius: 22px !important;
            margin-bottom: 14px; overflow: hidden; background: white; transition: 0.4s;
            box-shadow: 0 2px 10px rgba(0,0,0,0.01);
        }
        .accordion-lux-v18 .accordion-item:hover { border-color: var(--exec-indigo) !important; transform: scale(1.005); box-shadow: 0 15px 35px -10px rgba(0,0,0,0.05); }

        .accordion-button-v18 {
            padding: 1.5rem 2rem; background: white !important; font-weight: 900; border: none; box-shadow: none !important;
        }

        /* 🧪 Timeline workflow */
        .workflow-step { position: relative; padding-right: 30px; margin-bottom: 25px; }
        .workflow-step::before { content: ''; position: absolute; right: 6px; top: 20px; bottom: -30px; width: 2px; background: #f1f5f9; }
        .workflow-step:last-child::before { display: none; }
        .workflow-dot { width: 14px; height: 14px; border-radius: 50%; background: #e2e8f0; position: absolute; right: 0; top: 4px; border: 3px solid white; box-shadow: 0 0 0 1px #e2e8f0; }
        .workflow-dot.done { background: var(--exec-emerald); box-shadow: 0 0 10px var(--exec-emerald); }

        /* 📱 Utilities */
        .btn-exec-v18 {
            background: var(--exec-navy); color: white !important; border-radius: 16px;
            padding: 14px 35px; font-weight: 900; transition: 0.3s; border: none;
        }
        .btn-exec-v18:hover { background: var(--exec-indigo); transform: translateY(-3px); box-shadow: 0 15px 30px rgba(99, 102, 241, 0.2); }

        [x-cloak] { display: none !important; }
    </style>

    <div class="container-fluid px-lg-5 pt-4">

        {{-- ۱. هدر بنتو (اطلاعات کلی سیستم) --}}
        <div class="bento-info-header">
            <div class="d-flex align-items-center gap-4">
                <div class="p-3 bg-dark rounded-4 shadow-lg text-white">
                    <i class="ti ti-database-cog fs-2"></i>
                </div>
                <div>
                    <h2 class="fw-black mb-1 h4" style="letter-spacing: -1px;">پنل تدارکات سازمانی</h2>
                    <span class="text-muted smaller fw-bold d-flex align-items-center">
                        <i class="ti ti-shield-check text-success me-2 fs-5"></i> پروتکل تدارکات و خرید متمرکز سرآمان
                    </span>
                </div>
            </div>
            <div class="d-flex gap-5">
                <div class="text-center">
                    <small class="field-label-v18 mb-0">کل درخواست‌ها</small>
                    <span class="fw-black h4 mb-0">{{ $quickStats['total'] }}</span>
                </div>
                <div class="vr opacity-10"></div>
                <div class="text-center">
                    <small class="field-label-v18 mb-0 text-warning">در انتظار اقدام</small>
                    <span class="fw-black h4 mb-0 text-warning">{{ $quickStats['pending'] }}</span>
                </div>
                <button class="btn btn-outline-dark rounded-pill px-4 fw-black border-2 ms-3">آموزش سامانه</button>
            </div>
        </div>

        {{-- ۲. ایستگاه کاری ثبت PR --}}
        <div class="exec-station-v18 shadow-sm animate-fade-in">
            <div class="exec-card-header">
                <div class="d-flex align-items-center gap-3">
                    <div class="p-2 bg-indigo-subtle rounded-3 text-indigo"><i class="ti ti-file-pencil fs-3"></i></div>
                    <h5 class="fw-black mb-0">تنظیم و ارسال درخواست جدید (Purchase Request)</h5>
                </div>
                <span class="badge bg-light text-muted rounded-pill px-4 py-2 fw-black small">Corporate Interface v18.0</span>
            </div>

            <div class="p-4 p-md-5">
                <div class="row g-4 mb-5">
                    <div class="col-md-4">
                        <label class="field-label-v18 px-1">پروژه و مرکز هزینه</label>
                        <div class="position-relative mb-2">
                            <i class="ti ti-search position-absolute top-50 translate-middle-y ms-3 text-muted"></i>
                            <input type="text" class="form-control input-v18 ps-5 border-dashed" wire:model.live.debounce.300ms="projectSearch" placeholder="نام پروژه...">
                        </div>
                        <select class="form-select input-v18" wire:model.defer="project_id">
                            <option value="">-- انتخاب پروژه مقصد --</option>
                            @foreach($this->projectsList as $project)
                                <option value="{{ $project->id }}">{{ $project->name }} ({{ $project->code }})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="field-label-v18 px-1">سرفصل بودجه تخصیصی</label>
                        <select class="form-select input-v18" wire:model.defer="cost_center_id">
                            <option value="">-- انتخاب سرفصل مالی --</option>
                            @foreach($costCenters as $id => $name) <option value="{{ $id }}">{{ $name }}</option> @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="field-label-v18 px-1">مهلت نهایی تامین کالا</label>
                        <div class="input-group">
                            <span class="input-group-text bg-white border-end-0 rounded-start-4 text-indigo"><i class="ti ti-calendar-event"></i></span>
                            <input type="text" class="form-control input-v18 border-start-0 rounded-start-0 shamsi-date-picker" wire:model.defer="required_by" id="required_by_input">
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="field-label-v18 px-1">شرح ضرورت و توضیحات تکمیلی</label>
                        <textarea class="form-control input-v18" wire:model.defer="description" rows="2" placeholder="دلیل نیاز به این کالا/خدمت را به صورت فنی و دقیق بنویسید..."></textarea>
                    </div>
                </div>

                {{-- بخش افزودن آیتم (Workdesk) --}}
                <div class="bg-light p-4 rounded-5 border border-white shadow-sm">
                    <div class="row g-4 align-items-end">
                        <div class="col-md-5">
                            <div class="btn-group w-100 mb-3 bg-white p-1 rounded-4 border shadow-sm">
                                <button type="button" class="btn btn-sm py-2 rounded-3 fw-black" :class="itemType === 'product' ? 'bg-dark text-white' : 'btn-white border-0'" @click="setItemType('product')">کالای انبار</button>
                                <button type="button" class="btn btn-sm py-2 rounded-3 fw-black" :class="itemType === 'service' ? 'bg-dark text-white' : 'btn-white border-0'" @click="setItemType('service')">خدمات فنی</button>
                            </div>
                            <template x-if="itemType === 'product'">
                                <select class="form-select input-v18" x-model="newItem.id" @change="updateNewItemName($event)">
                                    <option value="">-- انتخاب کالا از کاتالوگ --</option>
                                    @foreach($this->availableItemsList as $item)
                                        <option value="{{ $item->id }}" data-name="{{ $item->name }}" data-code="{{ $item->code }}">{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </template>
                            <template x-if="itemType === 'service'">
                                <input type="text" class="form-control input-v18" x-model="newItem.name" placeholder="شرح خدمت یا کالای خارج از لیست...">
                            </template>
                        </div>
                        <div class="col-md-2">
                            <label class="field-label-v18 text-center">مقدار</label>
                            <input type="number" class="form-control input-v18 text-center fs-5" x-model.number="newItem.quantity">
                        </div>
                        <div class="col-md-3">
                            <label class="field-label-v18 text-center">برآورد قیمت واحد (ریال)</label>
                            <input type="text" class="form-control input-v18 text-center fw-black fs-5 text-indigo" x-model="newItem.price" @keyup="formatPrice">
                        </div>
                        <div class="col-md-2">
                            <button type="button" class="btn btn-exec-v18 w-100 py-3 shadow-lg" @click="addItem()" :disabled="!isItemValid()">
                                <i class="ti ti-plus me-1"></i> درج در لیست
                            </button>
                        </div>
                    </div>
                </div>

                {{-- لیست اقلام انتخابی --}}
                <div class="mt-5" x-show="items.length > 0" x-cloak x-transition>
                    <div class="table-responsive border rounded-5 bg-white overflow-hidden shadow-sm">
                        <table class="table align-middle mb-0">
                            <thead class="bg-indigo-subtle">
                            <tr class="smaller fw-black text-indigo">
                                <th class="ps-4 py-3">ردیف</th><th>دسته</th><th>شرح دقیق کالا / خدمت</th><th class="text-center">تعداد</th><th>جمع جزء (ریال)</th><th class="text-center">عملیات</th>
                            </tr>
                            </thead>
                            <tbody class="fw-bold fs-6">
                            <template x-for="(item, index) in items" :key="index">
                                <tr class="border-bottom border-light">
                                    <td class="ps-4 text-muted" x-text="index + 1"></td>
                                    <td><span :class="item.is_service_item ? 'text-info' : 'text-success'" x-text="item.is_service_item ? 'خدمت' : 'کالا'"></span></td>
                                    <td x-text="item.name"></td>
                                    <td class="text-center" x-text="item.quantity"></td>
                                    <td class="text-indigo fs-5" x-text="formatNumber(item.quantity * item.price)"></td>
                                    <td class="text-center"><button type="button" class="btn btn-link text-danger" @click="removeItem(index)"><i class="ti ti-trash-x fs-4"></i></button></td>
                                </tr>
                            </template>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="mt-5 pt-4 border-top d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center gap-4 bg-white px-5 py-3 rounded-pill border shadow-sm">
                        <span class="field-label-v18 mb-0 text-muted">جمع برآورد کل:</span>
                        <span class="fw-black text-indigo fs-2 mb-0" x-text="formatNumber(totalPrice())"></span>
                        <span class="smaller fw-bold text-muted">ریال</span>
                    </div>
                    <button type="button" @click="submitForm" class="btn-exec-v18 px-5 py-3 fs-5 shadow-primary">
                        <i class="ti ti-square-rounded-check me-2"></i> ثبت و ارسال نهایی به کارتابل
                    </button>
                </div>
            </div>
        </div>

        {{-- ۳. بخش تاریخچه و رهگیری (Modern Accordion) --}}
        <div class="d-flex justify-content-between align-items-end mb-4 px-2">
            <div>
                <h4 class="fw-black text-dark mb-1">رهگیری وضعیت درخواست‌ها</h4>
                <p class="text-muted smaller fw-bold mb-0">مشاهده جزییات اقلام و سیر تاییدات آنلاین مدیران</p>
            </div>
            <div class="col-md-3">
                <div class="position-relative">
                    <i class="ti ti-search position-absolute top-50 translate-middle-y ms-3 text-muted"></i>
                    <input type="text" class="form-control input-v18 rounded-pill border-0 shadow-sm ps-5 fw-bold" wire:model.live.debounce.300ms="search" placeholder="جستجو در آرشیو...">
                </div>
            </div>
        </div>

        <div class="accordion accordion-lux-v18 animate-fade-in" id="purchaseAccordion">
            @foreach($this->myPurchaseRequests as $req)
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button accordion-button-v17 collapsed shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $req->id }}">
                            <div class="row w-100 align-items-center">
                                <div class="col-md-1 fw-black text-muted opacity-50">#{{ $req->id }}</div>
                                <div class="col-md-3">
                                    <div class="fw-black text-dark fs-6">{{ $req->project->name }}</div>
                                    <small class="text-muted fw-bold"><i class="ti ti-clock-play me-1"></i> {{ jdate($req->created_at)->format('Y/m/d') }}</small>
                                </div>
                                <div class="col-md-4 pe-4">
                                    <div class="fw-bold text-dark text-truncate opacity-75">{{ $req->description }}</div>
                                </div>
                                <div class="col-md-2 text-center">
                                    <span class="badge-v17 bg-lux-{{ $req->status == 'pending' ? 'pending' : 'approved' }}">
                                        {{ $req->status == 'pending' ? 'در جریان بررسی' : 'تایید نهایی شده' }}
                                    </span>
                                </div>
                                <div class="col-md-2 text-end">
                                    <span class="fw-black text-indigo h4">{{ number_format($req->items->sum(fn($i) => $i->quantity * $i->price)) }}</span>
                                    <small class="text-muted smaller-8 fw-bold ms-1">ریال</small>
                                </div>
                            </div>
                        </button>
                    </h2>
                    <div id="collapse{{ $req->id }}" class="accordion-collapse collapse" data-bs-parent="#purchaseAccordion">
                        <div class="accordion-body bg-light p-4 p-md-5 border-top border-light">
                            <div class="row g-5">
                                {{-- ریز اقلام --}}
                                <div class="col-lg-7">
                                    <h6 class="fw-black text-dark mb-4"><i class="ti ti-list-search me-2 text-primary fs-4"></i> جزئیات کالاهای درخواستی:</h6>
                                    <div class="table-responsive rounded-4 bg-white border shadow-sm">
                                        <table class="table align-middle mb-0 small text-center">
                                            <thead class="bg-light fw-black text-muted">
                                            <tr><th>ردیف</th><th>شرح کالا/خدمت</th><th>تعداد</th><th>قیمت واحد</th><th>جمع کل (ریال)</th></tr>
                                            </thead>
                                            <tbody class="fw-bold text-dark">
                                            @foreach($req->items as $index => $it)
                                                <tr class="border-bottom border-light">
                                                    <td>{{ $index + 1 }}</td>
                                                    <td class="text-start ps-4">{{ $it->item->name ?? $it->description }}</td>
                                                    <td>{{ $it->quantity }}</td>
                                                    <td>{{ number_format($it->price) }}</td>
                                                    <td class="text-indigo">{{ number_format($it->quantity * $it->price) }}</td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                {{-- تایم‌لاین تاییدات --}}
                                <div class="col-lg-5">
                                    <h6 class="fw-black text-dark mb-4"><i class="ti ti-git-branch me-2 text-primary fs-4"></i> سیر تاییدات و گردش کار:</h6>
                                    <div class="bg-white p-4 rounded-5 border shadow-sm">
                                        @foreach($req->approvals as $ap)
                                            <div class="workflow-step">
                                                <div class="workflow-dot {{ $ap->is_approved ? 'done' : '' }}"></div>
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <h6 class="fw-black text-dark mb-0 small">{{ $ap->user->name ?? 'مدیر مربوطه' }}</h6>
                                                    @if($ap->is_approved !== null)
                                                        <i class="ti ti-{{ $ap->is_approved ? 'discount-check-filled text-success' : 'square-rounded-x-filled text-danger' }} fs-4"></i>
                                                    @endif
                                                </div>
                                                <p class="smaller-8 fw-bold text-muted mt-1">{{ $ap->role->name ?? 'مسئول تایید' }}</p>
                                                @if($ap->comments)
                                                    <div class="bg-light p-2 rounded-3 mt-2 border-start border-3 border-indigo smaller-8 fw-bold text-dark opacity-75">«{{ $ap->comments }}»</div>
                                                @endif
                                            </div>
                                        @endforeach
                                        <div class="mt-2 pt-4 border-top d-flex justify-content-between">
                                            <button wire:click="deleteRequest({{ $req->id }})" wire:confirm="آیا مطمئن هستید؟" class="btn btn-sm btn-outline-danger px-4 rounded-pill fw-black">لغو درخواست</button>
                                            <button class="btn btn-sm btn-indigo px-4 rounded-pill fw-black">چاپ حواله</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-4 d-flex justify-content-center pagination-lux">
            {{ $this->myPurchaseRequests->links('pagination::bootstrap-5') }}
        </div>
    </div>

    {{-- داک پایینی ثابت (Executive Accessory) --}}
    <nav class="shadow-lg" style="position: fixed; bottom: 30px; left: 50%; transform: translateX(-50%); background: var(--exec-navy); padding: 12px 40px; border-radius: 40px; display: flex; gap: 40px; z-index: 2000; border: 1px solid rgba(255,255,255,0.15);">
        <a href="#" onclick="window.scrollTo({top:0, behavior:'smooth'})" class="text-white opacity-75 hover-opacity-100 transition-all"><i class="ti ti-chevron-up fs-4"></i></a>
        <a href="#" class="text-white opacity-75 hover-opacity-100 transition-all"><i class="ti ti-smart-home fs-4"></i></a>
        <a href="#" class="text-white opacity-75 hover-opacity-100 transition-all"><i class="ti ti-help-circle fs-4 text-warning"></i></a>
    </nav>

    @push('scripts')
        <script>
            function purchaseFormState() {
                return {
                    itemType: 'product', items: [], newItem: { id: '', name: '', code: '', quantity: 1, price: '' },
                    formattedPrice: '',
                    formatNumber(n) { return n ? new Intl.NumberFormat('fa-IR').format(n) : '۰'; },
                    totalPrice() { return this.items.reduce((sum, i) => sum + (i.quantity * i.price), 0); },
                    setItemType(t) { this.itemType = t; this.resetNewItem(); },
                    updateNewItemName(e) {
                        const opt = e.target.options[e.target.selectedIndex];
                        this.newItem.name = opt.getAttribute('data-name');
                        this.newItem.code = opt.getAttribute('data-code');
                    },
                    formatPrice() {
                        let v = this.newItem.price.replace(/,/g, '');
                        if (isNaN(v) || v === '') { this.formattedPrice = ''; this.newItem.price = ''; return; }
                        this.newItem.price = v;
                        this.formattedPrice = this.formatNumber(parseFloat(v));
                    },
                    isItemValid() {
                        let p = parseFloat(this.newItem.price.replace(/,/g, '')) || 0;
                        return this.newItem.quantity > 0 && p > 0 && (this.itemType === 'product' ? this.newItem.id !== '' : this.newItem.name !== '');
                    },
                    addItem() {
                        this.items.push({
                            item_id: this.itemType === 'product' ? this.newItem.id : null,
                            name: this.newItem.name,
                            code: this.itemType === 'product' ? this.newItem.code : 'SERV',
                            quantity: this.newItem.quantity,
                            price: parseFloat(this.newItem.price.replace(/,/g, '')),
                            is_service_item: this.itemType === 'service'
                        });
                        this.resetNewItem();
                    },
                    removeItem(i) { this.items.splice(i, 1); },
                    resetNewItem() { this.newItem = { id: '', name: '', code: '', quantity: 1, price: '' }; this.formattedPrice = ''; },
                    submitForm() {
                        if (this.items.length === 0) { alert('سبد اقلام خالی است!'); return; }
                        @this.dispatch('save-final-request', { finalItems: this.items });
                    },
                    resetFormState() { this.items = []; this.resetNewItem(); }
                }
            }
            function initializeShamsiPicker() {
                $('.shamsi-date-picker').persianDatepicker({
                    format: 'YYYY/MM/DD', initialValueType: 'persian', autoClose: true,
                    onSelect: function (u) { @this.set('required_by', new persianDate(u).format('YYYY/MM/DD')); }
                });
            }
        </script>
    @endpush
</div>
