<div class="container py-4">
    @if(session()->has('success') || session()->has('error'))
        <div class="alert {{ session()->has('success') ? 'alert-success' : 'alert-danger' }} rounded-4 shadow-sm mb-4" role="alert">
            <i class="ti ti-{{ session()->has('success') ? 'check' : 'alert-triangle' }} me-2"></i>
            <span class="fw-semibold">{{ session('success') ?? session('error') }}</span>
        </div>
    @endif

    <div class="card shadow-lg border-0 rounded-4 overflow-hidden">

        <div class="card-header bg-dark-deep text-white rounded-top-4 py-3 d-flex justify-content-between align-items-center sticky-header">
            <h4 class="fw-bold mb-0 text-white-custom"> <i class="ti ti-lock-access me-2"></i> مدیریت دسترسی‌ها (RBAC)
            </h4>
            <div class="d-flex align-items-center gap-3">
                <button wire:click="loadData" class="btn btn-sm btn-outline-light-custom rounded-pill">
                    <i class="ti ti-refresh me-1"></i>
                    <span>بارگذاری مجدد</span>
                </button>
                <div wire:loading class="spinner-border text-light spinner-border-sm" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped align-middle mb-0 text-center permissions-table">

                <thead class="bg-gray-light-subtle sticky-role-header">
                <tr>
                    <th class="text-end fw-bold ps-4 text-dark-custom" style="width: 25%;">مجوز / ماژول</th>
                    @foreach($roles as $role)
                        <th class="fw-bold text-nowrap text-dark-custom" style="width: auto;">
                            {{ $role->label ?? $role->name }}
                        </th>
                    @endforeach
                </tr>
                </thead>

                <tbody>
                @forelse($permissions->groupBy('group') as $groupName => $groupPermissions)
                    <tr class="module-row">
                        <td colspan="{{ count($roles) + 1 }}" class="text-start fw-bolder bg-module-highlight text-dark-custom py-2 ps-4">
                            <i class="ti ti-folder-open me-2"></i> ماژول: {{ $groupName }}
                        </td>
                    </tr>

                    @foreach($groupPermissions as $permission)
                        <tr wire:key="perm-{{ $permission->id }}" class="permission-row">
                            <td class="text-end fw-medium text-dark-custom ps-4">
                                {{ $permission->label }}
                                <small class="d-block text-muted">({{ $permission->name }})</small>
                            </td>

                            @foreach($roles as $role)
                                <td wire:key="role-{{ $role->id }}">
                                    <div class="form-check form-switch d-inline-block">
                                        <input
                                            class="form-check-input permission-switch"
                                            type="checkbox"
                                            role="switch"
                                            id="check-{{ $role->id }}-{{ $permission->id }}"
                                            wire:model.live="assignedPermissions.{{ $role->id }}.{{ $permission->id }}"
                                            wire:click="togglePermission({{ $role->id }}, {{ $permission->id }}, $event.target.checked)"
                                            wire:loading.attr="disabled"
                                        >
                                        <label class="form-check-label d-none" for="check-{{ $role->id }}-{{ $permission->id }}"></label>
                                    </div>
                                </td>
                            @endforeach
                        </tr>
                    @endforeach

                @empty
                    <tr>
                        <td colspan="{{ count($roles) + 1 }}" class="text-center py-5">
                            <i class="ti ti-database-off text-muted fs-2 mb-2"></i>
                            <p class="fw-medium text-muted">هیچ مجوزی برای تخصیص یافت نشد. لطفاً مجوزهای جدید ایجاد کنید.</p>
                        </td
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
    <style>
        /* استایل‌های مدرن و سفارشی نهایی */
        :root {
            --bs-dark-deep: #1A2538; /* رنگ هدر عمیق */
            --bs-module-highlight: #f7f9fc; /* روشن و تمیز برای ماژول‌ها */
            --bs-gray-light-subtle: #f0f3f7; /* رنگ سربرگ نقش‌ها */
            --bs-primary-hover: #eef3ff; /* رنگ هاور ردیف (آبی بسیار ملایم) */
            --bs-custom-primary: #4361EE; /* رنگ سوئیچ فعال */
            --bs-switch-off: #ced4da; /* رنگ سوئیچ خاموش */
        }

        /* 1. تنظیمات عمومی کارت و هدر */
        .card {
            border-radius: 1.25rem !important; /* گردی بیشتر */
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08) !important; /* سایه نرم‌تر */
        }
        .bg-dark-deep { background-color: var(--bs-dark-deep) !important; }
        .text-white-custom { color: white !important; }
        .btn-outline-light-custom {
            color: white;
            border-color: white;
            transition: all 0.2s ease-in-out;
        }
        .btn-outline-light-custom:hover {
            background-color: rgba(255, 255, 255, 0.2);
            color: white;
        }

        /* 2. استایل‌های جدول و سربرگ */
        .bg-gray-light-subtle { background-color: var(--bs-gray-light-subtle) !important; }
        .bg-module-highlight { background-color: var(--bs-module-highlight) !important; }

        .text-dark-custom { color: var(--bs-dark-deep) !important; }

        /* ردیف ماژول */
        .module-row td {
            border-bottom: 2px solid #e9ecef !important;
            border-top: 1px solid #e9ecef !important;
            font-size: 1rem;
        }

        /* افکت‌های شناور تمیز */
        .permission-row:hover {
            background-color: var(--bs-primary-hover) !important;
        }

        /* 3. استایل سوئیچ ظریف و مدرن */
        .permission-switch {
            width: 40px !important;
            height: 22px !important;
            cursor: pointer;
            /* تنظیم رنگ سوئیچ خاموش */
            background-color: var(--bs-switch-off) !important;
            border-color: var(--bs-switch-off) !important;
            box-shadow: none !important;
        }
        .permission-switch:checked {
            /* تنظیم رنگ سوئیچ روشن */
            background-color: var(--bs-custom-primary) !important;
            border-color: var(--bs-custom-primary) !important;
        }
        .permission-switch:focus {
            box-shadow: 0 0 0 0.25rem rgba(67, 97, 238, 0.15); /* فوکوس ملایم */
        }

    </style>

</div>
