<div class="container-fluid py-4">

    <!-- عنوان صفحه -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold text-primary-dark">
            <i class="ti ti-settings me-2"></i> تنظیمات و مدیریت نقش‌ها
        </h3>
    </div>

    <!-- ساختار Grid: کامپوننت ثبت در بالا و کامپوننت لیست در پایین -->
    <!-- از Livewire Layout استفاده شده است. -->
    <div class="row g-4">

        <!-- ردیف اول: فرم ثبت نقش (AddRoles) -->
        <div class="col-12">
            <!-- کامپوننت ثبت/ویرایش نقش -->
            <!-- از Key برای کمک به Livewire در تشخیص تغییرات استفاده می‌شود (اختیاری اما توصیه می‌شود) -->
            <livewire:admin.roles.add-roles key="role-upsert-form" />
        </div>

        <!-- ردیف دوم: لیست نقش‌ها (RolesList) -->
        <!-- اگر کامپوننت roles-list وجود دارد، در اینجا نمایش داده می‌شود. -->
        @if(class_exists(\App\Livewire\Admin\Roles\RolesList::class))
            <div class="col-12">
                <!-- کامپوننت لیست نقش‌ها -->
                <livewire:admin.roles.roles-list key="role-listing-table" />
            </div>
        @else
            <!-- اگر کامپوننت roles-list وجود ندارد، از AddRoles استفاده می‌شود که هم لیست و هم فرم را دارد -->
            <!-- از آنجایی که کامپوننت AddRoles قبلی شما شامل جدول لیست هم بود، نیازی به RolesList جدا نیست. -->
            <!-- اما اگر RolesList واقعاً وجود دارد، از ساختار بالا استفاده کنید. -->
        @endif

        <!-- توجه: اگر فرض کنیم AddRoles شامل هر دو (فرم و لیست) است، فقط AddRoles کافیست. -->
        <!-- با توجه به اینکه کامپوننت AddRoles شما شامل لیست نقش‌ها است، بهتر است ساختار را ساده‌تر کنیم. -->
    </div>

    <!-- اگر کامپوننت roles-list واقعاً وجود دارد: -->
    @if(false) <!-- فقط برای نشان دادن ساختار، به طور موقت false قرار داده شده -->
    @endif
</div>
