<div class="container-fluid">
    <!-- --------------------------------------------------- -->
    <!--  Form Basic Start -->
    <!-- --------------------------------------------------- -->
    <div class="card bg-light-info shadow-none position-relative overflow-hidden">
        <div class="card-body px-4 py-3">
            <div class="row align-items-center">
                @if(session()->has('message'))
                    <div class="alert alert-success">
                        {{ session('message') }}
                    </div>
                @endif
                @if(session()->has('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="col-9">
                    <h4 class="fw-semibold mb-3 text-primary">افزودن بخش بندی</h4>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a class="text-muted text-decoration-none" href="index-2.html">Dashboard</a></li>
                            <li class="breadcrumb-item active" aria-current="page">افزودن بخش بندی</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-3">
                    <div class="text-center">
                        <img src="../../dist/images/breadcrumb/ChatBc.png" alt="" class="img-fluid rounded mb-4">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <section>
        <div class="row">
            <div class="col-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="mb-4 text-dark">فرم افزودن بخش بندی</h5>
                        <form wire:submit.prevent="CreateSection">
                            <div class="row">
                                <!-- انتخاب پروژه -->
                                <div class="col-12 mb-4">
                                    <label for="selectedProject" class="form-label">انتخاب پروژه :</label>
                                    <select class="form-select" wire:model="selectedProject" id="selectedProject">
                                        <option value="">انتخاب پروژه</option>
                                        @foreach($projects as $project)
                                            <option value="{{ $project->id }}">{{ $project->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('selectedProject')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- نام بخش -->
                                <div class="col-md-4 mb-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" wire:model="name" id="name" placeholder="نام بخش را وارد کنید">
                                        <label for="name">نام بخش</label>
                                        @error('name')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <!-- توضیحات -->
                                <div class="col-md-8 mb-4">
                                    <div class="form-floating">
                                        <textarea class="form-control" rows="4" wire:model="description" id="description" placeholder="توضیحات"></textarea>
                                        <label for="description">توضیحات</label>
                                        @error('description')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <!-- دکمه ثبت -->
                                <div class="col-12 mt-4">
                                    <button type="submit" class="btn btn-success w-100 font-medium rounded-pill py-2">
                                        <div class="d-flex align-items-center justify-content-center">
                                            <i class="fas fa-check me-2 fs-4"></i>
                                            ثبت بخش
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal برای افزودن بخش جدید -->
    <div class="modal fade" id="createSectionModal" tabindex="-1" aria-labelledby="createSectionModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createSectionModalLabel">افزودن بخش جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- فرم ایجاد بخش -->
                    <form wire:submit.prevent="CreateSection">
                        <div class="mb-3">
                            <label for="selectedProject" class="form-label">انتخاب پروژه</label>
                            <select class="form-select" wire:model="selectedProject" id="selectedProject">
                                <option value="">انتخاب پروژه</option>
                                @foreach($projects as $project)
                                    <option value="{{ $project->id }}">{{ $project->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="name" class="form-label">نام بخش</label>
                            <input type="text" class="form-control" wire:model="name" id="name" placeholder="نام بخش را وارد کنید">
                        </div>
                        <div class="mb-3">
                            <label for="description" class="form-label">توضیحات</label>
                            <textarea class="form-control" wire:model="description" id="description" placeholder="توضیحات را وارد کنید"></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">ثبت بخش</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
