<div>
    @if(session()->has('message'))
        <div class="alert alert-success">{{ session('message') }}</div>
    @endif

    <form wire:submit.prevent="saveSignSetting">
        <div>
            <label for="user_id">کاربر:</label>
            <select id="user_id" wire:model="user_id">
                <option value="">انتخاب کاربر</option>
                @foreach($users as $user)
                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                @endforeach
            </select>
            @error('user_id') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="role_id">نقش:</label>
            <select id="role_id" wire:model="role_id">
                <option value="">انتخاب نقش</option>
                @foreach($roles as $role)
                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                @endforeach
            </select>
            @error('role_id') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="priority">اولویت:</label>
            <input type="number" id="priority" wire:model="priority" placeholder="اولویت" />
            @error('priority') <span class="error">{{ $message }}</span> @enderror
        </div>

        <button type="submit">ذخیره</button>
    </form>

    <h3>تنظیمات امضا:</h3>
    <ul>
        @foreach($signSettings as $setting)
            <li>{{ $setting->user->name }} - نقش: {{ $setting->role->name }} - اولویت: {{ $setting->priority }}</li>
        @endforeach
    </ul>
</div>
