<div class="container py-4 task-show-dashboard">

    {{-- 🛑 هدر و عنوان اصلی تسک --}}
    <div class="card card-header-main shadow-lg border-0 rounded-4 mb-5 bg-white">
        <div class="card-body p-4">
            <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                <h4 class="mb-0 fw-bold text-dark-primary d-flex align-items-center gap-3">
                    <i class="ti ti-list-check fs-4 text-action-primary"></i>
                    {{ $task->title }}
                    {!! $this->getStatusBadge($task) !!}
                </h4>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.project.task.edit', ['project' => $projectId, 'task' => $task->id]) }}" class="btn btn-outline-secondary btn-sm rounded-pill" title="ویرایش">
                        <i class="ti ti-edit"></i> ویرایش
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">

        {{-- ستون اصلی: توضیحات و جزئیات --}}
        <div class="col-lg-8">

            {{-- 1. توضیحات کامل --}}
            <div class="card shadow-md border-0 rounded-4 mb-4">
                <div class="card-header bg-white border-bottom py-3">
                    <h5 class="fw-bold text-dark-primary mb-0"><i class="ti ti-align-left me-2 text-info"></i> توضیحات کامل</h5>
                </div>
                <div class="card-body p-4">
                    <div class="text-dark-primary text-secondary-custom" style="white-space: pre-wrap;">{{ $task->description ?? 'توضیحات بیشتری ثبت نشده است.' }}</div>
                </div>
            </div>

            {{-- 2. پنل وابستگی‌ها و ساختار --}}
            <div class="card shadow-md border-0 rounded-4">
                <div class="card-header bg-white border-bottom py-3">
                    <h5 class="fw-bold text-dark-primary mb-0"><i class="ti ti-hierarchy-2 me-2 text-action-primary"></i> ساختار تسک</h5>
                </div>
                <div class="card-body p-4">
                    <div class="row g-4 small text-dark-primary">

                        <div class="col-md-6">
                            <label class="text-secondary small fw-semibold">تسک والد:</label>
                            <div class="fw-medium">
                                @if($task->parent)
                                    <a href="{{ route('admin.project.task.show', [$projectId, $task->parent->id]) }}" class="text-action-primary text-decoration-none">#{{ $task->parent->id }} - {{ $task->parent->title }}</a>
                                    {!! $this->getStatusBadge($task->parent) !!}
                                @else
                                    <span class="text-secondary-custom">— (تسک اصلی)</span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-secondary small fw-semibold">وابسته به:</label>
                            <div class="fw-medium">
                                @if($task->dependency)
                                    @php $isBlocked = $task->dependency->status !== 'done'; @endphp
                                    <span class="text-{{ $isBlocked ? 'danger' : 'success' }}" title="مسدود شده تا این تسک انجام شود">
                                        <i class="ti ti-{{ $isBlocked ? 'lock' : 'link' }} me-1"></i> #{{ $task->dependency->id }} - {{ $task->dependency->title }}
                                    </span>
                                @else
                                    <span class="text-secondary-custom">— (بدون وابستگی)</span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-secondary small fw-semibold">تسک‌های فرزند (Subtasks):</label>
                            <div class="fw-medium text-action-primary">{{ $task->children->count() }} تسک فرعی</div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-secondary small fw-semibold">تسک‌هایی که به این تسک وابسته‌اند:</label>
                            <div class="fw-medium text-info">{{ $task->dependents->count() }} تسک مسدود کننده</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- ستون کناری: متادیتا و پیشرفت --}}
        <div class="col-lg-4">
            <div class="card shadow-md border-0 rounded-4">
                <div class="card-body p-4">
                    <h5 class="fw-bold text-dark-primary mb-4"><i class="ti ti-settings me-2 text-warning"></i> متادیتا</h5>

                    <div class="task-meta-grid">
                        <div class="meta-item-box">
                            <label class="text-secondary small">مسئول</label>
                            <div class="fw-bold text-dark-primary">{{ $task->assignedUser->name ?? 'نامشخص' }}</div>
                        </div>
                        <div class="meta-item-box">
                            <label class="text-secondary small">بخش</label>
                            <div class="fw-bold text-dark-primary">{{ $task->section->name ?? 'اصلی' }}</div>
                        </div>
                        <div class="meta-item-box">
                            <label class="text-secondary small">اولویت</label>
                            <div class="fw-bold text-dark-primary">
                                <span class="badge bg-priority-{{ $task->priority }}">{{ Str::title($task->priority) }}</span>
                            </div>
                        </div>
                        <div class="meta-item-box">
                            <label class="text-secondary small">نوع</label>
                            <div class="fw-bold text-dark-primary">
                                <span class="badge bg-secondary-soft text-secondary">{{ Str::title($task->type) }}</span>
                            </div>
                        </div>
                        <div class="meta-item-box">
                            <label class="text-secondary small">شروع (شمسی)</label>
                            <div class="fw-bold text-dark-primary">{{ $this->getPersianDate($task->start_date) }}</div>
                        </div>
                        <div class="meta-item-box">
                            <label class="text-secondary small">مهلت (شمسی)</label>
                            <div class="fw-bold text-dark-primary">{{ $this->getPersianDate($task->due_date) }}</div>
                        </div>
                    </div>

                    {{-- درصد پیشرفت --}}
                    <div class="mt-4 pt-3 border-top">
                        <label class="text-secondary small fw-semibold d-block mb-2">درصد پیشرفت:</label>
                        <div class="progress" style="height: 20px;">
                            <div class="progress-bar progress-bar-striped progress-bar-animated bg-{{ $task->progress_percent==100 ? 'success' : 'primary' }}"
                                 role="progressbar"
                                 style="width:{{ $task->progress_percent }}%">
                                <span class="fw-bold text-white">{{ $task->progress_percent }}%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- بازگشت --}}
            <div class="mt-4 text-center">
                <a href="{{ route('admin.project.task.list', ['project' => $projectId]) }}" class="btn btn-outline-secondary rounded-pill px-4">
                    <i class="ti ti-arrow-back-up me-1"></i> بازگشت به لیست تسک‌ها
                </a>
            </div>
        </div>
    </div>


    {{-- بخش کامنت‌ها در تسک --}}
    <div class="mt-5">
        <livewire:admin.task.comment-list :taskId="$task->id"/>
    </div>

    <style>
        /* 🛑 استایل‌های نهایی و مدرن برای Task Show */
        :root {
            --dark-primary: #1F2937;
            --action-primary: #4361EE; /* Primary Blue */
            --secondary-light: #6B7280; /* Muted Gray */
            --border-color: #E5E7EB;
            --primary-light: #F0F3FF; /* Background for Progress */
            --success-color: #10B981;
            --danger-color: #EF4444;
            --info-color: #3498DB;
            --warning-color: #F59E0B;
            --bg-soft-gray: #F8FAFC;
        }

        .task-show-dashboard { background-color: var(--bg-soft-gray); }
        .text-dark-primary { color: var(--dark-primary) !important; }
        .text-action-primary { color: var(--action-primary) !important; }
        .text-secondary-custom { color: var(--secondary-light); }

        /* Layout & Cards */
        .card { border-radius: 1rem !important; }
        .card-header { border-bottom: 1px solid var(--border-color); }
        .card-header-main {
            border-left: 5px solid var(--action-primary) !important;
        }


        /* Progress Bar */
        .progress { height: 0.75rem; background-color: var(--primary-light); border-radius: 9999px; }
        .progress-bar { font-size: 0.65rem; font-weight: 600; }
        .bg-primary { background-color: var(--action-primary) !important; }
        .bg-success { background-color: var(--success-color) !important; }

        /* Grid for Meta Data */
        .task-meta-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1.5rem;
            padding: 0 0 1rem 0;
        }
        .meta-item-box {
            border-bottom: 1px dashed var(--border-color);
            padding-bottom: 1rem;
            padding-right: 1rem;
        }
        .meta-item-box:nth-child(even) {
            padding-right: 0;
            padding-left: 1rem;
            /* FIX: حذف Border در سمت راست برای آیتم‌های زوج */
            border-right: none !important;
        }
        .meta-item-box:nth-child(odd) {
            border-right: 1px dashed var(--border-color);
        }
        .meta-item-box:last-child,
        .meta-item-box:nth-last-child(2):nth-child(even) { /* Fix for last two items */
            border-bottom: none;
        }

        /* Status Badges (Soft Backgrounds) */
        .badge { padding: 0.4em 0.8em; border-radius: 9999px; font-weight: 600; }
        .bg-soft-success { background-color: #ECFDF5; color: var(--success-color); }
        .bg-soft-warning { background-color: #FEF3C7; color: var(--warning-color); }
        .bg-soft-danger { background-color: #FCECEB; color: var(--danger-color); }
        .bg-soft-info { background-color: #EBF5FB; color: var(--info-color); }
        .bg-soft-secondary { background-color: #e9ecef; color: var(--secondary-color); }


        /* Buttons */
        .btn-outline-secondary {
            border-color: var(--border-color);
            color: var(--secondary-light);
        }
        .btn-outline-secondary:hover {
            background-color: var(--primary-light);
            color: var(--action-primary);
        }
        .btn-outline-danger {
            color: var(--danger-color);
            border-color: var(--danger-color);
        }
        .btn-outline-danger:hover {
            background-color: var(--danger-color);
            color: white;
        }
    </style>
</div>
