<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-gradient-primary-to-secondary">
            <h4 class="mb-0 text-white">ایجاد قالب جدید ترنسمیتال</h4>
        </div>
        <div class="card-body">

            @if(session()->has('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form wire:submit.prevent="save" class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">عنوان قالب <span class="text-danger">*</span></label>
                    <input type="text" wire:model.defer="title" class="form-control" placeholder="مثلاً: قالب داخلی">
                    @error('title') <small class="text-danger">{{ $message }}</small> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">هدف ارسال</label>
                    <input type="text" wire:model.defer="purpose" class="form-control" placeholder="برای تایید / اطلاع / پیگیری ...">
                    @error('purpose') <small class="text-danger">{{ $message }}</small> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">فرستنده پیش‌فرض</label>
                    <select wire:model.defer="sender_id" class="form-select">
                        <option value="">بدون فرستنده</option>
                        @foreach($senders as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                    @error('sender_id') <small class="text-danger">{{ $message }}</small> @enderror
                </div>

                <div class="col-12">
                    <label class="form-label">توضیحات پیش‌فرض</label>
                    <textarea wire:model.defer="description" class="form-control" rows="3" placeholder="توضیحات اختیاری..."></textarea>
                    @error('description') <small class="text-danger">{{ $message }}</small> @enderror
                </div>

                <div class="col-12 text-end">
                    <button type="submit" class="btn btn-success px-5">
                        <i class="fas fa-save"></i> ذخیره قالب
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
