@php use Illuminate\Support\Str; @endphp

<div class="container py-3" dir="rtl">
    <style>
        :root {
            --brand: #4f46e5;
            --brand2: #0ea5e9;
            --soft: #f8fafc;
            --card-radius: 16px;
            --field-radius: 12px;
            --bg: #ffffff;
            --text: #111827;
            --card: #f9fafb;
            --border: #e5e7eb;
        }
        .dark {
            --bg: #111827;
            --text: #f9fafb;
            --card: #1f2937;
            --border: #374151;
        }
        body {
            background-color: var(--bg);
            color: var(--text);
            transition: background-color 0.3s;
        }
        .bg-grad { background: linear-gradient(90deg, var(--brand) 0%, var(--brand2) 100%); }
        .mobile-topbar {
            display: none; position: sticky; top: 0; z-index: 30; padding: .6rem .9rem;
            background: linear-gradient(90deg, rgba(79,70,229,.95), rgba(14,165,233,.95));
            color: #fff; backdrop-filter: blur(6px);
        }
        .mobile-topbar h5 { font-size: 1rem; margin: 0; display: flex; align-items: center; gap: .5rem }
        .stepper { display: flex; gap: .5rem; flex-wrap: wrap }
        .step { display: flex; align-items: center; gap: .5rem; padding: .3rem .7rem; border-radius: 999px; background: #eef2ff; color: #374151 }
        .step.active { background: #dbeafe; color: #111827; font-weight: 600 }
        .chip { background: #eef2ff; border-radius: 999px; padding: .3rem .75rem; display: inline-flex; gap: .4rem; align-items: center; cursor: pointer; transition: .15s }
        .chip:hover { background: #e0e7ff }
        .chip.is-active { background: var(--brand); color: #fff }
        .muted { color: #6b7280 }
        .table thead th.sticky { position: sticky; top: 0; background: var(--card); z-index: 2; }
        .doc-card { border: 1px solid var(--border); border-radius: 14px; padding: .7rem; background: var(--card); }
        .doc-card .title { font-weight: 600 }
        .img-thumb { max-width: 80px; max-height: 60px; object-fit: cover; border-radius: .6rem; border: 1px solid var(--border); }
        .action-bar {
            position: sticky; bottom: .25rem; z-index: 25; background: var(--bg);
            padding: .6rem .75rem calc(env(safe-area-inset-bottom,0) + .6rem);
            box-shadow: 0 -8px 24px rgba(15,23,42,.06);
            border-radius: 12px;
        }
        .dropzone {
            border: 2px dashed #cbd5e1; border-radius: 14px; padding: 1rem; background: var(--soft);
            text-align: center; transition: .2s
        }
        .dropzone.dragover { background: #eef2ff; border-color: #93c5fd }
        .skeleton { position: relative; overflow: hidden; background: var(--border); border-radius: .35rem }
        .skeleton::after { content: ""; position: absolute; inset: 0; transform: translateX(-100%);
            background: linear-gradient(90deg, transparent, rgba(255,255,255,.3), transparent); animation: sh 1.2s infinite }
        @keyframes sh { to { transform: translateX(100%) } }

        .card { border-radius: var(--card-radius); overflow: hidden; background: var(--card); }
        .card-header { border-radius: var(--card-radius) var(--card-radius) 0 0; }
        .form-control, .form-select { border-radius: var(--field-radius); background: var(--bg); color: var(--text); }
        .btn { border-radius: 12px; }
        .form-label { font-size: .95rem; color: var(--text); }

        .form-check-input { width: 1.2rem; height: 1.2rem; }

        @media (max-width: 767.98px) {
            .mobile-topbar { display: flex; align-items: center; justify-content: space-between }
            .card-header { display: none }
            .container { padding-left: .6rem; padding-right: .6rem }
            .doc-card { padding: .6rem }
            .form-label { font-size: .9rem }
            .form-check-input { width: 1.35rem; height: 1.35rem }
        }
    </style>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css"/>

    <div class="mobile-topbar">
        <h5><i class="fas fa-paper-plane"></i> ثبت ترنسمیتال</h5>
        @if($step === 'form')
            <span class="small">انتخاب‌ها: <strong>{{ count($selected_documents) }}</strong></span>
        @else
            <button class="btn btn-sm btn-light" wire:click="previousStep">ویرایش</button>
        @endif
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-grad d-flex justify-content-between align-items-center">
            <h4 class="mb-0 text-white"><i class="fas fa-paper-plane"></i> ثبت ترنسمیتال</h4>
            @if($step === 'preview')
                <button wire:click="previousStep" class="btn btn-light btn-sm">بازگشت به فرم</button>
            @endif
        </div>

        <div class="card-body">
            <div class="stepper mb-3" aria-label="مراحل">
                <div class="step {{ $step==='form' ? 'active' : '' }}"><span>۱</span><span>اطلاعات</span></div>
                <div class="step {{ $step==='preview' ? 'active' : '' }}"><span>۲</span><span>پیش‌نمایش و ارسال</span></div>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <strong>خطاهای فرم:</strong>
                    <ul class="mb-0">@foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach</ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            @if(session()->has('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }} <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            @if(session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }} <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($step === 'form')
                <form wire:submit.prevent="nextStep">
                    @if(!$isProjectSelected)
                        <div class="mb-3">
                            <label class="form-label"><i class="far fa-folder-open ms-1"></i> انتخاب پروژه</label>
                            <div class="d-flex gap-2">
                                <select wire:model.live="project_id" class="form-select" aria-label="انتخاب پروژه">
                                    <option value="">پروژه را انتخاب کنید</option>
                                    @foreach($projects as $p)
                                        <option value="{{ $p->id }}">{{ $p->name }} ({{ $p->code ?? 'بدون کد' }})</option>
                                    @endforeach
                                </select>
                                @if($project_id)
                                    <button type="button" class="btn btn-outline-secondary" wire:click="clearProject">
                                        <i class="fas fa-rotate"></i>
                                    </button>
                                @endif
                            </div>
                            @error('project_id') <small class="text-danger">{{ $message }}</small> @enderror
                        </div>
                    @else
                        <div class="mb-3 d-flex align-items-center justify-content-between gap-2">
                            <div>
                                <label class="form-label mb-1">پروژه انتخاب‌شده</label>
                                <div class="chip is-active">{{ $project_name }}</div>
                            </div>
                            <button class="btn btn-sm btn-outline-secondary" type="button" wire:click="clearProject">تغییر</button>
                            <input type="hidden" wire:model="project_id">
                        </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label"><i class="far fa-file ms-1"></i> قالب ترنسمیتال</label>
                        <select wire:model.live="template_id" class="form-select">
                            <option value="">بدون قالب</option>
                            @foreach($templates as $t) <option value="{{ $t->id }}">{{ $t->title }}</option> @endforeach
                        </select>
                    </div>

                    <div class="row g-3 mb-3 align-items-end">
                        <div class="col-12 col-md-3">
                            <label class="form-label">شماره (پیش‌نمایش)</label>
                            <input type="text" class="form-control" value="{{ $transmittal_number_preview }}" readonly>
                        </div>
                        <div class="col-12 col-md-3" wire:ignore>
                            <label class="form-label">تاریخ (شمسی)</label>
                            <input id="pdp-trans-date" type="text" class="form-control" placeholder="YYYY/MM/DD"
                                   value="{{ $transmittal_date_jalali }}">
                            @error('transmittal_date_jalali') <small class="text-danger d-block">{{ $message }}</small> @enderror
                        </div>
                        <div class="col-6 col-md-3">
                            <label class="form-label">فرستنده</label>
                            <select wire:model="sender_id" class="form-select">
                                <option value="">انتخاب کنید</option>
                                @foreach($senders as $s) <option value="{{ $s->id }}">{{ $s->name }}</option> @endforeach
                            </select>
                            @error('sender_id') <small class="text-danger">{{ $message }}</small> @enderror
                        </div>
                        <div class="col-6 col-md-3">
                            <label class="form-label">گیرنده اصلی</label>
                            <select wire:model="receiver_id" class="form-select">
                                <option value="">انتخاب کنید</option>
                                @foreach($recipients as $r) <option value="{{ $r->id }}">{{ $r->name }}</option> @endforeach
                            </select>
                            @error('receiver_id') <small class="text-danger">{{ $message }}</small> @enderror
                        </div>
                    </div>

                    <div class="row g-3 mb-3 align-items-end">
                        <div class="col-12 col-md-3">
                            <label class="form-label">هدف ارسال</label>
                            <select wire:model="purpose" class="form-select">
                                <option value="">انتخاب کنید</option>
                                @foreach($purposeOptions as $opt)
                                    <option value="{{ $opt }}">{{ $opt }}</option>
                                @endforeach
                            </select>
                            @error('purpose') <small class="text-danger">{{ $message }}</small> @enderror

                            <div class="mt-2 d-flex flex-wrap gap-1">
                                @foreach($purposeOptions as $opt)
                                    <span class="chip {{ $purpose===$opt ? 'is-active' : '' }}" wire:click="$set('purpose','{{ $opt }}')">{{ $opt }}</span>
                                @endforeach
                            </div>
                        </div>

                        <div class="col-12 col-md-6">
                            <label class="form-label">توضیحات</label>
                            <input type="text" wire:model="description" class="form-control" placeholder="توضیحات (اختیاری)">
                        </div>

                        <div class="col-12 col-md-3">
                            <label class="form-label">پیوست‌ها</label>
                            <div
                                id="drop-area"
                                class="dropzone"
                                ondragover="event.preventDefault(); this.classList.add('dragover')"
                                ondragleave="this.classList.remove('dragover')"
                                ondrop="event.preventDefault(); this.classList.remove('dragover'); document.getElementById('attachments-input').files = event.dataTransfer.files; document.getElementById('attachments-input').dispatchEvent(new Event('change'));"
                            >
                                <div class="mb-1">فایل‌ها را بکشید و رها کنید</div>
                                <label for="attachments-input" class="btn btn-sm btn-outline-primary">انتخاب فایل</label>
                                <input id="attachments-input" type="file" wire:model="attachments" multiple class="d-none">
                                <div class="small muted mt-2">pdf, تصاویر، doc/x، xls/x | حداکثر ۵ فایل</div>
                            </div>
                            @error('attachments.*') <small class="text-danger d-block mt-1">{{ $message }}</small> @enderror
                            <div class="mt-2" wire:loading wire:target="attachments">
                                <div class="progress"><div class="progress-bar progress-bar-striped progress-bar-animated" style="width:100%">در حال آپلود…</div></div>
                            </div>

                            @if($attachments)
                                <div class="mt-2 d-flex flex-column gap-2">
                                    @foreach($attachments as $idx => $att)
                                        <div class="d-flex align-items-center justify-content-between doc-card">
                                            <div class="d-flex align-items-center gap-2">
                                                @if(str_starts_with($att->getMimeType(),'image/'))
                                                    <img class="img-thumb" src="{{ $att->temporaryUrl() }}" alt="">
                                                @else
                                                    <i class="far fa-file fa-lg text-secondary"></i>
                                                @endif
                                                <div>
                                                    <div class="fw-semibold">{{ $att->getClientOriginalName() }}</div>
                                                    <div class="muted small">{{ number_format($att->getSize()/1024,1) }} KB</div>
                                                </div>
                                            </div>
                                            <button type="button" class="btn btn-sm btn-outline-danger" wire:click="removeAttachment({{ $idx }})" aria-label="حذف پیوست">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">گیرنده‌های CC (اختیاری)</label>
                        <select wire:model="cc_recipients" class="form-select" multiple aria-label="گیرندگان CC">
                            @foreach($recipients as $r) <option value="{{ $r->id }}">{{ $r->name }}</option> @endforeach
                        </select>
                    </div>

                    @if($isProjectSelected)
                        <div class="d-flex flex-wrap align-items-end justify-content-between gap-2 mb-2">
                            <div class="flex-grow-1">
                                <label class="form-label">جستجوی مدرک</label>
                                <div class="input-group">
                                    <input type="text" wire:model.debounce.500ms="searchTerm" class="form-control" placeholder="شماره سند یا عنوان">
                                    @if($searchTerm)
                                        <button class="btn btn-outline-secondary" type="button" wire:click="$set('searchTerm','')">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    @endif
                                </div>
                            </div>
                            <div class="text-end">
                                <div class="small muted mb-1">
                                    انتخاب‌ها: <span class="fw-bold">{{ count($selected_documents) }}</span>
                                    <span class="mx-2">|</span>
                                    نتایج صفحه: <span class="fw-bold">{{ $documents->count() }}</span>
                                </div>

                                <button type="button" class="btn btn-sm btn-outline-primary"
                                        wire:click="selectAllMatching"
                                    @disabled(!$documents->total())>
                                    انتخاب همه نتایج
                                </button>

                                <button type="button" class="btn btn-sm btn-outline-secondary"
                                        wire:click="clearSelection"
                                    @disabled(!count($selected_documents))>
                                    پاک‌سازی
                                </button>
                            </div>
                        </div>

                        <!-- موبایل: کارت‌ها -->
                        <div class="d-md-none">
                            @forelse($documents as $doc)
                                @php
                                    $isChecked = in_array($doc->id, $selected_documents ?? []);
                                    $latestRevision = $doc->revisions->first();
                                @endphp
                                <label class="doc-card mb-2 w-100" wire:key="doc-card-{{ $doc->id }}">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="title">{{ $doc->document_number }} — {{ Str::limit($doc->title, 50) }}</div>
                                        <input class="form-check-input mt-1" type="checkbox" wire:model="selected_documents" value="{{ $doc->id }}">
                                    </div>
                                    <div class="muted small mt-1">نسخه فعلی: {{ $latestRevision?->revision ?? '—' }}</div>

                                    @if($doc->revisions->count() && $isChecked)
                                        <div class="mt-2">
                                            <select class="form-select form-select-sm" wire:model="selected_revisions.{{ $doc->id }}">
                                                <option value="">انتخاب نسخه</option>
                                                @foreach($doc->revisions as $rev)
                                                    <option value="{{ $rev->id }}">{{ $rev->revision }} — {{ jdate($rev->created_at)->format('Y/m/d') }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @elseif(!$doc->revisions->count() && $isChecked)
                                        <span class="badge bg-secondary mt-2">بدون رویژن</span>
                                    @endif
                                </label>
                            @empty
                                <div class="text-muted text-center py-3">مدرکی برای این پروژه وجود ندارد.</div>
                            @endforelse
                            <div class="mt-2">{{ $documents->links() }}</div>
                        </div>

                        <!-- دسکتاپ: جدول -->
                        <div class="table-responsive d-none d-md-block">
                            @php
                                $pageIds = $documents->pluck('id')->all();
                                $pageAllSelected = $documents->count() && count(array_intersect($pageIds, $selected_documents)) === $documents->count();
                                $dirIcon = fn($f)=> $docSortField===$f ? ($docSortDir==='asc'?'↑':'↓') : '↕';
                            @endphp
                            <table class="table table-sm table-hover align-middle text-center">
                                <thead class="table-light">
                                <tr>
                                    <th class="sticky" style="width:60px;">
                                        <input type="checkbox" @checked($pageAllSelected) wire:click="toggleSelectPage({{ $pageAllSelected ? 0 : 1 }})" aria-label="انتخاب همه صفحه">
                                    </th>
                                    <th class="sticky" style="width:160px;cursor:pointer" wire:click="sortDocsBy('document_number')">شماره سند <span class="small">{{ $dirIcon('document_number') }}</span></th>
                                    <th class="sticky" style="cursor:pointer" wire:click="sortDocsBy('title')">عنوان <span class="small">{{ $dirIcon('title') }}</span></th>
                                    <th class="sticky" style="width:180px;">شماره رویژن</th>
                                    <th class="sticky">توضیح</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($documents as $doc)
                                    @php
                                        $latestRevision = $doc->revisions->first();
                                    @endphp
                                    <tr wire:key="doc-row-{{ $doc->id }}">
                                        <td><input type="checkbox" wire:model="selected_documents" value="{{ $doc->id }}"></td>
                                        <td class="text-monospace">{{ $doc->document_number }}</td>
                                        <td class="text-start" title="{{ $doc->title }}">{{ Str::limit($doc->title, 60) }}</td>
                                        <td>
                                            @if($doc->revisions->count())
                                                <select wire:model="selected_revisions.{{ $doc->id }}" class="form-select form-select-sm">
                                                    <option value="">انتخاب نسخه</option>
                                                    @foreach($doc->revisions as $rev)
                                                        <option value="{{ $rev->id }}">{{ $rev->revision }} — {{ jdate($rev->created_at)->format('Y/m/d') }}</option>
                                                    @endforeach
                                                </select>
                                            @else
                                                <span class="badge bg-secondary">بدون رویژن</span>
                                                <input type="hidden" wire:model="selected_revisions.{{ $doc->id }}" value="">
                                            @endif
                                        </td>
                                        <td title="{{ $doc->description }}">{{ Str::limit($doc->description, 60) }}</td>
                                    </tr>
                                @empty
                                    <tr><td colspan="5">
                                            <div class="skeleton" style="height:12px;margin:8px 0"></div>
                                            <div class="skeleton" style="height:12px;margin:8px 0"></div>
                                            <div class="skeleton" style="height:12px;margin:8px 0"></div>
                                        </td></tr>
                                @endforelse
                                </tbody>
                            </table>
                            {{ $documents->links() }}
                        </div>
                    @endif

                    <div class="action-bar mt-3 d-flex justify-content-between align-items-center">
                        <div class="small muted">
                            @if(count($selected_documents))
                                <i class="fas fa-check-circle text-success"></i>
                                {{ count($selected_documents) }} مدرک انتخاب‌شده
                                @if($allMatchingSelected)
                                    <span class="chip">همه نتایج انتخاب شده</span>
                                @endif
                            @endif
                        </div>
                        <button type="submit" class="btn btn-primary btn-lg px-4"
                                wire:loading.attr="disabled" wire:target="nextStep,attachments">
                            <i class="fas fa-eye"></i> مرحله بعد
                        </button>
                    </div>
                </form>
            @endif

            @if($step === 'preview')
                <div class="p-3 bg-light rounded mb-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h5 class="mb-0">پیش‌نمایش</h5>
                        <button class="btn btn-sm btn-outline-secondary" wire:click="previousStep">ویرایش</button>
                    </div>
                    <div class="row g-2">
                        <div class="col-12 col-md-3"><div><strong>شماره:</strong> {{ $transmittal_number_preview }}</div></div>
                        <div class="col-12 col-md-3"><div><strong>پروژه:</strong> {{ $project_name }}</div></div>
                        <div class="col-12 col-md-3"><div><strong>فرستنده:</strong> {{ $sender_name }}</div></div>
                        <div class="col-12 col-md-3"><div><strong>گیرنده:</strong> {{ $receiver_name }}</div></div>
                        <div class="col-12 col-md-3"><div><strong>تاریخ (شمسی):</strong> {{ $transmittal_date_jalali ?? '—' }}</div></div>
                        <div class="col-12 col-md-3"><div><strong>هدف:</strong> {{ $purpose ?: '—' }}</div></div>
                        <div class="col-12 col-md-6"><div><strong>توضیحات:</strong> {{ $description ?: '—' }}</div></div>
                        <div class="col-12"><strong>گیرندگان CC:</strong>
                            @if($cc_names && count($cc_names))
                                @foreach($cc_names as $n) <span class="chip is-active">{{ $n }}</span> @endforeach
                            @else <span class="muted">ندارد</span> @endif
                        </div>
                    </div>
                    <hr>
                    <div class="mb-2"><strong>مدارک انتخابی:</strong></div>
                    @if(count($previewDocs))
                        <ul class="mb-2">
                            @foreach($previewDocs as $pd)
                                <li>{{ $pd['number'] }} — {{ $pd['title'] }} ({{ $pd['revision_label'] }})</li>
                            @endforeach
                        </ul>
                    @else
                        <div class="muted">مدرکی انتخاب نشده است.</div>
                    @endif

                    <div class="mb-2"><strong>پیوست‌ها:</strong></div>
                    @if($attachments && count($attachments))
                        <ul class="mb-0">@foreach($attachments as $att) <li>{{ $att->getClientOriginalName() }}</li> @endforeach</ul>
                    @else
                        <div class="muted">فاقد پیوست</div>
                    @endif
                </div>

                <form wire:submit.prevent="saveTransmittal" onsubmit="return confirm('آیا از ارسال ترنسمیتال مطمئن هستید؟')">
                    <div class="text-end">
                        <button class="btn btn-success btn-lg px-5" wire:loading.attr="disabled" wire:target="saveTransmittal">
                            <i class="fas fa-save"></i> ذخیره و ارسال
                        </button>
                    </div>
                </form>
            @endif
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });

        document.addEventListener('livewire:initialized', () => {
            initPD();
            Livewire.hook('message.processed', () => initPD());

            function initPD(){
                if (!window.$ || !$.fn.pDatepicker) return;
                const $input = $('#pdp-trans-date');
                if (!$input.length) return;

                if ($input.data('hasPicker')){
                    $input.val(@this.get('transmittal_date_jalali') || '');
                    return;
                }

                $input.pDatepicker({
                    initialValue: !!@this.get('transmittal_date_jalali'),
                    format: 'YYYY/MM/DD',
                    autoClose: true,
                    calendarType: 'persian',
                    onSelect: function (unix) {
                        try{
                            const p = new persianDate(unix).format('YYYY/MM/DD');
                            $input.val(p);
                            @this.set('transmittal_date_jalali', p);
                        }catch(e){}
                    }
                });

                $input.val(@this.get('transmittal_date_jalali') || '');
                $input.data('hasPicker', true);
            }
        });
    </script>
</div>
