<div class="container py-4" dir="rtl" id="show-tr-root">
    <style>
        :root{ --brand:#4f46e5; --brand2:#0ea5e9; --soft:#f8fafc; }
        .bg-grad{ background:linear-gradient(90deg,var(--brand) 0%,var(--brand2) 100%); }
        .muted{color:#6b7280}
        .chip{background:#eef2ff;border-radius:999px;padding:.25rem .6rem;display:inline-flex;gap:.45rem;align-items:center}
        .mono{font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", monospace;}
        .card-section{border:1px solid #e5e7eb;border-radius:1rem;padding:1rem;background:#fff}
        .doc-thumb{width:70px;height:54px;object-fit:cover;border-radius:.5rem;border:1px solid #e5e7eb}
        .table thead th{ position:sticky; top:0; background:#f8fafc; z-index:1; }
        .btn-xs{padding:.15rem .45rem;font-size:.8rem;border-radius:.35rem}
        @media (max-width: 767.98px){
            .card-header h4{font-size:1rem}
            .btn{padding:.5rem .9rem}
        }
    </style>

    <div class="card shadow-sm">
        <div class="card-header bg-grad d-flex flex-wrap justify-content-between align-items-center gap-2">
            <h4 class="mb-0 text-white d-flex align-items-center gap-2">
                <i class="fas fa-file-alt"></i> مشاهده ترنسمیتال
            </h4>
            <div class="d-flex gap-2">
                <a href="{{ url()->previous() }}" class="btn btn-light btn-sm">
                    <i class="fas fa-arrow-right"></i> بازگشت
                </a>
                <a href="{{ route('transmittal.attachments.zip', $trans->id) }}" class="btn btn-light btn-sm">
                    <i class="fas fa-file-archive"></i> ZIP پیوست‌ها
                </a>
                <button class="btn btn-light btn-sm" id="btn-print">
                    <i class="fas fa-print"></i> چاپ
                </button>
                <a href="{{ route('transmittal.download', $trans->id) }}" target="_blank" class="btn btn-success btn-sm">
                    <i class="fas fa-file-pdf"></i> PDF
                </a>
            </div>
        </div>

        <div class="card-body">
            @php
                $raw = $trans->status;
                $label = match($raw){
                    'sent','ارسال شده'      => 'ارسال شده',
                    'received','دریافت شده' => 'دریافت شده',
                    'rejected','رد شده'     => 'رد شده',
                    default                 => 'در انتظار',
                };
                $badge = match($label){
                    'ارسال شده'   => 'bg-success',
                    'دریافت شده'  => 'bg-info',
                    'رد شده'      => 'bg-danger',
                    default       => 'bg-warning text-dark',
                };
                $dateFa = jdate($trans->sent_at ?? $trans->created_at)->format('Y/m/d');
            @endphp

            {{-- خلاصه --}}
            <div class="card-section">
                <div class="d-flex flex-wrap justify-content-between align-items-start gap-2">
                    <div>
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <div class="mono h5 mb-0">{{ $trans->transmittal_number }}</div>
                            <button class="btn btn-xs btn-outline-secondary copy-btn" data-copy="{{ $trans->transmittal_number }}">
                                <i class="far fa-copy"></i> کپی
                            </button>
                            <span class="chip"><i class="far fa-calendar"></i> {{ $dateFa }}</span>

                            {{-- لینک پروژه --}}
                            @php $hasProjRoute = \Illuminate\Support\Facades\Route::has('admin.projects.show'); @endphp
                            @if($hasProjRoute && $trans->project_id)
                                <a class="chip text-decoration-none" href="{{ route('admin.projects.show', $trans->project_id) }}">
                                    <i class="far fa-folder-open"></i> {{ $trans->project?->name ?? '—' }}
                                </a>
                            @else
                                <span class="chip"><i class="far fa-folder-open"></i> {{ $trans->project?->name ?? '—' }}</span>
                            @endif
                        </div>
                        <div class="mt-2 small muted">شناسه: {{ $trans->id }}</div>
                    </div>
                    <div><span class="badge {{ $badge }} p-2">{{ $label }}</span></div>
                </div>

                <hr>

                <div class="row g-2">
                    <div class="col-12 col-md-6">
                        <div class="muted small mb-1">فرستنده</div>
                        @php $hasUserRoute = \Illuminate\Support\Facades\Route::has('admin.users.show'); @endphp
                        @if($hasUserRoute && $trans->sender_id)
                            <a class="fw-semibold text-decoration-none" href="{{ route('admin.users.show', $trans->sender_id) }}">{{ $trans->sender?->name ?? '—' }}</a>
                        @else
                            <div class="fw-semibold">{{ $trans->sender?->name ?? '—' }}</div>
                        @endif
                    </div>
                    <div class="col-12 col-md-6">
                        <div class="muted small mb-1">گیرنده</div>
                        @if($hasUserRoute && $trans->receiver_id)
                            <a class="fw-semibold text-decoration-none" href="{{ route('admin.users.show', $trans->receiver_id) }}">{{ $trans->receiver?->name ?? '—' }}</a>
                        @else
                            <div class="fw-semibold">{{ $trans->receiver?->name ?? '—' }}</div>
                        @endif
                    </div>

                    <div class="col-12 col-md-6">
                        <div class="muted small mb-1">هدف</div>
                        <div>{{ $trans->purpose ?: '—' }}</div>
                    </div>
                    <div class="col-12 col-md-6">
                        <div class="muted small mb-1">توضیحات</div>
                        <div>{{ $trans->description ?: '—' }}</div>
                    </div>

                    <div class="col-12">
                        <div class="muted small mb-1">گیرندگان CC</div>
                        @if($trans->recipients && $trans->recipients->count())
                            <div class="d-flex flex-wrap gap-1">
                                @foreach($trans->recipients as $rec)
                                    @if($rec->role === 'cc')
                                        @if($hasUserRoute && $rec->user_id)
                                            <a class="chip text-decoration-none" href="{{ route('admin.users.show', $rec->user_id) }}">
                                                <i class="far fa-user"></i> {{ $rec->user?->name ?? '—' }}
                                            </a>
                                        @else
                                            <span class="chip"><i class="far fa-user"></i> {{ $rec->user?->name ?? '—' }}</span>
                                        @endif
                                    @endif
                                @endforeach
                            </div>
                        @else
                            <div class="muted">—</div>
                        @endif
                    </div>
                </div>
            </div>

            {{-- مدارک --}}
            <div class="card-section mt-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="mb-0 d-flex align-items-center gap-2">
                        <i class="far fa-file"></i> مدارک ارسالی
                        <span class="badge bg-light text-dark">{{ $trans->documents->count() }}</span>
                    </h6>
                </div>

                <div class="table-responsive">
                    <table class="table table-sm table-hover align-middle text-center">
                        <thead class="table-light">
                        <tr>
                            <th style="width:60px">#</th>
                            <th style="width:180px">شماره سند</th>
                            <th>عنوان</th>
                            <th style="width:120px">ریویژن</th>
                            <th>توضیح</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($trans->documents as $i => $doc)
                            <tr>
                                <td>{{ $i+1 }}</td>
                                <td class="mono">{{ $doc->masterDocument?->document_number ?? '—' }}</td>
                                <td class="text-start">{{ $doc->masterDocument?->title ?? '—' }}</td>
                                <td>{{ $doc->revision ?? '—' }}</td>
                                <td class="text-start">{{ \Illuminate\Support\Str::limit($doc->description ?? '—', 120) }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="5" class="text-muted">بدون مدرک</td></tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            {{-- پیوست‌ها --}}
            <div class="card-section mt-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="mb-0 d-flex align-items-center gap-2">
                        <i class="fas fa-paperclip"></i> پیوست‌ها
                    </h6>
                    <a href="{{ route('transmittal.attachments.zip', $trans->id) }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-file-archive"></i> دانلود همه (ZIP)
                    </a>
                </div>

                @if($trans->attachments && $trans->attachments->count())
                    <div class="row g-2">
                        @foreach($trans->attachments as $att)
                            @php
                                $ext = strtolower(pathinfo($att->file_name, PATHINFO_EXTENSION));
                                $isImg = in_array($ext, ['jpg','jpeg','png','gif','webp']);
                                $url = asset('storage/'.$att->file_path);
                            @endphp
                            <div class="col-6 col-md-3">
                                <div class="border rounded p-2 h-100 d-flex flex-column">
                                    <div class="text-center">
                                        @if($isImg)
                                            <a href="{{ $url }}" target="_blank">
                                                <img class="doc-thumb" src="{{ $url }}" alt="{{ $att->file_name }}">
                                            </a>
                                        @else
                                            <a href="{{ $url }}" target="_blank" class="d-block py-3">
                                                <i class="far fa-file fa-2x text-secondary"></i>
                                            </a>
                                        @endif
                                    </div>
                                    <div class="small mt-2 text-truncate" title="{{ $att->file_name }}">{{ $att->file_name }}</div>
                                    <div class="muted small">{{ number_format($att->size/1024,1) }} KB</div>
                                    <div class="mt-auto text-end">
                                        <a class="btn btn-sm btn-outline-primary" href="{{ $url }}" target="_blank">دانلود</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="muted">فاقد پیوست</div>
                @endif
            </div>

            {{-- اکشن‌های پایین --}}
            <div class="d-flex justify-content-between align-items-center mt-4">
                <a href="{{ url()->previous() }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-right"></i> بازگشت
                </a>
                <div class="d-flex gap-2">
                    <a href="{{ route('transmittal.attachments.zip', $trans->id) }}" class="btn btn-outline-primary">
                        <i class="fas fa-file-archive"></i> ZIP پیوست‌ها
                    </a>
                    <button class="btn btn-outline-secondary" id="btn-print-2">
                        <i class="fas fa-print"></i> چاپ
                    </button>
                    <a href="{{ route('transmittal.download', $trans->id) }}" target="_blank" class="btn btn-success">
                        <i class="fas fa-file-pdf"></i> PDF
                    </a>
                </div>
            </div>
        </div>
    </div>

    {{-- اسکریپت‌های سبک --}}
    <script>
        (function(){
            const root = document.getElementById('show-tr-root');
            const printBtns = [document.getElementById('btn-print'), document.getElementById('btn-print-2')];
            printBtns.forEach(b => b && b.addEventListener('click', () => window.print()));

            root.addEventListener('click', (e) => {
                const copyBtn = e.target.closest('.copy-btn');
                if(copyBtn){
                    const txt = copyBtn.dataset.copy || '';
                    navigator.clipboard.writeText(txt).then(() => {
                        copyBtn.classList.add('btn-success');
                        setTimeout(()=>copyBtn.classList.remove('btn-success'), 600);
                    });
                }
            });
        })();
    </script>
</div>
