<div class="container py-4" dir="rtl" id="tr-list-root" wire:key="tr-list-root">
    <style>
        :root{ --brand:#4f46e5; --brand2:#0ea5e9; }
        .bg-grad{ background:linear-gradient(90deg,var(--brand) 0%,var(--brand2) 100%); }
        .muted{color:#6b7280}
        .chip{background:#eef2ff;border-radius:999px;padding:.25rem .6rem;display:inline-flex;gap:.4rem;align-items:center}
        .chip .btn-clear{border:none;background:transparent;margin-inline-start:.25rem;line-height:1}
        .doc-card{border:1px solid #e5e7eb;border-radius:1rem;padding:.9rem}
        .table thead th{ position:sticky; top:0; z-index:1; background:#f8fafc; }
        .mono{font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", monospace;}
        .btn-xs{padding:.1rem .35rem;font-size:.75rem;line-height:1;border-radius:.35rem}
        .document-link{color:#0d6efd;text-decoration:none}
        .document-link:hover{text-decoration:underline}
        @media (max-width: 767.98px){
            .card-header h4{font-size:1rem}
            .btn{padding:.45rem .8rem}
        }
    </style>

    <div class="card shadow-sm">
        <div class="card-header bg-grad d-flex flex-wrap gap-2 justify-content-between align-items-center">
            <h4 class="mb-0 text-white d-flex align-items-center gap-2">
                <i class="fas fa-paper-plane"></i> لیست ترنسمیتال‌ها
            </h4>
            <div class="d-flex gap-2">
                <a href="{{ route('transmittal.create') }}" class="btn btn-success btn-sm">
                    <i class="fas fa-plus"></i> ثبت ترنسمیتال جدید
                </a>
            </div>
        </div>

        <div class="card-body">
            {{-- تب‌های وضعیت با شمارنده --}}
            @php $tabs = array_merge(['همه'], $this->statuses); @endphp
            <ul class="nav nav-pills flex-wrap gap-1 mb-3">
                @foreach($tabs as $tab)
                    @php
                        $isActive = ($tab === 'همه' && !$status) || ($tab === $status);
                        $count = $statusCounts[$tab] ?? null;
                    @endphp
                    <li class="nav-item">
                        <a class="nav-link d-flex align-items-center gap-2 {{ $isActive ? 'active' : '' }}"
                           href="javascript:void(0)"
                           wire:click="setStatus('{{ $tab === 'همه' ? '' : $tab }}')">
                            <span>{{ $tab }}</span>
                            @if(!is_null($count))
                                <span class="badge rounded-pill bg-light text-dark">{{ $count }}</span>
                            @endif
                        </a>
                    </li>
                @endforeach
            </ul>

            {{-- فیلترها --}}
            <div class="row g-2 g-md-3 align-items-end mb-2">
                <div class="col-12 col-md-4">
                    <label class="form-label small muted">جستجو</label>
                    <input type="text" wire:model.debounce.500ms="search" class="form-control" placeholder="شماره، پروژه، فرستنده، گیرنده…">
                </div>
                <div class="col-6 col-md-3">
                    <label class="form-label small muted">پروژه</label>
                    <select wire:model="project_id" class="form-select">
                        <option value="">همه پروژه‌ها</option>
                        @foreach($projects as $p)
                            <option value="{{ $p->id }}">{{ $p->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-6 col-md-2">
                    <label class="form-label small muted">در هر صفحه</label>
                    <select wire:model="perPage" class="form-select">
                        @foreach([10,20,50,100] as $n)
                            <option value="{{ $n }}">{{ $n }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-12 col-md-3 text-end">
                    <button class="btn btn-outline-secondary" wire:click="clearFilters">
                        <i class="fas fa-rotate"></i> بازنشانی
                    </button>
                </div>
            </div>

            {{-- چیپ‌های فیلتر فعال --}}
            <div class="d-flex flex-wrap gap-1 mb-3">
                @if($search)
                    <span class="chip">جستجو: “{{ $search }}”
                        <button type="button" class="btn-clear" wire:click="$set('search','')">&times;</button>
                    </span>
                @endif
                @if($project_id)
                    <span class="chip">پروژه انتخاب‌شده
                        <button type="button" class="btn-clear" wire:click="$set('project_id',null)">&times;</button>
                    </span>
                @endif
                @if($status)
                    <span class="chip">وضعیت: {{ $status }}
                        <button type="button" class="btn-clear" wire:click="$set('status',null)">&times;</button>
                    </span>
                @endif
            </div>

            {{-- موبایل: کارت‌ها --}}
            <div class="d-md-none" wire:loading.class="opacity-50">
                @forelse($transmittals as $tr)
                    @php
                        $date = jdate($tr->sent_at ?? $tr->created_at)->format('Y/m/d');
                        $badge = match($tr->status){
                            'ارسال شده' => 'bg-success',
                            'دریافت شده' => 'bg-info',
                            'رد شده'     => 'bg-danger',
                            default       => 'bg-warning text-dark'
                        };
                    @endphp
                    <div class="doc-card mb-2" wire:key="card-{{ $tr->id }}">
                        <div class="d-flex justify-content-between align-items-start gap-2">
                            <div>
                                <div class="fw-bold d-flex align-items-center gap-2">
                                    <a class="document-link mono" href="{{ route('transmittals.show', $tr->id) }}">
                                        {{ $tr->transmittal_number }}
                                    </a>
                                    <button class="btn btn-xs btn-light copy-btn" data-copy="{{ $tr->transmittal_number }}" title="کپی">
                                        <i class="far fa-copy"></i>
                                    </button>
                                </div>
                                <div class="small muted">{{ $tr->project?->name ?? '—' }}</div>
                            </div>
                            <span class="badge {{ $badge }}">{{ $tr->status }}</span>
                        </div>

                        <div class="mt-2 small">
                            <div><i class="far fa-user"></i> فرستنده: {{ $tr->sender?->name ?? '—' }}</div>
                            <div><i class="far fa-user"></i> گیرنده: {{ $tr->receiver?->name ?? '—' }}</div>
                            <div><i class="far fa-calendar"></i> {{ $date }}</div>
                            <div><i class="far fa-flag"></i> {{ $tr->purpose ?: '—' }}</div>
                            <div><i class="far fa-file"></i> مدارک: <span class="badge bg-info">{{ $tr->documents_count }}</span></div>
                        </div>

                        <div class="mt-2 d-flex gap-2">
                            <button class="btn btn-sm btn-outline-primary flex-fill" wire:click="showModal({{ $tr->id }})">
                                <i class="fas fa-eye"></i> جزئیات
                            </button>
                            <a href="{{ route('transmittal.download', $tr->id) }}" class="btn btn-sm btn-outline-success flex-fill" target="_blank">
                                <i class="fas fa-file-pdf"></i> PDF
                            </a>
                        </div>
                    </div>
                @empty
                    <div class="text-center text-muted py-4">موردی یافت نشد.</div>
                @endforelse

                <div class="mt-3">{{ $transmittals->links() }}</div>
            </div>

            {{-- دسکتاپ: جدول --}}
            <div class="table-responsive d-none d-md-block" wire:loading.class="opacity-50">
                @php $dirIcon = fn($f)=> $sortField===$f ? ($sortDir==='asc'?'↑':'↓') : '↕'; @endphp
                <table class="table table-hover table-bordered align-middle text-center">
                    <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th role="button" wire:click="sortBy('transmittal_number')">
                            شماره <span class="small">{{ $dirIcon('transmittal_number') }}</span>
                        </th>
                        <th>پروژه</th>
                        <th>فرستنده</th>
                        <th>گیرنده</th>
                        <th role="button" wire:click="sortBy('sent_at')">
                            تاریخ <span class="small">{{ $dirIcon('sent_at') }}</span>
                        </th>
                        <th>هدف</th>
                        <th>مدارک</th>
                        <th role="button" wire:click="sortBy('status')">
                            وضعیت <span class="small">{{ $dirIcon('status') }}</span>
                        </th>
                        <th>پیوست</th>
                        <th role="button" wire:click="sortBy('created_at')">
                            ایجاد <span class="small">{{ $dirIcon('created_at') }}</span>
                        </th>
                        <th>عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($transmittals as $i => $tr)
                        @php
                            $row  = ($transmittals->currentPage()-1)*$transmittals->perPage() + $i + 1;
                            $date = jdate($tr->sent_at ?? $tr->created_at)->format('Y/m/d');
                            $badge = match($tr->status){
                                'ارسال شده' => 'bg-success',
                                'دریافت شده' => 'bg-info',
                                'رد شده'     => 'bg-danger',
                                default       => 'bg-warning text-dark'
                            };
                        @endphp
                        <tr wire:key="row-{{ $tr->id }}">
                            <td>{{ $row }}</td>
                            <td class="text-monospace">
                                <a href="{{ route('transmittals.show', $tr->id) }}" class="document-link">
                                    {{ $tr->transmittal_number }}
                                </a>
                                <button class="btn btn-xs btn-light copy-btn ms-2" data-copy="{{ $tr->transmittal_number }}" title="کپی">
                                    <i class="far fa-copy"></i>
                                </button>
                            </td>
                            <td class="text-start">{{ $tr->project?->name ?? '—' }}</td>
                            <td class="text-start">{{ $tr->sender?->name ?? '—' }}</td>
                            <td class="text-start">{{ $tr->receiver?->name ?? '—' }}</td>
                            <td>{{ $date }}</td>
                            <td class="text-start">{{ \Illuminate\Support\Str::limit($tr->purpose, 30) }}</td>
                            <td><span class="badge bg-info">{{ $tr->documents_count }}</span></td>
                            <td><span class="badge {{ $badge }}">{{ $tr->status }}</span></td>
                            <td>
                                @if($tr->attachments && $tr->attachments->count())
                                    <a href="{{ asset('storage/'.$tr->attachments->first()->file_path) }}"
                                       target="_blank"
                                       class="btn btn-sm btn-outline-primary"
                                       title="دانلود اولین پیوست">
                                        <i class="fas fa-paperclip"></i>
                                    </a>
                                @else
                                    <span class="text-muted">—</span>
                                @endif
                            </td>
                            <td class="small muted">{{ jdate($tr->created_at)->format('Y/m/d H:i') }}</td>
                            <td class="d-flex gap-1 justify-content-center">
                                <button class="btn btn-sm btn-outline-primary" wire:click="showModal({{ $tr->id }})">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <a href="{{ route('transmittal.download', $tr->id) }}" class="btn btn-sm btn-outline-success" target="_blank" title="دانلود PDF">
                                    <i class="fas fa-file-pdf"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="12" class="p-4 text-muted text-center">موردی یافت نشد.</td></tr>
                    @endforelse
                    </tbody>
                </table>

                <div class="mt-3 d-flex justify-content-center">{{ $transmittals->links() }}</div>
            </div>
        </div>
    </div>

    {{-- Modal جزئیات --}}
    <div class="modal fade" id="trModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">جزئیات ترنسمیتال</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" wire:click="closeModal"></button>
                </div>

                <div class="modal-body">
                    @if($modalTr)
                        @php
                            $date = jdate($modalTr->sent_at ?? $modalTr->created_at)->format('Y/m/d');
                            $badge = match($modalTr->status){
                                'ارسال شده' => 'bg-success',
                                'دریافت شده' => 'bg-info',
                                'رد شده'     => 'bg-danger',
                                default       => 'bg-warning text-dark'
                            };
                        @endphp

                        <div class="row g-2 mb-2">
                            <div class="col-12 col-md-6"><strong>شماره:</strong> {{ $modalTr->transmittal_number }}</div>
                            <div class="col-12 col-md-6"><strong>پروژه:</strong> {{ $modalTr->project?->name ?? '—' }}</div>
                            <div class="col-12 col-md-6"><strong>فرستنده:</strong> {{ $modalTr->sender?->name ?? '—' }}</div>
                            <div class="col-12 col-md-6"><strong>گیرنده:</strong> {{ $modalTr->receiver?->name ?? '—' }}</div>
                            <div class="col-12 col-md-6"><strong>تاریخ:</strong> {{ $date }}</div>
                            <div class="col-12 col-md-6"><strong>وضعیت:</strong> <span class="badge {{ $badge }}">{{ $modalTr->status }}</span></div>
                            <div class="col-12"><strong>هدف:</strong> {{ $modalTr->purpose ?: '—' }}</div>
                            <div class="col-12"><strong>توضیحات:</strong> {{ $modalTr->description ?: '—' }}</div>
                        </div>

                        <hr>
                        <h6 class="mb-2">مدارک ارسالی</h6>
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered align-middle text-center">
                                <thead class="table-light">
                                <tr>
                                    <th>شماره سند</th>
                                    <th>عنوان</th>
                                    <th>ریویژن</th>
                                    <th>توضیح</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($modalTr->documents as $doc)
                                    <tr>
                                        <td class="text-monospace">{{ $doc->masterDocument?->document_number }}</td>
                                        <td class="text-start">{{ $doc->masterDocument?->title }}</td>
                                        <td>{{ $doc->revision ?? '—' }}</td>
                                        <td class="text-start">{{ \Illuminate\Support\Str::limit($doc->description, 80) }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>

                        @if($modalTr->attachments && $modalTr->attachments->count())
                            <h6 class="mt-3">پیوست‌ها</h6>
                            <ul class="small">
                                @foreach($modalTr->attachments as $att)
                                    <li>
                                        <a href="{{ asset('storage/'.$att->file_path) }}" target="_blank">
                                            {{ $att->file_name }}
                                        </a>
                                        <span class="muted">({{ number_format($att->size/1024,1) }} KB)</span>
                                    </li>
                                @endforeach
                            </ul>
                        @endif

                        <div class="mt-3 text-center">
                            {!! \SimpleSoftwareIO\QrCode\Facades\QrCode::size(100)->generate(route('transmittals.show', $modalTr->id)) !!}
                        </div>
                    @else
                        <div class="text-muted">آیتمی انتخاب نشده است.</div>
                    @endif
                </div>

                <div class="modal-footer">
                    <a href="{{ $modalTr ? route('transmittal.download', $modalTr->id) : '#' }}"
                       class="btn btn-success {{ $modalTr ? '' : 'disabled' }}" target="_blank">
                        <i class="fas fa-file-pdf"></i> PDF
                    </a>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="closeModal">بستن</button>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
    <style>
        .bg-grad{ background:linear-gradient(90deg,var(--brand,#4f46e5) 0%,var(--brand2,#0ea5e9) 100%); }
    </style>
@endpush

@push('scripts')
    <script>
        document.addEventListener('livewire:initialized', () => {
            const el = document.getElementById('trModal');

            // کنترل مودال با eventهای Livewire
            Livewire.on('open-tr-modal', () => new bootstrap.Modal(el).show());
            Livewire.on('close-tr-modal', () => { const m = bootstrap.Modal.getInstance(el); if (m) m.hide(); });

            // کپی شماره
            document.getElementById('tr-list-root').addEventListener('click', (e) => {
                const btn = e.target.closest('.copy-btn'); if(!btn) return;
                const txt = btn.dataset.copy || '';
                navigator.clipboard.writeText(txt).then(() => {
                    btn.classList.add('btn-success'); setTimeout(()=>btn.classList.remove('btn-success'),600);
                });
            });
        });
    </script>
@endpush
